import IPrisma, { Prisma, PrismaClient } from '@prisma/client';
import { v4 as uuid } from 'uuid';

export const prisma = new PrismaClient({
    log: ['error']
})
export const generateUUID = () => {
    return uuid()
}

export interface ResponseApiSuccess {
    code: number
    status: string
    message?: string
    result?: any
}

export interface ResponseToolsApiSuccess {
    code: number
    status: string
    message?: string
    hit: number
    result?: any
}

export interface ResponseApiError {
    code: number
    status: string
    message?: string
}

export type ResponseApi = ResponseApiSuccess & ResponseApiError

export const defaultResponseApi = (): ResponseApiSuccess => {
    return {
        code: 200,
        status: 'success'
    }
}

export const genErrorResponse = (message: string, code = 400): ResponseApiError => {
    return {
        code,
        status: 'failed',
        message,
    }
}

export const genInternalErrorResponse = (response: ResponseApiSuccess, error: unknown): ResponseApiError => {
    response.code = 500
    response.status = 'error'
    response.message = "Internal Server Error"
    if (error instanceof Error) {
        response.message = error.message;
    }
    if (error instanceof Prisma.PrismaClientKnownRequestError) {
        response.message = error.message;
    }
    return response
}