require("dotenv").config();

import autoLoad from '@fastify/autoload'
import cors from '@fastify/cors'
import Fastify from 'fastify'
import path from 'path'

const build = (opts = {}) => {
    const fastify = Fastify(opts)

    fastify.addHook('preHandler', (req, reply, done) => {
        reply.header("Content-Type", "application/json")
        done()
    })

    fastify.register(cors)
    fastify.register(autoLoad, {
        dir: path.join(__dirname, 'routes'),
        options: {
            prefix: '/api/v1'
        }
    })

    fastify.get('/', () => {
        return {
            code: 200,
            status: true,
            message: "MechaCraft API Server v1.0",
            date: new Date()
        }
    })

    return fastify;
};

export default build;