"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ChainedBatch = void 0;
const binding = require('../binding');
class ChainedBatch {
    context;
    constructor(db) {
        this.context = db.context;
    }
    put(key, value) {
        binding.batch_put(this.context, key, value);
    }
    delete(key) {
        binding.batch_del(this.context, key);
    }
    clear() {
        binding.batch_clear(this.context);
    }
    async write(options) {
        return await new Promise((res, rej) => {
            binding.batch_write(this.context, options, err => err ? rej(err) : res(err));
        });
    }
}
exports.ChainedBatch = ChainedBatch;
