const helper = require('./helpers/buildPath.js')
const path = require('path')
const debug = require('debug')('leveldb')

if (!process.versions.electron) {
  // Electron has its own crash handler, and segfault-handler
  // uses NAN which is a hassle, so only load outside electron
  try {
    const SegfaultHandler = require('segfault-handler')
    SegfaultHandler.registerHandler('crash.log')
  } catch (e) {
    debug('[leveldb] segfault handler is not installed. If you run into crashing issues, install it with `npm i -D segfault-handler` to get debug info on native crashes')
  }
}

let bindings
const pathToSearch = helper.getPath()
if (pathToSearch) {
  const rpath = path.join(__dirname, pathToSearch, '/node-leveldb.node')
  try {
    bindings = require(rpath)
  } catch (e) {
    debug(e)
    debug('[leveldb] did not find lib in ', rpath)
  }
}
if (!bindings) {
  bindings = require('bindings')('node-leveldb.node')
}

module.exports = bindings
