
/**
 * Client
**/

import * as runtime from '@prisma/client/runtime/library';
import $Types = runtime.Types // general types
import $Public = runtime.Types.Public
import $Utils = runtime.Types.Utils
import $Extensions = runtime.Types.Extensions
import $Result = runtime.Types.Result

export type PrismaPromise<T> = $Public.PrismaPromise<T>


/**
 * Model User
 * 
 */
export type User = $Result.DefaultSelection<Prisma.$UserPayload>
/**
 * Model Warp
 * 
 */
export type Warp = $Result.DefaultSelection<Prisma.$WarpPayload>
/**
 * Model Guild
 * 
 */
export type Guild = $Result.DefaultSelection<Prisma.$GuildPayload>
/**
 * Model GuildMember
 * 
 */
export type GuildMember = $Result.DefaultSelection<Prisma.$GuildMemberPayload>
/**
 * Model ShopCategory
 * 
 */
export type ShopCategory = $Result.DefaultSelection<Prisma.$ShopCategoryPayload>
/**
 * Model ShopItem
 * 
 */
export type ShopItem = $Result.DefaultSelection<Prisma.$ShopItemPayload>
/**
 * Model Transaction
 * 
 */
export type Transaction = $Result.DefaultSelection<Prisma.$TransactionPayload>
/**
 * Model TransactionDetail
 * 
 */
export type TransactionDetail = $Result.DefaultSelection<Prisma.$TransactionDetailPayload>
/**
 * Model TpaRequest
 * 
 */
export type TpaRequest = $Result.DefaultSelection<Prisma.$TpaRequestPayload>
/**
 * Model WayPoint
 * 
 */
export type WayPoint = $Result.DefaultSelection<Prisma.$WayPointPayload>
/**
 * Model Settings
 * 
 */
export type Settings = $Result.DefaultSelection<Prisma.$SettingsPayload>

/**
 * Enums
 */
export namespace $Enums {
  export const UserRole: {
  OPERATOR: 'OPERATOR',
  ADMIN: 'ADMIN',
  MODERATOR: 'MODERATOR',
  BUILDER: 'BUILDER',
  STAFF: 'STAFF',
  VIP: 'VIP',
  USER: 'USER'
};

export type UserRole = (typeof UserRole)[keyof typeof UserRole]


export const GuildRole: {
  LEADER: 'LEADER',
  OFFICER: 'OFFICER',
  MEMBER: 'MEMBER'
};

export type GuildRole = (typeof GuildRole)[keyof typeof GuildRole]


export const ItemType: {
  ITEM: 'ITEM',
  ENCHANT: 'ENCHANT',
  TRANSFER: 'TRANSFER',
  EXP: 'EXP'
};

export type ItemType = (typeof ItemType)[keyof typeof ItemType]


export const EnchantType: {
  ALL: 'ALL',
  ARMOR: 'ARMOR',
  MELEE_WEAPON: 'MELEE_WEAPON',
  RANGED_WEAPON: 'RANGED_WEAPON',
  TOOL: 'TOOL'
};

export type EnchantType = (typeof EnchantType)[keyof typeof EnchantType]


export const TrxType: {
  DEBIT: 'DEBIT',
  CREDIT: 'CREDIT'
};

export type TrxType = (typeof TrxType)[keyof typeof TrxType]


export const DataType: {
  STRING: 'STRING',
  INTEGER: 'INTEGER',
  FLOAT: 'FLOAT',
  DOUBLE: 'DOUBLE',
  BOOLEAN: 'BOOLEAN'
};

export type DataType = (typeof DataType)[keyof typeof DataType]

}

export type UserRole = $Enums.UserRole

export const UserRole: typeof $Enums.UserRole

export type GuildRole = $Enums.GuildRole

export const GuildRole: typeof $Enums.GuildRole

export type ItemType = $Enums.ItemType

export const ItemType: typeof $Enums.ItemType

export type EnchantType = $Enums.EnchantType

export const EnchantType: typeof $Enums.EnchantType

export type TrxType = $Enums.TrxType

export const TrxType: typeof $Enums.TrxType

export type DataType = $Enums.DataType

export const DataType: typeof $Enums.DataType

/**
 * ##  Prisma Client ʲˢ
 * 
 * Type-safe database client for TypeScript & Node.js
 * @example
 * ```
 * const prisma = new PrismaClient()
 * // Fetch zero or more Users
 * const users = await prisma.user.findMany()
 * ```
 *
 * 
 * Read more in our [docs](https://www.prisma.io/docs/reference/tools-and-interfaces/prisma-client).
 */
export class PrismaClient<
  T extends Prisma.PrismaClientOptions = Prisma.PrismaClientOptions,
  U = 'log' extends keyof T ? T['log'] extends Array<Prisma.LogLevel | Prisma.LogDefinition> ? Prisma.GetEvents<T['log']> : never : never,
  ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs
> {
  [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['other'] }

    /**
   * ##  Prisma Client ʲˢ
   * 
   * Type-safe database client for TypeScript & Node.js
   * @example
   * ```
   * const prisma = new PrismaClient()
   * // Fetch zero or more Users
   * const users = await prisma.user.findMany()
   * ```
   *
   * 
   * Read more in our [docs](https://www.prisma.io/docs/reference/tools-and-interfaces/prisma-client).
   */

  constructor(optionsArg ?: Prisma.Subset<T, Prisma.PrismaClientOptions>);
  $on<V extends U>(eventType: V, callback: (event: V extends 'query' ? Prisma.QueryEvent : Prisma.LogEvent) => void): void;

  /**
   * Connect with the database
   */
  $connect(): $Utils.JsPromise<void>;

  /**
   * Disconnect from the database
   */
  $disconnect(): $Utils.JsPromise<void>;

  /**
   * Add a middleware
   * @deprecated since 4.16.0. For new code, prefer client extensions instead.
   * @see https://pris.ly/d/extensions
   */
  $use(cb: Prisma.Middleware): void

/**
   * Executes a prepared raw query and returns the number of affected rows.
   * @example
   * ```
   * const result = await prisma.$executeRaw`UPDATE User SET cool = ${true} WHERE email = ${'user@email.com'};`
   * ```
   * 
   * Read more in our [docs](https://www.prisma.io/docs/reference/tools-and-interfaces/prisma-client/raw-database-access).
   */
  $executeRaw<T = unknown>(query: TemplateStringsArray | Prisma.Sql, ...values: any[]): Prisma.PrismaPromise<number>;

  /**
   * Executes a raw query and returns the number of affected rows.
   * Susceptible to SQL injections, see documentation.
   * @example
   * ```
   * const result = await prisma.$executeRawUnsafe('UPDATE User SET cool = $1 WHERE email = $2 ;', true, 'user@email.com')
   * ```
   * 
   * Read more in our [docs](https://www.prisma.io/docs/reference/tools-and-interfaces/prisma-client/raw-database-access).
   */
  $executeRawUnsafe<T = unknown>(query: string, ...values: any[]): Prisma.PrismaPromise<number>;

  /**
   * Performs a prepared raw query and returns the `SELECT` data.
   * @example
   * ```
   * const result = await prisma.$queryRaw`SELECT * FROM User WHERE id = ${1} OR email = ${'user@email.com'};`
   * ```
   * 
   * Read more in our [docs](https://www.prisma.io/docs/reference/tools-and-interfaces/prisma-client/raw-database-access).
   */
  $queryRaw<T = unknown>(query: TemplateStringsArray | Prisma.Sql, ...values: any[]): Prisma.PrismaPromise<T>;

  /**
   * Performs a raw query and returns the `SELECT` data.
   * Susceptible to SQL injections, see documentation.
   * @example
   * ```
   * const result = await prisma.$queryRawUnsafe('SELECT * FROM User WHERE id = $1 OR email = $2;', 1, 'user@email.com')
   * ```
   * 
   * Read more in our [docs](https://www.prisma.io/docs/reference/tools-and-interfaces/prisma-client/raw-database-access).
   */
  $queryRawUnsafe<T = unknown>(query: string, ...values: any[]): Prisma.PrismaPromise<T>;

  /**
   * Allows the running of a sequence of read/write operations that are guaranteed to either succeed or fail as a whole.
   * @example
   * ```
   * const [george, bob, alice] = await prisma.$transaction([
   *   prisma.user.create({ data: { name: 'George' } }),
   *   prisma.user.create({ data: { name: 'Bob' } }),
   *   prisma.user.create({ data: { name: 'Alice' } }),
   * ])
   * ```
   * 
   * Read more in our [docs](https://www.prisma.io/docs/concepts/components/prisma-client/transactions).
   */
  $transaction<P extends Prisma.PrismaPromise<any>[]>(arg: [...P], options?: { isolationLevel?: Prisma.TransactionIsolationLevel }): $Utils.JsPromise<runtime.Types.Utils.UnwrapTuple<P>>

  $transaction<R>(fn: (prisma: Omit<PrismaClient, runtime.ITXClientDenyList>) => $Utils.JsPromise<R>, options?: { maxWait?: number, timeout?: number, isolationLevel?: Prisma.TransactionIsolationLevel }): $Utils.JsPromise<R>


  $extends: $Extensions.ExtendsHook<'extends', Prisma.TypeMapCb, ExtArgs>

      /**
   * `prisma.user`: Exposes CRUD operations for the **User** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Users
    * const users = await prisma.user.findMany()
    * ```
    */
  get user(): Prisma.UserDelegate<ExtArgs>;

  /**
   * `prisma.warp`: Exposes CRUD operations for the **Warp** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Warps
    * const warps = await prisma.warp.findMany()
    * ```
    */
  get warp(): Prisma.WarpDelegate<ExtArgs>;

  /**
   * `prisma.guild`: Exposes CRUD operations for the **Guild** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Guilds
    * const guilds = await prisma.guild.findMany()
    * ```
    */
  get guild(): Prisma.GuildDelegate<ExtArgs>;

  /**
   * `prisma.guildMember`: Exposes CRUD operations for the **GuildMember** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more GuildMembers
    * const guildMembers = await prisma.guildMember.findMany()
    * ```
    */
  get guildMember(): Prisma.GuildMemberDelegate<ExtArgs>;

  /**
   * `prisma.shopCategory`: Exposes CRUD operations for the **ShopCategory** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more ShopCategories
    * const shopCategories = await prisma.shopCategory.findMany()
    * ```
    */
  get shopCategory(): Prisma.ShopCategoryDelegate<ExtArgs>;

  /**
   * `prisma.shopItem`: Exposes CRUD operations for the **ShopItem** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more ShopItems
    * const shopItems = await prisma.shopItem.findMany()
    * ```
    */
  get shopItem(): Prisma.ShopItemDelegate<ExtArgs>;

  /**
   * `prisma.transaction`: Exposes CRUD operations for the **Transaction** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Transactions
    * const transactions = await prisma.transaction.findMany()
    * ```
    */
  get transaction(): Prisma.TransactionDelegate<ExtArgs>;

  /**
   * `prisma.transactionDetail`: Exposes CRUD operations for the **TransactionDetail** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more TransactionDetails
    * const transactionDetails = await prisma.transactionDetail.findMany()
    * ```
    */
  get transactionDetail(): Prisma.TransactionDetailDelegate<ExtArgs>;

  /**
   * `prisma.tpaRequest`: Exposes CRUD operations for the **TpaRequest** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more TpaRequests
    * const tpaRequests = await prisma.tpaRequest.findMany()
    * ```
    */
  get tpaRequest(): Prisma.TpaRequestDelegate<ExtArgs>;

  /**
   * `prisma.wayPoint`: Exposes CRUD operations for the **WayPoint** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more WayPoints
    * const wayPoints = await prisma.wayPoint.findMany()
    * ```
    */
  get wayPoint(): Prisma.WayPointDelegate<ExtArgs>;

  /**
   * `prisma.settings`: Exposes CRUD operations for the **Settings** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Settings
    * const settings = await prisma.settings.findMany()
    * ```
    */
  get settings(): Prisma.SettingsDelegate<ExtArgs>;
}

export namespace Prisma {
  export import DMMF = runtime.DMMF

  export type PrismaPromise<T> = $Public.PrismaPromise<T>

  /**
   * Validator
   */
  export import validator = runtime.Public.validator

  /**
   * Prisma Errors
   */
  export import PrismaClientKnownRequestError = runtime.PrismaClientKnownRequestError
  export import PrismaClientUnknownRequestError = runtime.PrismaClientUnknownRequestError
  export import PrismaClientRustPanicError = runtime.PrismaClientRustPanicError
  export import PrismaClientInitializationError = runtime.PrismaClientInitializationError
  export import PrismaClientValidationError = runtime.PrismaClientValidationError
  export import NotFoundError = runtime.NotFoundError

  /**
   * Re-export of sql-template-tag
   */
  export import sql = runtime.sqltag
  export import empty = runtime.empty
  export import join = runtime.join
  export import raw = runtime.raw
  export import Sql = runtime.Sql

  /**
   * Decimal.js
   */
  export import Decimal = runtime.Decimal

  export type DecimalJsLike = runtime.DecimalJsLike

  /**
   * Metrics 
   */
  export type Metrics = runtime.Metrics
  export type Metric<T> = runtime.Metric<T>
  export type MetricHistogram = runtime.MetricHistogram
  export type MetricHistogramBucket = runtime.MetricHistogramBucket

  /**
  * Extensions
  */
  export import Extension = $Extensions.UserArgs
  export import getExtensionContext = runtime.Extensions.getExtensionContext
  export import Args = $Public.Args
  export import Payload = $Public.Payload
  export import Result = $Public.Result
  export import Exact = $Public.Exact

  /**
   * Prisma Client JS version: 5.7.0
   * Query Engine version: 79fb5193cf0a8fdbef536e4b4a159cad677ab1b9
   */
  export type PrismaVersion = {
    client: string
  }

  export const prismaVersion: PrismaVersion 

  /**
   * Utility Types
   */

  /**
   * From https://github.com/sindresorhus/type-fest/
   * Matches a JSON object.
   * This type can be useful to enforce some input to be JSON-compatible or as a super-type to be extended from. 
   */
  export type JsonObject = {[Key in string]?: JsonValue}

  /**
   * From https://github.com/sindresorhus/type-fest/
   * Matches a JSON array.
   */
  export interface JsonArray extends Array<JsonValue> {}

  /**
   * From https://github.com/sindresorhus/type-fest/
   * Matches any valid JSON value.
   */
  export type JsonValue = string | number | boolean | JsonObject | JsonArray | null

  /**
   * Matches a JSON object.
   * Unlike `JsonObject`, this type allows undefined and read-only properties.
   */
  export type InputJsonObject = {readonly [Key in string]?: InputJsonValue | null}

  /**
   * Matches a JSON array.
   * Unlike `JsonArray`, readonly arrays are assignable to this type.
   */
  export interface InputJsonArray extends ReadonlyArray<InputJsonValue | null> {}

  /**
   * Matches any valid value that can be used as an input for operations like
   * create and update as the value of a JSON field. Unlike `JsonValue`, this
   * type allows read-only arrays and read-only object properties and disallows
   * `null` at the top level.
   *
   * `null` cannot be used as the value of a JSON field because its meaning
   * would be ambiguous. Use `Prisma.JsonNull` to store the JSON null value or
   * `Prisma.DbNull` to clear the JSON value and set the field to the database
   * NULL value instead.
   *
   * @see https://www.prisma.io/docs/concepts/components/prisma-client/working-with-fields/working-with-json-fields#filtering-by-null-values
   */
  export type InputJsonValue = string | number | boolean | InputJsonObject | InputJsonArray | { toJSON(): unknown }

  /**
   * Types of the values used to represent different kinds of `null` values when working with JSON fields.
   * 
   * @see https://www.prisma.io/docs/concepts/components/prisma-client/working-with-fields/working-with-json-fields#filtering-on-a-json-field
   */
  namespace NullTypes {
    /**
    * Type of `Prisma.DbNull`.
    * 
    * You cannot use other instances of this class. Please use the `Prisma.DbNull` value.
    * 
    * @see https://www.prisma.io/docs/concepts/components/prisma-client/working-with-fields/working-with-json-fields#filtering-on-a-json-field
    */
    class DbNull {
      private DbNull: never
      private constructor()
    }

    /**
    * Type of `Prisma.JsonNull`.
    * 
    * You cannot use other instances of this class. Please use the `Prisma.JsonNull` value.
    * 
    * @see https://www.prisma.io/docs/concepts/components/prisma-client/working-with-fields/working-with-json-fields#filtering-on-a-json-field
    */
    class JsonNull {
      private JsonNull: never
      private constructor()
    }

    /**
    * Type of `Prisma.AnyNull`.
    * 
    * You cannot use other instances of this class. Please use the `Prisma.AnyNull` value.
    * 
    * @see https://www.prisma.io/docs/concepts/components/prisma-client/working-with-fields/working-with-json-fields#filtering-on-a-json-field
    */
    class AnyNull {
      private AnyNull: never
      private constructor()
    }
  }

  /**
   * Helper for filtering JSON entries that have `null` on the database (empty on the db)
   * 
   * @see https://www.prisma.io/docs/concepts/components/prisma-client/working-with-fields/working-with-json-fields#filtering-on-a-json-field
   */
  export const DbNull: NullTypes.DbNull

  /**
   * Helper for filtering JSON entries that have JSON `null` values (not empty on the db)
   * 
   * @see https://www.prisma.io/docs/concepts/components/prisma-client/working-with-fields/working-with-json-fields#filtering-on-a-json-field
   */
  export const JsonNull: NullTypes.JsonNull

  /**
   * Helper for filtering JSON entries that are `Prisma.DbNull` or `Prisma.JsonNull`
   * 
   * @see https://www.prisma.io/docs/concepts/components/prisma-client/working-with-fields/working-with-json-fields#filtering-on-a-json-field
   */
  export const AnyNull: NullTypes.AnyNull

  type SelectAndInclude = {
    select: any
    include: any
  }

  /**
   * Get the type of the value, that the Promise holds.
   */
  export type PromiseType<T extends PromiseLike<any>> = T extends PromiseLike<infer U> ? U : T;

  /**
   * Get the return type of a function which returns a Promise.
   */
  export type PromiseReturnType<T extends (...args: any) => $Utils.JsPromise<any>> = PromiseType<ReturnType<T>>

  /**
   * From T, pick a set of properties whose keys are in the union K
   */
  type Prisma__Pick<T, K extends keyof T> = {
      [P in K]: T[P];
  };


  export type Enumerable<T> = T | Array<T>;

  export type RequiredKeys<T> = {
    [K in keyof T]-?: {} extends Prisma__Pick<T, K> ? never : K
  }[keyof T]

  export type TruthyKeys<T> = keyof {
    [K in keyof T as T[K] extends false | undefined | null ? never : K]: K
  }

  export type TrueKeys<T> = TruthyKeys<Prisma__Pick<T, RequiredKeys<T>>>

  /**
   * Subset
   * @desc From `T` pick properties that exist in `U`. Simple version of Intersection
   */
  export type Subset<T, U> = {
    [key in keyof T]: key extends keyof U ? T[key] : never;
  };

  /**
   * SelectSubset
   * @desc From `T` pick properties that exist in `U`. Simple version of Intersection.
   * Additionally, it validates, if both select and include are present. If the case, it errors.
   */
  export type SelectSubset<T, U> = {
    [key in keyof T]: key extends keyof U ? T[key] : never
  } &
    (T extends SelectAndInclude
      ? 'Please either choose `select` or `include`.'
      : {})

  /**
   * Subset + Intersection
   * @desc From `T` pick properties that exist in `U` and intersect `K`
   */
  export type SubsetIntersection<T, U, K> = {
    [key in keyof T]: key extends keyof U ? T[key] : never
  } &
    K

  type Without<T, U> = { [P in Exclude<keyof T, keyof U>]?: never };

  /**
   * XOR is needed to have a real mutually exclusive union type
   * https://stackoverflow.com/questions/42123407/does-typescript-support-mutually-exclusive-types
   */
  type XOR<T, U> =
    T extends object ?
    U extends object ?
      (Without<T, U> & U) | (Without<U, T> & T)
    : U : T


  /**
   * Is T a Record?
   */
  type IsObject<T extends any> = T extends Array<any>
  ? False
  : T extends Date
  ? False
  : T extends Uint8Array
  ? False
  : T extends BigInt
  ? False
  : T extends object
  ? True
  : False


  /**
   * If it's T[], return T
   */
  export type UnEnumerate<T extends unknown> = T extends Array<infer U> ? U : T

  /**
   * From ts-toolbelt
   */

  type __Either<O extends object, K extends Key> = Omit<O, K> &
    {
      // Merge all but K
      [P in K]: Prisma__Pick<O, P & keyof O> // With K possibilities
    }[K]

  type EitherStrict<O extends object, K extends Key> = Strict<__Either<O, K>>

  type EitherLoose<O extends object, K extends Key> = ComputeRaw<__Either<O, K>>

  type _Either<
    O extends object,
    K extends Key,
    strict extends Boolean
  > = {
    1: EitherStrict<O, K>
    0: EitherLoose<O, K>
  }[strict]

  type Either<
    O extends object,
    K extends Key,
    strict extends Boolean = 1
  > = O extends unknown ? _Either<O, K, strict> : never

  export type Union = any

  type PatchUndefined<O extends object, O1 extends object> = {
    [K in keyof O]: O[K] extends undefined ? At<O1, K> : O[K]
  } & {}

  /** Helper Types for "Merge" **/
  export type IntersectOf<U extends Union> = (
    U extends unknown ? (k: U) => void : never
  ) extends (k: infer I) => void
    ? I
    : never

  export type Overwrite<O extends object, O1 extends object> = {
      [K in keyof O]: K extends keyof O1 ? O1[K] : O[K];
  } & {};

  type _Merge<U extends object> = IntersectOf<Overwrite<U, {
      [K in keyof U]-?: At<U, K>;
  }>>;

  type Key = string | number | symbol;
  type AtBasic<O extends object, K extends Key> = K extends keyof O ? O[K] : never;
  type AtStrict<O extends object, K extends Key> = O[K & keyof O];
  type AtLoose<O extends object, K extends Key> = O extends unknown ? AtStrict<O, K> : never;
  export type At<O extends object, K extends Key, strict extends Boolean = 1> = {
      1: AtStrict<O, K>;
      0: AtLoose<O, K>;
  }[strict];

  export type ComputeRaw<A extends any> = A extends Function ? A : {
    [K in keyof A]: A[K];
  } & {};

  export type OptionalFlat<O> = {
    [K in keyof O]?: O[K];
  } & {};

  type _Record<K extends keyof any, T> = {
    [P in K]: T;
  };

  // cause typescript not to expand types and preserve names
  type NoExpand<T> = T extends unknown ? T : never;

  // this type assumes the passed object is entirely optional
  type AtLeast<O extends object, K extends string> = NoExpand<
    O extends unknown
    ? | (K extends keyof O ? { [P in K]: O[P] } & O : O)
      | {[P in keyof O as P extends K ? K : never]-?: O[P]} & O
    : never>;

  type _Strict<U, _U = U> = U extends unknown ? U & OptionalFlat<_Record<Exclude<Keys<_U>, keyof U>, never>> : never;

  export type Strict<U extends object> = ComputeRaw<_Strict<U>>;
  /** End Helper Types for "Merge" **/

  export type Merge<U extends object> = ComputeRaw<_Merge<Strict<U>>>;

  /**
  A [[Boolean]]
  */
  export type Boolean = True | False

  // /**
  // 1
  // */
  export type True = 1

  /**
  0
  */
  export type False = 0

  export type Not<B extends Boolean> = {
    0: 1
    1: 0
  }[B]

  export type Extends<A1 extends any, A2 extends any> = [A1] extends [never]
    ? 0 // anything `never` is false
    : A1 extends A2
    ? 1
    : 0

  export type Has<U extends Union, U1 extends Union> = Not<
    Extends<Exclude<U1, U>, U1>
  >

  export type Or<B1 extends Boolean, B2 extends Boolean> = {
    0: {
      0: 0
      1: 1
    }
    1: {
      0: 1
      1: 1
    }
  }[B1][B2]

  export type Keys<U extends Union> = U extends unknown ? keyof U : never

  type Cast<A, B> = A extends B ? A : B;

  export const type: unique symbol;



  /**
   * Used by group by
   */

  export type GetScalarType<T, O> = O extends object ? {
    [P in keyof T]: P extends keyof O
      ? O[P]
      : never
  } : never

  type FieldPaths<
    T,
    U = Omit<T, '_avg' | '_sum' | '_count' | '_min' | '_max'>
  > = IsObject<T> extends True ? U : T

  type GetHavingFields<T> = {
    [K in keyof T]: Or<
      Or<Extends<'OR', K>, Extends<'AND', K>>,
      Extends<'NOT', K>
    > extends True
      ? // infer is only needed to not hit TS limit
        // based on the brilliant idea of Pierre-Antoine Mills
        // https://github.com/microsoft/TypeScript/issues/30188#issuecomment-478938437
        T[K] extends infer TK
        ? GetHavingFields<UnEnumerate<TK> extends object ? Merge<UnEnumerate<TK>> : never>
        : never
      : {} extends FieldPaths<T[K]>
      ? never
      : K
  }[keyof T]

  /**
   * Convert tuple to union
   */
  type _TupleToUnion<T> = T extends (infer E)[] ? E : never
  type TupleToUnion<K extends readonly any[]> = _TupleToUnion<K>
  type MaybeTupleToUnion<T> = T extends any[] ? TupleToUnion<T> : T

  /**
   * Like `Pick`, but additionally can also accept an array of keys
   */
  type PickEnumerable<T, K extends Enumerable<keyof T> | keyof T> = Prisma__Pick<T, MaybeTupleToUnion<K>>

  /**
   * Exclude all keys with underscores
   */
  type ExcludeUnderscoreKeys<T extends string> = T extends `_${string}` ? never : T


  export type FieldRef<Model, FieldType> = runtime.FieldRef<Model, FieldType>

  type FieldRefInputType<Model, FieldType> = Model extends never ? never : FieldRef<Model, FieldType>


  export const ModelName: {
    User: 'User',
    Warp: 'Warp',
    Guild: 'Guild',
    GuildMember: 'GuildMember',
    ShopCategory: 'ShopCategory',
    ShopItem: 'ShopItem',
    Transaction: 'Transaction',
    TransactionDetail: 'TransactionDetail',
    TpaRequest: 'TpaRequest',
    WayPoint: 'WayPoint',
    Settings: 'Settings'
  };

  export type ModelName = (typeof ModelName)[keyof typeof ModelName]


  export type Datasources = {
    db?: Datasource
  }


  interface TypeMapCb extends $Utils.Fn<{extArgs: $Extensions.InternalArgs}, $Utils.Record<string, any>> {
    returns: Prisma.TypeMap<this['params']['extArgs']>
  }

  export type TypeMap<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    meta: {
      modelProps: 'user' | 'warp' | 'guild' | 'guildMember' | 'shopCategory' | 'shopItem' | 'transaction' | 'transactionDetail' | 'tpaRequest' | 'wayPoint' | 'settings'
      txIsolationLevel: Prisma.TransactionIsolationLevel
    },
    model: {
      User: {
        payload: Prisma.$UserPayload<ExtArgs>
        fields: Prisma.UserFieldRefs
        operations: {
          findUnique: {
            args: Prisma.UserFindUniqueArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$UserPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.UserFindUniqueOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$UserPayload>
          }
          findFirst: {
            args: Prisma.UserFindFirstArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$UserPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.UserFindFirstOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$UserPayload>
          }
          findMany: {
            args: Prisma.UserFindManyArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$UserPayload>[]
          }
          create: {
            args: Prisma.UserCreateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$UserPayload>
          }
          createMany: {
            args: Prisma.UserCreateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          delete: {
            args: Prisma.UserDeleteArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$UserPayload>
          }
          update: {
            args: Prisma.UserUpdateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$UserPayload>
          }
          deleteMany: {
            args: Prisma.UserDeleteManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          updateMany: {
            args: Prisma.UserUpdateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          upsert: {
            args: Prisma.UserUpsertArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$UserPayload>
          }
          aggregate: {
            args: Prisma.UserAggregateArgs<ExtArgs>,
            result: $Utils.Optional<AggregateUser>
          }
          groupBy: {
            args: Prisma.UserGroupByArgs<ExtArgs>,
            result: $Utils.Optional<UserGroupByOutputType>[]
          }
          count: {
            args: Prisma.UserCountArgs<ExtArgs>,
            result: $Utils.Optional<UserCountAggregateOutputType> | number
          }
        }
      }
      Warp: {
        payload: Prisma.$WarpPayload<ExtArgs>
        fields: Prisma.WarpFieldRefs
        operations: {
          findUnique: {
            args: Prisma.WarpFindUniqueArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$WarpPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.WarpFindUniqueOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$WarpPayload>
          }
          findFirst: {
            args: Prisma.WarpFindFirstArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$WarpPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.WarpFindFirstOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$WarpPayload>
          }
          findMany: {
            args: Prisma.WarpFindManyArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$WarpPayload>[]
          }
          create: {
            args: Prisma.WarpCreateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$WarpPayload>
          }
          createMany: {
            args: Prisma.WarpCreateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          delete: {
            args: Prisma.WarpDeleteArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$WarpPayload>
          }
          update: {
            args: Prisma.WarpUpdateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$WarpPayload>
          }
          deleteMany: {
            args: Prisma.WarpDeleteManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          updateMany: {
            args: Prisma.WarpUpdateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          upsert: {
            args: Prisma.WarpUpsertArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$WarpPayload>
          }
          aggregate: {
            args: Prisma.WarpAggregateArgs<ExtArgs>,
            result: $Utils.Optional<AggregateWarp>
          }
          groupBy: {
            args: Prisma.WarpGroupByArgs<ExtArgs>,
            result: $Utils.Optional<WarpGroupByOutputType>[]
          }
          count: {
            args: Prisma.WarpCountArgs<ExtArgs>,
            result: $Utils.Optional<WarpCountAggregateOutputType> | number
          }
        }
      }
      Guild: {
        payload: Prisma.$GuildPayload<ExtArgs>
        fields: Prisma.GuildFieldRefs
        operations: {
          findUnique: {
            args: Prisma.GuildFindUniqueArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$GuildPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.GuildFindUniqueOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$GuildPayload>
          }
          findFirst: {
            args: Prisma.GuildFindFirstArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$GuildPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.GuildFindFirstOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$GuildPayload>
          }
          findMany: {
            args: Prisma.GuildFindManyArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$GuildPayload>[]
          }
          create: {
            args: Prisma.GuildCreateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$GuildPayload>
          }
          createMany: {
            args: Prisma.GuildCreateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          delete: {
            args: Prisma.GuildDeleteArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$GuildPayload>
          }
          update: {
            args: Prisma.GuildUpdateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$GuildPayload>
          }
          deleteMany: {
            args: Prisma.GuildDeleteManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          updateMany: {
            args: Prisma.GuildUpdateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          upsert: {
            args: Prisma.GuildUpsertArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$GuildPayload>
          }
          aggregate: {
            args: Prisma.GuildAggregateArgs<ExtArgs>,
            result: $Utils.Optional<AggregateGuild>
          }
          groupBy: {
            args: Prisma.GuildGroupByArgs<ExtArgs>,
            result: $Utils.Optional<GuildGroupByOutputType>[]
          }
          count: {
            args: Prisma.GuildCountArgs<ExtArgs>,
            result: $Utils.Optional<GuildCountAggregateOutputType> | number
          }
        }
      }
      GuildMember: {
        payload: Prisma.$GuildMemberPayload<ExtArgs>
        fields: Prisma.GuildMemberFieldRefs
        operations: {
          findUnique: {
            args: Prisma.GuildMemberFindUniqueArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$GuildMemberPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.GuildMemberFindUniqueOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$GuildMemberPayload>
          }
          findFirst: {
            args: Prisma.GuildMemberFindFirstArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$GuildMemberPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.GuildMemberFindFirstOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$GuildMemberPayload>
          }
          findMany: {
            args: Prisma.GuildMemberFindManyArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$GuildMemberPayload>[]
          }
          create: {
            args: Prisma.GuildMemberCreateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$GuildMemberPayload>
          }
          createMany: {
            args: Prisma.GuildMemberCreateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          delete: {
            args: Prisma.GuildMemberDeleteArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$GuildMemberPayload>
          }
          update: {
            args: Prisma.GuildMemberUpdateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$GuildMemberPayload>
          }
          deleteMany: {
            args: Prisma.GuildMemberDeleteManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          updateMany: {
            args: Prisma.GuildMemberUpdateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          upsert: {
            args: Prisma.GuildMemberUpsertArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$GuildMemberPayload>
          }
          aggregate: {
            args: Prisma.GuildMemberAggregateArgs<ExtArgs>,
            result: $Utils.Optional<AggregateGuildMember>
          }
          groupBy: {
            args: Prisma.GuildMemberGroupByArgs<ExtArgs>,
            result: $Utils.Optional<GuildMemberGroupByOutputType>[]
          }
          count: {
            args: Prisma.GuildMemberCountArgs<ExtArgs>,
            result: $Utils.Optional<GuildMemberCountAggregateOutputType> | number
          }
        }
      }
      ShopCategory: {
        payload: Prisma.$ShopCategoryPayload<ExtArgs>
        fields: Prisma.ShopCategoryFieldRefs
        operations: {
          findUnique: {
            args: Prisma.ShopCategoryFindUniqueArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ShopCategoryPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.ShopCategoryFindUniqueOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ShopCategoryPayload>
          }
          findFirst: {
            args: Prisma.ShopCategoryFindFirstArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ShopCategoryPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.ShopCategoryFindFirstOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ShopCategoryPayload>
          }
          findMany: {
            args: Prisma.ShopCategoryFindManyArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ShopCategoryPayload>[]
          }
          create: {
            args: Prisma.ShopCategoryCreateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ShopCategoryPayload>
          }
          createMany: {
            args: Prisma.ShopCategoryCreateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          delete: {
            args: Prisma.ShopCategoryDeleteArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ShopCategoryPayload>
          }
          update: {
            args: Prisma.ShopCategoryUpdateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ShopCategoryPayload>
          }
          deleteMany: {
            args: Prisma.ShopCategoryDeleteManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          updateMany: {
            args: Prisma.ShopCategoryUpdateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          upsert: {
            args: Prisma.ShopCategoryUpsertArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ShopCategoryPayload>
          }
          aggregate: {
            args: Prisma.ShopCategoryAggregateArgs<ExtArgs>,
            result: $Utils.Optional<AggregateShopCategory>
          }
          groupBy: {
            args: Prisma.ShopCategoryGroupByArgs<ExtArgs>,
            result: $Utils.Optional<ShopCategoryGroupByOutputType>[]
          }
          count: {
            args: Prisma.ShopCategoryCountArgs<ExtArgs>,
            result: $Utils.Optional<ShopCategoryCountAggregateOutputType> | number
          }
        }
      }
      ShopItem: {
        payload: Prisma.$ShopItemPayload<ExtArgs>
        fields: Prisma.ShopItemFieldRefs
        operations: {
          findUnique: {
            args: Prisma.ShopItemFindUniqueArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ShopItemPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.ShopItemFindUniqueOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ShopItemPayload>
          }
          findFirst: {
            args: Prisma.ShopItemFindFirstArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ShopItemPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.ShopItemFindFirstOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ShopItemPayload>
          }
          findMany: {
            args: Prisma.ShopItemFindManyArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ShopItemPayload>[]
          }
          create: {
            args: Prisma.ShopItemCreateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ShopItemPayload>
          }
          createMany: {
            args: Prisma.ShopItemCreateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          delete: {
            args: Prisma.ShopItemDeleteArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ShopItemPayload>
          }
          update: {
            args: Prisma.ShopItemUpdateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ShopItemPayload>
          }
          deleteMany: {
            args: Prisma.ShopItemDeleteManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          updateMany: {
            args: Prisma.ShopItemUpdateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          upsert: {
            args: Prisma.ShopItemUpsertArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ShopItemPayload>
          }
          aggregate: {
            args: Prisma.ShopItemAggregateArgs<ExtArgs>,
            result: $Utils.Optional<AggregateShopItem>
          }
          groupBy: {
            args: Prisma.ShopItemGroupByArgs<ExtArgs>,
            result: $Utils.Optional<ShopItemGroupByOutputType>[]
          }
          count: {
            args: Prisma.ShopItemCountArgs<ExtArgs>,
            result: $Utils.Optional<ShopItemCountAggregateOutputType> | number
          }
        }
      }
      Transaction: {
        payload: Prisma.$TransactionPayload<ExtArgs>
        fields: Prisma.TransactionFieldRefs
        operations: {
          findUnique: {
            args: Prisma.TransactionFindUniqueArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$TransactionPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.TransactionFindUniqueOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$TransactionPayload>
          }
          findFirst: {
            args: Prisma.TransactionFindFirstArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$TransactionPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.TransactionFindFirstOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$TransactionPayload>
          }
          findMany: {
            args: Prisma.TransactionFindManyArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$TransactionPayload>[]
          }
          create: {
            args: Prisma.TransactionCreateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$TransactionPayload>
          }
          createMany: {
            args: Prisma.TransactionCreateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          delete: {
            args: Prisma.TransactionDeleteArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$TransactionPayload>
          }
          update: {
            args: Prisma.TransactionUpdateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$TransactionPayload>
          }
          deleteMany: {
            args: Prisma.TransactionDeleteManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          updateMany: {
            args: Prisma.TransactionUpdateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          upsert: {
            args: Prisma.TransactionUpsertArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$TransactionPayload>
          }
          aggregate: {
            args: Prisma.TransactionAggregateArgs<ExtArgs>,
            result: $Utils.Optional<AggregateTransaction>
          }
          groupBy: {
            args: Prisma.TransactionGroupByArgs<ExtArgs>,
            result: $Utils.Optional<TransactionGroupByOutputType>[]
          }
          count: {
            args: Prisma.TransactionCountArgs<ExtArgs>,
            result: $Utils.Optional<TransactionCountAggregateOutputType> | number
          }
        }
      }
      TransactionDetail: {
        payload: Prisma.$TransactionDetailPayload<ExtArgs>
        fields: Prisma.TransactionDetailFieldRefs
        operations: {
          findUnique: {
            args: Prisma.TransactionDetailFindUniqueArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$TransactionDetailPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.TransactionDetailFindUniqueOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$TransactionDetailPayload>
          }
          findFirst: {
            args: Prisma.TransactionDetailFindFirstArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$TransactionDetailPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.TransactionDetailFindFirstOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$TransactionDetailPayload>
          }
          findMany: {
            args: Prisma.TransactionDetailFindManyArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$TransactionDetailPayload>[]
          }
          create: {
            args: Prisma.TransactionDetailCreateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$TransactionDetailPayload>
          }
          createMany: {
            args: Prisma.TransactionDetailCreateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          delete: {
            args: Prisma.TransactionDetailDeleteArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$TransactionDetailPayload>
          }
          update: {
            args: Prisma.TransactionDetailUpdateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$TransactionDetailPayload>
          }
          deleteMany: {
            args: Prisma.TransactionDetailDeleteManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          updateMany: {
            args: Prisma.TransactionDetailUpdateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          upsert: {
            args: Prisma.TransactionDetailUpsertArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$TransactionDetailPayload>
          }
          aggregate: {
            args: Prisma.TransactionDetailAggregateArgs<ExtArgs>,
            result: $Utils.Optional<AggregateTransactionDetail>
          }
          groupBy: {
            args: Prisma.TransactionDetailGroupByArgs<ExtArgs>,
            result: $Utils.Optional<TransactionDetailGroupByOutputType>[]
          }
          count: {
            args: Prisma.TransactionDetailCountArgs<ExtArgs>,
            result: $Utils.Optional<TransactionDetailCountAggregateOutputType> | number
          }
        }
      }
      TpaRequest: {
        payload: Prisma.$TpaRequestPayload<ExtArgs>
        fields: Prisma.TpaRequestFieldRefs
        operations: {
          findUnique: {
            args: Prisma.TpaRequestFindUniqueArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$TpaRequestPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.TpaRequestFindUniqueOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$TpaRequestPayload>
          }
          findFirst: {
            args: Prisma.TpaRequestFindFirstArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$TpaRequestPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.TpaRequestFindFirstOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$TpaRequestPayload>
          }
          findMany: {
            args: Prisma.TpaRequestFindManyArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$TpaRequestPayload>[]
          }
          create: {
            args: Prisma.TpaRequestCreateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$TpaRequestPayload>
          }
          createMany: {
            args: Prisma.TpaRequestCreateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          delete: {
            args: Prisma.TpaRequestDeleteArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$TpaRequestPayload>
          }
          update: {
            args: Prisma.TpaRequestUpdateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$TpaRequestPayload>
          }
          deleteMany: {
            args: Prisma.TpaRequestDeleteManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          updateMany: {
            args: Prisma.TpaRequestUpdateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          upsert: {
            args: Prisma.TpaRequestUpsertArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$TpaRequestPayload>
          }
          aggregate: {
            args: Prisma.TpaRequestAggregateArgs<ExtArgs>,
            result: $Utils.Optional<AggregateTpaRequest>
          }
          groupBy: {
            args: Prisma.TpaRequestGroupByArgs<ExtArgs>,
            result: $Utils.Optional<TpaRequestGroupByOutputType>[]
          }
          count: {
            args: Prisma.TpaRequestCountArgs<ExtArgs>,
            result: $Utils.Optional<TpaRequestCountAggregateOutputType> | number
          }
        }
      }
      WayPoint: {
        payload: Prisma.$WayPointPayload<ExtArgs>
        fields: Prisma.WayPointFieldRefs
        operations: {
          findUnique: {
            args: Prisma.WayPointFindUniqueArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$WayPointPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.WayPointFindUniqueOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$WayPointPayload>
          }
          findFirst: {
            args: Prisma.WayPointFindFirstArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$WayPointPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.WayPointFindFirstOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$WayPointPayload>
          }
          findMany: {
            args: Prisma.WayPointFindManyArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$WayPointPayload>[]
          }
          create: {
            args: Prisma.WayPointCreateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$WayPointPayload>
          }
          createMany: {
            args: Prisma.WayPointCreateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          delete: {
            args: Prisma.WayPointDeleteArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$WayPointPayload>
          }
          update: {
            args: Prisma.WayPointUpdateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$WayPointPayload>
          }
          deleteMany: {
            args: Prisma.WayPointDeleteManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          updateMany: {
            args: Prisma.WayPointUpdateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          upsert: {
            args: Prisma.WayPointUpsertArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$WayPointPayload>
          }
          aggregate: {
            args: Prisma.WayPointAggregateArgs<ExtArgs>,
            result: $Utils.Optional<AggregateWayPoint>
          }
          groupBy: {
            args: Prisma.WayPointGroupByArgs<ExtArgs>,
            result: $Utils.Optional<WayPointGroupByOutputType>[]
          }
          count: {
            args: Prisma.WayPointCountArgs<ExtArgs>,
            result: $Utils.Optional<WayPointCountAggregateOutputType> | number
          }
        }
      }
      Settings: {
        payload: Prisma.$SettingsPayload<ExtArgs>
        fields: Prisma.SettingsFieldRefs
        operations: {
          findUnique: {
            args: Prisma.SettingsFindUniqueArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$SettingsPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.SettingsFindUniqueOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$SettingsPayload>
          }
          findFirst: {
            args: Prisma.SettingsFindFirstArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$SettingsPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.SettingsFindFirstOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$SettingsPayload>
          }
          findMany: {
            args: Prisma.SettingsFindManyArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$SettingsPayload>[]
          }
          create: {
            args: Prisma.SettingsCreateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$SettingsPayload>
          }
          createMany: {
            args: Prisma.SettingsCreateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          delete: {
            args: Prisma.SettingsDeleteArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$SettingsPayload>
          }
          update: {
            args: Prisma.SettingsUpdateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$SettingsPayload>
          }
          deleteMany: {
            args: Prisma.SettingsDeleteManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          updateMany: {
            args: Prisma.SettingsUpdateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          upsert: {
            args: Prisma.SettingsUpsertArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$SettingsPayload>
          }
          aggregate: {
            args: Prisma.SettingsAggregateArgs<ExtArgs>,
            result: $Utils.Optional<AggregateSettings>
          }
          groupBy: {
            args: Prisma.SettingsGroupByArgs<ExtArgs>,
            result: $Utils.Optional<SettingsGroupByOutputType>[]
          }
          count: {
            args: Prisma.SettingsCountArgs<ExtArgs>,
            result: $Utils.Optional<SettingsCountAggregateOutputType> | number
          }
        }
      }
    }
  } & {
    other: {
      payload: any
      operations: {
        $executeRawUnsafe: {
          args: [query: string, ...values: any[]],
          result: any
        }
        $executeRaw: {
          args: [query: TemplateStringsArray | Prisma.Sql, ...values: any[]],
          result: any
        }
        $queryRawUnsafe: {
          args: [query: string, ...values: any[]],
          result: any
        }
        $queryRaw: {
          args: [query: TemplateStringsArray | Prisma.Sql, ...values: any[]],
          result: any
        }
      }
    }
  }
  export const defineExtension: $Extensions.ExtendsHook<'define', Prisma.TypeMapCb, $Extensions.DefaultArgs>
  export type DefaultPrismaClient = PrismaClient
  export type ErrorFormat = 'pretty' | 'colorless' | 'minimal'
  export interface PrismaClientOptions {
    /**
     * Overwrites the datasource url from your schema.prisma file
     */
    datasources?: Datasources
    /**
     * Overwrites the datasource url from your schema.prisma file
     */
    datasourceUrl?: string
    /**
     * @default "colorless"
     */
    errorFormat?: ErrorFormat
    /**
     * @example
     * ```
     * // Defaults to stdout
     * log: ['query', 'info', 'warn', 'error']
     * 
     * // Emit as events
     * log: [
     *   { emit: 'stdout', level: 'query' },
     *   { emit: 'stdout', level: 'info' },
     *   { emit: 'stdout', level: 'warn' }
     *   { emit: 'stdout', level: 'error' }
     * ]
     * ```
     * Read more in our [docs](https://www.prisma.io/docs/reference/tools-and-interfaces/prisma-client/logging#the-log-option).
     */
    log?: (LogLevel | LogDefinition)[]
  }

  /* Types for Logging */
  export type LogLevel = 'info' | 'query' | 'warn' | 'error'
  export type LogDefinition = {
    level: LogLevel
    emit: 'stdout' | 'event'
  }

  export type GetLogType<T extends LogLevel | LogDefinition> = T extends LogDefinition ? T['emit'] extends 'event' ? T['level'] : never : never
  export type GetEvents<T extends any> = T extends Array<LogLevel | LogDefinition> ?
    GetLogType<T[0]> | GetLogType<T[1]> | GetLogType<T[2]> | GetLogType<T[3]>
    : never

  export type QueryEvent = {
    timestamp: Date
    query: string
    params: string
    duration: number
    target: string
  }

  export type LogEvent = {
    timestamp: Date
    message: string
    target: string
  }
  /* End Types for Logging */


  export type PrismaAction =
    | 'findUnique'
    | 'findUniqueOrThrow'
    | 'findMany'
    | 'findFirst'
    | 'findFirstOrThrow'
    | 'create'
    | 'createMany'
    | 'update'
    | 'updateMany'
    | 'upsert'
    | 'delete'
    | 'deleteMany'
    | 'executeRaw'
    | 'queryRaw'
    | 'aggregate'
    | 'count'
    | 'runCommandRaw'
    | 'findRaw'
    | 'groupBy'

  /**
   * These options are being passed into the middleware as "params"
   */
  export type MiddlewareParams = {
    model?: ModelName
    action: PrismaAction
    args: any
    dataPath: string[]
    runInTransaction: boolean
  }

  /**
   * The `T` type makes sure, that the `return proceed` is not forgotten in the middleware implementation
   */
  export type Middleware<T = any> = (
    params: MiddlewareParams,
    next: (params: MiddlewareParams) => $Utils.JsPromise<T>,
  ) => $Utils.JsPromise<T>

  // tested in getLogLevel.test.ts
  export function getLogLevel(log: Array<LogLevel | LogDefinition>): LogLevel | undefined;

  /**
   * `PrismaClient` proxy available in interactive transactions.
   */
  export type TransactionClient = Omit<Prisma.DefaultPrismaClient, runtime.ITXClientDenyList>

  export type Datasource = {
    url?: string
  }

  /**
   * Count Types
   */


  /**
   * Count Type UserCountOutputType
   */

  export type UserCountOutputType = {
    userTransaction: number
    targetTransaction: number
    waypoint: number
  }

  export type UserCountOutputTypeSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    userTransaction?: boolean | UserCountOutputTypeCountUserTransactionArgs
    targetTransaction?: boolean | UserCountOutputTypeCountTargetTransactionArgs
    waypoint?: boolean | UserCountOutputTypeCountWaypointArgs
  }

  // Custom InputTypes

  /**
   * UserCountOutputType without action
   */
  export type UserCountOutputTypeDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserCountOutputType
     */
    select?: UserCountOutputTypeSelect<ExtArgs> | null
  }


  /**
   * UserCountOutputType without action
   */
  export type UserCountOutputTypeCountUserTransactionArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: TransactionWhereInput
  }


  /**
   * UserCountOutputType without action
   */
  export type UserCountOutputTypeCountTargetTransactionArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: TransactionWhereInput
  }


  /**
   * UserCountOutputType without action
   */
  export type UserCountOutputTypeCountWaypointArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: WayPointWhereInput
  }



  /**
   * Count Type GuildCountOutputType
   */

  export type GuildCountOutputType = {
    GuildMember: number
  }

  export type GuildCountOutputTypeSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    GuildMember?: boolean | GuildCountOutputTypeCountGuildMemberArgs
  }

  // Custom InputTypes

  /**
   * GuildCountOutputType without action
   */
  export type GuildCountOutputTypeDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the GuildCountOutputType
     */
    select?: GuildCountOutputTypeSelect<ExtArgs> | null
  }


  /**
   * GuildCountOutputType without action
   */
  export type GuildCountOutputTypeCountGuildMemberArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: GuildMemberWhereInput
  }



  /**
   * Count Type ShopCategoryCountOutputType
   */

  export type ShopCategoryCountOutputType = {
    ShopItem: number
  }

  export type ShopCategoryCountOutputTypeSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    ShopItem?: boolean | ShopCategoryCountOutputTypeCountShopItemArgs
  }

  // Custom InputTypes

  /**
   * ShopCategoryCountOutputType without action
   */
  export type ShopCategoryCountOutputTypeDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ShopCategoryCountOutputType
     */
    select?: ShopCategoryCountOutputTypeSelect<ExtArgs> | null
  }


  /**
   * ShopCategoryCountOutputType without action
   */
  export type ShopCategoryCountOutputTypeCountShopItemArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: ShopItemWhereInput
  }



  /**
   * Count Type ShopItemCountOutputType
   */

  export type ShopItemCountOutputType = {
    TransactionDetail: number
  }

  export type ShopItemCountOutputTypeSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    TransactionDetail?: boolean | ShopItemCountOutputTypeCountTransactionDetailArgs
  }

  // Custom InputTypes

  /**
   * ShopItemCountOutputType without action
   */
  export type ShopItemCountOutputTypeDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ShopItemCountOutputType
     */
    select?: ShopItemCountOutputTypeSelect<ExtArgs> | null
  }


  /**
   * ShopItemCountOutputType without action
   */
  export type ShopItemCountOutputTypeCountTransactionDetailArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: TransactionDetailWhereInput
  }



  /**
   * Models
   */

  /**
   * Model User
   */

  export type AggregateUser = {
    _count: UserCountAggregateOutputType | null
    _avg: UserAvgAggregateOutputType | null
    _sum: UserSumAggregateOutputType | null
    _min: UserMinAggregateOutputType | null
    _max: UserMaxAggregateOutputType | null
  }

  export type UserAvgAggregateOutputType = {
    userId: number | null
    money: number | null
    guildId: number | null
  }

  export type UserSumAggregateOutputType = {
    userId: number | null
    money: number | null
    guildId: number | null
  }

  export type UserMinAggregateOutputType = {
    userId: number | null
    xuid: string | null
    name: string | null
    role: $Enums.UserRole | null
    money: number | null
    canTpa: boolean | null
    password: string | null
    createdAt: Date | null
    updatedAt: Date | null
    guildId: number | null
  }

  export type UserMaxAggregateOutputType = {
    userId: number | null
    xuid: string | null
    name: string | null
    role: $Enums.UserRole | null
    money: number | null
    canTpa: boolean | null
    password: string | null
    createdAt: Date | null
    updatedAt: Date | null
    guildId: number | null
  }

  export type UserCountAggregateOutputType = {
    userId: number
    xuid: number
    name: number
    role: number
    money: number
    canTpa: number
    password: number
    createdAt: number
    updatedAt: number
    guildId: number
    _all: number
  }


  export type UserAvgAggregateInputType = {
    userId?: true
    money?: true
    guildId?: true
  }

  export type UserSumAggregateInputType = {
    userId?: true
    money?: true
    guildId?: true
  }

  export type UserMinAggregateInputType = {
    userId?: true
    xuid?: true
    name?: true
    role?: true
    money?: true
    canTpa?: true
    password?: true
    createdAt?: true
    updatedAt?: true
    guildId?: true
  }

  export type UserMaxAggregateInputType = {
    userId?: true
    xuid?: true
    name?: true
    role?: true
    money?: true
    canTpa?: true
    password?: true
    createdAt?: true
    updatedAt?: true
    guildId?: true
  }

  export type UserCountAggregateInputType = {
    userId?: true
    xuid?: true
    name?: true
    role?: true
    money?: true
    canTpa?: true
    password?: true
    createdAt?: true
    updatedAt?: true
    guildId?: true
    _all?: true
  }

  export type UserAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which User to aggregate.
     */
    where?: UserWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Users to fetch.
     */
    orderBy?: UserOrderByWithRelationInput | UserOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: UserWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Users from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Users.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned Users
    **/
    _count?: true | UserCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to average
    **/
    _avg?: UserAvgAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to sum
    **/
    _sum?: UserSumAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: UserMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: UserMaxAggregateInputType
  }

  export type GetUserAggregateType<T extends UserAggregateArgs> = {
        [P in keyof T & keyof AggregateUser]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateUser[P]>
      : GetScalarType<T[P], AggregateUser[P]>
  }




  export type UserGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: UserWhereInput
    orderBy?: UserOrderByWithAggregationInput | UserOrderByWithAggregationInput[]
    by: UserScalarFieldEnum[] | UserScalarFieldEnum
    having?: UserScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: UserCountAggregateInputType | true
    _avg?: UserAvgAggregateInputType
    _sum?: UserSumAggregateInputType
    _min?: UserMinAggregateInputType
    _max?: UserMaxAggregateInputType
  }

  export type UserGroupByOutputType = {
    userId: number
    xuid: string
    name: string
    role: $Enums.UserRole
    money: number
    canTpa: boolean
    password: string | null
    createdAt: Date
    updatedAt: Date
    guildId: number | null
    _count: UserCountAggregateOutputType | null
    _avg: UserAvgAggregateOutputType | null
    _sum: UserSumAggregateOutputType | null
    _min: UserMinAggregateOutputType | null
    _max: UserMaxAggregateOutputType | null
  }

  type GetUserGroupByPayload<T extends UserGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<UserGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof UserGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], UserGroupByOutputType[P]>
            : GetScalarType<T[P], UserGroupByOutputType[P]>
        }
      >
    >


  export type UserSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    userId?: boolean
    xuid?: boolean
    name?: boolean
    role?: boolean
    money?: boolean
    canTpa?: boolean
    password?: boolean
    createdAt?: boolean
    updatedAt?: boolean
    guildId?: boolean
    guildMember?: boolean | User$guildMemberArgs<ExtArgs>
    userTransaction?: boolean | User$userTransactionArgs<ExtArgs>
    targetTransaction?: boolean | User$targetTransactionArgs<ExtArgs>
    waypoint?: boolean | User$waypointArgs<ExtArgs>
    _count?: boolean | UserCountOutputTypeDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["user"]>

  export type UserSelectScalar = {
    userId?: boolean
    xuid?: boolean
    name?: boolean
    role?: boolean
    money?: boolean
    canTpa?: boolean
    password?: boolean
    createdAt?: boolean
    updatedAt?: boolean
    guildId?: boolean
  }

  export type UserInclude<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    guildMember?: boolean | User$guildMemberArgs<ExtArgs>
    userTransaction?: boolean | User$userTransactionArgs<ExtArgs>
    targetTransaction?: boolean | User$targetTransactionArgs<ExtArgs>
    waypoint?: boolean | User$waypointArgs<ExtArgs>
    _count?: boolean | UserCountOutputTypeDefaultArgs<ExtArgs>
  }


  export type $UserPayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "User"
    objects: {
      guildMember: Prisma.$GuildMemberPayload<ExtArgs> | null
      userTransaction: Prisma.$TransactionPayload<ExtArgs>[]
      targetTransaction: Prisma.$TransactionPayload<ExtArgs>[]
      waypoint: Prisma.$WayPointPayload<ExtArgs>[]
    }
    scalars: $Extensions.GetPayloadResult<{
      userId: number
      xuid: string
      name: string
      role: $Enums.UserRole
      money: number
      canTpa: boolean
      password: string | null
      createdAt: Date
      updatedAt: Date
      guildId: number | null
    }, ExtArgs["result"]["user"]>
    composites: {}
  }


  type UserGetPayload<S extends boolean | null | undefined | UserDefaultArgs> = $Result.GetResult<Prisma.$UserPayload, S>

  type UserCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = 
    Omit<UserFindManyArgs, 'select' | 'include' | 'distinct' > & {
      select?: UserCountAggregateInputType | true
    }

  export interface UserDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['User'], meta: { name: 'User' } }
    /**
     * Find zero or one User that matches the filter.
     * @param {UserFindUniqueArgs} args - Arguments to find a User
     * @example
     * // Get one User
     * const user = await prisma.user.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findUnique<T extends UserFindUniqueArgs<ExtArgs>>(
      args: SelectSubset<T, UserFindUniqueArgs<ExtArgs>>
    ): Prisma__UserClient<$Result.GetResult<Prisma.$UserPayload<ExtArgs>, T, 'findUnique'> | null, null, ExtArgs>

    /**
     * Find one User that matches the filter or throw an error  with `error.code='P2025'` 
     *     if no matches were found.
     * @param {UserFindUniqueOrThrowArgs} args - Arguments to find a User
     * @example
     * // Get one User
     * const user = await prisma.user.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findUniqueOrThrow<T extends UserFindUniqueOrThrowArgs<ExtArgs>>(
      args?: SelectSubset<T, UserFindUniqueOrThrowArgs<ExtArgs>>
    ): Prisma__UserClient<$Result.GetResult<Prisma.$UserPayload<ExtArgs>, T, 'findUniqueOrThrow'>, never, ExtArgs>

    /**
     * Find the first User that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {UserFindFirstArgs} args - Arguments to find a User
     * @example
     * // Get one User
     * const user = await prisma.user.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findFirst<T extends UserFindFirstArgs<ExtArgs>>(
      args?: SelectSubset<T, UserFindFirstArgs<ExtArgs>>
    ): Prisma__UserClient<$Result.GetResult<Prisma.$UserPayload<ExtArgs>, T, 'findFirst'> | null, null, ExtArgs>

    /**
     * Find the first User that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {UserFindFirstOrThrowArgs} args - Arguments to find a User
     * @example
     * // Get one User
     * const user = await prisma.user.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findFirstOrThrow<T extends UserFindFirstOrThrowArgs<ExtArgs>>(
      args?: SelectSubset<T, UserFindFirstOrThrowArgs<ExtArgs>>
    ): Prisma__UserClient<$Result.GetResult<Prisma.$UserPayload<ExtArgs>, T, 'findFirstOrThrow'>, never, ExtArgs>

    /**
     * Find zero or more Users that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {UserFindManyArgs=} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all Users
     * const users = await prisma.user.findMany()
     * 
     * // Get first 10 Users
     * const users = await prisma.user.findMany({ take: 10 })
     * 
     * // Only select the `userId`
     * const userWithUserIdOnly = await prisma.user.findMany({ select: { userId: true } })
     * 
    **/
    findMany<T extends UserFindManyArgs<ExtArgs>>(
      args?: SelectSubset<T, UserFindManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<$Result.GetResult<Prisma.$UserPayload<ExtArgs>, T, 'findMany'>>

    /**
     * Create a User.
     * @param {UserCreateArgs} args - Arguments to create a User.
     * @example
     * // Create one User
     * const User = await prisma.user.create({
     *   data: {
     *     // ... data to create a User
     *   }
     * })
     * 
    **/
    create<T extends UserCreateArgs<ExtArgs>>(
      args: SelectSubset<T, UserCreateArgs<ExtArgs>>
    ): Prisma__UserClient<$Result.GetResult<Prisma.$UserPayload<ExtArgs>, T, 'create'>, never, ExtArgs>

    /**
     * Create many Users.
     *     @param {UserCreateManyArgs} args - Arguments to create many Users.
     *     @example
     *     // Create many Users
     *     const user = await prisma.user.createMany({
     *       data: {
     *         // ... provide data here
     *       }
     *     })
     *     
    **/
    createMany<T extends UserCreateManyArgs<ExtArgs>>(
      args?: SelectSubset<T, UserCreateManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Delete a User.
     * @param {UserDeleteArgs} args - Arguments to delete one User.
     * @example
     * // Delete one User
     * const User = await prisma.user.delete({
     *   where: {
     *     // ... filter to delete one User
     *   }
     * })
     * 
    **/
    delete<T extends UserDeleteArgs<ExtArgs>>(
      args: SelectSubset<T, UserDeleteArgs<ExtArgs>>
    ): Prisma__UserClient<$Result.GetResult<Prisma.$UserPayload<ExtArgs>, T, 'delete'>, never, ExtArgs>

    /**
     * Update one User.
     * @param {UserUpdateArgs} args - Arguments to update one User.
     * @example
     * // Update one User
     * const user = await prisma.user.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
    **/
    update<T extends UserUpdateArgs<ExtArgs>>(
      args: SelectSubset<T, UserUpdateArgs<ExtArgs>>
    ): Prisma__UserClient<$Result.GetResult<Prisma.$UserPayload<ExtArgs>, T, 'update'>, never, ExtArgs>

    /**
     * Delete zero or more Users.
     * @param {UserDeleteManyArgs} args - Arguments to filter Users to delete.
     * @example
     * // Delete a few Users
     * const { count } = await prisma.user.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
    **/
    deleteMany<T extends UserDeleteManyArgs<ExtArgs>>(
      args?: SelectSubset<T, UserDeleteManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more Users.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {UserUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many Users
     * const user = await prisma.user.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
    **/
    updateMany<T extends UserUpdateManyArgs<ExtArgs>>(
      args: SelectSubset<T, UserUpdateManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create or update one User.
     * @param {UserUpsertArgs} args - Arguments to update or create a User.
     * @example
     * // Update or create a User
     * const user = await prisma.user.upsert({
     *   create: {
     *     // ... data to create a User
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the User we want to update
     *   }
     * })
    **/
    upsert<T extends UserUpsertArgs<ExtArgs>>(
      args: SelectSubset<T, UserUpsertArgs<ExtArgs>>
    ): Prisma__UserClient<$Result.GetResult<Prisma.$UserPayload<ExtArgs>, T, 'upsert'>, never, ExtArgs>

    /**
     * Count the number of Users.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {UserCountArgs} args - Arguments to filter Users to count.
     * @example
     * // Count the number of Users
     * const count = await prisma.user.count({
     *   where: {
     *     // ... the filter for the Users we want to count
     *   }
     * })
    **/
    count<T extends UserCountArgs>(
      args?: Subset<T, UserCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], UserCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a User.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {UserAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends UserAggregateArgs>(args: Subset<T, UserAggregateArgs>): Prisma.PrismaPromise<GetUserAggregateType<T>>

    /**
     * Group by User.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {UserGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends UserGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: UserGroupByArgs['orderBy'] }
        : { orderBy?: UserGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, UserGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetUserGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the User model
   */
  readonly fields: UserFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for User.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__UserClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: 'PrismaPromise';

    guildMember<T extends User$guildMemberArgs<ExtArgs> = {}>(args?: Subset<T, User$guildMemberArgs<ExtArgs>>): Prisma__GuildMemberClient<$Result.GetResult<Prisma.$GuildMemberPayload<ExtArgs>, T, 'findUniqueOrThrow'> | null, null, ExtArgs>;

    userTransaction<T extends User$userTransactionArgs<ExtArgs> = {}>(args?: Subset<T, User$userTransactionArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$TransactionPayload<ExtArgs>, T, 'findMany'> | Null>;

    targetTransaction<T extends User$targetTransactionArgs<ExtArgs> = {}>(args?: Subset<T, User$targetTransactionArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$TransactionPayload<ExtArgs>, T, 'findMany'> | Null>;

    waypoint<T extends User$waypointArgs<ExtArgs> = {}>(args?: Subset<T, User$waypointArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$WayPointPayload<ExtArgs>, T, 'findMany'> | Null>;

    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>;
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>;
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>;
  }



  /**
   * Fields of the User model
   */ 
  interface UserFieldRefs {
    readonly userId: FieldRef<"User", 'Int'>
    readonly xuid: FieldRef<"User", 'String'>
    readonly name: FieldRef<"User", 'String'>
    readonly role: FieldRef<"User", 'UserRole'>
    readonly money: FieldRef<"User", 'Int'>
    readonly canTpa: FieldRef<"User", 'Boolean'>
    readonly password: FieldRef<"User", 'String'>
    readonly createdAt: FieldRef<"User", 'DateTime'>
    readonly updatedAt: FieldRef<"User", 'DateTime'>
    readonly guildId: FieldRef<"User", 'Int'>
  }
    

  // Custom InputTypes

  /**
   * User findUnique
   */
  export type UserFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the User
     */
    select?: UserSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: UserInclude<ExtArgs> | null
    /**
     * Filter, which User to fetch.
     */
    where: UserWhereUniqueInput
  }


  /**
   * User findUniqueOrThrow
   */
  export type UserFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the User
     */
    select?: UserSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: UserInclude<ExtArgs> | null
    /**
     * Filter, which User to fetch.
     */
    where: UserWhereUniqueInput
  }


  /**
   * User findFirst
   */
  export type UserFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the User
     */
    select?: UserSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: UserInclude<ExtArgs> | null
    /**
     * Filter, which User to fetch.
     */
    where?: UserWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Users to fetch.
     */
    orderBy?: UserOrderByWithRelationInput | UserOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for Users.
     */
    cursor?: UserWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Users from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Users.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of Users.
     */
    distinct?: UserScalarFieldEnum | UserScalarFieldEnum[]
  }


  /**
   * User findFirstOrThrow
   */
  export type UserFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the User
     */
    select?: UserSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: UserInclude<ExtArgs> | null
    /**
     * Filter, which User to fetch.
     */
    where?: UserWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Users to fetch.
     */
    orderBy?: UserOrderByWithRelationInput | UserOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for Users.
     */
    cursor?: UserWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Users from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Users.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of Users.
     */
    distinct?: UserScalarFieldEnum | UserScalarFieldEnum[]
  }


  /**
   * User findMany
   */
  export type UserFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the User
     */
    select?: UserSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: UserInclude<ExtArgs> | null
    /**
     * Filter, which Users to fetch.
     */
    where?: UserWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Users to fetch.
     */
    orderBy?: UserOrderByWithRelationInput | UserOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing Users.
     */
    cursor?: UserWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Users from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Users.
     */
    skip?: number
    distinct?: UserScalarFieldEnum | UserScalarFieldEnum[]
  }


  /**
   * User create
   */
  export type UserCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the User
     */
    select?: UserSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: UserInclude<ExtArgs> | null
    /**
     * The data needed to create a User.
     */
    data: XOR<UserCreateInput, UserUncheckedCreateInput>
  }


  /**
   * User createMany
   */
  export type UserCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many Users.
     */
    data: UserCreateManyInput | UserCreateManyInput[]
    skipDuplicates?: boolean
  }


  /**
   * User update
   */
  export type UserUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the User
     */
    select?: UserSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: UserInclude<ExtArgs> | null
    /**
     * The data needed to update a User.
     */
    data: XOR<UserUpdateInput, UserUncheckedUpdateInput>
    /**
     * Choose, which User to update.
     */
    where: UserWhereUniqueInput
  }


  /**
   * User updateMany
   */
  export type UserUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update Users.
     */
    data: XOR<UserUpdateManyMutationInput, UserUncheckedUpdateManyInput>
    /**
     * Filter which Users to update
     */
    where?: UserWhereInput
  }


  /**
   * User upsert
   */
  export type UserUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the User
     */
    select?: UserSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: UserInclude<ExtArgs> | null
    /**
     * The filter to search for the User to update in case it exists.
     */
    where: UserWhereUniqueInput
    /**
     * In case the User found by the `where` argument doesn't exist, create a new User with this data.
     */
    create: XOR<UserCreateInput, UserUncheckedCreateInput>
    /**
     * In case the User was found with the provided `where` argument, update it with this data.
     */
    update: XOR<UserUpdateInput, UserUncheckedUpdateInput>
  }


  /**
   * User delete
   */
  export type UserDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the User
     */
    select?: UserSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: UserInclude<ExtArgs> | null
    /**
     * Filter which User to delete.
     */
    where: UserWhereUniqueInput
  }


  /**
   * User deleteMany
   */
  export type UserDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which Users to delete
     */
    where?: UserWhereInput
  }


  /**
   * User.guildMember
   */
  export type User$guildMemberArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the GuildMember
     */
    select?: GuildMemberSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: GuildMemberInclude<ExtArgs> | null
    where?: GuildMemberWhereInput
  }


  /**
   * User.userTransaction
   */
  export type User$userTransactionArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Transaction
     */
    select?: TransactionSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: TransactionInclude<ExtArgs> | null
    where?: TransactionWhereInput
    orderBy?: TransactionOrderByWithRelationInput | TransactionOrderByWithRelationInput[]
    cursor?: TransactionWhereUniqueInput
    take?: number
    skip?: number
    distinct?: TransactionScalarFieldEnum | TransactionScalarFieldEnum[]
  }


  /**
   * User.targetTransaction
   */
  export type User$targetTransactionArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Transaction
     */
    select?: TransactionSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: TransactionInclude<ExtArgs> | null
    where?: TransactionWhereInput
    orderBy?: TransactionOrderByWithRelationInput | TransactionOrderByWithRelationInput[]
    cursor?: TransactionWhereUniqueInput
    take?: number
    skip?: number
    distinct?: TransactionScalarFieldEnum | TransactionScalarFieldEnum[]
  }


  /**
   * User.waypoint
   */
  export type User$waypointArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the WayPoint
     */
    select?: WayPointSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: WayPointInclude<ExtArgs> | null
    where?: WayPointWhereInput
    orderBy?: WayPointOrderByWithRelationInput | WayPointOrderByWithRelationInput[]
    cursor?: WayPointWhereUniqueInput
    take?: number
    skip?: number
    distinct?: WayPointScalarFieldEnum | WayPointScalarFieldEnum[]
  }


  /**
   * User without action
   */
  export type UserDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the User
     */
    select?: UserSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: UserInclude<ExtArgs> | null
  }



  /**
   * Model Warp
   */

  export type AggregateWarp = {
    _count: WarpCountAggregateOutputType | null
    _avg: WarpAvgAggregateOutputType | null
    _sum: WarpSumAggregateOutputType | null
    _min: WarpMinAggregateOutputType | null
    _max: WarpMaxAggregateOutputType | null
  }

  export type WarpAvgAggregateOutputType = {
    id: number | null
    x: number | null
    y: number | null
    z: number | null
  }

  export type WarpSumAggregateOutputType = {
    id: number | null
    x: number | null
    y: number | null
    z: number | null
  }

  export type WarpMinAggregateOutputType = {
    id: number | null
    name: string | null
    texture: string | null
    gamemode: string | null
    x: number | null
    y: number | null
    z: number | null
    active: boolean | null
  }

  export type WarpMaxAggregateOutputType = {
    id: number | null
    name: string | null
    texture: string | null
    gamemode: string | null
    x: number | null
    y: number | null
    z: number | null
    active: boolean | null
  }

  export type WarpCountAggregateOutputType = {
    id: number
    name: number
    texture: number
    gamemode: number
    x: number
    y: number
    z: number
    active: number
    _all: number
  }


  export type WarpAvgAggregateInputType = {
    id?: true
    x?: true
    y?: true
    z?: true
  }

  export type WarpSumAggregateInputType = {
    id?: true
    x?: true
    y?: true
    z?: true
  }

  export type WarpMinAggregateInputType = {
    id?: true
    name?: true
    texture?: true
    gamemode?: true
    x?: true
    y?: true
    z?: true
    active?: true
  }

  export type WarpMaxAggregateInputType = {
    id?: true
    name?: true
    texture?: true
    gamemode?: true
    x?: true
    y?: true
    z?: true
    active?: true
  }

  export type WarpCountAggregateInputType = {
    id?: true
    name?: true
    texture?: true
    gamemode?: true
    x?: true
    y?: true
    z?: true
    active?: true
    _all?: true
  }

  export type WarpAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which Warp to aggregate.
     */
    where?: WarpWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Warps to fetch.
     */
    orderBy?: WarpOrderByWithRelationInput | WarpOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: WarpWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Warps from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Warps.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned Warps
    **/
    _count?: true | WarpCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to average
    **/
    _avg?: WarpAvgAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to sum
    **/
    _sum?: WarpSumAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: WarpMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: WarpMaxAggregateInputType
  }

  export type GetWarpAggregateType<T extends WarpAggregateArgs> = {
        [P in keyof T & keyof AggregateWarp]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateWarp[P]>
      : GetScalarType<T[P], AggregateWarp[P]>
  }




  export type WarpGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: WarpWhereInput
    orderBy?: WarpOrderByWithAggregationInput | WarpOrderByWithAggregationInput[]
    by: WarpScalarFieldEnum[] | WarpScalarFieldEnum
    having?: WarpScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: WarpCountAggregateInputType | true
    _avg?: WarpAvgAggregateInputType
    _sum?: WarpSumAggregateInputType
    _min?: WarpMinAggregateInputType
    _max?: WarpMaxAggregateInputType
  }

  export type WarpGroupByOutputType = {
    id: number
    name: string
    texture: string
    gamemode: string
    x: number
    y: number
    z: number
    active: boolean
    _count: WarpCountAggregateOutputType | null
    _avg: WarpAvgAggregateOutputType | null
    _sum: WarpSumAggregateOutputType | null
    _min: WarpMinAggregateOutputType | null
    _max: WarpMaxAggregateOutputType | null
  }

  type GetWarpGroupByPayload<T extends WarpGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<WarpGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof WarpGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], WarpGroupByOutputType[P]>
            : GetScalarType<T[P], WarpGroupByOutputType[P]>
        }
      >
    >


  export type WarpSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    name?: boolean
    texture?: boolean
    gamemode?: boolean
    x?: boolean
    y?: boolean
    z?: boolean
    active?: boolean
  }, ExtArgs["result"]["warp"]>

  export type WarpSelectScalar = {
    id?: boolean
    name?: boolean
    texture?: boolean
    gamemode?: boolean
    x?: boolean
    y?: boolean
    z?: boolean
    active?: boolean
  }


  export type $WarpPayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "Warp"
    objects: {}
    scalars: $Extensions.GetPayloadResult<{
      id: number
      name: string
      texture: string
      gamemode: string
      x: number
      y: number
      z: number
      active: boolean
    }, ExtArgs["result"]["warp"]>
    composites: {}
  }


  type WarpGetPayload<S extends boolean | null | undefined | WarpDefaultArgs> = $Result.GetResult<Prisma.$WarpPayload, S>

  type WarpCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = 
    Omit<WarpFindManyArgs, 'select' | 'include' | 'distinct' > & {
      select?: WarpCountAggregateInputType | true
    }

  export interface WarpDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['Warp'], meta: { name: 'Warp' } }
    /**
     * Find zero or one Warp that matches the filter.
     * @param {WarpFindUniqueArgs} args - Arguments to find a Warp
     * @example
     * // Get one Warp
     * const warp = await prisma.warp.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findUnique<T extends WarpFindUniqueArgs<ExtArgs>>(
      args: SelectSubset<T, WarpFindUniqueArgs<ExtArgs>>
    ): Prisma__WarpClient<$Result.GetResult<Prisma.$WarpPayload<ExtArgs>, T, 'findUnique'> | null, null, ExtArgs>

    /**
     * Find one Warp that matches the filter or throw an error  with `error.code='P2025'` 
     *     if no matches were found.
     * @param {WarpFindUniqueOrThrowArgs} args - Arguments to find a Warp
     * @example
     * // Get one Warp
     * const warp = await prisma.warp.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findUniqueOrThrow<T extends WarpFindUniqueOrThrowArgs<ExtArgs>>(
      args?: SelectSubset<T, WarpFindUniqueOrThrowArgs<ExtArgs>>
    ): Prisma__WarpClient<$Result.GetResult<Prisma.$WarpPayload<ExtArgs>, T, 'findUniqueOrThrow'>, never, ExtArgs>

    /**
     * Find the first Warp that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {WarpFindFirstArgs} args - Arguments to find a Warp
     * @example
     * // Get one Warp
     * const warp = await prisma.warp.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findFirst<T extends WarpFindFirstArgs<ExtArgs>>(
      args?: SelectSubset<T, WarpFindFirstArgs<ExtArgs>>
    ): Prisma__WarpClient<$Result.GetResult<Prisma.$WarpPayload<ExtArgs>, T, 'findFirst'> | null, null, ExtArgs>

    /**
     * Find the first Warp that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {WarpFindFirstOrThrowArgs} args - Arguments to find a Warp
     * @example
     * // Get one Warp
     * const warp = await prisma.warp.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findFirstOrThrow<T extends WarpFindFirstOrThrowArgs<ExtArgs>>(
      args?: SelectSubset<T, WarpFindFirstOrThrowArgs<ExtArgs>>
    ): Prisma__WarpClient<$Result.GetResult<Prisma.$WarpPayload<ExtArgs>, T, 'findFirstOrThrow'>, never, ExtArgs>

    /**
     * Find zero or more Warps that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {WarpFindManyArgs=} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all Warps
     * const warps = await prisma.warp.findMany()
     * 
     * // Get first 10 Warps
     * const warps = await prisma.warp.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const warpWithIdOnly = await prisma.warp.findMany({ select: { id: true } })
     * 
    **/
    findMany<T extends WarpFindManyArgs<ExtArgs>>(
      args?: SelectSubset<T, WarpFindManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<$Result.GetResult<Prisma.$WarpPayload<ExtArgs>, T, 'findMany'>>

    /**
     * Create a Warp.
     * @param {WarpCreateArgs} args - Arguments to create a Warp.
     * @example
     * // Create one Warp
     * const Warp = await prisma.warp.create({
     *   data: {
     *     // ... data to create a Warp
     *   }
     * })
     * 
    **/
    create<T extends WarpCreateArgs<ExtArgs>>(
      args: SelectSubset<T, WarpCreateArgs<ExtArgs>>
    ): Prisma__WarpClient<$Result.GetResult<Prisma.$WarpPayload<ExtArgs>, T, 'create'>, never, ExtArgs>

    /**
     * Create many Warps.
     *     @param {WarpCreateManyArgs} args - Arguments to create many Warps.
     *     @example
     *     // Create many Warps
     *     const warp = await prisma.warp.createMany({
     *       data: {
     *         // ... provide data here
     *       }
     *     })
     *     
    **/
    createMany<T extends WarpCreateManyArgs<ExtArgs>>(
      args?: SelectSubset<T, WarpCreateManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Delete a Warp.
     * @param {WarpDeleteArgs} args - Arguments to delete one Warp.
     * @example
     * // Delete one Warp
     * const Warp = await prisma.warp.delete({
     *   where: {
     *     // ... filter to delete one Warp
     *   }
     * })
     * 
    **/
    delete<T extends WarpDeleteArgs<ExtArgs>>(
      args: SelectSubset<T, WarpDeleteArgs<ExtArgs>>
    ): Prisma__WarpClient<$Result.GetResult<Prisma.$WarpPayload<ExtArgs>, T, 'delete'>, never, ExtArgs>

    /**
     * Update one Warp.
     * @param {WarpUpdateArgs} args - Arguments to update one Warp.
     * @example
     * // Update one Warp
     * const warp = await prisma.warp.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
    **/
    update<T extends WarpUpdateArgs<ExtArgs>>(
      args: SelectSubset<T, WarpUpdateArgs<ExtArgs>>
    ): Prisma__WarpClient<$Result.GetResult<Prisma.$WarpPayload<ExtArgs>, T, 'update'>, never, ExtArgs>

    /**
     * Delete zero or more Warps.
     * @param {WarpDeleteManyArgs} args - Arguments to filter Warps to delete.
     * @example
     * // Delete a few Warps
     * const { count } = await prisma.warp.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
    **/
    deleteMany<T extends WarpDeleteManyArgs<ExtArgs>>(
      args?: SelectSubset<T, WarpDeleteManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more Warps.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {WarpUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many Warps
     * const warp = await prisma.warp.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
    **/
    updateMany<T extends WarpUpdateManyArgs<ExtArgs>>(
      args: SelectSubset<T, WarpUpdateManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create or update one Warp.
     * @param {WarpUpsertArgs} args - Arguments to update or create a Warp.
     * @example
     * // Update or create a Warp
     * const warp = await prisma.warp.upsert({
     *   create: {
     *     // ... data to create a Warp
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the Warp we want to update
     *   }
     * })
    **/
    upsert<T extends WarpUpsertArgs<ExtArgs>>(
      args: SelectSubset<T, WarpUpsertArgs<ExtArgs>>
    ): Prisma__WarpClient<$Result.GetResult<Prisma.$WarpPayload<ExtArgs>, T, 'upsert'>, never, ExtArgs>

    /**
     * Count the number of Warps.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {WarpCountArgs} args - Arguments to filter Warps to count.
     * @example
     * // Count the number of Warps
     * const count = await prisma.warp.count({
     *   where: {
     *     // ... the filter for the Warps we want to count
     *   }
     * })
    **/
    count<T extends WarpCountArgs>(
      args?: Subset<T, WarpCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], WarpCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a Warp.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {WarpAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends WarpAggregateArgs>(args: Subset<T, WarpAggregateArgs>): Prisma.PrismaPromise<GetWarpAggregateType<T>>

    /**
     * Group by Warp.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {WarpGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends WarpGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: WarpGroupByArgs['orderBy'] }
        : { orderBy?: WarpGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, WarpGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetWarpGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the Warp model
   */
  readonly fields: WarpFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for Warp.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__WarpClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: 'PrismaPromise';


    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>;
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>;
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>;
  }



  /**
   * Fields of the Warp model
   */ 
  interface WarpFieldRefs {
    readonly id: FieldRef<"Warp", 'Int'>
    readonly name: FieldRef<"Warp", 'String'>
    readonly texture: FieldRef<"Warp", 'String'>
    readonly gamemode: FieldRef<"Warp", 'String'>
    readonly x: FieldRef<"Warp", 'Float'>
    readonly y: FieldRef<"Warp", 'Float'>
    readonly z: FieldRef<"Warp", 'Float'>
    readonly active: FieldRef<"Warp", 'Boolean'>
  }
    

  // Custom InputTypes

  /**
   * Warp findUnique
   */
  export type WarpFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Warp
     */
    select?: WarpSelect<ExtArgs> | null
    /**
     * Filter, which Warp to fetch.
     */
    where: WarpWhereUniqueInput
  }


  /**
   * Warp findUniqueOrThrow
   */
  export type WarpFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Warp
     */
    select?: WarpSelect<ExtArgs> | null
    /**
     * Filter, which Warp to fetch.
     */
    where: WarpWhereUniqueInput
  }


  /**
   * Warp findFirst
   */
  export type WarpFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Warp
     */
    select?: WarpSelect<ExtArgs> | null
    /**
     * Filter, which Warp to fetch.
     */
    where?: WarpWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Warps to fetch.
     */
    orderBy?: WarpOrderByWithRelationInput | WarpOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for Warps.
     */
    cursor?: WarpWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Warps from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Warps.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of Warps.
     */
    distinct?: WarpScalarFieldEnum | WarpScalarFieldEnum[]
  }


  /**
   * Warp findFirstOrThrow
   */
  export type WarpFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Warp
     */
    select?: WarpSelect<ExtArgs> | null
    /**
     * Filter, which Warp to fetch.
     */
    where?: WarpWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Warps to fetch.
     */
    orderBy?: WarpOrderByWithRelationInput | WarpOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for Warps.
     */
    cursor?: WarpWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Warps from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Warps.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of Warps.
     */
    distinct?: WarpScalarFieldEnum | WarpScalarFieldEnum[]
  }


  /**
   * Warp findMany
   */
  export type WarpFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Warp
     */
    select?: WarpSelect<ExtArgs> | null
    /**
     * Filter, which Warps to fetch.
     */
    where?: WarpWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Warps to fetch.
     */
    orderBy?: WarpOrderByWithRelationInput | WarpOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing Warps.
     */
    cursor?: WarpWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Warps from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Warps.
     */
    skip?: number
    distinct?: WarpScalarFieldEnum | WarpScalarFieldEnum[]
  }


  /**
   * Warp create
   */
  export type WarpCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Warp
     */
    select?: WarpSelect<ExtArgs> | null
    /**
     * The data needed to create a Warp.
     */
    data: XOR<WarpCreateInput, WarpUncheckedCreateInput>
  }


  /**
   * Warp createMany
   */
  export type WarpCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many Warps.
     */
    data: WarpCreateManyInput | WarpCreateManyInput[]
    skipDuplicates?: boolean
  }


  /**
   * Warp update
   */
  export type WarpUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Warp
     */
    select?: WarpSelect<ExtArgs> | null
    /**
     * The data needed to update a Warp.
     */
    data: XOR<WarpUpdateInput, WarpUncheckedUpdateInput>
    /**
     * Choose, which Warp to update.
     */
    where: WarpWhereUniqueInput
  }


  /**
   * Warp updateMany
   */
  export type WarpUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update Warps.
     */
    data: XOR<WarpUpdateManyMutationInput, WarpUncheckedUpdateManyInput>
    /**
     * Filter which Warps to update
     */
    where?: WarpWhereInput
  }


  /**
   * Warp upsert
   */
  export type WarpUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Warp
     */
    select?: WarpSelect<ExtArgs> | null
    /**
     * The filter to search for the Warp to update in case it exists.
     */
    where: WarpWhereUniqueInput
    /**
     * In case the Warp found by the `where` argument doesn't exist, create a new Warp with this data.
     */
    create: XOR<WarpCreateInput, WarpUncheckedCreateInput>
    /**
     * In case the Warp was found with the provided `where` argument, update it with this data.
     */
    update: XOR<WarpUpdateInput, WarpUncheckedUpdateInput>
  }


  /**
   * Warp delete
   */
  export type WarpDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Warp
     */
    select?: WarpSelect<ExtArgs> | null
    /**
     * Filter which Warp to delete.
     */
    where: WarpWhereUniqueInput
  }


  /**
   * Warp deleteMany
   */
  export type WarpDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which Warps to delete
     */
    where?: WarpWhereInput
  }


  /**
   * Warp without action
   */
  export type WarpDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Warp
     */
    select?: WarpSelect<ExtArgs> | null
  }



  /**
   * Model Guild
   */

  export type AggregateGuild = {
    _count: GuildCountAggregateOutputType | null
    _avg: GuildAvgAggregateOutputType | null
    _sum: GuildSumAggregateOutputType | null
    _min: GuildMinAggregateOutputType | null
    _max: GuildMaxAggregateOutputType | null
  }

  export type GuildAvgAggregateOutputType = {
    guildId: number | null
    maxMembers: number | null
  }

  export type GuildSumAggregateOutputType = {
    guildId: number | null
    maxMembers: number | null
  }

  export type GuildMinAggregateOutputType = {
    guildId: number | null
    name: string | null
    description: string | null
    ownerId: string | null
    maxMembers: number | null
    isPublic: boolean | null
    createdAt: Date | null
    updatedAt: Date | null
  }

  export type GuildMaxAggregateOutputType = {
    guildId: number | null
    name: string | null
    description: string | null
    ownerId: string | null
    maxMembers: number | null
    isPublic: boolean | null
    createdAt: Date | null
    updatedAt: Date | null
  }

  export type GuildCountAggregateOutputType = {
    guildId: number
    name: number
    description: number
    ownerId: number
    maxMembers: number
    isPublic: number
    createdAt: number
    updatedAt: number
    _all: number
  }


  export type GuildAvgAggregateInputType = {
    guildId?: true
    maxMembers?: true
  }

  export type GuildSumAggregateInputType = {
    guildId?: true
    maxMembers?: true
  }

  export type GuildMinAggregateInputType = {
    guildId?: true
    name?: true
    description?: true
    ownerId?: true
    maxMembers?: true
    isPublic?: true
    createdAt?: true
    updatedAt?: true
  }

  export type GuildMaxAggregateInputType = {
    guildId?: true
    name?: true
    description?: true
    ownerId?: true
    maxMembers?: true
    isPublic?: true
    createdAt?: true
    updatedAt?: true
  }

  export type GuildCountAggregateInputType = {
    guildId?: true
    name?: true
    description?: true
    ownerId?: true
    maxMembers?: true
    isPublic?: true
    createdAt?: true
    updatedAt?: true
    _all?: true
  }

  export type GuildAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which Guild to aggregate.
     */
    where?: GuildWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Guilds to fetch.
     */
    orderBy?: GuildOrderByWithRelationInput | GuildOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: GuildWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Guilds from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Guilds.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned Guilds
    **/
    _count?: true | GuildCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to average
    **/
    _avg?: GuildAvgAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to sum
    **/
    _sum?: GuildSumAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: GuildMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: GuildMaxAggregateInputType
  }

  export type GetGuildAggregateType<T extends GuildAggregateArgs> = {
        [P in keyof T & keyof AggregateGuild]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateGuild[P]>
      : GetScalarType<T[P], AggregateGuild[P]>
  }




  export type GuildGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: GuildWhereInput
    orderBy?: GuildOrderByWithAggregationInput | GuildOrderByWithAggregationInput[]
    by: GuildScalarFieldEnum[] | GuildScalarFieldEnum
    having?: GuildScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: GuildCountAggregateInputType | true
    _avg?: GuildAvgAggregateInputType
    _sum?: GuildSumAggregateInputType
    _min?: GuildMinAggregateInputType
    _max?: GuildMaxAggregateInputType
  }

  export type GuildGroupByOutputType = {
    guildId: number
    name: string
    description: string | null
    ownerId: string
    maxMembers: number
    isPublic: boolean
    createdAt: Date
    updatedAt: Date
    _count: GuildCountAggregateOutputType | null
    _avg: GuildAvgAggregateOutputType | null
    _sum: GuildSumAggregateOutputType | null
    _min: GuildMinAggregateOutputType | null
    _max: GuildMaxAggregateOutputType | null
  }

  type GetGuildGroupByPayload<T extends GuildGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<GuildGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof GuildGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], GuildGroupByOutputType[P]>
            : GetScalarType<T[P], GuildGroupByOutputType[P]>
        }
      >
    >


  export type GuildSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    guildId?: boolean
    name?: boolean
    description?: boolean
    ownerId?: boolean
    maxMembers?: boolean
    isPublic?: boolean
    createdAt?: boolean
    updatedAt?: boolean
    GuildMember?: boolean | Guild$GuildMemberArgs<ExtArgs>
    _count?: boolean | GuildCountOutputTypeDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["guild"]>

  export type GuildSelectScalar = {
    guildId?: boolean
    name?: boolean
    description?: boolean
    ownerId?: boolean
    maxMembers?: boolean
    isPublic?: boolean
    createdAt?: boolean
    updatedAt?: boolean
  }

  export type GuildInclude<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    GuildMember?: boolean | Guild$GuildMemberArgs<ExtArgs>
    _count?: boolean | GuildCountOutputTypeDefaultArgs<ExtArgs>
  }


  export type $GuildPayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "Guild"
    objects: {
      GuildMember: Prisma.$GuildMemberPayload<ExtArgs>[]
    }
    scalars: $Extensions.GetPayloadResult<{
      guildId: number
      name: string
      description: string | null
      ownerId: string
      maxMembers: number
      isPublic: boolean
      createdAt: Date
      updatedAt: Date
    }, ExtArgs["result"]["guild"]>
    composites: {}
  }


  type GuildGetPayload<S extends boolean | null | undefined | GuildDefaultArgs> = $Result.GetResult<Prisma.$GuildPayload, S>

  type GuildCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = 
    Omit<GuildFindManyArgs, 'select' | 'include' | 'distinct' > & {
      select?: GuildCountAggregateInputType | true
    }

  export interface GuildDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['Guild'], meta: { name: 'Guild' } }
    /**
     * Find zero or one Guild that matches the filter.
     * @param {GuildFindUniqueArgs} args - Arguments to find a Guild
     * @example
     * // Get one Guild
     * const guild = await prisma.guild.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findUnique<T extends GuildFindUniqueArgs<ExtArgs>>(
      args: SelectSubset<T, GuildFindUniqueArgs<ExtArgs>>
    ): Prisma__GuildClient<$Result.GetResult<Prisma.$GuildPayload<ExtArgs>, T, 'findUnique'> | null, null, ExtArgs>

    /**
     * Find one Guild that matches the filter or throw an error  with `error.code='P2025'` 
     *     if no matches were found.
     * @param {GuildFindUniqueOrThrowArgs} args - Arguments to find a Guild
     * @example
     * // Get one Guild
     * const guild = await prisma.guild.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findUniqueOrThrow<T extends GuildFindUniqueOrThrowArgs<ExtArgs>>(
      args?: SelectSubset<T, GuildFindUniqueOrThrowArgs<ExtArgs>>
    ): Prisma__GuildClient<$Result.GetResult<Prisma.$GuildPayload<ExtArgs>, T, 'findUniqueOrThrow'>, never, ExtArgs>

    /**
     * Find the first Guild that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {GuildFindFirstArgs} args - Arguments to find a Guild
     * @example
     * // Get one Guild
     * const guild = await prisma.guild.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findFirst<T extends GuildFindFirstArgs<ExtArgs>>(
      args?: SelectSubset<T, GuildFindFirstArgs<ExtArgs>>
    ): Prisma__GuildClient<$Result.GetResult<Prisma.$GuildPayload<ExtArgs>, T, 'findFirst'> | null, null, ExtArgs>

    /**
     * Find the first Guild that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {GuildFindFirstOrThrowArgs} args - Arguments to find a Guild
     * @example
     * // Get one Guild
     * const guild = await prisma.guild.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findFirstOrThrow<T extends GuildFindFirstOrThrowArgs<ExtArgs>>(
      args?: SelectSubset<T, GuildFindFirstOrThrowArgs<ExtArgs>>
    ): Prisma__GuildClient<$Result.GetResult<Prisma.$GuildPayload<ExtArgs>, T, 'findFirstOrThrow'>, never, ExtArgs>

    /**
     * Find zero or more Guilds that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {GuildFindManyArgs=} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all Guilds
     * const guilds = await prisma.guild.findMany()
     * 
     * // Get first 10 Guilds
     * const guilds = await prisma.guild.findMany({ take: 10 })
     * 
     * // Only select the `guildId`
     * const guildWithGuildIdOnly = await prisma.guild.findMany({ select: { guildId: true } })
     * 
    **/
    findMany<T extends GuildFindManyArgs<ExtArgs>>(
      args?: SelectSubset<T, GuildFindManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<$Result.GetResult<Prisma.$GuildPayload<ExtArgs>, T, 'findMany'>>

    /**
     * Create a Guild.
     * @param {GuildCreateArgs} args - Arguments to create a Guild.
     * @example
     * // Create one Guild
     * const Guild = await prisma.guild.create({
     *   data: {
     *     // ... data to create a Guild
     *   }
     * })
     * 
    **/
    create<T extends GuildCreateArgs<ExtArgs>>(
      args: SelectSubset<T, GuildCreateArgs<ExtArgs>>
    ): Prisma__GuildClient<$Result.GetResult<Prisma.$GuildPayload<ExtArgs>, T, 'create'>, never, ExtArgs>

    /**
     * Create many Guilds.
     *     @param {GuildCreateManyArgs} args - Arguments to create many Guilds.
     *     @example
     *     // Create many Guilds
     *     const guild = await prisma.guild.createMany({
     *       data: {
     *         // ... provide data here
     *       }
     *     })
     *     
    **/
    createMany<T extends GuildCreateManyArgs<ExtArgs>>(
      args?: SelectSubset<T, GuildCreateManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Delete a Guild.
     * @param {GuildDeleteArgs} args - Arguments to delete one Guild.
     * @example
     * // Delete one Guild
     * const Guild = await prisma.guild.delete({
     *   where: {
     *     // ... filter to delete one Guild
     *   }
     * })
     * 
    **/
    delete<T extends GuildDeleteArgs<ExtArgs>>(
      args: SelectSubset<T, GuildDeleteArgs<ExtArgs>>
    ): Prisma__GuildClient<$Result.GetResult<Prisma.$GuildPayload<ExtArgs>, T, 'delete'>, never, ExtArgs>

    /**
     * Update one Guild.
     * @param {GuildUpdateArgs} args - Arguments to update one Guild.
     * @example
     * // Update one Guild
     * const guild = await prisma.guild.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
    **/
    update<T extends GuildUpdateArgs<ExtArgs>>(
      args: SelectSubset<T, GuildUpdateArgs<ExtArgs>>
    ): Prisma__GuildClient<$Result.GetResult<Prisma.$GuildPayload<ExtArgs>, T, 'update'>, never, ExtArgs>

    /**
     * Delete zero or more Guilds.
     * @param {GuildDeleteManyArgs} args - Arguments to filter Guilds to delete.
     * @example
     * // Delete a few Guilds
     * const { count } = await prisma.guild.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
    **/
    deleteMany<T extends GuildDeleteManyArgs<ExtArgs>>(
      args?: SelectSubset<T, GuildDeleteManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more Guilds.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {GuildUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many Guilds
     * const guild = await prisma.guild.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
    **/
    updateMany<T extends GuildUpdateManyArgs<ExtArgs>>(
      args: SelectSubset<T, GuildUpdateManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create or update one Guild.
     * @param {GuildUpsertArgs} args - Arguments to update or create a Guild.
     * @example
     * // Update or create a Guild
     * const guild = await prisma.guild.upsert({
     *   create: {
     *     // ... data to create a Guild
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the Guild we want to update
     *   }
     * })
    **/
    upsert<T extends GuildUpsertArgs<ExtArgs>>(
      args: SelectSubset<T, GuildUpsertArgs<ExtArgs>>
    ): Prisma__GuildClient<$Result.GetResult<Prisma.$GuildPayload<ExtArgs>, T, 'upsert'>, never, ExtArgs>

    /**
     * Count the number of Guilds.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {GuildCountArgs} args - Arguments to filter Guilds to count.
     * @example
     * // Count the number of Guilds
     * const count = await prisma.guild.count({
     *   where: {
     *     // ... the filter for the Guilds we want to count
     *   }
     * })
    **/
    count<T extends GuildCountArgs>(
      args?: Subset<T, GuildCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], GuildCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a Guild.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {GuildAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends GuildAggregateArgs>(args: Subset<T, GuildAggregateArgs>): Prisma.PrismaPromise<GetGuildAggregateType<T>>

    /**
     * Group by Guild.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {GuildGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends GuildGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: GuildGroupByArgs['orderBy'] }
        : { orderBy?: GuildGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, GuildGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetGuildGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the Guild model
   */
  readonly fields: GuildFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for Guild.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__GuildClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: 'PrismaPromise';

    GuildMember<T extends Guild$GuildMemberArgs<ExtArgs> = {}>(args?: Subset<T, Guild$GuildMemberArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$GuildMemberPayload<ExtArgs>, T, 'findMany'> | Null>;

    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>;
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>;
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>;
  }



  /**
   * Fields of the Guild model
   */ 
  interface GuildFieldRefs {
    readonly guildId: FieldRef<"Guild", 'Int'>
    readonly name: FieldRef<"Guild", 'String'>
    readonly description: FieldRef<"Guild", 'String'>
    readonly ownerId: FieldRef<"Guild", 'String'>
    readonly maxMembers: FieldRef<"Guild", 'Int'>
    readonly isPublic: FieldRef<"Guild", 'Boolean'>
    readonly createdAt: FieldRef<"Guild", 'DateTime'>
    readonly updatedAt: FieldRef<"Guild", 'DateTime'>
  }
    

  // Custom InputTypes

  /**
   * Guild findUnique
   */
  export type GuildFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Guild
     */
    select?: GuildSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: GuildInclude<ExtArgs> | null
    /**
     * Filter, which Guild to fetch.
     */
    where: GuildWhereUniqueInput
  }


  /**
   * Guild findUniqueOrThrow
   */
  export type GuildFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Guild
     */
    select?: GuildSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: GuildInclude<ExtArgs> | null
    /**
     * Filter, which Guild to fetch.
     */
    where: GuildWhereUniqueInput
  }


  /**
   * Guild findFirst
   */
  export type GuildFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Guild
     */
    select?: GuildSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: GuildInclude<ExtArgs> | null
    /**
     * Filter, which Guild to fetch.
     */
    where?: GuildWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Guilds to fetch.
     */
    orderBy?: GuildOrderByWithRelationInput | GuildOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for Guilds.
     */
    cursor?: GuildWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Guilds from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Guilds.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of Guilds.
     */
    distinct?: GuildScalarFieldEnum | GuildScalarFieldEnum[]
  }


  /**
   * Guild findFirstOrThrow
   */
  export type GuildFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Guild
     */
    select?: GuildSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: GuildInclude<ExtArgs> | null
    /**
     * Filter, which Guild to fetch.
     */
    where?: GuildWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Guilds to fetch.
     */
    orderBy?: GuildOrderByWithRelationInput | GuildOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for Guilds.
     */
    cursor?: GuildWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Guilds from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Guilds.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of Guilds.
     */
    distinct?: GuildScalarFieldEnum | GuildScalarFieldEnum[]
  }


  /**
   * Guild findMany
   */
  export type GuildFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Guild
     */
    select?: GuildSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: GuildInclude<ExtArgs> | null
    /**
     * Filter, which Guilds to fetch.
     */
    where?: GuildWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Guilds to fetch.
     */
    orderBy?: GuildOrderByWithRelationInput | GuildOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing Guilds.
     */
    cursor?: GuildWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Guilds from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Guilds.
     */
    skip?: number
    distinct?: GuildScalarFieldEnum | GuildScalarFieldEnum[]
  }


  /**
   * Guild create
   */
  export type GuildCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Guild
     */
    select?: GuildSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: GuildInclude<ExtArgs> | null
    /**
     * The data needed to create a Guild.
     */
    data: XOR<GuildCreateInput, GuildUncheckedCreateInput>
  }


  /**
   * Guild createMany
   */
  export type GuildCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many Guilds.
     */
    data: GuildCreateManyInput | GuildCreateManyInput[]
    skipDuplicates?: boolean
  }


  /**
   * Guild update
   */
  export type GuildUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Guild
     */
    select?: GuildSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: GuildInclude<ExtArgs> | null
    /**
     * The data needed to update a Guild.
     */
    data: XOR<GuildUpdateInput, GuildUncheckedUpdateInput>
    /**
     * Choose, which Guild to update.
     */
    where: GuildWhereUniqueInput
  }


  /**
   * Guild updateMany
   */
  export type GuildUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update Guilds.
     */
    data: XOR<GuildUpdateManyMutationInput, GuildUncheckedUpdateManyInput>
    /**
     * Filter which Guilds to update
     */
    where?: GuildWhereInput
  }


  /**
   * Guild upsert
   */
  export type GuildUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Guild
     */
    select?: GuildSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: GuildInclude<ExtArgs> | null
    /**
     * The filter to search for the Guild to update in case it exists.
     */
    where: GuildWhereUniqueInput
    /**
     * In case the Guild found by the `where` argument doesn't exist, create a new Guild with this data.
     */
    create: XOR<GuildCreateInput, GuildUncheckedCreateInput>
    /**
     * In case the Guild was found with the provided `where` argument, update it with this data.
     */
    update: XOR<GuildUpdateInput, GuildUncheckedUpdateInput>
  }


  /**
   * Guild delete
   */
  export type GuildDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Guild
     */
    select?: GuildSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: GuildInclude<ExtArgs> | null
    /**
     * Filter which Guild to delete.
     */
    where: GuildWhereUniqueInput
  }


  /**
   * Guild deleteMany
   */
  export type GuildDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which Guilds to delete
     */
    where?: GuildWhereInput
  }


  /**
   * Guild.GuildMember
   */
  export type Guild$GuildMemberArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the GuildMember
     */
    select?: GuildMemberSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: GuildMemberInclude<ExtArgs> | null
    where?: GuildMemberWhereInput
    orderBy?: GuildMemberOrderByWithRelationInput | GuildMemberOrderByWithRelationInput[]
    cursor?: GuildMemberWhereUniqueInput
    take?: number
    skip?: number
    distinct?: GuildMemberScalarFieldEnum | GuildMemberScalarFieldEnum[]
  }


  /**
   * Guild without action
   */
  export type GuildDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Guild
     */
    select?: GuildSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: GuildInclude<ExtArgs> | null
  }



  /**
   * Model GuildMember
   */

  export type AggregateGuildMember = {
    _count: GuildMemberCountAggregateOutputType | null
    _avg: GuildMemberAvgAggregateOutputType | null
    _sum: GuildMemberSumAggregateOutputType | null
    _min: GuildMemberMinAggregateOutputType | null
    _max: GuildMemberMaxAggregateOutputType | null
  }

  export type GuildMemberAvgAggregateOutputType = {
    id: number | null
    guildId: number | null
  }

  export type GuildMemberSumAggregateOutputType = {
    id: number | null
    guildId: number | null
  }

  export type GuildMemberMinAggregateOutputType = {
    id: number | null
    guildId: number | null
    memberId: string | null
    memberRole: $Enums.GuildRole | null
  }

  export type GuildMemberMaxAggregateOutputType = {
    id: number | null
    guildId: number | null
    memberId: string | null
    memberRole: $Enums.GuildRole | null
  }

  export type GuildMemberCountAggregateOutputType = {
    id: number
    guildId: number
    memberId: number
    memberRole: number
    _all: number
  }


  export type GuildMemberAvgAggregateInputType = {
    id?: true
    guildId?: true
  }

  export type GuildMemberSumAggregateInputType = {
    id?: true
    guildId?: true
  }

  export type GuildMemberMinAggregateInputType = {
    id?: true
    guildId?: true
    memberId?: true
    memberRole?: true
  }

  export type GuildMemberMaxAggregateInputType = {
    id?: true
    guildId?: true
    memberId?: true
    memberRole?: true
  }

  export type GuildMemberCountAggregateInputType = {
    id?: true
    guildId?: true
    memberId?: true
    memberRole?: true
    _all?: true
  }

  export type GuildMemberAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which GuildMember to aggregate.
     */
    where?: GuildMemberWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of GuildMembers to fetch.
     */
    orderBy?: GuildMemberOrderByWithRelationInput | GuildMemberOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: GuildMemberWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` GuildMembers from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` GuildMembers.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned GuildMembers
    **/
    _count?: true | GuildMemberCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to average
    **/
    _avg?: GuildMemberAvgAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to sum
    **/
    _sum?: GuildMemberSumAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: GuildMemberMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: GuildMemberMaxAggregateInputType
  }

  export type GetGuildMemberAggregateType<T extends GuildMemberAggregateArgs> = {
        [P in keyof T & keyof AggregateGuildMember]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateGuildMember[P]>
      : GetScalarType<T[P], AggregateGuildMember[P]>
  }




  export type GuildMemberGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: GuildMemberWhereInput
    orderBy?: GuildMemberOrderByWithAggregationInput | GuildMemberOrderByWithAggregationInput[]
    by: GuildMemberScalarFieldEnum[] | GuildMemberScalarFieldEnum
    having?: GuildMemberScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: GuildMemberCountAggregateInputType | true
    _avg?: GuildMemberAvgAggregateInputType
    _sum?: GuildMemberSumAggregateInputType
    _min?: GuildMemberMinAggregateInputType
    _max?: GuildMemberMaxAggregateInputType
  }

  export type GuildMemberGroupByOutputType = {
    id: number
    guildId: number
    memberId: string
    memberRole: $Enums.GuildRole
    _count: GuildMemberCountAggregateOutputType | null
    _avg: GuildMemberAvgAggregateOutputType | null
    _sum: GuildMemberSumAggregateOutputType | null
    _min: GuildMemberMinAggregateOutputType | null
    _max: GuildMemberMaxAggregateOutputType | null
  }

  type GetGuildMemberGroupByPayload<T extends GuildMemberGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<GuildMemberGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof GuildMemberGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], GuildMemberGroupByOutputType[P]>
            : GetScalarType<T[P], GuildMemberGroupByOutputType[P]>
        }
      >
    >


  export type GuildMemberSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    guildId?: boolean
    memberId?: boolean
    memberRole?: boolean
    guild?: boolean | GuildDefaultArgs<ExtArgs>
    member?: boolean | UserDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["guildMember"]>

  export type GuildMemberSelectScalar = {
    id?: boolean
    guildId?: boolean
    memberId?: boolean
    memberRole?: boolean
  }

  export type GuildMemberInclude<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    guild?: boolean | GuildDefaultArgs<ExtArgs>
    member?: boolean | UserDefaultArgs<ExtArgs>
  }


  export type $GuildMemberPayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "GuildMember"
    objects: {
      guild: Prisma.$GuildPayload<ExtArgs>
      member: Prisma.$UserPayload<ExtArgs>
    }
    scalars: $Extensions.GetPayloadResult<{
      id: number
      guildId: number
      memberId: string
      memberRole: $Enums.GuildRole
    }, ExtArgs["result"]["guildMember"]>
    composites: {}
  }


  type GuildMemberGetPayload<S extends boolean | null | undefined | GuildMemberDefaultArgs> = $Result.GetResult<Prisma.$GuildMemberPayload, S>

  type GuildMemberCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = 
    Omit<GuildMemberFindManyArgs, 'select' | 'include' | 'distinct' > & {
      select?: GuildMemberCountAggregateInputType | true
    }

  export interface GuildMemberDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['GuildMember'], meta: { name: 'GuildMember' } }
    /**
     * Find zero or one GuildMember that matches the filter.
     * @param {GuildMemberFindUniqueArgs} args - Arguments to find a GuildMember
     * @example
     * // Get one GuildMember
     * const guildMember = await prisma.guildMember.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findUnique<T extends GuildMemberFindUniqueArgs<ExtArgs>>(
      args: SelectSubset<T, GuildMemberFindUniqueArgs<ExtArgs>>
    ): Prisma__GuildMemberClient<$Result.GetResult<Prisma.$GuildMemberPayload<ExtArgs>, T, 'findUnique'> | null, null, ExtArgs>

    /**
     * Find one GuildMember that matches the filter or throw an error  with `error.code='P2025'` 
     *     if no matches were found.
     * @param {GuildMemberFindUniqueOrThrowArgs} args - Arguments to find a GuildMember
     * @example
     * // Get one GuildMember
     * const guildMember = await prisma.guildMember.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findUniqueOrThrow<T extends GuildMemberFindUniqueOrThrowArgs<ExtArgs>>(
      args?: SelectSubset<T, GuildMemberFindUniqueOrThrowArgs<ExtArgs>>
    ): Prisma__GuildMemberClient<$Result.GetResult<Prisma.$GuildMemberPayload<ExtArgs>, T, 'findUniqueOrThrow'>, never, ExtArgs>

    /**
     * Find the first GuildMember that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {GuildMemberFindFirstArgs} args - Arguments to find a GuildMember
     * @example
     * // Get one GuildMember
     * const guildMember = await prisma.guildMember.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findFirst<T extends GuildMemberFindFirstArgs<ExtArgs>>(
      args?: SelectSubset<T, GuildMemberFindFirstArgs<ExtArgs>>
    ): Prisma__GuildMemberClient<$Result.GetResult<Prisma.$GuildMemberPayload<ExtArgs>, T, 'findFirst'> | null, null, ExtArgs>

    /**
     * Find the first GuildMember that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {GuildMemberFindFirstOrThrowArgs} args - Arguments to find a GuildMember
     * @example
     * // Get one GuildMember
     * const guildMember = await prisma.guildMember.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findFirstOrThrow<T extends GuildMemberFindFirstOrThrowArgs<ExtArgs>>(
      args?: SelectSubset<T, GuildMemberFindFirstOrThrowArgs<ExtArgs>>
    ): Prisma__GuildMemberClient<$Result.GetResult<Prisma.$GuildMemberPayload<ExtArgs>, T, 'findFirstOrThrow'>, never, ExtArgs>

    /**
     * Find zero or more GuildMembers that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {GuildMemberFindManyArgs=} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all GuildMembers
     * const guildMembers = await prisma.guildMember.findMany()
     * 
     * // Get first 10 GuildMembers
     * const guildMembers = await prisma.guildMember.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const guildMemberWithIdOnly = await prisma.guildMember.findMany({ select: { id: true } })
     * 
    **/
    findMany<T extends GuildMemberFindManyArgs<ExtArgs>>(
      args?: SelectSubset<T, GuildMemberFindManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<$Result.GetResult<Prisma.$GuildMemberPayload<ExtArgs>, T, 'findMany'>>

    /**
     * Create a GuildMember.
     * @param {GuildMemberCreateArgs} args - Arguments to create a GuildMember.
     * @example
     * // Create one GuildMember
     * const GuildMember = await prisma.guildMember.create({
     *   data: {
     *     // ... data to create a GuildMember
     *   }
     * })
     * 
    **/
    create<T extends GuildMemberCreateArgs<ExtArgs>>(
      args: SelectSubset<T, GuildMemberCreateArgs<ExtArgs>>
    ): Prisma__GuildMemberClient<$Result.GetResult<Prisma.$GuildMemberPayload<ExtArgs>, T, 'create'>, never, ExtArgs>

    /**
     * Create many GuildMembers.
     *     @param {GuildMemberCreateManyArgs} args - Arguments to create many GuildMembers.
     *     @example
     *     // Create many GuildMembers
     *     const guildMember = await prisma.guildMember.createMany({
     *       data: {
     *         // ... provide data here
     *       }
     *     })
     *     
    **/
    createMany<T extends GuildMemberCreateManyArgs<ExtArgs>>(
      args?: SelectSubset<T, GuildMemberCreateManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Delete a GuildMember.
     * @param {GuildMemberDeleteArgs} args - Arguments to delete one GuildMember.
     * @example
     * // Delete one GuildMember
     * const GuildMember = await prisma.guildMember.delete({
     *   where: {
     *     // ... filter to delete one GuildMember
     *   }
     * })
     * 
    **/
    delete<T extends GuildMemberDeleteArgs<ExtArgs>>(
      args: SelectSubset<T, GuildMemberDeleteArgs<ExtArgs>>
    ): Prisma__GuildMemberClient<$Result.GetResult<Prisma.$GuildMemberPayload<ExtArgs>, T, 'delete'>, never, ExtArgs>

    /**
     * Update one GuildMember.
     * @param {GuildMemberUpdateArgs} args - Arguments to update one GuildMember.
     * @example
     * // Update one GuildMember
     * const guildMember = await prisma.guildMember.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
    **/
    update<T extends GuildMemberUpdateArgs<ExtArgs>>(
      args: SelectSubset<T, GuildMemberUpdateArgs<ExtArgs>>
    ): Prisma__GuildMemberClient<$Result.GetResult<Prisma.$GuildMemberPayload<ExtArgs>, T, 'update'>, never, ExtArgs>

    /**
     * Delete zero or more GuildMembers.
     * @param {GuildMemberDeleteManyArgs} args - Arguments to filter GuildMembers to delete.
     * @example
     * // Delete a few GuildMembers
     * const { count } = await prisma.guildMember.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
    **/
    deleteMany<T extends GuildMemberDeleteManyArgs<ExtArgs>>(
      args?: SelectSubset<T, GuildMemberDeleteManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more GuildMembers.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {GuildMemberUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many GuildMembers
     * const guildMember = await prisma.guildMember.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
    **/
    updateMany<T extends GuildMemberUpdateManyArgs<ExtArgs>>(
      args: SelectSubset<T, GuildMemberUpdateManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create or update one GuildMember.
     * @param {GuildMemberUpsertArgs} args - Arguments to update or create a GuildMember.
     * @example
     * // Update or create a GuildMember
     * const guildMember = await prisma.guildMember.upsert({
     *   create: {
     *     // ... data to create a GuildMember
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the GuildMember we want to update
     *   }
     * })
    **/
    upsert<T extends GuildMemberUpsertArgs<ExtArgs>>(
      args: SelectSubset<T, GuildMemberUpsertArgs<ExtArgs>>
    ): Prisma__GuildMemberClient<$Result.GetResult<Prisma.$GuildMemberPayload<ExtArgs>, T, 'upsert'>, never, ExtArgs>

    /**
     * Count the number of GuildMembers.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {GuildMemberCountArgs} args - Arguments to filter GuildMembers to count.
     * @example
     * // Count the number of GuildMembers
     * const count = await prisma.guildMember.count({
     *   where: {
     *     // ... the filter for the GuildMembers we want to count
     *   }
     * })
    **/
    count<T extends GuildMemberCountArgs>(
      args?: Subset<T, GuildMemberCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], GuildMemberCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a GuildMember.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {GuildMemberAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends GuildMemberAggregateArgs>(args: Subset<T, GuildMemberAggregateArgs>): Prisma.PrismaPromise<GetGuildMemberAggregateType<T>>

    /**
     * Group by GuildMember.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {GuildMemberGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends GuildMemberGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: GuildMemberGroupByArgs['orderBy'] }
        : { orderBy?: GuildMemberGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, GuildMemberGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetGuildMemberGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the GuildMember model
   */
  readonly fields: GuildMemberFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for GuildMember.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__GuildMemberClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: 'PrismaPromise';

    guild<T extends GuildDefaultArgs<ExtArgs> = {}>(args?: Subset<T, GuildDefaultArgs<ExtArgs>>): Prisma__GuildClient<$Result.GetResult<Prisma.$GuildPayload<ExtArgs>, T, 'findUniqueOrThrow'> | Null, Null, ExtArgs>;

    member<T extends UserDefaultArgs<ExtArgs> = {}>(args?: Subset<T, UserDefaultArgs<ExtArgs>>): Prisma__UserClient<$Result.GetResult<Prisma.$UserPayload<ExtArgs>, T, 'findUniqueOrThrow'> | Null, Null, ExtArgs>;

    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>;
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>;
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>;
  }



  /**
   * Fields of the GuildMember model
   */ 
  interface GuildMemberFieldRefs {
    readonly id: FieldRef<"GuildMember", 'Int'>
    readonly guildId: FieldRef<"GuildMember", 'Int'>
    readonly memberId: FieldRef<"GuildMember", 'String'>
    readonly memberRole: FieldRef<"GuildMember", 'GuildRole'>
  }
    

  // Custom InputTypes

  /**
   * GuildMember findUnique
   */
  export type GuildMemberFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the GuildMember
     */
    select?: GuildMemberSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: GuildMemberInclude<ExtArgs> | null
    /**
     * Filter, which GuildMember to fetch.
     */
    where: GuildMemberWhereUniqueInput
  }


  /**
   * GuildMember findUniqueOrThrow
   */
  export type GuildMemberFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the GuildMember
     */
    select?: GuildMemberSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: GuildMemberInclude<ExtArgs> | null
    /**
     * Filter, which GuildMember to fetch.
     */
    where: GuildMemberWhereUniqueInput
  }


  /**
   * GuildMember findFirst
   */
  export type GuildMemberFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the GuildMember
     */
    select?: GuildMemberSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: GuildMemberInclude<ExtArgs> | null
    /**
     * Filter, which GuildMember to fetch.
     */
    where?: GuildMemberWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of GuildMembers to fetch.
     */
    orderBy?: GuildMemberOrderByWithRelationInput | GuildMemberOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for GuildMembers.
     */
    cursor?: GuildMemberWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` GuildMembers from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` GuildMembers.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of GuildMembers.
     */
    distinct?: GuildMemberScalarFieldEnum | GuildMemberScalarFieldEnum[]
  }


  /**
   * GuildMember findFirstOrThrow
   */
  export type GuildMemberFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the GuildMember
     */
    select?: GuildMemberSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: GuildMemberInclude<ExtArgs> | null
    /**
     * Filter, which GuildMember to fetch.
     */
    where?: GuildMemberWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of GuildMembers to fetch.
     */
    orderBy?: GuildMemberOrderByWithRelationInput | GuildMemberOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for GuildMembers.
     */
    cursor?: GuildMemberWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` GuildMembers from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` GuildMembers.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of GuildMembers.
     */
    distinct?: GuildMemberScalarFieldEnum | GuildMemberScalarFieldEnum[]
  }


  /**
   * GuildMember findMany
   */
  export type GuildMemberFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the GuildMember
     */
    select?: GuildMemberSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: GuildMemberInclude<ExtArgs> | null
    /**
     * Filter, which GuildMembers to fetch.
     */
    where?: GuildMemberWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of GuildMembers to fetch.
     */
    orderBy?: GuildMemberOrderByWithRelationInput | GuildMemberOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing GuildMembers.
     */
    cursor?: GuildMemberWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` GuildMembers from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` GuildMembers.
     */
    skip?: number
    distinct?: GuildMemberScalarFieldEnum | GuildMemberScalarFieldEnum[]
  }


  /**
   * GuildMember create
   */
  export type GuildMemberCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the GuildMember
     */
    select?: GuildMemberSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: GuildMemberInclude<ExtArgs> | null
    /**
     * The data needed to create a GuildMember.
     */
    data: XOR<GuildMemberCreateInput, GuildMemberUncheckedCreateInput>
  }


  /**
   * GuildMember createMany
   */
  export type GuildMemberCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many GuildMembers.
     */
    data: GuildMemberCreateManyInput | GuildMemberCreateManyInput[]
    skipDuplicates?: boolean
  }


  /**
   * GuildMember update
   */
  export type GuildMemberUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the GuildMember
     */
    select?: GuildMemberSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: GuildMemberInclude<ExtArgs> | null
    /**
     * The data needed to update a GuildMember.
     */
    data: XOR<GuildMemberUpdateInput, GuildMemberUncheckedUpdateInput>
    /**
     * Choose, which GuildMember to update.
     */
    where: GuildMemberWhereUniqueInput
  }


  /**
   * GuildMember updateMany
   */
  export type GuildMemberUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update GuildMembers.
     */
    data: XOR<GuildMemberUpdateManyMutationInput, GuildMemberUncheckedUpdateManyInput>
    /**
     * Filter which GuildMembers to update
     */
    where?: GuildMemberWhereInput
  }


  /**
   * GuildMember upsert
   */
  export type GuildMemberUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the GuildMember
     */
    select?: GuildMemberSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: GuildMemberInclude<ExtArgs> | null
    /**
     * The filter to search for the GuildMember to update in case it exists.
     */
    where: GuildMemberWhereUniqueInput
    /**
     * In case the GuildMember found by the `where` argument doesn't exist, create a new GuildMember with this data.
     */
    create: XOR<GuildMemberCreateInput, GuildMemberUncheckedCreateInput>
    /**
     * In case the GuildMember was found with the provided `where` argument, update it with this data.
     */
    update: XOR<GuildMemberUpdateInput, GuildMemberUncheckedUpdateInput>
  }


  /**
   * GuildMember delete
   */
  export type GuildMemberDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the GuildMember
     */
    select?: GuildMemberSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: GuildMemberInclude<ExtArgs> | null
    /**
     * Filter which GuildMember to delete.
     */
    where: GuildMemberWhereUniqueInput
  }


  /**
   * GuildMember deleteMany
   */
  export type GuildMemberDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which GuildMembers to delete
     */
    where?: GuildMemberWhereInput
  }


  /**
   * GuildMember without action
   */
  export type GuildMemberDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the GuildMember
     */
    select?: GuildMemberSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: GuildMemberInclude<ExtArgs> | null
  }



  /**
   * Model ShopCategory
   */

  export type AggregateShopCategory = {
    _count: ShopCategoryCountAggregateOutputType | null
    _avg: ShopCategoryAvgAggregateOutputType | null
    _sum: ShopCategorySumAggregateOutputType | null
    _min: ShopCategoryMinAggregateOutputType | null
    _max: ShopCategoryMaxAggregateOutputType | null
  }

  export type ShopCategoryAvgAggregateOutputType = {
    categoryID: number | null
    no: number | null
  }

  export type ShopCategorySumAggregateOutputType = {
    categoryID: number | null
    no: number | null
  }

  export type ShopCategoryMinAggregateOutputType = {
    categoryID: number | null
    no: number | null
    name: string | null
    texture: string | null
    type: $Enums.ItemType | null
    active: boolean | null
  }

  export type ShopCategoryMaxAggregateOutputType = {
    categoryID: number | null
    no: number | null
    name: string | null
    texture: string | null
    type: $Enums.ItemType | null
    active: boolean | null
  }

  export type ShopCategoryCountAggregateOutputType = {
    categoryID: number
    no: number
    name: number
    texture: number
    type: number
    active: number
    _all: number
  }


  export type ShopCategoryAvgAggregateInputType = {
    categoryID?: true
    no?: true
  }

  export type ShopCategorySumAggregateInputType = {
    categoryID?: true
    no?: true
  }

  export type ShopCategoryMinAggregateInputType = {
    categoryID?: true
    no?: true
    name?: true
    texture?: true
    type?: true
    active?: true
  }

  export type ShopCategoryMaxAggregateInputType = {
    categoryID?: true
    no?: true
    name?: true
    texture?: true
    type?: true
    active?: true
  }

  export type ShopCategoryCountAggregateInputType = {
    categoryID?: true
    no?: true
    name?: true
    texture?: true
    type?: true
    active?: true
    _all?: true
  }

  export type ShopCategoryAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which ShopCategory to aggregate.
     */
    where?: ShopCategoryWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of ShopCategories to fetch.
     */
    orderBy?: ShopCategoryOrderByWithRelationInput | ShopCategoryOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: ShopCategoryWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` ShopCategories from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` ShopCategories.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned ShopCategories
    **/
    _count?: true | ShopCategoryCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to average
    **/
    _avg?: ShopCategoryAvgAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to sum
    **/
    _sum?: ShopCategorySumAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: ShopCategoryMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: ShopCategoryMaxAggregateInputType
  }

  export type GetShopCategoryAggregateType<T extends ShopCategoryAggregateArgs> = {
        [P in keyof T & keyof AggregateShopCategory]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateShopCategory[P]>
      : GetScalarType<T[P], AggregateShopCategory[P]>
  }




  export type ShopCategoryGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: ShopCategoryWhereInput
    orderBy?: ShopCategoryOrderByWithAggregationInput | ShopCategoryOrderByWithAggregationInput[]
    by: ShopCategoryScalarFieldEnum[] | ShopCategoryScalarFieldEnum
    having?: ShopCategoryScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: ShopCategoryCountAggregateInputType | true
    _avg?: ShopCategoryAvgAggregateInputType
    _sum?: ShopCategorySumAggregateInputType
    _min?: ShopCategoryMinAggregateInputType
    _max?: ShopCategoryMaxAggregateInputType
  }

  export type ShopCategoryGroupByOutputType = {
    categoryID: number
    no: number
    name: string
    texture: string
    type: $Enums.ItemType
    active: boolean
    _count: ShopCategoryCountAggregateOutputType | null
    _avg: ShopCategoryAvgAggregateOutputType | null
    _sum: ShopCategorySumAggregateOutputType | null
    _min: ShopCategoryMinAggregateOutputType | null
    _max: ShopCategoryMaxAggregateOutputType | null
  }

  type GetShopCategoryGroupByPayload<T extends ShopCategoryGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<ShopCategoryGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof ShopCategoryGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], ShopCategoryGroupByOutputType[P]>
            : GetScalarType<T[P], ShopCategoryGroupByOutputType[P]>
        }
      >
    >


  export type ShopCategorySelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    categoryID?: boolean
    no?: boolean
    name?: boolean
    texture?: boolean
    type?: boolean
    active?: boolean
    ShopItem?: boolean | ShopCategory$ShopItemArgs<ExtArgs>
    _count?: boolean | ShopCategoryCountOutputTypeDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["shopCategory"]>

  export type ShopCategorySelectScalar = {
    categoryID?: boolean
    no?: boolean
    name?: boolean
    texture?: boolean
    type?: boolean
    active?: boolean
  }

  export type ShopCategoryInclude<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    ShopItem?: boolean | ShopCategory$ShopItemArgs<ExtArgs>
    _count?: boolean | ShopCategoryCountOutputTypeDefaultArgs<ExtArgs>
  }


  export type $ShopCategoryPayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "ShopCategory"
    objects: {
      ShopItem: Prisma.$ShopItemPayload<ExtArgs>[]
    }
    scalars: $Extensions.GetPayloadResult<{
      categoryID: number
      no: number
      name: string
      texture: string
      type: $Enums.ItemType
      active: boolean
    }, ExtArgs["result"]["shopCategory"]>
    composites: {}
  }


  type ShopCategoryGetPayload<S extends boolean | null | undefined | ShopCategoryDefaultArgs> = $Result.GetResult<Prisma.$ShopCategoryPayload, S>

  type ShopCategoryCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = 
    Omit<ShopCategoryFindManyArgs, 'select' | 'include' | 'distinct' > & {
      select?: ShopCategoryCountAggregateInputType | true
    }

  export interface ShopCategoryDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['ShopCategory'], meta: { name: 'ShopCategory' } }
    /**
     * Find zero or one ShopCategory that matches the filter.
     * @param {ShopCategoryFindUniqueArgs} args - Arguments to find a ShopCategory
     * @example
     * // Get one ShopCategory
     * const shopCategory = await prisma.shopCategory.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findUnique<T extends ShopCategoryFindUniqueArgs<ExtArgs>>(
      args: SelectSubset<T, ShopCategoryFindUniqueArgs<ExtArgs>>
    ): Prisma__ShopCategoryClient<$Result.GetResult<Prisma.$ShopCategoryPayload<ExtArgs>, T, 'findUnique'> | null, null, ExtArgs>

    /**
     * Find one ShopCategory that matches the filter or throw an error  with `error.code='P2025'` 
     *     if no matches were found.
     * @param {ShopCategoryFindUniqueOrThrowArgs} args - Arguments to find a ShopCategory
     * @example
     * // Get one ShopCategory
     * const shopCategory = await prisma.shopCategory.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findUniqueOrThrow<T extends ShopCategoryFindUniqueOrThrowArgs<ExtArgs>>(
      args?: SelectSubset<T, ShopCategoryFindUniqueOrThrowArgs<ExtArgs>>
    ): Prisma__ShopCategoryClient<$Result.GetResult<Prisma.$ShopCategoryPayload<ExtArgs>, T, 'findUniqueOrThrow'>, never, ExtArgs>

    /**
     * Find the first ShopCategory that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ShopCategoryFindFirstArgs} args - Arguments to find a ShopCategory
     * @example
     * // Get one ShopCategory
     * const shopCategory = await prisma.shopCategory.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findFirst<T extends ShopCategoryFindFirstArgs<ExtArgs>>(
      args?: SelectSubset<T, ShopCategoryFindFirstArgs<ExtArgs>>
    ): Prisma__ShopCategoryClient<$Result.GetResult<Prisma.$ShopCategoryPayload<ExtArgs>, T, 'findFirst'> | null, null, ExtArgs>

    /**
     * Find the first ShopCategory that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ShopCategoryFindFirstOrThrowArgs} args - Arguments to find a ShopCategory
     * @example
     * // Get one ShopCategory
     * const shopCategory = await prisma.shopCategory.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findFirstOrThrow<T extends ShopCategoryFindFirstOrThrowArgs<ExtArgs>>(
      args?: SelectSubset<T, ShopCategoryFindFirstOrThrowArgs<ExtArgs>>
    ): Prisma__ShopCategoryClient<$Result.GetResult<Prisma.$ShopCategoryPayload<ExtArgs>, T, 'findFirstOrThrow'>, never, ExtArgs>

    /**
     * Find zero or more ShopCategories that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ShopCategoryFindManyArgs=} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all ShopCategories
     * const shopCategories = await prisma.shopCategory.findMany()
     * 
     * // Get first 10 ShopCategories
     * const shopCategories = await prisma.shopCategory.findMany({ take: 10 })
     * 
     * // Only select the `categoryID`
     * const shopCategoryWithCategoryIDOnly = await prisma.shopCategory.findMany({ select: { categoryID: true } })
     * 
    **/
    findMany<T extends ShopCategoryFindManyArgs<ExtArgs>>(
      args?: SelectSubset<T, ShopCategoryFindManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<$Result.GetResult<Prisma.$ShopCategoryPayload<ExtArgs>, T, 'findMany'>>

    /**
     * Create a ShopCategory.
     * @param {ShopCategoryCreateArgs} args - Arguments to create a ShopCategory.
     * @example
     * // Create one ShopCategory
     * const ShopCategory = await prisma.shopCategory.create({
     *   data: {
     *     // ... data to create a ShopCategory
     *   }
     * })
     * 
    **/
    create<T extends ShopCategoryCreateArgs<ExtArgs>>(
      args: SelectSubset<T, ShopCategoryCreateArgs<ExtArgs>>
    ): Prisma__ShopCategoryClient<$Result.GetResult<Prisma.$ShopCategoryPayload<ExtArgs>, T, 'create'>, never, ExtArgs>

    /**
     * Create many ShopCategories.
     *     @param {ShopCategoryCreateManyArgs} args - Arguments to create many ShopCategories.
     *     @example
     *     // Create many ShopCategories
     *     const shopCategory = await prisma.shopCategory.createMany({
     *       data: {
     *         // ... provide data here
     *       }
     *     })
     *     
    **/
    createMany<T extends ShopCategoryCreateManyArgs<ExtArgs>>(
      args?: SelectSubset<T, ShopCategoryCreateManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Delete a ShopCategory.
     * @param {ShopCategoryDeleteArgs} args - Arguments to delete one ShopCategory.
     * @example
     * // Delete one ShopCategory
     * const ShopCategory = await prisma.shopCategory.delete({
     *   where: {
     *     // ... filter to delete one ShopCategory
     *   }
     * })
     * 
    **/
    delete<T extends ShopCategoryDeleteArgs<ExtArgs>>(
      args: SelectSubset<T, ShopCategoryDeleteArgs<ExtArgs>>
    ): Prisma__ShopCategoryClient<$Result.GetResult<Prisma.$ShopCategoryPayload<ExtArgs>, T, 'delete'>, never, ExtArgs>

    /**
     * Update one ShopCategory.
     * @param {ShopCategoryUpdateArgs} args - Arguments to update one ShopCategory.
     * @example
     * // Update one ShopCategory
     * const shopCategory = await prisma.shopCategory.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
    **/
    update<T extends ShopCategoryUpdateArgs<ExtArgs>>(
      args: SelectSubset<T, ShopCategoryUpdateArgs<ExtArgs>>
    ): Prisma__ShopCategoryClient<$Result.GetResult<Prisma.$ShopCategoryPayload<ExtArgs>, T, 'update'>, never, ExtArgs>

    /**
     * Delete zero or more ShopCategories.
     * @param {ShopCategoryDeleteManyArgs} args - Arguments to filter ShopCategories to delete.
     * @example
     * // Delete a few ShopCategories
     * const { count } = await prisma.shopCategory.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
    **/
    deleteMany<T extends ShopCategoryDeleteManyArgs<ExtArgs>>(
      args?: SelectSubset<T, ShopCategoryDeleteManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more ShopCategories.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ShopCategoryUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many ShopCategories
     * const shopCategory = await prisma.shopCategory.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
    **/
    updateMany<T extends ShopCategoryUpdateManyArgs<ExtArgs>>(
      args: SelectSubset<T, ShopCategoryUpdateManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create or update one ShopCategory.
     * @param {ShopCategoryUpsertArgs} args - Arguments to update or create a ShopCategory.
     * @example
     * // Update or create a ShopCategory
     * const shopCategory = await prisma.shopCategory.upsert({
     *   create: {
     *     // ... data to create a ShopCategory
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the ShopCategory we want to update
     *   }
     * })
    **/
    upsert<T extends ShopCategoryUpsertArgs<ExtArgs>>(
      args: SelectSubset<T, ShopCategoryUpsertArgs<ExtArgs>>
    ): Prisma__ShopCategoryClient<$Result.GetResult<Prisma.$ShopCategoryPayload<ExtArgs>, T, 'upsert'>, never, ExtArgs>

    /**
     * Count the number of ShopCategories.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ShopCategoryCountArgs} args - Arguments to filter ShopCategories to count.
     * @example
     * // Count the number of ShopCategories
     * const count = await prisma.shopCategory.count({
     *   where: {
     *     // ... the filter for the ShopCategories we want to count
     *   }
     * })
    **/
    count<T extends ShopCategoryCountArgs>(
      args?: Subset<T, ShopCategoryCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], ShopCategoryCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a ShopCategory.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ShopCategoryAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends ShopCategoryAggregateArgs>(args: Subset<T, ShopCategoryAggregateArgs>): Prisma.PrismaPromise<GetShopCategoryAggregateType<T>>

    /**
     * Group by ShopCategory.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ShopCategoryGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends ShopCategoryGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: ShopCategoryGroupByArgs['orderBy'] }
        : { orderBy?: ShopCategoryGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, ShopCategoryGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetShopCategoryGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the ShopCategory model
   */
  readonly fields: ShopCategoryFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for ShopCategory.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__ShopCategoryClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: 'PrismaPromise';

    ShopItem<T extends ShopCategory$ShopItemArgs<ExtArgs> = {}>(args?: Subset<T, ShopCategory$ShopItemArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$ShopItemPayload<ExtArgs>, T, 'findMany'> | Null>;

    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>;
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>;
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>;
  }



  /**
   * Fields of the ShopCategory model
   */ 
  interface ShopCategoryFieldRefs {
    readonly categoryID: FieldRef<"ShopCategory", 'Int'>
    readonly no: FieldRef<"ShopCategory", 'Int'>
    readonly name: FieldRef<"ShopCategory", 'String'>
    readonly texture: FieldRef<"ShopCategory", 'String'>
    readonly type: FieldRef<"ShopCategory", 'ItemType'>
    readonly active: FieldRef<"ShopCategory", 'Boolean'>
  }
    

  // Custom InputTypes

  /**
   * ShopCategory findUnique
   */
  export type ShopCategoryFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ShopCategory
     */
    select?: ShopCategorySelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: ShopCategoryInclude<ExtArgs> | null
    /**
     * Filter, which ShopCategory to fetch.
     */
    where: ShopCategoryWhereUniqueInput
  }


  /**
   * ShopCategory findUniqueOrThrow
   */
  export type ShopCategoryFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ShopCategory
     */
    select?: ShopCategorySelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: ShopCategoryInclude<ExtArgs> | null
    /**
     * Filter, which ShopCategory to fetch.
     */
    where: ShopCategoryWhereUniqueInput
  }


  /**
   * ShopCategory findFirst
   */
  export type ShopCategoryFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ShopCategory
     */
    select?: ShopCategorySelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: ShopCategoryInclude<ExtArgs> | null
    /**
     * Filter, which ShopCategory to fetch.
     */
    where?: ShopCategoryWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of ShopCategories to fetch.
     */
    orderBy?: ShopCategoryOrderByWithRelationInput | ShopCategoryOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for ShopCategories.
     */
    cursor?: ShopCategoryWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` ShopCategories from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` ShopCategories.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of ShopCategories.
     */
    distinct?: ShopCategoryScalarFieldEnum | ShopCategoryScalarFieldEnum[]
  }


  /**
   * ShopCategory findFirstOrThrow
   */
  export type ShopCategoryFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ShopCategory
     */
    select?: ShopCategorySelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: ShopCategoryInclude<ExtArgs> | null
    /**
     * Filter, which ShopCategory to fetch.
     */
    where?: ShopCategoryWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of ShopCategories to fetch.
     */
    orderBy?: ShopCategoryOrderByWithRelationInput | ShopCategoryOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for ShopCategories.
     */
    cursor?: ShopCategoryWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` ShopCategories from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` ShopCategories.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of ShopCategories.
     */
    distinct?: ShopCategoryScalarFieldEnum | ShopCategoryScalarFieldEnum[]
  }


  /**
   * ShopCategory findMany
   */
  export type ShopCategoryFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ShopCategory
     */
    select?: ShopCategorySelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: ShopCategoryInclude<ExtArgs> | null
    /**
     * Filter, which ShopCategories to fetch.
     */
    where?: ShopCategoryWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of ShopCategories to fetch.
     */
    orderBy?: ShopCategoryOrderByWithRelationInput | ShopCategoryOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing ShopCategories.
     */
    cursor?: ShopCategoryWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` ShopCategories from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` ShopCategories.
     */
    skip?: number
    distinct?: ShopCategoryScalarFieldEnum | ShopCategoryScalarFieldEnum[]
  }


  /**
   * ShopCategory create
   */
  export type ShopCategoryCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ShopCategory
     */
    select?: ShopCategorySelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: ShopCategoryInclude<ExtArgs> | null
    /**
     * The data needed to create a ShopCategory.
     */
    data: XOR<ShopCategoryCreateInput, ShopCategoryUncheckedCreateInput>
  }


  /**
   * ShopCategory createMany
   */
  export type ShopCategoryCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many ShopCategories.
     */
    data: ShopCategoryCreateManyInput | ShopCategoryCreateManyInput[]
    skipDuplicates?: boolean
  }


  /**
   * ShopCategory update
   */
  export type ShopCategoryUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ShopCategory
     */
    select?: ShopCategorySelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: ShopCategoryInclude<ExtArgs> | null
    /**
     * The data needed to update a ShopCategory.
     */
    data: XOR<ShopCategoryUpdateInput, ShopCategoryUncheckedUpdateInput>
    /**
     * Choose, which ShopCategory to update.
     */
    where: ShopCategoryWhereUniqueInput
  }


  /**
   * ShopCategory updateMany
   */
  export type ShopCategoryUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update ShopCategories.
     */
    data: XOR<ShopCategoryUpdateManyMutationInput, ShopCategoryUncheckedUpdateManyInput>
    /**
     * Filter which ShopCategories to update
     */
    where?: ShopCategoryWhereInput
  }


  /**
   * ShopCategory upsert
   */
  export type ShopCategoryUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ShopCategory
     */
    select?: ShopCategorySelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: ShopCategoryInclude<ExtArgs> | null
    /**
     * The filter to search for the ShopCategory to update in case it exists.
     */
    where: ShopCategoryWhereUniqueInput
    /**
     * In case the ShopCategory found by the `where` argument doesn't exist, create a new ShopCategory with this data.
     */
    create: XOR<ShopCategoryCreateInput, ShopCategoryUncheckedCreateInput>
    /**
     * In case the ShopCategory was found with the provided `where` argument, update it with this data.
     */
    update: XOR<ShopCategoryUpdateInput, ShopCategoryUncheckedUpdateInput>
  }


  /**
   * ShopCategory delete
   */
  export type ShopCategoryDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ShopCategory
     */
    select?: ShopCategorySelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: ShopCategoryInclude<ExtArgs> | null
    /**
     * Filter which ShopCategory to delete.
     */
    where: ShopCategoryWhereUniqueInput
  }


  /**
   * ShopCategory deleteMany
   */
  export type ShopCategoryDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which ShopCategories to delete
     */
    where?: ShopCategoryWhereInput
  }


  /**
   * ShopCategory.ShopItem
   */
  export type ShopCategory$ShopItemArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ShopItem
     */
    select?: ShopItemSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: ShopItemInclude<ExtArgs> | null
    where?: ShopItemWhereInput
    orderBy?: ShopItemOrderByWithRelationInput | ShopItemOrderByWithRelationInput[]
    cursor?: ShopItemWhereUniqueInput
    take?: number
    skip?: number
    distinct?: ShopItemScalarFieldEnum | ShopItemScalarFieldEnum[]
  }


  /**
   * ShopCategory without action
   */
  export type ShopCategoryDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ShopCategory
     */
    select?: ShopCategorySelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: ShopCategoryInclude<ExtArgs> | null
  }



  /**
   * Model ShopItem
   */

  export type AggregateShopItem = {
    _count: ShopItemCountAggregateOutputType | null
    _avg: ShopItemAvgAggregateOutputType | null
    _sum: ShopItemSumAggregateOutputType | null
    _min: ShopItemMinAggregateOutputType | null
    _max: ShopItemMaxAggregateOutputType | null
  }

  export type ShopItemAvgAggregateOutputType = {
    itemId: number | null
    categoryId: number | null
    cost: number | null
    sell: number | null
    data: number | null
    maxLevel: number | null
  }

  export type ShopItemSumAggregateOutputType = {
    itemId: number | null
    categoryId: number | null
    cost: number | null
    sell: number | null
    data: number | null
    maxLevel: number | null
  }

  export type ShopItemMinAggregateOutputType = {
    itemId: number | null
    categoryId: number | null
    texture: string | null
    name: string | null
    cost: number | null
    sell: number | null
    data: number | null
    item: string | null
    maxLevel: number | null
    enchant: string | null
    enchantType: $Enums.EnchantType | null
    available: boolean | null
    createdAt: Date | null
    updatedAt: Date | null
  }

  export type ShopItemMaxAggregateOutputType = {
    itemId: number | null
    categoryId: number | null
    texture: string | null
    name: string | null
    cost: number | null
    sell: number | null
    data: number | null
    item: string | null
    maxLevel: number | null
    enchant: string | null
    enchantType: $Enums.EnchantType | null
    available: boolean | null
    createdAt: Date | null
    updatedAt: Date | null
  }

  export type ShopItemCountAggregateOutputType = {
    itemId: number
    categoryId: number
    texture: number
    name: number
    cost: number
    sell: number
    data: number
    item: number
    maxLevel: number
    enchant: number
    enchantType: number
    available: number
    createdAt: number
    updatedAt: number
    _all: number
  }


  export type ShopItemAvgAggregateInputType = {
    itemId?: true
    categoryId?: true
    cost?: true
    sell?: true
    data?: true
    maxLevel?: true
  }

  export type ShopItemSumAggregateInputType = {
    itemId?: true
    categoryId?: true
    cost?: true
    sell?: true
    data?: true
    maxLevel?: true
  }

  export type ShopItemMinAggregateInputType = {
    itemId?: true
    categoryId?: true
    texture?: true
    name?: true
    cost?: true
    sell?: true
    data?: true
    item?: true
    maxLevel?: true
    enchant?: true
    enchantType?: true
    available?: true
    createdAt?: true
    updatedAt?: true
  }

  export type ShopItemMaxAggregateInputType = {
    itemId?: true
    categoryId?: true
    texture?: true
    name?: true
    cost?: true
    sell?: true
    data?: true
    item?: true
    maxLevel?: true
    enchant?: true
    enchantType?: true
    available?: true
    createdAt?: true
    updatedAt?: true
  }

  export type ShopItemCountAggregateInputType = {
    itemId?: true
    categoryId?: true
    texture?: true
    name?: true
    cost?: true
    sell?: true
    data?: true
    item?: true
    maxLevel?: true
    enchant?: true
    enchantType?: true
    available?: true
    createdAt?: true
    updatedAt?: true
    _all?: true
  }

  export type ShopItemAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which ShopItem to aggregate.
     */
    where?: ShopItemWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of ShopItems to fetch.
     */
    orderBy?: ShopItemOrderByWithRelationInput | ShopItemOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: ShopItemWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` ShopItems from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` ShopItems.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned ShopItems
    **/
    _count?: true | ShopItemCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to average
    **/
    _avg?: ShopItemAvgAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to sum
    **/
    _sum?: ShopItemSumAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: ShopItemMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: ShopItemMaxAggregateInputType
  }

  export type GetShopItemAggregateType<T extends ShopItemAggregateArgs> = {
        [P in keyof T & keyof AggregateShopItem]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateShopItem[P]>
      : GetScalarType<T[P], AggregateShopItem[P]>
  }




  export type ShopItemGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: ShopItemWhereInput
    orderBy?: ShopItemOrderByWithAggregationInput | ShopItemOrderByWithAggregationInput[]
    by: ShopItemScalarFieldEnum[] | ShopItemScalarFieldEnum
    having?: ShopItemScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: ShopItemCountAggregateInputType | true
    _avg?: ShopItemAvgAggregateInputType
    _sum?: ShopItemSumAggregateInputType
    _min?: ShopItemMinAggregateInputType
    _max?: ShopItemMaxAggregateInputType
  }

  export type ShopItemGroupByOutputType = {
    itemId: number
    categoryId: number
    texture: string
    name: string
    cost: number
    sell: number | null
    data: number
    item: string
    maxLevel: number | null
    enchant: string | null
    enchantType: $Enums.EnchantType | null
    available: boolean
    createdAt: Date
    updatedAt: Date
    _count: ShopItemCountAggregateOutputType | null
    _avg: ShopItemAvgAggregateOutputType | null
    _sum: ShopItemSumAggregateOutputType | null
    _min: ShopItemMinAggregateOutputType | null
    _max: ShopItemMaxAggregateOutputType | null
  }

  type GetShopItemGroupByPayload<T extends ShopItemGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<ShopItemGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof ShopItemGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], ShopItemGroupByOutputType[P]>
            : GetScalarType<T[P], ShopItemGroupByOutputType[P]>
        }
      >
    >


  export type ShopItemSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    itemId?: boolean
    categoryId?: boolean
    texture?: boolean
    name?: boolean
    cost?: boolean
    sell?: boolean
    data?: boolean
    item?: boolean
    maxLevel?: boolean
    enchant?: boolean
    enchantType?: boolean
    available?: boolean
    createdAt?: boolean
    updatedAt?: boolean
    category?: boolean | ShopCategoryDefaultArgs<ExtArgs>
    TransactionDetail?: boolean | ShopItem$TransactionDetailArgs<ExtArgs>
    _count?: boolean | ShopItemCountOutputTypeDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["shopItem"]>

  export type ShopItemSelectScalar = {
    itemId?: boolean
    categoryId?: boolean
    texture?: boolean
    name?: boolean
    cost?: boolean
    sell?: boolean
    data?: boolean
    item?: boolean
    maxLevel?: boolean
    enchant?: boolean
    enchantType?: boolean
    available?: boolean
    createdAt?: boolean
    updatedAt?: boolean
  }

  export type ShopItemInclude<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    category?: boolean | ShopCategoryDefaultArgs<ExtArgs>
    TransactionDetail?: boolean | ShopItem$TransactionDetailArgs<ExtArgs>
    _count?: boolean | ShopItemCountOutputTypeDefaultArgs<ExtArgs>
  }


  export type $ShopItemPayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "ShopItem"
    objects: {
      category: Prisma.$ShopCategoryPayload<ExtArgs>
      TransactionDetail: Prisma.$TransactionDetailPayload<ExtArgs>[]
    }
    scalars: $Extensions.GetPayloadResult<{
      itemId: number
      categoryId: number
      texture: string
      name: string
      cost: number
      sell: number | null
      data: number
      item: string
      maxLevel: number | null
      enchant: string | null
      enchantType: $Enums.EnchantType | null
      available: boolean
      createdAt: Date
      updatedAt: Date
    }, ExtArgs["result"]["shopItem"]>
    composites: {}
  }


  type ShopItemGetPayload<S extends boolean | null | undefined | ShopItemDefaultArgs> = $Result.GetResult<Prisma.$ShopItemPayload, S>

  type ShopItemCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = 
    Omit<ShopItemFindManyArgs, 'select' | 'include' | 'distinct' > & {
      select?: ShopItemCountAggregateInputType | true
    }

  export interface ShopItemDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['ShopItem'], meta: { name: 'ShopItem' } }
    /**
     * Find zero or one ShopItem that matches the filter.
     * @param {ShopItemFindUniqueArgs} args - Arguments to find a ShopItem
     * @example
     * // Get one ShopItem
     * const shopItem = await prisma.shopItem.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findUnique<T extends ShopItemFindUniqueArgs<ExtArgs>>(
      args: SelectSubset<T, ShopItemFindUniqueArgs<ExtArgs>>
    ): Prisma__ShopItemClient<$Result.GetResult<Prisma.$ShopItemPayload<ExtArgs>, T, 'findUnique'> | null, null, ExtArgs>

    /**
     * Find one ShopItem that matches the filter or throw an error  with `error.code='P2025'` 
     *     if no matches were found.
     * @param {ShopItemFindUniqueOrThrowArgs} args - Arguments to find a ShopItem
     * @example
     * // Get one ShopItem
     * const shopItem = await prisma.shopItem.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findUniqueOrThrow<T extends ShopItemFindUniqueOrThrowArgs<ExtArgs>>(
      args?: SelectSubset<T, ShopItemFindUniqueOrThrowArgs<ExtArgs>>
    ): Prisma__ShopItemClient<$Result.GetResult<Prisma.$ShopItemPayload<ExtArgs>, T, 'findUniqueOrThrow'>, never, ExtArgs>

    /**
     * Find the first ShopItem that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ShopItemFindFirstArgs} args - Arguments to find a ShopItem
     * @example
     * // Get one ShopItem
     * const shopItem = await prisma.shopItem.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findFirst<T extends ShopItemFindFirstArgs<ExtArgs>>(
      args?: SelectSubset<T, ShopItemFindFirstArgs<ExtArgs>>
    ): Prisma__ShopItemClient<$Result.GetResult<Prisma.$ShopItemPayload<ExtArgs>, T, 'findFirst'> | null, null, ExtArgs>

    /**
     * Find the first ShopItem that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ShopItemFindFirstOrThrowArgs} args - Arguments to find a ShopItem
     * @example
     * // Get one ShopItem
     * const shopItem = await prisma.shopItem.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findFirstOrThrow<T extends ShopItemFindFirstOrThrowArgs<ExtArgs>>(
      args?: SelectSubset<T, ShopItemFindFirstOrThrowArgs<ExtArgs>>
    ): Prisma__ShopItemClient<$Result.GetResult<Prisma.$ShopItemPayload<ExtArgs>, T, 'findFirstOrThrow'>, never, ExtArgs>

    /**
     * Find zero or more ShopItems that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ShopItemFindManyArgs=} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all ShopItems
     * const shopItems = await prisma.shopItem.findMany()
     * 
     * // Get first 10 ShopItems
     * const shopItems = await prisma.shopItem.findMany({ take: 10 })
     * 
     * // Only select the `itemId`
     * const shopItemWithItemIdOnly = await prisma.shopItem.findMany({ select: { itemId: true } })
     * 
    **/
    findMany<T extends ShopItemFindManyArgs<ExtArgs>>(
      args?: SelectSubset<T, ShopItemFindManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<$Result.GetResult<Prisma.$ShopItemPayload<ExtArgs>, T, 'findMany'>>

    /**
     * Create a ShopItem.
     * @param {ShopItemCreateArgs} args - Arguments to create a ShopItem.
     * @example
     * // Create one ShopItem
     * const ShopItem = await prisma.shopItem.create({
     *   data: {
     *     // ... data to create a ShopItem
     *   }
     * })
     * 
    **/
    create<T extends ShopItemCreateArgs<ExtArgs>>(
      args: SelectSubset<T, ShopItemCreateArgs<ExtArgs>>
    ): Prisma__ShopItemClient<$Result.GetResult<Prisma.$ShopItemPayload<ExtArgs>, T, 'create'>, never, ExtArgs>

    /**
     * Create many ShopItems.
     *     @param {ShopItemCreateManyArgs} args - Arguments to create many ShopItems.
     *     @example
     *     // Create many ShopItems
     *     const shopItem = await prisma.shopItem.createMany({
     *       data: {
     *         // ... provide data here
     *       }
     *     })
     *     
    **/
    createMany<T extends ShopItemCreateManyArgs<ExtArgs>>(
      args?: SelectSubset<T, ShopItemCreateManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Delete a ShopItem.
     * @param {ShopItemDeleteArgs} args - Arguments to delete one ShopItem.
     * @example
     * // Delete one ShopItem
     * const ShopItem = await prisma.shopItem.delete({
     *   where: {
     *     // ... filter to delete one ShopItem
     *   }
     * })
     * 
    **/
    delete<T extends ShopItemDeleteArgs<ExtArgs>>(
      args: SelectSubset<T, ShopItemDeleteArgs<ExtArgs>>
    ): Prisma__ShopItemClient<$Result.GetResult<Prisma.$ShopItemPayload<ExtArgs>, T, 'delete'>, never, ExtArgs>

    /**
     * Update one ShopItem.
     * @param {ShopItemUpdateArgs} args - Arguments to update one ShopItem.
     * @example
     * // Update one ShopItem
     * const shopItem = await prisma.shopItem.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
    **/
    update<T extends ShopItemUpdateArgs<ExtArgs>>(
      args: SelectSubset<T, ShopItemUpdateArgs<ExtArgs>>
    ): Prisma__ShopItemClient<$Result.GetResult<Prisma.$ShopItemPayload<ExtArgs>, T, 'update'>, never, ExtArgs>

    /**
     * Delete zero or more ShopItems.
     * @param {ShopItemDeleteManyArgs} args - Arguments to filter ShopItems to delete.
     * @example
     * // Delete a few ShopItems
     * const { count } = await prisma.shopItem.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
    **/
    deleteMany<T extends ShopItemDeleteManyArgs<ExtArgs>>(
      args?: SelectSubset<T, ShopItemDeleteManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more ShopItems.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ShopItemUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many ShopItems
     * const shopItem = await prisma.shopItem.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
    **/
    updateMany<T extends ShopItemUpdateManyArgs<ExtArgs>>(
      args: SelectSubset<T, ShopItemUpdateManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create or update one ShopItem.
     * @param {ShopItemUpsertArgs} args - Arguments to update or create a ShopItem.
     * @example
     * // Update or create a ShopItem
     * const shopItem = await prisma.shopItem.upsert({
     *   create: {
     *     // ... data to create a ShopItem
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the ShopItem we want to update
     *   }
     * })
    **/
    upsert<T extends ShopItemUpsertArgs<ExtArgs>>(
      args: SelectSubset<T, ShopItemUpsertArgs<ExtArgs>>
    ): Prisma__ShopItemClient<$Result.GetResult<Prisma.$ShopItemPayload<ExtArgs>, T, 'upsert'>, never, ExtArgs>

    /**
     * Count the number of ShopItems.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ShopItemCountArgs} args - Arguments to filter ShopItems to count.
     * @example
     * // Count the number of ShopItems
     * const count = await prisma.shopItem.count({
     *   where: {
     *     // ... the filter for the ShopItems we want to count
     *   }
     * })
    **/
    count<T extends ShopItemCountArgs>(
      args?: Subset<T, ShopItemCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], ShopItemCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a ShopItem.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ShopItemAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends ShopItemAggregateArgs>(args: Subset<T, ShopItemAggregateArgs>): Prisma.PrismaPromise<GetShopItemAggregateType<T>>

    /**
     * Group by ShopItem.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ShopItemGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends ShopItemGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: ShopItemGroupByArgs['orderBy'] }
        : { orderBy?: ShopItemGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, ShopItemGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetShopItemGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the ShopItem model
   */
  readonly fields: ShopItemFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for ShopItem.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__ShopItemClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: 'PrismaPromise';

    category<T extends ShopCategoryDefaultArgs<ExtArgs> = {}>(args?: Subset<T, ShopCategoryDefaultArgs<ExtArgs>>): Prisma__ShopCategoryClient<$Result.GetResult<Prisma.$ShopCategoryPayload<ExtArgs>, T, 'findUniqueOrThrow'> | Null, Null, ExtArgs>;

    TransactionDetail<T extends ShopItem$TransactionDetailArgs<ExtArgs> = {}>(args?: Subset<T, ShopItem$TransactionDetailArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$TransactionDetailPayload<ExtArgs>, T, 'findMany'> | Null>;

    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>;
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>;
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>;
  }



  /**
   * Fields of the ShopItem model
   */ 
  interface ShopItemFieldRefs {
    readonly itemId: FieldRef<"ShopItem", 'Int'>
    readonly categoryId: FieldRef<"ShopItem", 'Int'>
    readonly texture: FieldRef<"ShopItem", 'String'>
    readonly name: FieldRef<"ShopItem", 'String'>
    readonly cost: FieldRef<"ShopItem", 'Int'>
    readonly sell: FieldRef<"ShopItem", 'Int'>
    readonly data: FieldRef<"ShopItem", 'Int'>
    readonly item: FieldRef<"ShopItem", 'String'>
    readonly maxLevel: FieldRef<"ShopItem", 'Int'>
    readonly enchant: FieldRef<"ShopItem", 'String'>
    readonly enchantType: FieldRef<"ShopItem", 'EnchantType'>
    readonly available: FieldRef<"ShopItem", 'Boolean'>
    readonly createdAt: FieldRef<"ShopItem", 'DateTime'>
    readonly updatedAt: FieldRef<"ShopItem", 'DateTime'>
  }
    

  // Custom InputTypes

  /**
   * ShopItem findUnique
   */
  export type ShopItemFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ShopItem
     */
    select?: ShopItemSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: ShopItemInclude<ExtArgs> | null
    /**
     * Filter, which ShopItem to fetch.
     */
    where: ShopItemWhereUniqueInput
  }


  /**
   * ShopItem findUniqueOrThrow
   */
  export type ShopItemFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ShopItem
     */
    select?: ShopItemSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: ShopItemInclude<ExtArgs> | null
    /**
     * Filter, which ShopItem to fetch.
     */
    where: ShopItemWhereUniqueInput
  }


  /**
   * ShopItem findFirst
   */
  export type ShopItemFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ShopItem
     */
    select?: ShopItemSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: ShopItemInclude<ExtArgs> | null
    /**
     * Filter, which ShopItem to fetch.
     */
    where?: ShopItemWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of ShopItems to fetch.
     */
    orderBy?: ShopItemOrderByWithRelationInput | ShopItemOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for ShopItems.
     */
    cursor?: ShopItemWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` ShopItems from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` ShopItems.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of ShopItems.
     */
    distinct?: ShopItemScalarFieldEnum | ShopItemScalarFieldEnum[]
  }


  /**
   * ShopItem findFirstOrThrow
   */
  export type ShopItemFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ShopItem
     */
    select?: ShopItemSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: ShopItemInclude<ExtArgs> | null
    /**
     * Filter, which ShopItem to fetch.
     */
    where?: ShopItemWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of ShopItems to fetch.
     */
    orderBy?: ShopItemOrderByWithRelationInput | ShopItemOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for ShopItems.
     */
    cursor?: ShopItemWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` ShopItems from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` ShopItems.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of ShopItems.
     */
    distinct?: ShopItemScalarFieldEnum | ShopItemScalarFieldEnum[]
  }


  /**
   * ShopItem findMany
   */
  export type ShopItemFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ShopItem
     */
    select?: ShopItemSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: ShopItemInclude<ExtArgs> | null
    /**
     * Filter, which ShopItems to fetch.
     */
    where?: ShopItemWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of ShopItems to fetch.
     */
    orderBy?: ShopItemOrderByWithRelationInput | ShopItemOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing ShopItems.
     */
    cursor?: ShopItemWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` ShopItems from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` ShopItems.
     */
    skip?: number
    distinct?: ShopItemScalarFieldEnum | ShopItemScalarFieldEnum[]
  }


  /**
   * ShopItem create
   */
  export type ShopItemCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ShopItem
     */
    select?: ShopItemSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: ShopItemInclude<ExtArgs> | null
    /**
     * The data needed to create a ShopItem.
     */
    data: XOR<ShopItemCreateInput, ShopItemUncheckedCreateInput>
  }


  /**
   * ShopItem createMany
   */
  export type ShopItemCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many ShopItems.
     */
    data: ShopItemCreateManyInput | ShopItemCreateManyInput[]
    skipDuplicates?: boolean
  }


  /**
   * ShopItem update
   */
  export type ShopItemUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ShopItem
     */
    select?: ShopItemSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: ShopItemInclude<ExtArgs> | null
    /**
     * The data needed to update a ShopItem.
     */
    data: XOR<ShopItemUpdateInput, ShopItemUncheckedUpdateInput>
    /**
     * Choose, which ShopItem to update.
     */
    where: ShopItemWhereUniqueInput
  }


  /**
   * ShopItem updateMany
   */
  export type ShopItemUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update ShopItems.
     */
    data: XOR<ShopItemUpdateManyMutationInput, ShopItemUncheckedUpdateManyInput>
    /**
     * Filter which ShopItems to update
     */
    where?: ShopItemWhereInput
  }


  /**
   * ShopItem upsert
   */
  export type ShopItemUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ShopItem
     */
    select?: ShopItemSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: ShopItemInclude<ExtArgs> | null
    /**
     * The filter to search for the ShopItem to update in case it exists.
     */
    where: ShopItemWhereUniqueInput
    /**
     * In case the ShopItem found by the `where` argument doesn't exist, create a new ShopItem with this data.
     */
    create: XOR<ShopItemCreateInput, ShopItemUncheckedCreateInput>
    /**
     * In case the ShopItem was found with the provided `where` argument, update it with this data.
     */
    update: XOR<ShopItemUpdateInput, ShopItemUncheckedUpdateInput>
  }


  /**
   * ShopItem delete
   */
  export type ShopItemDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ShopItem
     */
    select?: ShopItemSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: ShopItemInclude<ExtArgs> | null
    /**
     * Filter which ShopItem to delete.
     */
    where: ShopItemWhereUniqueInput
  }


  /**
   * ShopItem deleteMany
   */
  export type ShopItemDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which ShopItems to delete
     */
    where?: ShopItemWhereInput
  }


  /**
   * ShopItem.TransactionDetail
   */
  export type ShopItem$TransactionDetailArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the TransactionDetail
     */
    select?: TransactionDetailSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: TransactionDetailInclude<ExtArgs> | null
    where?: TransactionDetailWhereInput
    orderBy?: TransactionDetailOrderByWithRelationInput | TransactionDetailOrderByWithRelationInput[]
    cursor?: TransactionDetailWhereUniqueInput
    take?: number
    skip?: number
    distinct?: TransactionDetailScalarFieldEnum | TransactionDetailScalarFieldEnum[]
  }


  /**
   * ShopItem without action
   */
  export type ShopItemDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ShopItem
     */
    select?: ShopItemSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: ShopItemInclude<ExtArgs> | null
  }



  /**
   * Model Transaction
   */

  export type AggregateTransaction = {
    _count: TransactionCountAggregateOutputType | null
    _avg: TransactionAvgAggregateOutputType | null
    _sum: TransactionSumAggregateOutputType | null
    _min: TransactionMinAggregateOutputType | null
    _max: TransactionMaxAggregateOutputType | null
  }

  export type TransactionAvgAggregateOutputType = {
    transactionId: number | null
  }

  export type TransactionSumAggregateOutputType = {
    transactionId: number | null
  }

  export type TransactionMinAggregateOutputType = {
    transactionId: number | null
    userId: string | null
    targetUserId: string | null
    createdAt: Date | null
    trxType: $Enums.TrxType | null
  }

  export type TransactionMaxAggregateOutputType = {
    transactionId: number | null
    userId: string | null
    targetUserId: string | null
    createdAt: Date | null
    trxType: $Enums.TrxType | null
  }

  export type TransactionCountAggregateOutputType = {
    transactionId: number
    userId: number
    targetUserId: number
    createdAt: number
    trxType: number
    _all: number
  }


  export type TransactionAvgAggregateInputType = {
    transactionId?: true
  }

  export type TransactionSumAggregateInputType = {
    transactionId?: true
  }

  export type TransactionMinAggregateInputType = {
    transactionId?: true
    userId?: true
    targetUserId?: true
    createdAt?: true
    trxType?: true
  }

  export type TransactionMaxAggregateInputType = {
    transactionId?: true
    userId?: true
    targetUserId?: true
    createdAt?: true
    trxType?: true
  }

  export type TransactionCountAggregateInputType = {
    transactionId?: true
    userId?: true
    targetUserId?: true
    createdAt?: true
    trxType?: true
    _all?: true
  }

  export type TransactionAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which Transaction to aggregate.
     */
    where?: TransactionWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Transactions to fetch.
     */
    orderBy?: TransactionOrderByWithRelationInput | TransactionOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: TransactionWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Transactions from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Transactions.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned Transactions
    **/
    _count?: true | TransactionCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to average
    **/
    _avg?: TransactionAvgAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to sum
    **/
    _sum?: TransactionSumAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: TransactionMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: TransactionMaxAggregateInputType
  }

  export type GetTransactionAggregateType<T extends TransactionAggregateArgs> = {
        [P in keyof T & keyof AggregateTransaction]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateTransaction[P]>
      : GetScalarType<T[P], AggregateTransaction[P]>
  }




  export type TransactionGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: TransactionWhereInput
    orderBy?: TransactionOrderByWithAggregationInput | TransactionOrderByWithAggregationInput[]
    by: TransactionScalarFieldEnum[] | TransactionScalarFieldEnum
    having?: TransactionScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: TransactionCountAggregateInputType | true
    _avg?: TransactionAvgAggregateInputType
    _sum?: TransactionSumAggregateInputType
    _min?: TransactionMinAggregateInputType
    _max?: TransactionMaxAggregateInputType
  }

  export type TransactionGroupByOutputType = {
    transactionId: number
    userId: string
    targetUserId: string | null
    createdAt: Date
    trxType: $Enums.TrxType
    _count: TransactionCountAggregateOutputType | null
    _avg: TransactionAvgAggregateOutputType | null
    _sum: TransactionSumAggregateOutputType | null
    _min: TransactionMinAggregateOutputType | null
    _max: TransactionMaxAggregateOutputType | null
  }

  type GetTransactionGroupByPayload<T extends TransactionGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<TransactionGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof TransactionGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], TransactionGroupByOutputType[P]>
            : GetScalarType<T[P], TransactionGroupByOutputType[P]>
        }
      >
    >


  export type TransactionSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    transactionId?: boolean
    userId?: boolean
    targetUserId?: boolean
    createdAt?: boolean
    trxType?: boolean
    user?: boolean | Transaction$userArgs<ExtArgs>
    targetUser?: boolean | Transaction$targetUserArgs<ExtArgs>
    TransactionDetail?: boolean | Transaction$TransactionDetailArgs<ExtArgs>
  }, ExtArgs["result"]["transaction"]>

  export type TransactionSelectScalar = {
    transactionId?: boolean
    userId?: boolean
    targetUserId?: boolean
    createdAt?: boolean
    trxType?: boolean
  }

  export type TransactionInclude<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    user?: boolean | Transaction$userArgs<ExtArgs>
    targetUser?: boolean | Transaction$targetUserArgs<ExtArgs>
    TransactionDetail?: boolean | Transaction$TransactionDetailArgs<ExtArgs>
  }


  export type $TransactionPayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "Transaction"
    objects: {
      user: Prisma.$UserPayload<ExtArgs> | null
      targetUser: Prisma.$UserPayload<ExtArgs> | null
      TransactionDetail: Prisma.$TransactionDetailPayload<ExtArgs> | null
    }
    scalars: $Extensions.GetPayloadResult<{
      transactionId: number
      userId: string
      targetUserId: string | null
      createdAt: Date
      trxType: $Enums.TrxType
    }, ExtArgs["result"]["transaction"]>
    composites: {}
  }


  type TransactionGetPayload<S extends boolean | null | undefined | TransactionDefaultArgs> = $Result.GetResult<Prisma.$TransactionPayload, S>

  type TransactionCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = 
    Omit<TransactionFindManyArgs, 'select' | 'include' | 'distinct' > & {
      select?: TransactionCountAggregateInputType | true
    }

  export interface TransactionDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['Transaction'], meta: { name: 'Transaction' } }
    /**
     * Find zero or one Transaction that matches the filter.
     * @param {TransactionFindUniqueArgs} args - Arguments to find a Transaction
     * @example
     * // Get one Transaction
     * const transaction = await prisma.transaction.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findUnique<T extends TransactionFindUniqueArgs<ExtArgs>>(
      args: SelectSubset<T, TransactionFindUniqueArgs<ExtArgs>>
    ): Prisma__TransactionClient<$Result.GetResult<Prisma.$TransactionPayload<ExtArgs>, T, 'findUnique'> | null, null, ExtArgs>

    /**
     * Find one Transaction that matches the filter or throw an error  with `error.code='P2025'` 
     *     if no matches were found.
     * @param {TransactionFindUniqueOrThrowArgs} args - Arguments to find a Transaction
     * @example
     * // Get one Transaction
     * const transaction = await prisma.transaction.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findUniqueOrThrow<T extends TransactionFindUniqueOrThrowArgs<ExtArgs>>(
      args?: SelectSubset<T, TransactionFindUniqueOrThrowArgs<ExtArgs>>
    ): Prisma__TransactionClient<$Result.GetResult<Prisma.$TransactionPayload<ExtArgs>, T, 'findUniqueOrThrow'>, never, ExtArgs>

    /**
     * Find the first Transaction that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {TransactionFindFirstArgs} args - Arguments to find a Transaction
     * @example
     * // Get one Transaction
     * const transaction = await prisma.transaction.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findFirst<T extends TransactionFindFirstArgs<ExtArgs>>(
      args?: SelectSubset<T, TransactionFindFirstArgs<ExtArgs>>
    ): Prisma__TransactionClient<$Result.GetResult<Prisma.$TransactionPayload<ExtArgs>, T, 'findFirst'> | null, null, ExtArgs>

    /**
     * Find the first Transaction that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {TransactionFindFirstOrThrowArgs} args - Arguments to find a Transaction
     * @example
     * // Get one Transaction
     * const transaction = await prisma.transaction.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findFirstOrThrow<T extends TransactionFindFirstOrThrowArgs<ExtArgs>>(
      args?: SelectSubset<T, TransactionFindFirstOrThrowArgs<ExtArgs>>
    ): Prisma__TransactionClient<$Result.GetResult<Prisma.$TransactionPayload<ExtArgs>, T, 'findFirstOrThrow'>, never, ExtArgs>

    /**
     * Find zero or more Transactions that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {TransactionFindManyArgs=} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all Transactions
     * const transactions = await prisma.transaction.findMany()
     * 
     * // Get first 10 Transactions
     * const transactions = await prisma.transaction.findMany({ take: 10 })
     * 
     * // Only select the `transactionId`
     * const transactionWithTransactionIdOnly = await prisma.transaction.findMany({ select: { transactionId: true } })
     * 
    **/
    findMany<T extends TransactionFindManyArgs<ExtArgs>>(
      args?: SelectSubset<T, TransactionFindManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<$Result.GetResult<Prisma.$TransactionPayload<ExtArgs>, T, 'findMany'>>

    /**
     * Create a Transaction.
     * @param {TransactionCreateArgs} args - Arguments to create a Transaction.
     * @example
     * // Create one Transaction
     * const Transaction = await prisma.transaction.create({
     *   data: {
     *     // ... data to create a Transaction
     *   }
     * })
     * 
    **/
    create<T extends TransactionCreateArgs<ExtArgs>>(
      args: SelectSubset<T, TransactionCreateArgs<ExtArgs>>
    ): Prisma__TransactionClient<$Result.GetResult<Prisma.$TransactionPayload<ExtArgs>, T, 'create'>, never, ExtArgs>

    /**
     * Create many Transactions.
     *     @param {TransactionCreateManyArgs} args - Arguments to create many Transactions.
     *     @example
     *     // Create many Transactions
     *     const transaction = await prisma.transaction.createMany({
     *       data: {
     *         // ... provide data here
     *       }
     *     })
     *     
    **/
    createMany<T extends TransactionCreateManyArgs<ExtArgs>>(
      args?: SelectSubset<T, TransactionCreateManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Delete a Transaction.
     * @param {TransactionDeleteArgs} args - Arguments to delete one Transaction.
     * @example
     * // Delete one Transaction
     * const Transaction = await prisma.transaction.delete({
     *   where: {
     *     // ... filter to delete one Transaction
     *   }
     * })
     * 
    **/
    delete<T extends TransactionDeleteArgs<ExtArgs>>(
      args: SelectSubset<T, TransactionDeleteArgs<ExtArgs>>
    ): Prisma__TransactionClient<$Result.GetResult<Prisma.$TransactionPayload<ExtArgs>, T, 'delete'>, never, ExtArgs>

    /**
     * Update one Transaction.
     * @param {TransactionUpdateArgs} args - Arguments to update one Transaction.
     * @example
     * // Update one Transaction
     * const transaction = await prisma.transaction.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
    **/
    update<T extends TransactionUpdateArgs<ExtArgs>>(
      args: SelectSubset<T, TransactionUpdateArgs<ExtArgs>>
    ): Prisma__TransactionClient<$Result.GetResult<Prisma.$TransactionPayload<ExtArgs>, T, 'update'>, never, ExtArgs>

    /**
     * Delete zero or more Transactions.
     * @param {TransactionDeleteManyArgs} args - Arguments to filter Transactions to delete.
     * @example
     * // Delete a few Transactions
     * const { count } = await prisma.transaction.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
    **/
    deleteMany<T extends TransactionDeleteManyArgs<ExtArgs>>(
      args?: SelectSubset<T, TransactionDeleteManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more Transactions.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {TransactionUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many Transactions
     * const transaction = await prisma.transaction.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
    **/
    updateMany<T extends TransactionUpdateManyArgs<ExtArgs>>(
      args: SelectSubset<T, TransactionUpdateManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create or update one Transaction.
     * @param {TransactionUpsertArgs} args - Arguments to update or create a Transaction.
     * @example
     * // Update or create a Transaction
     * const transaction = await prisma.transaction.upsert({
     *   create: {
     *     // ... data to create a Transaction
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the Transaction we want to update
     *   }
     * })
    **/
    upsert<T extends TransactionUpsertArgs<ExtArgs>>(
      args: SelectSubset<T, TransactionUpsertArgs<ExtArgs>>
    ): Prisma__TransactionClient<$Result.GetResult<Prisma.$TransactionPayload<ExtArgs>, T, 'upsert'>, never, ExtArgs>

    /**
     * Count the number of Transactions.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {TransactionCountArgs} args - Arguments to filter Transactions to count.
     * @example
     * // Count the number of Transactions
     * const count = await prisma.transaction.count({
     *   where: {
     *     // ... the filter for the Transactions we want to count
     *   }
     * })
    **/
    count<T extends TransactionCountArgs>(
      args?: Subset<T, TransactionCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], TransactionCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a Transaction.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {TransactionAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends TransactionAggregateArgs>(args: Subset<T, TransactionAggregateArgs>): Prisma.PrismaPromise<GetTransactionAggregateType<T>>

    /**
     * Group by Transaction.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {TransactionGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends TransactionGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: TransactionGroupByArgs['orderBy'] }
        : { orderBy?: TransactionGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, TransactionGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetTransactionGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the Transaction model
   */
  readonly fields: TransactionFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for Transaction.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__TransactionClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: 'PrismaPromise';

    user<T extends Transaction$userArgs<ExtArgs> = {}>(args?: Subset<T, Transaction$userArgs<ExtArgs>>): Prisma__UserClient<$Result.GetResult<Prisma.$UserPayload<ExtArgs>, T, 'findUniqueOrThrow'> | null, null, ExtArgs>;

    targetUser<T extends Transaction$targetUserArgs<ExtArgs> = {}>(args?: Subset<T, Transaction$targetUserArgs<ExtArgs>>): Prisma__UserClient<$Result.GetResult<Prisma.$UserPayload<ExtArgs>, T, 'findUniqueOrThrow'> | null, null, ExtArgs>;

    TransactionDetail<T extends Transaction$TransactionDetailArgs<ExtArgs> = {}>(args?: Subset<T, Transaction$TransactionDetailArgs<ExtArgs>>): Prisma__TransactionDetailClient<$Result.GetResult<Prisma.$TransactionDetailPayload<ExtArgs>, T, 'findUniqueOrThrow'> | null, null, ExtArgs>;

    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>;
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>;
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>;
  }



  /**
   * Fields of the Transaction model
   */ 
  interface TransactionFieldRefs {
    readonly transactionId: FieldRef<"Transaction", 'Int'>
    readonly userId: FieldRef<"Transaction", 'String'>
    readonly targetUserId: FieldRef<"Transaction", 'String'>
    readonly createdAt: FieldRef<"Transaction", 'DateTime'>
    readonly trxType: FieldRef<"Transaction", 'TrxType'>
  }
    

  // Custom InputTypes

  /**
   * Transaction findUnique
   */
  export type TransactionFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Transaction
     */
    select?: TransactionSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: TransactionInclude<ExtArgs> | null
    /**
     * Filter, which Transaction to fetch.
     */
    where: TransactionWhereUniqueInput
  }


  /**
   * Transaction findUniqueOrThrow
   */
  export type TransactionFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Transaction
     */
    select?: TransactionSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: TransactionInclude<ExtArgs> | null
    /**
     * Filter, which Transaction to fetch.
     */
    where: TransactionWhereUniqueInput
  }


  /**
   * Transaction findFirst
   */
  export type TransactionFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Transaction
     */
    select?: TransactionSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: TransactionInclude<ExtArgs> | null
    /**
     * Filter, which Transaction to fetch.
     */
    where?: TransactionWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Transactions to fetch.
     */
    orderBy?: TransactionOrderByWithRelationInput | TransactionOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for Transactions.
     */
    cursor?: TransactionWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Transactions from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Transactions.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of Transactions.
     */
    distinct?: TransactionScalarFieldEnum | TransactionScalarFieldEnum[]
  }


  /**
   * Transaction findFirstOrThrow
   */
  export type TransactionFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Transaction
     */
    select?: TransactionSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: TransactionInclude<ExtArgs> | null
    /**
     * Filter, which Transaction to fetch.
     */
    where?: TransactionWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Transactions to fetch.
     */
    orderBy?: TransactionOrderByWithRelationInput | TransactionOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for Transactions.
     */
    cursor?: TransactionWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Transactions from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Transactions.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of Transactions.
     */
    distinct?: TransactionScalarFieldEnum | TransactionScalarFieldEnum[]
  }


  /**
   * Transaction findMany
   */
  export type TransactionFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Transaction
     */
    select?: TransactionSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: TransactionInclude<ExtArgs> | null
    /**
     * Filter, which Transactions to fetch.
     */
    where?: TransactionWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Transactions to fetch.
     */
    orderBy?: TransactionOrderByWithRelationInput | TransactionOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing Transactions.
     */
    cursor?: TransactionWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Transactions from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Transactions.
     */
    skip?: number
    distinct?: TransactionScalarFieldEnum | TransactionScalarFieldEnum[]
  }


  /**
   * Transaction create
   */
  export type TransactionCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Transaction
     */
    select?: TransactionSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: TransactionInclude<ExtArgs> | null
    /**
     * The data needed to create a Transaction.
     */
    data: XOR<TransactionCreateInput, TransactionUncheckedCreateInput>
  }


  /**
   * Transaction createMany
   */
  export type TransactionCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many Transactions.
     */
    data: TransactionCreateManyInput | TransactionCreateManyInput[]
    skipDuplicates?: boolean
  }


  /**
   * Transaction update
   */
  export type TransactionUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Transaction
     */
    select?: TransactionSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: TransactionInclude<ExtArgs> | null
    /**
     * The data needed to update a Transaction.
     */
    data: XOR<TransactionUpdateInput, TransactionUncheckedUpdateInput>
    /**
     * Choose, which Transaction to update.
     */
    where: TransactionWhereUniqueInput
  }


  /**
   * Transaction updateMany
   */
  export type TransactionUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update Transactions.
     */
    data: XOR<TransactionUpdateManyMutationInput, TransactionUncheckedUpdateManyInput>
    /**
     * Filter which Transactions to update
     */
    where?: TransactionWhereInput
  }


  /**
   * Transaction upsert
   */
  export type TransactionUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Transaction
     */
    select?: TransactionSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: TransactionInclude<ExtArgs> | null
    /**
     * The filter to search for the Transaction to update in case it exists.
     */
    where: TransactionWhereUniqueInput
    /**
     * In case the Transaction found by the `where` argument doesn't exist, create a new Transaction with this data.
     */
    create: XOR<TransactionCreateInput, TransactionUncheckedCreateInput>
    /**
     * In case the Transaction was found with the provided `where` argument, update it with this data.
     */
    update: XOR<TransactionUpdateInput, TransactionUncheckedUpdateInput>
  }


  /**
   * Transaction delete
   */
  export type TransactionDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Transaction
     */
    select?: TransactionSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: TransactionInclude<ExtArgs> | null
    /**
     * Filter which Transaction to delete.
     */
    where: TransactionWhereUniqueInput
  }


  /**
   * Transaction deleteMany
   */
  export type TransactionDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which Transactions to delete
     */
    where?: TransactionWhereInput
  }


  /**
   * Transaction.user
   */
  export type Transaction$userArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the User
     */
    select?: UserSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: UserInclude<ExtArgs> | null
    where?: UserWhereInput
  }


  /**
   * Transaction.targetUser
   */
  export type Transaction$targetUserArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the User
     */
    select?: UserSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: UserInclude<ExtArgs> | null
    where?: UserWhereInput
  }


  /**
   * Transaction.TransactionDetail
   */
  export type Transaction$TransactionDetailArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the TransactionDetail
     */
    select?: TransactionDetailSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: TransactionDetailInclude<ExtArgs> | null
    where?: TransactionDetailWhereInput
  }


  /**
   * Transaction without action
   */
  export type TransactionDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Transaction
     */
    select?: TransactionSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: TransactionInclude<ExtArgs> | null
  }



  /**
   * Model TransactionDetail
   */

  export type AggregateTransactionDetail = {
    _count: TransactionDetailCountAggregateOutputType | null
    _avg: TransactionDetailAvgAggregateOutputType | null
    _sum: TransactionDetailSumAggregateOutputType | null
    _min: TransactionDetailMinAggregateOutputType | null
    _max: TransactionDetailMaxAggregateOutputType | null
  }

  export type TransactionDetailAvgAggregateOutputType = {
    id: number | null
    transactionId: number | null
    itemId: number | null
    qty: number | null
    totalPrice: number | null
  }

  export type TransactionDetailSumAggregateOutputType = {
    id: number | null
    transactionId: number | null
    itemId: number | null
    qty: number | null
    totalPrice: number | null
  }

  export type TransactionDetailMinAggregateOutputType = {
    id: number | null
    transactionId: number | null
    itemId: number | null
    qty: number | null
    totalPrice: number | null
  }

  export type TransactionDetailMaxAggregateOutputType = {
    id: number | null
    transactionId: number | null
    itemId: number | null
    qty: number | null
    totalPrice: number | null
  }

  export type TransactionDetailCountAggregateOutputType = {
    id: number
    transactionId: number
    itemId: number
    qty: number
    totalPrice: number
    _all: number
  }


  export type TransactionDetailAvgAggregateInputType = {
    id?: true
    transactionId?: true
    itemId?: true
    qty?: true
    totalPrice?: true
  }

  export type TransactionDetailSumAggregateInputType = {
    id?: true
    transactionId?: true
    itemId?: true
    qty?: true
    totalPrice?: true
  }

  export type TransactionDetailMinAggregateInputType = {
    id?: true
    transactionId?: true
    itemId?: true
    qty?: true
    totalPrice?: true
  }

  export type TransactionDetailMaxAggregateInputType = {
    id?: true
    transactionId?: true
    itemId?: true
    qty?: true
    totalPrice?: true
  }

  export type TransactionDetailCountAggregateInputType = {
    id?: true
    transactionId?: true
    itemId?: true
    qty?: true
    totalPrice?: true
    _all?: true
  }

  export type TransactionDetailAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which TransactionDetail to aggregate.
     */
    where?: TransactionDetailWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of TransactionDetails to fetch.
     */
    orderBy?: TransactionDetailOrderByWithRelationInput | TransactionDetailOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: TransactionDetailWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` TransactionDetails from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` TransactionDetails.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned TransactionDetails
    **/
    _count?: true | TransactionDetailCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to average
    **/
    _avg?: TransactionDetailAvgAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to sum
    **/
    _sum?: TransactionDetailSumAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: TransactionDetailMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: TransactionDetailMaxAggregateInputType
  }

  export type GetTransactionDetailAggregateType<T extends TransactionDetailAggregateArgs> = {
        [P in keyof T & keyof AggregateTransactionDetail]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateTransactionDetail[P]>
      : GetScalarType<T[P], AggregateTransactionDetail[P]>
  }




  export type TransactionDetailGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: TransactionDetailWhereInput
    orderBy?: TransactionDetailOrderByWithAggregationInput | TransactionDetailOrderByWithAggregationInput[]
    by: TransactionDetailScalarFieldEnum[] | TransactionDetailScalarFieldEnum
    having?: TransactionDetailScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: TransactionDetailCountAggregateInputType | true
    _avg?: TransactionDetailAvgAggregateInputType
    _sum?: TransactionDetailSumAggregateInputType
    _min?: TransactionDetailMinAggregateInputType
    _max?: TransactionDetailMaxAggregateInputType
  }

  export type TransactionDetailGroupByOutputType = {
    id: number
    transactionId: number
    itemId: number | null
    qty: number
    totalPrice: number
    _count: TransactionDetailCountAggregateOutputType | null
    _avg: TransactionDetailAvgAggregateOutputType | null
    _sum: TransactionDetailSumAggregateOutputType | null
    _min: TransactionDetailMinAggregateOutputType | null
    _max: TransactionDetailMaxAggregateOutputType | null
  }

  type GetTransactionDetailGroupByPayload<T extends TransactionDetailGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<TransactionDetailGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof TransactionDetailGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], TransactionDetailGroupByOutputType[P]>
            : GetScalarType<T[P], TransactionDetailGroupByOutputType[P]>
        }
      >
    >


  export type TransactionDetailSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    transactionId?: boolean
    itemId?: boolean
    qty?: boolean
    totalPrice?: boolean
    shopItem?: boolean | TransactionDetail$shopItemArgs<ExtArgs>
    transaction?: boolean | TransactionDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["transactionDetail"]>

  export type TransactionDetailSelectScalar = {
    id?: boolean
    transactionId?: boolean
    itemId?: boolean
    qty?: boolean
    totalPrice?: boolean
  }

  export type TransactionDetailInclude<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    shopItem?: boolean | TransactionDetail$shopItemArgs<ExtArgs>
    transaction?: boolean | TransactionDefaultArgs<ExtArgs>
  }


  export type $TransactionDetailPayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "TransactionDetail"
    objects: {
      shopItem: Prisma.$ShopItemPayload<ExtArgs> | null
      transaction: Prisma.$TransactionPayload<ExtArgs>
    }
    scalars: $Extensions.GetPayloadResult<{
      id: number
      transactionId: number
      itemId: number | null
      qty: number
      totalPrice: number
    }, ExtArgs["result"]["transactionDetail"]>
    composites: {}
  }


  type TransactionDetailGetPayload<S extends boolean | null | undefined | TransactionDetailDefaultArgs> = $Result.GetResult<Prisma.$TransactionDetailPayload, S>

  type TransactionDetailCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = 
    Omit<TransactionDetailFindManyArgs, 'select' | 'include' | 'distinct' > & {
      select?: TransactionDetailCountAggregateInputType | true
    }

  export interface TransactionDetailDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['TransactionDetail'], meta: { name: 'TransactionDetail' } }
    /**
     * Find zero or one TransactionDetail that matches the filter.
     * @param {TransactionDetailFindUniqueArgs} args - Arguments to find a TransactionDetail
     * @example
     * // Get one TransactionDetail
     * const transactionDetail = await prisma.transactionDetail.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findUnique<T extends TransactionDetailFindUniqueArgs<ExtArgs>>(
      args: SelectSubset<T, TransactionDetailFindUniqueArgs<ExtArgs>>
    ): Prisma__TransactionDetailClient<$Result.GetResult<Prisma.$TransactionDetailPayload<ExtArgs>, T, 'findUnique'> | null, null, ExtArgs>

    /**
     * Find one TransactionDetail that matches the filter or throw an error  with `error.code='P2025'` 
     *     if no matches were found.
     * @param {TransactionDetailFindUniqueOrThrowArgs} args - Arguments to find a TransactionDetail
     * @example
     * // Get one TransactionDetail
     * const transactionDetail = await prisma.transactionDetail.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findUniqueOrThrow<T extends TransactionDetailFindUniqueOrThrowArgs<ExtArgs>>(
      args?: SelectSubset<T, TransactionDetailFindUniqueOrThrowArgs<ExtArgs>>
    ): Prisma__TransactionDetailClient<$Result.GetResult<Prisma.$TransactionDetailPayload<ExtArgs>, T, 'findUniqueOrThrow'>, never, ExtArgs>

    /**
     * Find the first TransactionDetail that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {TransactionDetailFindFirstArgs} args - Arguments to find a TransactionDetail
     * @example
     * // Get one TransactionDetail
     * const transactionDetail = await prisma.transactionDetail.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findFirst<T extends TransactionDetailFindFirstArgs<ExtArgs>>(
      args?: SelectSubset<T, TransactionDetailFindFirstArgs<ExtArgs>>
    ): Prisma__TransactionDetailClient<$Result.GetResult<Prisma.$TransactionDetailPayload<ExtArgs>, T, 'findFirst'> | null, null, ExtArgs>

    /**
     * Find the first TransactionDetail that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {TransactionDetailFindFirstOrThrowArgs} args - Arguments to find a TransactionDetail
     * @example
     * // Get one TransactionDetail
     * const transactionDetail = await prisma.transactionDetail.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findFirstOrThrow<T extends TransactionDetailFindFirstOrThrowArgs<ExtArgs>>(
      args?: SelectSubset<T, TransactionDetailFindFirstOrThrowArgs<ExtArgs>>
    ): Prisma__TransactionDetailClient<$Result.GetResult<Prisma.$TransactionDetailPayload<ExtArgs>, T, 'findFirstOrThrow'>, never, ExtArgs>

    /**
     * Find zero or more TransactionDetails that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {TransactionDetailFindManyArgs=} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all TransactionDetails
     * const transactionDetails = await prisma.transactionDetail.findMany()
     * 
     * // Get first 10 TransactionDetails
     * const transactionDetails = await prisma.transactionDetail.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const transactionDetailWithIdOnly = await prisma.transactionDetail.findMany({ select: { id: true } })
     * 
    **/
    findMany<T extends TransactionDetailFindManyArgs<ExtArgs>>(
      args?: SelectSubset<T, TransactionDetailFindManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<$Result.GetResult<Prisma.$TransactionDetailPayload<ExtArgs>, T, 'findMany'>>

    /**
     * Create a TransactionDetail.
     * @param {TransactionDetailCreateArgs} args - Arguments to create a TransactionDetail.
     * @example
     * // Create one TransactionDetail
     * const TransactionDetail = await prisma.transactionDetail.create({
     *   data: {
     *     // ... data to create a TransactionDetail
     *   }
     * })
     * 
    **/
    create<T extends TransactionDetailCreateArgs<ExtArgs>>(
      args: SelectSubset<T, TransactionDetailCreateArgs<ExtArgs>>
    ): Prisma__TransactionDetailClient<$Result.GetResult<Prisma.$TransactionDetailPayload<ExtArgs>, T, 'create'>, never, ExtArgs>

    /**
     * Create many TransactionDetails.
     *     @param {TransactionDetailCreateManyArgs} args - Arguments to create many TransactionDetails.
     *     @example
     *     // Create many TransactionDetails
     *     const transactionDetail = await prisma.transactionDetail.createMany({
     *       data: {
     *         // ... provide data here
     *       }
     *     })
     *     
    **/
    createMany<T extends TransactionDetailCreateManyArgs<ExtArgs>>(
      args?: SelectSubset<T, TransactionDetailCreateManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Delete a TransactionDetail.
     * @param {TransactionDetailDeleteArgs} args - Arguments to delete one TransactionDetail.
     * @example
     * // Delete one TransactionDetail
     * const TransactionDetail = await prisma.transactionDetail.delete({
     *   where: {
     *     // ... filter to delete one TransactionDetail
     *   }
     * })
     * 
    **/
    delete<T extends TransactionDetailDeleteArgs<ExtArgs>>(
      args: SelectSubset<T, TransactionDetailDeleteArgs<ExtArgs>>
    ): Prisma__TransactionDetailClient<$Result.GetResult<Prisma.$TransactionDetailPayload<ExtArgs>, T, 'delete'>, never, ExtArgs>

    /**
     * Update one TransactionDetail.
     * @param {TransactionDetailUpdateArgs} args - Arguments to update one TransactionDetail.
     * @example
     * // Update one TransactionDetail
     * const transactionDetail = await prisma.transactionDetail.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
    **/
    update<T extends TransactionDetailUpdateArgs<ExtArgs>>(
      args: SelectSubset<T, TransactionDetailUpdateArgs<ExtArgs>>
    ): Prisma__TransactionDetailClient<$Result.GetResult<Prisma.$TransactionDetailPayload<ExtArgs>, T, 'update'>, never, ExtArgs>

    /**
     * Delete zero or more TransactionDetails.
     * @param {TransactionDetailDeleteManyArgs} args - Arguments to filter TransactionDetails to delete.
     * @example
     * // Delete a few TransactionDetails
     * const { count } = await prisma.transactionDetail.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
    **/
    deleteMany<T extends TransactionDetailDeleteManyArgs<ExtArgs>>(
      args?: SelectSubset<T, TransactionDetailDeleteManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more TransactionDetails.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {TransactionDetailUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many TransactionDetails
     * const transactionDetail = await prisma.transactionDetail.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
    **/
    updateMany<T extends TransactionDetailUpdateManyArgs<ExtArgs>>(
      args: SelectSubset<T, TransactionDetailUpdateManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create or update one TransactionDetail.
     * @param {TransactionDetailUpsertArgs} args - Arguments to update or create a TransactionDetail.
     * @example
     * // Update or create a TransactionDetail
     * const transactionDetail = await prisma.transactionDetail.upsert({
     *   create: {
     *     // ... data to create a TransactionDetail
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the TransactionDetail we want to update
     *   }
     * })
    **/
    upsert<T extends TransactionDetailUpsertArgs<ExtArgs>>(
      args: SelectSubset<T, TransactionDetailUpsertArgs<ExtArgs>>
    ): Prisma__TransactionDetailClient<$Result.GetResult<Prisma.$TransactionDetailPayload<ExtArgs>, T, 'upsert'>, never, ExtArgs>

    /**
     * Count the number of TransactionDetails.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {TransactionDetailCountArgs} args - Arguments to filter TransactionDetails to count.
     * @example
     * // Count the number of TransactionDetails
     * const count = await prisma.transactionDetail.count({
     *   where: {
     *     // ... the filter for the TransactionDetails we want to count
     *   }
     * })
    **/
    count<T extends TransactionDetailCountArgs>(
      args?: Subset<T, TransactionDetailCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], TransactionDetailCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a TransactionDetail.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {TransactionDetailAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends TransactionDetailAggregateArgs>(args: Subset<T, TransactionDetailAggregateArgs>): Prisma.PrismaPromise<GetTransactionDetailAggregateType<T>>

    /**
     * Group by TransactionDetail.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {TransactionDetailGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends TransactionDetailGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: TransactionDetailGroupByArgs['orderBy'] }
        : { orderBy?: TransactionDetailGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, TransactionDetailGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetTransactionDetailGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the TransactionDetail model
   */
  readonly fields: TransactionDetailFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for TransactionDetail.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__TransactionDetailClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: 'PrismaPromise';

    shopItem<T extends TransactionDetail$shopItemArgs<ExtArgs> = {}>(args?: Subset<T, TransactionDetail$shopItemArgs<ExtArgs>>): Prisma__ShopItemClient<$Result.GetResult<Prisma.$ShopItemPayload<ExtArgs>, T, 'findUniqueOrThrow'> | null, null, ExtArgs>;

    transaction<T extends TransactionDefaultArgs<ExtArgs> = {}>(args?: Subset<T, TransactionDefaultArgs<ExtArgs>>): Prisma__TransactionClient<$Result.GetResult<Prisma.$TransactionPayload<ExtArgs>, T, 'findUniqueOrThrow'> | Null, Null, ExtArgs>;

    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>;
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>;
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>;
  }



  /**
   * Fields of the TransactionDetail model
   */ 
  interface TransactionDetailFieldRefs {
    readonly id: FieldRef<"TransactionDetail", 'Int'>
    readonly transactionId: FieldRef<"TransactionDetail", 'Int'>
    readonly itemId: FieldRef<"TransactionDetail", 'Int'>
    readonly qty: FieldRef<"TransactionDetail", 'Int'>
    readonly totalPrice: FieldRef<"TransactionDetail", 'Int'>
  }
    

  // Custom InputTypes

  /**
   * TransactionDetail findUnique
   */
  export type TransactionDetailFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the TransactionDetail
     */
    select?: TransactionDetailSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: TransactionDetailInclude<ExtArgs> | null
    /**
     * Filter, which TransactionDetail to fetch.
     */
    where: TransactionDetailWhereUniqueInput
  }


  /**
   * TransactionDetail findUniqueOrThrow
   */
  export type TransactionDetailFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the TransactionDetail
     */
    select?: TransactionDetailSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: TransactionDetailInclude<ExtArgs> | null
    /**
     * Filter, which TransactionDetail to fetch.
     */
    where: TransactionDetailWhereUniqueInput
  }


  /**
   * TransactionDetail findFirst
   */
  export type TransactionDetailFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the TransactionDetail
     */
    select?: TransactionDetailSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: TransactionDetailInclude<ExtArgs> | null
    /**
     * Filter, which TransactionDetail to fetch.
     */
    where?: TransactionDetailWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of TransactionDetails to fetch.
     */
    orderBy?: TransactionDetailOrderByWithRelationInput | TransactionDetailOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for TransactionDetails.
     */
    cursor?: TransactionDetailWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` TransactionDetails from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` TransactionDetails.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of TransactionDetails.
     */
    distinct?: TransactionDetailScalarFieldEnum | TransactionDetailScalarFieldEnum[]
  }


  /**
   * TransactionDetail findFirstOrThrow
   */
  export type TransactionDetailFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the TransactionDetail
     */
    select?: TransactionDetailSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: TransactionDetailInclude<ExtArgs> | null
    /**
     * Filter, which TransactionDetail to fetch.
     */
    where?: TransactionDetailWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of TransactionDetails to fetch.
     */
    orderBy?: TransactionDetailOrderByWithRelationInput | TransactionDetailOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for TransactionDetails.
     */
    cursor?: TransactionDetailWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` TransactionDetails from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` TransactionDetails.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of TransactionDetails.
     */
    distinct?: TransactionDetailScalarFieldEnum | TransactionDetailScalarFieldEnum[]
  }


  /**
   * TransactionDetail findMany
   */
  export type TransactionDetailFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the TransactionDetail
     */
    select?: TransactionDetailSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: TransactionDetailInclude<ExtArgs> | null
    /**
     * Filter, which TransactionDetails to fetch.
     */
    where?: TransactionDetailWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of TransactionDetails to fetch.
     */
    orderBy?: TransactionDetailOrderByWithRelationInput | TransactionDetailOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing TransactionDetails.
     */
    cursor?: TransactionDetailWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` TransactionDetails from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` TransactionDetails.
     */
    skip?: number
    distinct?: TransactionDetailScalarFieldEnum | TransactionDetailScalarFieldEnum[]
  }


  /**
   * TransactionDetail create
   */
  export type TransactionDetailCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the TransactionDetail
     */
    select?: TransactionDetailSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: TransactionDetailInclude<ExtArgs> | null
    /**
     * The data needed to create a TransactionDetail.
     */
    data: XOR<TransactionDetailCreateInput, TransactionDetailUncheckedCreateInput>
  }


  /**
   * TransactionDetail createMany
   */
  export type TransactionDetailCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many TransactionDetails.
     */
    data: TransactionDetailCreateManyInput | TransactionDetailCreateManyInput[]
    skipDuplicates?: boolean
  }


  /**
   * TransactionDetail update
   */
  export type TransactionDetailUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the TransactionDetail
     */
    select?: TransactionDetailSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: TransactionDetailInclude<ExtArgs> | null
    /**
     * The data needed to update a TransactionDetail.
     */
    data: XOR<TransactionDetailUpdateInput, TransactionDetailUncheckedUpdateInput>
    /**
     * Choose, which TransactionDetail to update.
     */
    where: TransactionDetailWhereUniqueInput
  }


  /**
   * TransactionDetail updateMany
   */
  export type TransactionDetailUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update TransactionDetails.
     */
    data: XOR<TransactionDetailUpdateManyMutationInput, TransactionDetailUncheckedUpdateManyInput>
    /**
     * Filter which TransactionDetails to update
     */
    where?: TransactionDetailWhereInput
  }


  /**
   * TransactionDetail upsert
   */
  export type TransactionDetailUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the TransactionDetail
     */
    select?: TransactionDetailSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: TransactionDetailInclude<ExtArgs> | null
    /**
     * The filter to search for the TransactionDetail to update in case it exists.
     */
    where: TransactionDetailWhereUniqueInput
    /**
     * In case the TransactionDetail found by the `where` argument doesn't exist, create a new TransactionDetail with this data.
     */
    create: XOR<TransactionDetailCreateInput, TransactionDetailUncheckedCreateInput>
    /**
     * In case the TransactionDetail was found with the provided `where` argument, update it with this data.
     */
    update: XOR<TransactionDetailUpdateInput, TransactionDetailUncheckedUpdateInput>
  }


  /**
   * TransactionDetail delete
   */
  export type TransactionDetailDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the TransactionDetail
     */
    select?: TransactionDetailSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: TransactionDetailInclude<ExtArgs> | null
    /**
     * Filter which TransactionDetail to delete.
     */
    where: TransactionDetailWhereUniqueInput
  }


  /**
   * TransactionDetail deleteMany
   */
  export type TransactionDetailDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which TransactionDetails to delete
     */
    where?: TransactionDetailWhereInput
  }


  /**
   * TransactionDetail.shopItem
   */
  export type TransactionDetail$shopItemArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ShopItem
     */
    select?: ShopItemSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: ShopItemInclude<ExtArgs> | null
    where?: ShopItemWhereInput
  }


  /**
   * TransactionDetail without action
   */
  export type TransactionDetailDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the TransactionDetail
     */
    select?: TransactionDetailSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: TransactionDetailInclude<ExtArgs> | null
  }



  /**
   * Model TpaRequest
   */

  export type AggregateTpaRequest = {
    _count: TpaRequestCountAggregateOutputType | null
    _avg: TpaRequestAvgAggregateOutputType | null
    _sum: TpaRequestSumAggregateOutputType | null
    _min: TpaRequestMinAggregateOutputType | null
    _max: TpaRequestMaxAggregateOutputType | null
  }

  export type TpaRequestAvgAggregateOutputType = {
    id: number | null
  }

  export type TpaRequestSumAggregateOutputType = {
    id: number | null
  }

  export type TpaRequestMinAggregateOutputType = {
    id: number | null
    fromName: string | null
    targetName: string | null
    createdAt: Date | null
  }

  export type TpaRequestMaxAggregateOutputType = {
    id: number | null
    fromName: string | null
    targetName: string | null
    createdAt: Date | null
  }

  export type TpaRequestCountAggregateOutputType = {
    id: number
    fromName: number
    targetName: number
    createdAt: number
    _all: number
  }


  export type TpaRequestAvgAggregateInputType = {
    id?: true
  }

  export type TpaRequestSumAggregateInputType = {
    id?: true
  }

  export type TpaRequestMinAggregateInputType = {
    id?: true
    fromName?: true
    targetName?: true
    createdAt?: true
  }

  export type TpaRequestMaxAggregateInputType = {
    id?: true
    fromName?: true
    targetName?: true
    createdAt?: true
  }

  export type TpaRequestCountAggregateInputType = {
    id?: true
    fromName?: true
    targetName?: true
    createdAt?: true
    _all?: true
  }

  export type TpaRequestAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which TpaRequest to aggregate.
     */
    where?: TpaRequestWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of TpaRequests to fetch.
     */
    orderBy?: TpaRequestOrderByWithRelationInput | TpaRequestOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: TpaRequestWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` TpaRequests from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` TpaRequests.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned TpaRequests
    **/
    _count?: true | TpaRequestCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to average
    **/
    _avg?: TpaRequestAvgAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to sum
    **/
    _sum?: TpaRequestSumAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: TpaRequestMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: TpaRequestMaxAggregateInputType
  }

  export type GetTpaRequestAggregateType<T extends TpaRequestAggregateArgs> = {
        [P in keyof T & keyof AggregateTpaRequest]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateTpaRequest[P]>
      : GetScalarType<T[P], AggregateTpaRequest[P]>
  }




  export type TpaRequestGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: TpaRequestWhereInput
    orderBy?: TpaRequestOrderByWithAggregationInput | TpaRequestOrderByWithAggregationInput[]
    by: TpaRequestScalarFieldEnum[] | TpaRequestScalarFieldEnum
    having?: TpaRequestScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: TpaRequestCountAggregateInputType | true
    _avg?: TpaRequestAvgAggregateInputType
    _sum?: TpaRequestSumAggregateInputType
    _min?: TpaRequestMinAggregateInputType
    _max?: TpaRequestMaxAggregateInputType
  }

  export type TpaRequestGroupByOutputType = {
    id: number
    fromName: string
    targetName: string
    createdAt: Date
    _count: TpaRequestCountAggregateOutputType | null
    _avg: TpaRequestAvgAggregateOutputType | null
    _sum: TpaRequestSumAggregateOutputType | null
    _min: TpaRequestMinAggregateOutputType | null
    _max: TpaRequestMaxAggregateOutputType | null
  }

  type GetTpaRequestGroupByPayload<T extends TpaRequestGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<TpaRequestGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof TpaRequestGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], TpaRequestGroupByOutputType[P]>
            : GetScalarType<T[P], TpaRequestGroupByOutputType[P]>
        }
      >
    >


  export type TpaRequestSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    fromName?: boolean
    targetName?: boolean
    createdAt?: boolean
  }, ExtArgs["result"]["tpaRequest"]>

  export type TpaRequestSelectScalar = {
    id?: boolean
    fromName?: boolean
    targetName?: boolean
    createdAt?: boolean
  }


  export type $TpaRequestPayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "TpaRequest"
    objects: {}
    scalars: $Extensions.GetPayloadResult<{
      id: number
      fromName: string
      targetName: string
      createdAt: Date
    }, ExtArgs["result"]["tpaRequest"]>
    composites: {}
  }


  type TpaRequestGetPayload<S extends boolean | null | undefined | TpaRequestDefaultArgs> = $Result.GetResult<Prisma.$TpaRequestPayload, S>

  type TpaRequestCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = 
    Omit<TpaRequestFindManyArgs, 'select' | 'include' | 'distinct' > & {
      select?: TpaRequestCountAggregateInputType | true
    }

  export interface TpaRequestDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['TpaRequest'], meta: { name: 'TpaRequest' } }
    /**
     * Find zero or one TpaRequest that matches the filter.
     * @param {TpaRequestFindUniqueArgs} args - Arguments to find a TpaRequest
     * @example
     * // Get one TpaRequest
     * const tpaRequest = await prisma.tpaRequest.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findUnique<T extends TpaRequestFindUniqueArgs<ExtArgs>>(
      args: SelectSubset<T, TpaRequestFindUniqueArgs<ExtArgs>>
    ): Prisma__TpaRequestClient<$Result.GetResult<Prisma.$TpaRequestPayload<ExtArgs>, T, 'findUnique'> | null, null, ExtArgs>

    /**
     * Find one TpaRequest that matches the filter or throw an error  with `error.code='P2025'` 
     *     if no matches were found.
     * @param {TpaRequestFindUniqueOrThrowArgs} args - Arguments to find a TpaRequest
     * @example
     * // Get one TpaRequest
     * const tpaRequest = await prisma.tpaRequest.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findUniqueOrThrow<T extends TpaRequestFindUniqueOrThrowArgs<ExtArgs>>(
      args?: SelectSubset<T, TpaRequestFindUniqueOrThrowArgs<ExtArgs>>
    ): Prisma__TpaRequestClient<$Result.GetResult<Prisma.$TpaRequestPayload<ExtArgs>, T, 'findUniqueOrThrow'>, never, ExtArgs>

    /**
     * Find the first TpaRequest that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {TpaRequestFindFirstArgs} args - Arguments to find a TpaRequest
     * @example
     * // Get one TpaRequest
     * const tpaRequest = await prisma.tpaRequest.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findFirst<T extends TpaRequestFindFirstArgs<ExtArgs>>(
      args?: SelectSubset<T, TpaRequestFindFirstArgs<ExtArgs>>
    ): Prisma__TpaRequestClient<$Result.GetResult<Prisma.$TpaRequestPayload<ExtArgs>, T, 'findFirst'> | null, null, ExtArgs>

    /**
     * Find the first TpaRequest that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {TpaRequestFindFirstOrThrowArgs} args - Arguments to find a TpaRequest
     * @example
     * // Get one TpaRequest
     * const tpaRequest = await prisma.tpaRequest.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findFirstOrThrow<T extends TpaRequestFindFirstOrThrowArgs<ExtArgs>>(
      args?: SelectSubset<T, TpaRequestFindFirstOrThrowArgs<ExtArgs>>
    ): Prisma__TpaRequestClient<$Result.GetResult<Prisma.$TpaRequestPayload<ExtArgs>, T, 'findFirstOrThrow'>, never, ExtArgs>

    /**
     * Find zero or more TpaRequests that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {TpaRequestFindManyArgs=} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all TpaRequests
     * const tpaRequests = await prisma.tpaRequest.findMany()
     * 
     * // Get first 10 TpaRequests
     * const tpaRequests = await prisma.tpaRequest.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const tpaRequestWithIdOnly = await prisma.tpaRequest.findMany({ select: { id: true } })
     * 
    **/
    findMany<T extends TpaRequestFindManyArgs<ExtArgs>>(
      args?: SelectSubset<T, TpaRequestFindManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<$Result.GetResult<Prisma.$TpaRequestPayload<ExtArgs>, T, 'findMany'>>

    /**
     * Create a TpaRequest.
     * @param {TpaRequestCreateArgs} args - Arguments to create a TpaRequest.
     * @example
     * // Create one TpaRequest
     * const TpaRequest = await prisma.tpaRequest.create({
     *   data: {
     *     // ... data to create a TpaRequest
     *   }
     * })
     * 
    **/
    create<T extends TpaRequestCreateArgs<ExtArgs>>(
      args: SelectSubset<T, TpaRequestCreateArgs<ExtArgs>>
    ): Prisma__TpaRequestClient<$Result.GetResult<Prisma.$TpaRequestPayload<ExtArgs>, T, 'create'>, never, ExtArgs>

    /**
     * Create many TpaRequests.
     *     @param {TpaRequestCreateManyArgs} args - Arguments to create many TpaRequests.
     *     @example
     *     // Create many TpaRequests
     *     const tpaRequest = await prisma.tpaRequest.createMany({
     *       data: {
     *         // ... provide data here
     *       }
     *     })
     *     
    **/
    createMany<T extends TpaRequestCreateManyArgs<ExtArgs>>(
      args?: SelectSubset<T, TpaRequestCreateManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Delete a TpaRequest.
     * @param {TpaRequestDeleteArgs} args - Arguments to delete one TpaRequest.
     * @example
     * // Delete one TpaRequest
     * const TpaRequest = await prisma.tpaRequest.delete({
     *   where: {
     *     // ... filter to delete one TpaRequest
     *   }
     * })
     * 
    **/
    delete<T extends TpaRequestDeleteArgs<ExtArgs>>(
      args: SelectSubset<T, TpaRequestDeleteArgs<ExtArgs>>
    ): Prisma__TpaRequestClient<$Result.GetResult<Prisma.$TpaRequestPayload<ExtArgs>, T, 'delete'>, never, ExtArgs>

    /**
     * Update one TpaRequest.
     * @param {TpaRequestUpdateArgs} args - Arguments to update one TpaRequest.
     * @example
     * // Update one TpaRequest
     * const tpaRequest = await prisma.tpaRequest.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
    **/
    update<T extends TpaRequestUpdateArgs<ExtArgs>>(
      args: SelectSubset<T, TpaRequestUpdateArgs<ExtArgs>>
    ): Prisma__TpaRequestClient<$Result.GetResult<Prisma.$TpaRequestPayload<ExtArgs>, T, 'update'>, never, ExtArgs>

    /**
     * Delete zero or more TpaRequests.
     * @param {TpaRequestDeleteManyArgs} args - Arguments to filter TpaRequests to delete.
     * @example
     * // Delete a few TpaRequests
     * const { count } = await prisma.tpaRequest.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
    **/
    deleteMany<T extends TpaRequestDeleteManyArgs<ExtArgs>>(
      args?: SelectSubset<T, TpaRequestDeleteManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more TpaRequests.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {TpaRequestUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many TpaRequests
     * const tpaRequest = await prisma.tpaRequest.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
    **/
    updateMany<T extends TpaRequestUpdateManyArgs<ExtArgs>>(
      args: SelectSubset<T, TpaRequestUpdateManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create or update one TpaRequest.
     * @param {TpaRequestUpsertArgs} args - Arguments to update or create a TpaRequest.
     * @example
     * // Update or create a TpaRequest
     * const tpaRequest = await prisma.tpaRequest.upsert({
     *   create: {
     *     // ... data to create a TpaRequest
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the TpaRequest we want to update
     *   }
     * })
    **/
    upsert<T extends TpaRequestUpsertArgs<ExtArgs>>(
      args: SelectSubset<T, TpaRequestUpsertArgs<ExtArgs>>
    ): Prisma__TpaRequestClient<$Result.GetResult<Prisma.$TpaRequestPayload<ExtArgs>, T, 'upsert'>, never, ExtArgs>

    /**
     * Count the number of TpaRequests.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {TpaRequestCountArgs} args - Arguments to filter TpaRequests to count.
     * @example
     * // Count the number of TpaRequests
     * const count = await prisma.tpaRequest.count({
     *   where: {
     *     // ... the filter for the TpaRequests we want to count
     *   }
     * })
    **/
    count<T extends TpaRequestCountArgs>(
      args?: Subset<T, TpaRequestCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], TpaRequestCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a TpaRequest.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {TpaRequestAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends TpaRequestAggregateArgs>(args: Subset<T, TpaRequestAggregateArgs>): Prisma.PrismaPromise<GetTpaRequestAggregateType<T>>

    /**
     * Group by TpaRequest.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {TpaRequestGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends TpaRequestGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: TpaRequestGroupByArgs['orderBy'] }
        : { orderBy?: TpaRequestGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, TpaRequestGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetTpaRequestGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the TpaRequest model
   */
  readonly fields: TpaRequestFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for TpaRequest.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__TpaRequestClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: 'PrismaPromise';


    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>;
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>;
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>;
  }



  /**
   * Fields of the TpaRequest model
   */ 
  interface TpaRequestFieldRefs {
    readonly id: FieldRef<"TpaRequest", 'Int'>
    readonly fromName: FieldRef<"TpaRequest", 'String'>
    readonly targetName: FieldRef<"TpaRequest", 'String'>
    readonly createdAt: FieldRef<"TpaRequest", 'DateTime'>
  }
    

  // Custom InputTypes

  /**
   * TpaRequest findUnique
   */
  export type TpaRequestFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the TpaRequest
     */
    select?: TpaRequestSelect<ExtArgs> | null
    /**
     * Filter, which TpaRequest to fetch.
     */
    where: TpaRequestWhereUniqueInput
  }


  /**
   * TpaRequest findUniqueOrThrow
   */
  export type TpaRequestFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the TpaRequest
     */
    select?: TpaRequestSelect<ExtArgs> | null
    /**
     * Filter, which TpaRequest to fetch.
     */
    where: TpaRequestWhereUniqueInput
  }


  /**
   * TpaRequest findFirst
   */
  export type TpaRequestFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the TpaRequest
     */
    select?: TpaRequestSelect<ExtArgs> | null
    /**
     * Filter, which TpaRequest to fetch.
     */
    where?: TpaRequestWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of TpaRequests to fetch.
     */
    orderBy?: TpaRequestOrderByWithRelationInput | TpaRequestOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for TpaRequests.
     */
    cursor?: TpaRequestWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` TpaRequests from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` TpaRequests.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of TpaRequests.
     */
    distinct?: TpaRequestScalarFieldEnum | TpaRequestScalarFieldEnum[]
  }


  /**
   * TpaRequest findFirstOrThrow
   */
  export type TpaRequestFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the TpaRequest
     */
    select?: TpaRequestSelect<ExtArgs> | null
    /**
     * Filter, which TpaRequest to fetch.
     */
    where?: TpaRequestWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of TpaRequests to fetch.
     */
    orderBy?: TpaRequestOrderByWithRelationInput | TpaRequestOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for TpaRequests.
     */
    cursor?: TpaRequestWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` TpaRequests from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` TpaRequests.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of TpaRequests.
     */
    distinct?: TpaRequestScalarFieldEnum | TpaRequestScalarFieldEnum[]
  }


  /**
   * TpaRequest findMany
   */
  export type TpaRequestFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the TpaRequest
     */
    select?: TpaRequestSelect<ExtArgs> | null
    /**
     * Filter, which TpaRequests to fetch.
     */
    where?: TpaRequestWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of TpaRequests to fetch.
     */
    orderBy?: TpaRequestOrderByWithRelationInput | TpaRequestOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing TpaRequests.
     */
    cursor?: TpaRequestWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` TpaRequests from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` TpaRequests.
     */
    skip?: number
    distinct?: TpaRequestScalarFieldEnum | TpaRequestScalarFieldEnum[]
  }


  /**
   * TpaRequest create
   */
  export type TpaRequestCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the TpaRequest
     */
    select?: TpaRequestSelect<ExtArgs> | null
    /**
     * The data needed to create a TpaRequest.
     */
    data: XOR<TpaRequestCreateInput, TpaRequestUncheckedCreateInput>
  }


  /**
   * TpaRequest createMany
   */
  export type TpaRequestCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many TpaRequests.
     */
    data: TpaRequestCreateManyInput | TpaRequestCreateManyInput[]
    skipDuplicates?: boolean
  }


  /**
   * TpaRequest update
   */
  export type TpaRequestUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the TpaRequest
     */
    select?: TpaRequestSelect<ExtArgs> | null
    /**
     * The data needed to update a TpaRequest.
     */
    data: XOR<TpaRequestUpdateInput, TpaRequestUncheckedUpdateInput>
    /**
     * Choose, which TpaRequest to update.
     */
    where: TpaRequestWhereUniqueInput
  }


  /**
   * TpaRequest updateMany
   */
  export type TpaRequestUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update TpaRequests.
     */
    data: XOR<TpaRequestUpdateManyMutationInput, TpaRequestUncheckedUpdateManyInput>
    /**
     * Filter which TpaRequests to update
     */
    where?: TpaRequestWhereInput
  }


  /**
   * TpaRequest upsert
   */
  export type TpaRequestUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the TpaRequest
     */
    select?: TpaRequestSelect<ExtArgs> | null
    /**
     * The filter to search for the TpaRequest to update in case it exists.
     */
    where: TpaRequestWhereUniqueInput
    /**
     * In case the TpaRequest found by the `where` argument doesn't exist, create a new TpaRequest with this data.
     */
    create: XOR<TpaRequestCreateInput, TpaRequestUncheckedCreateInput>
    /**
     * In case the TpaRequest was found with the provided `where` argument, update it with this data.
     */
    update: XOR<TpaRequestUpdateInput, TpaRequestUncheckedUpdateInput>
  }


  /**
   * TpaRequest delete
   */
  export type TpaRequestDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the TpaRequest
     */
    select?: TpaRequestSelect<ExtArgs> | null
    /**
     * Filter which TpaRequest to delete.
     */
    where: TpaRequestWhereUniqueInput
  }


  /**
   * TpaRequest deleteMany
   */
  export type TpaRequestDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which TpaRequests to delete
     */
    where?: TpaRequestWhereInput
  }


  /**
   * TpaRequest without action
   */
  export type TpaRequestDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the TpaRequest
     */
    select?: TpaRequestSelect<ExtArgs> | null
  }



  /**
   * Model WayPoint
   */

  export type AggregateWayPoint = {
    _count: WayPointCountAggregateOutputType | null
    _avg: WayPointAvgAggregateOutputType | null
    _sum: WayPointSumAggregateOutputType | null
    _min: WayPointMinAggregateOutputType | null
    _max: WayPointMaxAggregateOutputType | null
  }

  export type WayPointAvgAggregateOutputType = {
    id: number | null
    x: number | null
    y: number | null
    z: number | null
  }

  export type WayPointSumAggregateOutputType = {
    id: number | null
    x: number | null
    y: number | null
    z: number | null
  }

  export type WayPointMinAggregateOutputType = {
    id: number | null
    ownerId: string | null
    name: string | null
    x: number | null
    y: number | null
    z: number | null
    dimension: string | null
    isPublic: boolean | null
  }

  export type WayPointMaxAggregateOutputType = {
    id: number | null
    ownerId: string | null
    name: string | null
    x: number | null
    y: number | null
    z: number | null
    dimension: string | null
    isPublic: boolean | null
  }

  export type WayPointCountAggregateOutputType = {
    id: number
    ownerId: number
    name: number
    x: number
    y: number
    z: number
    dimension: number
    isPublic: number
    _all: number
  }


  export type WayPointAvgAggregateInputType = {
    id?: true
    x?: true
    y?: true
    z?: true
  }

  export type WayPointSumAggregateInputType = {
    id?: true
    x?: true
    y?: true
    z?: true
  }

  export type WayPointMinAggregateInputType = {
    id?: true
    ownerId?: true
    name?: true
    x?: true
    y?: true
    z?: true
    dimension?: true
    isPublic?: true
  }

  export type WayPointMaxAggregateInputType = {
    id?: true
    ownerId?: true
    name?: true
    x?: true
    y?: true
    z?: true
    dimension?: true
    isPublic?: true
  }

  export type WayPointCountAggregateInputType = {
    id?: true
    ownerId?: true
    name?: true
    x?: true
    y?: true
    z?: true
    dimension?: true
    isPublic?: true
    _all?: true
  }

  export type WayPointAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which WayPoint to aggregate.
     */
    where?: WayPointWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of WayPoints to fetch.
     */
    orderBy?: WayPointOrderByWithRelationInput | WayPointOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: WayPointWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` WayPoints from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` WayPoints.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned WayPoints
    **/
    _count?: true | WayPointCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to average
    **/
    _avg?: WayPointAvgAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to sum
    **/
    _sum?: WayPointSumAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: WayPointMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: WayPointMaxAggregateInputType
  }

  export type GetWayPointAggregateType<T extends WayPointAggregateArgs> = {
        [P in keyof T & keyof AggregateWayPoint]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateWayPoint[P]>
      : GetScalarType<T[P], AggregateWayPoint[P]>
  }




  export type WayPointGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: WayPointWhereInput
    orderBy?: WayPointOrderByWithAggregationInput | WayPointOrderByWithAggregationInput[]
    by: WayPointScalarFieldEnum[] | WayPointScalarFieldEnum
    having?: WayPointScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: WayPointCountAggregateInputType | true
    _avg?: WayPointAvgAggregateInputType
    _sum?: WayPointSumAggregateInputType
    _min?: WayPointMinAggregateInputType
    _max?: WayPointMaxAggregateInputType
  }

  export type WayPointGroupByOutputType = {
    id: number
    ownerId: string
    name: string
    x: number
    y: number
    z: number
    dimension: string
    isPublic: boolean
    _count: WayPointCountAggregateOutputType | null
    _avg: WayPointAvgAggregateOutputType | null
    _sum: WayPointSumAggregateOutputType | null
    _min: WayPointMinAggregateOutputType | null
    _max: WayPointMaxAggregateOutputType | null
  }

  type GetWayPointGroupByPayload<T extends WayPointGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<WayPointGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof WayPointGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], WayPointGroupByOutputType[P]>
            : GetScalarType<T[P], WayPointGroupByOutputType[P]>
        }
      >
    >


  export type WayPointSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    ownerId?: boolean
    name?: boolean
    x?: boolean
    y?: boolean
    z?: boolean
    dimension?: boolean
    isPublic?: boolean
    User?: boolean | WayPoint$UserArgs<ExtArgs>
  }, ExtArgs["result"]["wayPoint"]>

  export type WayPointSelectScalar = {
    id?: boolean
    ownerId?: boolean
    name?: boolean
    x?: boolean
    y?: boolean
    z?: boolean
    dimension?: boolean
    isPublic?: boolean
  }

  export type WayPointInclude<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    User?: boolean | WayPoint$UserArgs<ExtArgs>
  }


  export type $WayPointPayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "WayPoint"
    objects: {
      User: Prisma.$UserPayload<ExtArgs> | null
    }
    scalars: $Extensions.GetPayloadResult<{
      id: number
      ownerId: string
      name: string
      x: number
      y: number
      z: number
      dimension: string
      isPublic: boolean
    }, ExtArgs["result"]["wayPoint"]>
    composites: {}
  }


  type WayPointGetPayload<S extends boolean | null | undefined | WayPointDefaultArgs> = $Result.GetResult<Prisma.$WayPointPayload, S>

  type WayPointCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = 
    Omit<WayPointFindManyArgs, 'select' | 'include' | 'distinct' > & {
      select?: WayPointCountAggregateInputType | true
    }

  export interface WayPointDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['WayPoint'], meta: { name: 'WayPoint' } }
    /**
     * Find zero or one WayPoint that matches the filter.
     * @param {WayPointFindUniqueArgs} args - Arguments to find a WayPoint
     * @example
     * // Get one WayPoint
     * const wayPoint = await prisma.wayPoint.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findUnique<T extends WayPointFindUniqueArgs<ExtArgs>>(
      args: SelectSubset<T, WayPointFindUniqueArgs<ExtArgs>>
    ): Prisma__WayPointClient<$Result.GetResult<Prisma.$WayPointPayload<ExtArgs>, T, 'findUnique'> | null, null, ExtArgs>

    /**
     * Find one WayPoint that matches the filter or throw an error  with `error.code='P2025'` 
     *     if no matches were found.
     * @param {WayPointFindUniqueOrThrowArgs} args - Arguments to find a WayPoint
     * @example
     * // Get one WayPoint
     * const wayPoint = await prisma.wayPoint.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findUniqueOrThrow<T extends WayPointFindUniqueOrThrowArgs<ExtArgs>>(
      args?: SelectSubset<T, WayPointFindUniqueOrThrowArgs<ExtArgs>>
    ): Prisma__WayPointClient<$Result.GetResult<Prisma.$WayPointPayload<ExtArgs>, T, 'findUniqueOrThrow'>, never, ExtArgs>

    /**
     * Find the first WayPoint that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {WayPointFindFirstArgs} args - Arguments to find a WayPoint
     * @example
     * // Get one WayPoint
     * const wayPoint = await prisma.wayPoint.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findFirst<T extends WayPointFindFirstArgs<ExtArgs>>(
      args?: SelectSubset<T, WayPointFindFirstArgs<ExtArgs>>
    ): Prisma__WayPointClient<$Result.GetResult<Prisma.$WayPointPayload<ExtArgs>, T, 'findFirst'> | null, null, ExtArgs>

    /**
     * Find the first WayPoint that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {WayPointFindFirstOrThrowArgs} args - Arguments to find a WayPoint
     * @example
     * // Get one WayPoint
     * const wayPoint = await prisma.wayPoint.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findFirstOrThrow<T extends WayPointFindFirstOrThrowArgs<ExtArgs>>(
      args?: SelectSubset<T, WayPointFindFirstOrThrowArgs<ExtArgs>>
    ): Prisma__WayPointClient<$Result.GetResult<Prisma.$WayPointPayload<ExtArgs>, T, 'findFirstOrThrow'>, never, ExtArgs>

    /**
     * Find zero or more WayPoints that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {WayPointFindManyArgs=} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all WayPoints
     * const wayPoints = await prisma.wayPoint.findMany()
     * 
     * // Get first 10 WayPoints
     * const wayPoints = await prisma.wayPoint.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const wayPointWithIdOnly = await prisma.wayPoint.findMany({ select: { id: true } })
     * 
    **/
    findMany<T extends WayPointFindManyArgs<ExtArgs>>(
      args?: SelectSubset<T, WayPointFindManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<$Result.GetResult<Prisma.$WayPointPayload<ExtArgs>, T, 'findMany'>>

    /**
     * Create a WayPoint.
     * @param {WayPointCreateArgs} args - Arguments to create a WayPoint.
     * @example
     * // Create one WayPoint
     * const WayPoint = await prisma.wayPoint.create({
     *   data: {
     *     // ... data to create a WayPoint
     *   }
     * })
     * 
    **/
    create<T extends WayPointCreateArgs<ExtArgs>>(
      args: SelectSubset<T, WayPointCreateArgs<ExtArgs>>
    ): Prisma__WayPointClient<$Result.GetResult<Prisma.$WayPointPayload<ExtArgs>, T, 'create'>, never, ExtArgs>

    /**
     * Create many WayPoints.
     *     @param {WayPointCreateManyArgs} args - Arguments to create many WayPoints.
     *     @example
     *     // Create many WayPoints
     *     const wayPoint = await prisma.wayPoint.createMany({
     *       data: {
     *         // ... provide data here
     *       }
     *     })
     *     
    **/
    createMany<T extends WayPointCreateManyArgs<ExtArgs>>(
      args?: SelectSubset<T, WayPointCreateManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Delete a WayPoint.
     * @param {WayPointDeleteArgs} args - Arguments to delete one WayPoint.
     * @example
     * // Delete one WayPoint
     * const WayPoint = await prisma.wayPoint.delete({
     *   where: {
     *     // ... filter to delete one WayPoint
     *   }
     * })
     * 
    **/
    delete<T extends WayPointDeleteArgs<ExtArgs>>(
      args: SelectSubset<T, WayPointDeleteArgs<ExtArgs>>
    ): Prisma__WayPointClient<$Result.GetResult<Prisma.$WayPointPayload<ExtArgs>, T, 'delete'>, never, ExtArgs>

    /**
     * Update one WayPoint.
     * @param {WayPointUpdateArgs} args - Arguments to update one WayPoint.
     * @example
     * // Update one WayPoint
     * const wayPoint = await prisma.wayPoint.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
    **/
    update<T extends WayPointUpdateArgs<ExtArgs>>(
      args: SelectSubset<T, WayPointUpdateArgs<ExtArgs>>
    ): Prisma__WayPointClient<$Result.GetResult<Prisma.$WayPointPayload<ExtArgs>, T, 'update'>, never, ExtArgs>

    /**
     * Delete zero or more WayPoints.
     * @param {WayPointDeleteManyArgs} args - Arguments to filter WayPoints to delete.
     * @example
     * // Delete a few WayPoints
     * const { count } = await prisma.wayPoint.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
    **/
    deleteMany<T extends WayPointDeleteManyArgs<ExtArgs>>(
      args?: SelectSubset<T, WayPointDeleteManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more WayPoints.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {WayPointUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many WayPoints
     * const wayPoint = await prisma.wayPoint.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
    **/
    updateMany<T extends WayPointUpdateManyArgs<ExtArgs>>(
      args: SelectSubset<T, WayPointUpdateManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create or update one WayPoint.
     * @param {WayPointUpsertArgs} args - Arguments to update or create a WayPoint.
     * @example
     * // Update or create a WayPoint
     * const wayPoint = await prisma.wayPoint.upsert({
     *   create: {
     *     // ... data to create a WayPoint
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the WayPoint we want to update
     *   }
     * })
    **/
    upsert<T extends WayPointUpsertArgs<ExtArgs>>(
      args: SelectSubset<T, WayPointUpsertArgs<ExtArgs>>
    ): Prisma__WayPointClient<$Result.GetResult<Prisma.$WayPointPayload<ExtArgs>, T, 'upsert'>, never, ExtArgs>

    /**
     * Count the number of WayPoints.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {WayPointCountArgs} args - Arguments to filter WayPoints to count.
     * @example
     * // Count the number of WayPoints
     * const count = await prisma.wayPoint.count({
     *   where: {
     *     // ... the filter for the WayPoints we want to count
     *   }
     * })
    **/
    count<T extends WayPointCountArgs>(
      args?: Subset<T, WayPointCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], WayPointCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a WayPoint.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {WayPointAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends WayPointAggregateArgs>(args: Subset<T, WayPointAggregateArgs>): Prisma.PrismaPromise<GetWayPointAggregateType<T>>

    /**
     * Group by WayPoint.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {WayPointGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends WayPointGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: WayPointGroupByArgs['orderBy'] }
        : { orderBy?: WayPointGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, WayPointGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetWayPointGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the WayPoint model
   */
  readonly fields: WayPointFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for WayPoint.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__WayPointClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: 'PrismaPromise';

    User<T extends WayPoint$UserArgs<ExtArgs> = {}>(args?: Subset<T, WayPoint$UserArgs<ExtArgs>>): Prisma__UserClient<$Result.GetResult<Prisma.$UserPayload<ExtArgs>, T, 'findUniqueOrThrow'> | null, null, ExtArgs>;

    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>;
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>;
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>;
  }



  /**
   * Fields of the WayPoint model
   */ 
  interface WayPointFieldRefs {
    readonly id: FieldRef<"WayPoint", 'Int'>
    readonly ownerId: FieldRef<"WayPoint", 'String'>
    readonly name: FieldRef<"WayPoint", 'String'>
    readonly x: FieldRef<"WayPoint", 'Float'>
    readonly y: FieldRef<"WayPoint", 'Float'>
    readonly z: FieldRef<"WayPoint", 'Float'>
    readonly dimension: FieldRef<"WayPoint", 'String'>
    readonly isPublic: FieldRef<"WayPoint", 'Boolean'>
  }
    

  // Custom InputTypes

  /**
   * WayPoint findUnique
   */
  export type WayPointFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the WayPoint
     */
    select?: WayPointSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: WayPointInclude<ExtArgs> | null
    /**
     * Filter, which WayPoint to fetch.
     */
    where: WayPointWhereUniqueInput
  }


  /**
   * WayPoint findUniqueOrThrow
   */
  export type WayPointFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the WayPoint
     */
    select?: WayPointSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: WayPointInclude<ExtArgs> | null
    /**
     * Filter, which WayPoint to fetch.
     */
    where: WayPointWhereUniqueInput
  }


  /**
   * WayPoint findFirst
   */
  export type WayPointFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the WayPoint
     */
    select?: WayPointSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: WayPointInclude<ExtArgs> | null
    /**
     * Filter, which WayPoint to fetch.
     */
    where?: WayPointWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of WayPoints to fetch.
     */
    orderBy?: WayPointOrderByWithRelationInput | WayPointOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for WayPoints.
     */
    cursor?: WayPointWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` WayPoints from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` WayPoints.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of WayPoints.
     */
    distinct?: WayPointScalarFieldEnum | WayPointScalarFieldEnum[]
  }


  /**
   * WayPoint findFirstOrThrow
   */
  export type WayPointFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the WayPoint
     */
    select?: WayPointSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: WayPointInclude<ExtArgs> | null
    /**
     * Filter, which WayPoint to fetch.
     */
    where?: WayPointWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of WayPoints to fetch.
     */
    orderBy?: WayPointOrderByWithRelationInput | WayPointOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for WayPoints.
     */
    cursor?: WayPointWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` WayPoints from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` WayPoints.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of WayPoints.
     */
    distinct?: WayPointScalarFieldEnum | WayPointScalarFieldEnum[]
  }


  /**
   * WayPoint findMany
   */
  export type WayPointFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the WayPoint
     */
    select?: WayPointSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: WayPointInclude<ExtArgs> | null
    /**
     * Filter, which WayPoints to fetch.
     */
    where?: WayPointWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of WayPoints to fetch.
     */
    orderBy?: WayPointOrderByWithRelationInput | WayPointOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing WayPoints.
     */
    cursor?: WayPointWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` WayPoints from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` WayPoints.
     */
    skip?: number
    distinct?: WayPointScalarFieldEnum | WayPointScalarFieldEnum[]
  }


  /**
   * WayPoint create
   */
  export type WayPointCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the WayPoint
     */
    select?: WayPointSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: WayPointInclude<ExtArgs> | null
    /**
     * The data needed to create a WayPoint.
     */
    data: XOR<WayPointCreateInput, WayPointUncheckedCreateInput>
  }


  /**
   * WayPoint createMany
   */
  export type WayPointCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many WayPoints.
     */
    data: WayPointCreateManyInput | WayPointCreateManyInput[]
    skipDuplicates?: boolean
  }


  /**
   * WayPoint update
   */
  export type WayPointUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the WayPoint
     */
    select?: WayPointSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: WayPointInclude<ExtArgs> | null
    /**
     * The data needed to update a WayPoint.
     */
    data: XOR<WayPointUpdateInput, WayPointUncheckedUpdateInput>
    /**
     * Choose, which WayPoint to update.
     */
    where: WayPointWhereUniqueInput
  }


  /**
   * WayPoint updateMany
   */
  export type WayPointUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update WayPoints.
     */
    data: XOR<WayPointUpdateManyMutationInput, WayPointUncheckedUpdateManyInput>
    /**
     * Filter which WayPoints to update
     */
    where?: WayPointWhereInput
  }


  /**
   * WayPoint upsert
   */
  export type WayPointUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the WayPoint
     */
    select?: WayPointSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: WayPointInclude<ExtArgs> | null
    /**
     * The filter to search for the WayPoint to update in case it exists.
     */
    where: WayPointWhereUniqueInput
    /**
     * In case the WayPoint found by the `where` argument doesn't exist, create a new WayPoint with this data.
     */
    create: XOR<WayPointCreateInput, WayPointUncheckedCreateInput>
    /**
     * In case the WayPoint was found with the provided `where` argument, update it with this data.
     */
    update: XOR<WayPointUpdateInput, WayPointUncheckedUpdateInput>
  }


  /**
   * WayPoint delete
   */
  export type WayPointDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the WayPoint
     */
    select?: WayPointSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: WayPointInclude<ExtArgs> | null
    /**
     * Filter which WayPoint to delete.
     */
    where: WayPointWhereUniqueInput
  }


  /**
   * WayPoint deleteMany
   */
  export type WayPointDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which WayPoints to delete
     */
    where?: WayPointWhereInput
  }


  /**
   * WayPoint.User
   */
  export type WayPoint$UserArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the User
     */
    select?: UserSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: UserInclude<ExtArgs> | null
    where?: UserWhereInput
  }


  /**
   * WayPoint without action
   */
  export type WayPointDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the WayPoint
     */
    select?: WayPointSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well.
     */
    include?: WayPointInclude<ExtArgs> | null
  }



  /**
   * Model Settings
   */

  export type AggregateSettings = {
    _count: SettingsCountAggregateOutputType | null
    _avg: SettingsAvgAggregateOutputType | null
    _sum: SettingsSumAggregateOutputType | null
    _min: SettingsMinAggregateOutputType | null
    _max: SettingsMaxAggregateOutputType | null
  }

  export type SettingsAvgAggregateOutputType = {
    id: number | null
  }

  export type SettingsSumAggregateOutputType = {
    id: number | null
  }

  export type SettingsMinAggregateOutputType = {
    id: number | null
    name: string | null
    value: string | null
    type: $Enums.DataType | null
    createdAt: Date | null
    updatedAt: Date | null
  }

  export type SettingsMaxAggregateOutputType = {
    id: number | null
    name: string | null
    value: string | null
    type: $Enums.DataType | null
    createdAt: Date | null
    updatedAt: Date | null
  }

  export type SettingsCountAggregateOutputType = {
    id: number
    name: number
    value: number
    type: number
    createdAt: number
    updatedAt: number
    _all: number
  }


  export type SettingsAvgAggregateInputType = {
    id?: true
  }

  export type SettingsSumAggregateInputType = {
    id?: true
  }

  export type SettingsMinAggregateInputType = {
    id?: true
    name?: true
    value?: true
    type?: true
    createdAt?: true
    updatedAt?: true
  }

  export type SettingsMaxAggregateInputType = {
    id?: true
    name?: true
    value?: true
    type?: true
    createdAt?: true
    updatedAt?: true
  }

  export type SettingsCountAggregateInputType = {
    id?: true
    name?: true
    value?: true
    type?: true
    createdAt?: true
    updatedAt?: true
    _all?: true
  }

  export type SettingsAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which Settings to aggregate.
     */
    where?: SettingsWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Settings to fetch.
     */
    orderBy?: SettingsOrderByWithRelationInput | SettingsOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: SettingsWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Settings from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Settings.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned Settings
    **/
    _count?: true | SettingsCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to average
    **/
    _avg?: SettingsAvgAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to sum
    **/
    _sum?: SettingsSumAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: SettingsMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: SettingsMaxAggregateInputType
  }

  export type GetSettingsAggregateType<T extends SettingsAggregateArgs> = {
        [P in keyof T & keyof AggregateSettings]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateSettings[P]>
      : GetScalarType<T[P], AggregateSettings[P]>
  }




  export type SettingsGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: SettingsWhereInput
    orderBy?: SettingsOrderByWithAggregationInput | SettingsOrderByWithAggregationInput[]
    by: SettingsScalarFieldEnum[] | SettingsScalarFieldEnum
    having?: SettingsScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: SettingsCountAggregateInputType | true
    _avg?: SettingsAvgAggregateInputType
    _sum?: SettingsSumAggregateInputType
    _min?: SettingsMinAggregateInputType
    _max?: SettingsMaxAggregateInputType
  }

  export type SettingsGroupByOutputType = {
    id: number
    name: string
    value: string | null
    type: $Enums.DataType
    createdAt: Date
    updatedAt: Date
    _count: SettingsCountAggregateOutputType | null
    _avg: SettingsAvgAggregateOutputType | null
    _sum: SettingsSumAggregateOutputType | null
    _min: SettingsMinAggregateOutputType | null
    _max: SettingsMaxAggregateOutputType | null
  }

  type GetSettingsGroupByPayload<T extends SettingsGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<SettingsGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof SettingsGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], SettingsGroupByOutputType[P]>
            : GetScalarType<T[P], SettingsGroupByOutputType[P]>
        }
      >
    >


  export type SettingsSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    name?: boolean
    value?: boolean
    type?: boolean
    createdAt?: boolean
    updatedAt?: boolean
  }, ExtArgs["result"]["settings"]>

  export type SettingsSelectScalar = {
    id?: boolean
    name?: boolean
    value?: boolean
    type?: boolean
    createdAt?: boolean
    updatedAt?: boolean
  }


  export type $SettingsPayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "Settings"
    objects: {}
    scalars: $Extensions.GetPayloadResult<{
      id: number
      name: string
      value: string | null
      type: $Enums.DataType
      createdAt: Date
      updatedAt: Date
    }, ExtArgs["result"]["settings"]>
    composites: {}
  }


  type SettingsGetPayload<S extends boolean | null | undefined | SettingsDefaultArgs> = $Result.GetResult<Prisma.$SettingsPayload, S>

  type SettingsCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = 
    Omit<SettingsFindManyArgs, 'select' | 'include' | 'distinct' > & {
      select?: SettingsCountAggregateInputType | true
    }

  export interface SettingsDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['Settings'], meta: { name: 'Settings' } }
    /**
     * Find zero or one Settings that matches the filter.
     * @param {SettingsFindUniqueArgs} args - Arguments to find a Settings
     * @example
     * // Get one Settings
     * const settings = await prisma.settings.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findUnique<T extends SettingsFindUniqueArgs<ExtArgs>>(
      args: SelectSubset<T, SettingsFindUniqueArgs<ExtArgs>>
    ): Prisma__SettingsClient<$Result.GetResult<Prisma.$SettingsPayload<ExtArgs>, T, 'findUnique'> | null, null, ExtArgs>

    /**
     * Find one Settings that matches the filter or throw an error  with `error.code='P2025'` 
     *     if no matches were found.
     * @param {SettingsFindUniqueOrThrowArgs} args - Arguments to find a Settings
     * @example
     * // Get one Settings
     * const settings = await prisma.settings.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findUniqueOrThrow<T extends SettingsFindUniqueOrThrowArgs<ExtArgs>>(
      args?: SelectSubset<T, SettingsFindUniqueOrThrowArgs<ExtArgs>>
    ): Prisma__SettingsClient<$Result.GetResult<Prisma.$SettingsPayload<ExtArgs>, T, 'findUniqueOrThrow'>, never, ExtArgs>

    /**
     * Find the first Settings that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {SettingsFindFirstArgs} args - Arguments to find a Settings
     * @example
     * // Get one Settings
     * const settings = await prisma.settings.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findFirst<T extends SettingsFindFirstArgs<ExtArgs>>(
      args?: SelectSubset<T, SettingsFindFirstArgs<ExtArgs>>
    ): Prisma__SettingsClient<$Result.GetResult<Prisma.$SettingsPayload<ExtArgs>, T, 'findFirst'> | null, null, ExtArgs>

    /**
     * Find the first Settings that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {SettingsFindFirstOrThrowArgs} args - Arguments to find a Settings
     * @example
     * // Get one Settings
     * const settings = await prisma.settings.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findFirstOrThrow<T extends SettingsFindFirstOrThrowArgs<ExtArgs>>(
      args?: SelectSubset<T, SettingsFindFirstOrThrowArgs<ExtArgs>>
    ): Prisma__SettingsClient<$Result.GetResult<Prisma.$SettingsPayload<ExtArgs>, T, 'findFirstOrThrow'>, never, ExtArgs>

    /**
     * Find zero or more Settings that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {SettingsFindManyArgs=} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all Settings
     * const settings = await prisma.settings.findMany()
     * 
     * // Get first 10 Settings
     * const settings = await prisma.settings.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const settingsWithIdOnly = await prisma.settings.findMany({ select: { id: true } })
     * 
    **/
    findMany<T extends SettingsFindManyArgs<ExtArgs>>(
      args?: SelectSubset<T, SettingsFindManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<$Result.GetResult<Prisma.$SettingsPayload<ExtArgs>, T, 'findMany'>>

    /**
     * Create a Settings.
     * @param {SettingsCreateArgs} args - Arguments to create a Settings.
     * @example
     * // Create one Settings
     * const Settings = await prisma.settings.create({
     *   data: {
     *     // ... data to create a Settings
     *   }
     * })
     * 
    **/
    create<T extends SettingsCreateArgs<ExtArgs>>(
      args: SelectSubset<T, SettingsCreateArgs<ExtArgs>>
    ): Prisma__SettingsClient<$Result.GetResult<Prisma.$SettingsPayload<ExtArgs>, T, 'create'>, never, ExtArgs>

    /**
     * Create many Settings.
     *     @param {SettingsCreateManyArgs} args - Arguments to create many Settings.
     *     @example
     *     // Create many Settings
     *     const settings = await prisma.settings.createMany({
     *       data: {
     *         // ... provide data here
     *       }
     *     })
     *     
    **/
    createMany<T extends SettingsCreateManyArgs<ExtArgs>>(
      args?: SelectSubset<T, SettingsCreateManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Delete a Settings.
     * @param {SettingsDeleteArgs} args - Arguments to delete one Settings.
     * @example
     * // Delete one Settings
     * const Settings = await prisma.settings.delete({
     *   where: {
     *     // ... filter to delete one Settings
     *   }
     * })
     * 
    **/
    delete<T extends SettingsDeleteArgs<ExtArgs>>(
      args: SelectSubset<T, SettingsDeleteArgs<ExtArgs>>
    ): Prisma__SettingsClient<$Result.GetResult<Prisma.$SettingsPayload<ExtArgs>, T, 'delete'>, never, ExtArgs>

    /**
     * Update one Settings.
     * @param {SettingsUpdateArgs} args - Arguments to update one Settings.
     * @example
     * // Update one Settings
     * const settings = await prisma.settings.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
    **/
    update<T extends SettingsUpdateArgs<ExtArgs>>(
      args: SelectSubset<T, SettingsUpdateArgs<ExtArgs>>
    ): Prisma__SettingsClient<$Result.GetResult<Prisma.$SettingsPayload<ExtArgs>, T, 'update'>, never, ExtArgs>

    /**
     * Delete zero or more Settings.
     * @param {SettingsDeleteManyArgs} args - Arguments to filter Settings to delete.
     * @example
     * // Delete a few Settings
     * const { count } = await prisma.settings.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
    **/
    deleteMany<T extends SettingsDeleteManyArgs<ExtArgs>>(
      args?: SelectSubset<T, SettingsDeleteManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more Settings.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {SettingsUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many Settings
     * const settings = await prisma.settings.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
    **/
    updateMany<T extends SettingsUpdateManyArgs<ExtArgs>>(
      args: SelectSubset<T, SettingsUpdateManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create or update one Settings.
     * @param {SettingsUpsertArgs} args - Arguments to update or create a Settings.
     * @example
     * // Update or create a Settings
     * const settings = await prisma.settings.upsert({
     *   create: {
     *     // ... data to create a Settings
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the Settings we want to update
     *   }
     * })
    **/
    upsert<T extends SettingsUpsertArgs<ExtArgs>>(
      args: SelectSubset<T, SettingsUpsertArgs<ExtArgs>>
    ): Prisma__SettingsClient<$Result.GetResult<Prisma.$SettingsPayload<ExtArgs>, T, 'upsert'>, never, ExtArgs>

    /**
     * Count the number of Settings.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {SettingsCountArgs} args - Arguments to filter Settings to count.
     * @example
     * // Count the number of Settings
     * const count = await prisma.settings.count({
     *   where: {
     *     // ... the filter for the Settings we want to count
     *   }
     * })
    **/
    count<T extends SettingsCountArgs>(
      args?: Subset<T, SettingsCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], SettingsCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a Settings.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {SettingsAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends SettingsAggregateArgs>(args: Subset<T, SettingsAggregateArgs>): Prisma.PrismaPromise<GetSettingsAggregateType<T>>

    /**
     * Group by Settings.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {SettingsGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends SettingsGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: SettingsGroupByArgs['orderBy'] }
        : { orderBy?: SettingsGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, SettingsGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetSettingsGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the Settings model
   */
  readonly fields: SettingsFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for Settings.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__SettingsClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: 'PrismaPromise';


    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>;
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>;
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>;
  }



  /**
   * Fields of the Settings model
   */ 
  interface SettingsFieldRefs {
    readonly id: FieldRef<"Settings", 'Int'>
    readonly name: FieldRef<"Settings", 'String'>
    readonly value: FieldRef<"Settings", 'String'>
    readonly type: FieldRef<"Settings", 'DataType'>
    readonly createdAt: FieldRef<"Settings", 'DateTime'>
    readonly updatedAt: FieldRef<"Settings", 'DateTime'>
  }
    

  // Custom InputTypes

  /**
   * Settings findUnique
   */
  export type SettingsFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Settings
     */
    select?: SettingsSelect<ExtArgs> | null
    /**
     * Filter, which Settings to fetch.
     */
    where: SettingsWhereUniqueInput
  }


  /**
   * Settings findUniqueOrThrow
   */
  export type SettingsFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Settings
     */
    select?: SettingsSelect<ExtArgs> | null
    /**
     * Filter, which Settings to fetch.
     */
    where: SettingsWhereUniqueInput
  }


  /**
   * Settings findFirst
   */
  export type SettingsFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Settings
     */
    select?: SettingsSelect<ExtArgs> | null
    /**
     * Filter, which Settings to fetch.
     */
    where?: SettingsWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Settings to fetch.
     */
    orderBy?: SettingsOrderByWithRelationInput | SettingsOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for Settings.
     */
    cursor?: SettingsWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Settings from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Settings.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of Settings.
     */
    distinct?: SettingsScalarFieldEnum | SettingsScalarFieldEnum[]
  }


  /**
   * Settings findFirstOrThrow
   */
  export type SettingsFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Settings
     */
    select?: SettingsSelect<ExtArgs> | null
    /**
     * Filter, which Settings to fetch.
     */
    where?: SettingsWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Settings to fetch.
     */
    orderBy?: SettingsOrderByWithRelationInput | SettingsOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for Settings.
     */
    cursor?: SettingsWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Settings from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Settings.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of Settings.
     */
    distinct?: SettingsScalarFieldEnum | SettingsScalarFieldEnum[]
  }


  /**
   * Settings findMany
   */
  export type SettingsFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Settings
     */
    select?: SettingsSelect<ExtArgs> | null
    /**
     * Filter, which Settings to fetch.
     */
    where?: SettingsWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Settings to fetch.
     */
    orderBy?: SettingsOrderByWithRelationInput | SettingsOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing Settings.
     */
    cursor?: SettingsWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Settings from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Settings.
     */
    skip?: number
    distinct?: SettingsScalarFieldEnum | SettingsScalarFieldEnum[]
  }


  /**
   * Settings create
   */
  export type SettingsCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Settings
     */
    select?: SettingsSelect<ExtArgs> | null
    /**
     * The data needed to create a Settings.
     */
    data: XOR<SettingsCreateInput, SettingsUncheckedCreateInput>
  }


  /**
   * Settings createMany
   */
  export type SettingsCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many Settings.
     */
    data: SettingsCreateManyInput | SettingsCreateManyInput[]
    skipDuplicates?: boolean
  }


  /**
   * Settings update
   */
  export type SettingsUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Settings
     */
    select?: SettingsSelect<ExtArgs> | null
    /**
     * The data needed to update a Settings.
     */
    data: XOR<SettingsUpdateInput, SettingsUncheckedUpdateInput>
    /**
     * Choose, which Settings to update.
     */
    where: SettingsWhereUniqueInput
  }


  /**
   * Settings updateMany
   */
  export type SettingsUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update Settings.
     */
    data: XOR<SettingsUpdateManyMutationInput, SettingsUncheckedUpdateManyInput>
    /**
     * Filter which Settings to update
     */
    where?: SettingsWhereInput
  }


  /**
   * Settings upsert
   */
  export type SettingsUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Settings
     */
    select?: SettingsSelect<ExtArgs> | null
    /**
     * The filter to search for the Settings to update in case it exists.
     */
    where: SettingsWhereUniqueInput
    /**
     * In case the Settings found by the `where` argument doesn't exist, create a new Settings with this data.
     */
    create: XOR<SettingsCreateInput, SettingsUncheckedCreateInput>
    /**
     * In case the Settings was found with the provided `where` argument, update it with this data.
     */
    update: XOR<SettingsUpdateInput, SettingsUncheckedUpdateInput>
  }


  /**
   * Settings delete
   */
  export type SettingsDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Settings
     */
    select?: SettingsSelect<ExtArgs> | null
    /**
     * Filter which Settings to delete.
     */
    where: SettingsWhereUniqueInput
  }


  /**
   * Settings deleteMany
   */
  export type SettingsDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which Settings to delete
     */
    where?: SettingsWhereInput
  }


  /**
   * Settings without action
   */
  export type SettingsDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Settings
     */
    select?: SettingsSelect<ExtArgs> | null
  }



  /**
   * Enums
   */

  export const TransactionIsolationLevel: {
    ReadUncommitted: 'ReadUncommitted',
    ReadCommitted: 'ReadCommitted',
    RepeatableRead: 'RepeatableRead',
    Serializable: 'Serializable'
  };

  export type TransactionIsolationLevel = (typeof TransactionIsolationLevel)[keyof typeof TransactionIsolationLevel]


  export const UserScalarFieldEnum: {
    userId: 'userId',
    xuid: 'xuid',
    name: 'name',
    role: 'role',
    money: 'money',
    canTpa: 'canTpa',
    password: 'password',
    createdAt: 'createdAt',
    updatedAt: 'updatedAt',
    guildId: 'guildId'
  };

  export type UserScalarFieldEnum = (typeof UserScalarFieldEnum)[keyof typeof UserScalarFieldEnum]


  export const WarpScalarFieldEnum: {
    id: 'id',
    name: 'name',
    texture: 'texture',
    gamemode: 'gamemode',
    x: 'x',
    y: 'y',
    z: 'z',
    active: 'active'
  };

  export type WarpScalarFieldEnum = (typeof WarpScalarFieldEnum)[keyof typeof WarpScalarFieldEnum]


  export const GuildScalarFieldEnum: {
    guildId: 'guildId',
    name: 'name',
    description: 'description',
    ownerId: 'ownerId',
    maxMembers: 'maxMembers',
    isPublic: 'isPublic',
    createdAt: 'createdAt',
    updatedAt: 'updatedAt'
  };

  export type GuildScalarFieldEnum = (typeof GuildScalarFieldEnum)[keyof typeof GuildScalarFieldEnum]


  export const GuildMemberScalarFieldEnum: {
    id: 'id',
    guildId: 'guildId',
    memberId: 'memberId',
    memberRole: 'memberRole'
  };

  export type GuildMemberScalarFieldEnum = (typeof GuildMemberScalarFieldEnum)[keyof typeof GuildMemberScalarFieldEnum]


  export const ShopCategoryScalarFieldEnum: {
    categoryID: 'categoryID',
    no: 'no',
    name: 'name',
    texture: 'texture',
    type: 'type',
    active: 'active'
  };

  export type ShopCategoryScalarFieldEnum = (typeof ShopCategoryScalarFieldEnum)[keyof typeof ShopCategoryScalarFieldEnum]


  export const ShopItemScalarFieldEnum: {
    itemId: 'itemId',
    categoryId: 'categoryId',
    texture: 'texture',
    name: 'name',
    cost: 'cost',
    sell: 'sell',
    data: 'data',
    item: 'item',
    maxLevel: 'maxLevel',
    enchant: 'enchant',
    enchantType: 'enchantType',
    available: 'available',
    createdAt: 'createdAt',
    updatedAt: 'updatedAt'
  };

  export type ShopItemScalarFieldEnum = (typeof ShopItemScalarFieldEnum)[keyof typeof ShopItemScalarFieldEnum]


  export const TransactionScalarFieldEnum: {
    transactionId: 'transactionId',
    userId: 'userId',
    targetUserId: 'targetUserId',
    createdAt: 'createdAt',
    trxType: 'trxType'
  };

  export type TransactionScalarFieldEnum = (typeof TransactionScalarFieldEnum)[keyof typeof TransactionScalarFieldEnum]


  export const TransactionDetailScalarFieldEnum: {
    id: 'id',
    transactionId: 'transactionId',
    itemId: 'itemId',
    qty: 'qty',
    totalPrice: 'totalPrice'
  };

  export type TransactionDetailScalarFieldEnum = (typeof TransactionDetailScalarFieldEnum)[keyof typeof TransactionDetailScalarFieldEnum]


  export const TpaRequestScalarFieldEnum: {
    id: 'id',
    fromName: 'fromName',
    targetName: 'targetName',
    createdAt: 'createdAt'
  };

  export type TpaRequestScalarFieldEnum = (typeof TpaRequestScalarFieldEnum)[keyof typeof TpaRequestScalarFieldEnum]


  export const WayPointScalarFieldEnum: {
    id: 'id',
    ownerId: 'ownerId',
    name: 'name',
    x: 'x',
    y: 'y',
    z: 'z',
    dimension: 'dimension',
    isPublic: 'isPublic'
  };

  export type WayPointScalarFieldEnum = (typeof WayPointScalarFieldEnum)[keyof typeof WayPointScalarFieldEnum]


  export const SettingsScalarFieldEnum: {
    id: 'id',
    name: 'name',
    value: 'value',
    type: 'type',
    createdAt: 'createdAt',
    updatedAt: 'updatedAt'
  };

  export type SettingsScalarFieldEnum = (typeof SettingsScalarFieldEnum)[keyof typeof SettingsScalarFieldEnum]


  export const SortOrder: {
    asc: 'asc',
    desc: 'desc'
  };

  export type SortOrder = (typeof SortOrder)[keyof typeof SortOrder]


  export const NullsOrder: {
    first: 'first',
    last: 'last'
  };

  export type NullsOrder = (typeof NullsOrder)[keyof typeof NullsOrder]


  /**
   * Field references 
   */


  /**
   * Reference to a field of type 'Int'
   */
  export type IntFieldRefInput<$PrismaModel> = FieldRefInputType<$PrismaModel, 'Int'>
    


  /**
   * Reference to a field of type 'String'
   */
  export type StringFieldRefInput<$PrismaModel> = FieldRefInputType<$PrismaModel, 'String'>
    


  /**
   * Reference to a field of type 'UserRole'
   */
  export type EnumUserRoleFieldRefInput<$PrismaModel> = FieldRefInputType<$PrismaModel, 'UserRole'>
    


  /**
   * Reference to a field of type 'Boolean'
   */
  export type BooleanFieldRefInput<$PrismaModel> = FieldRefInputType<$PrismaModel, 'Boolean'>
    


  /**
   * Reference to a field of type 'DateTime'
   */
  export type DateTimeFieldRefInput<$PrismaModel> = FieldRefInputType<$PrismaModel, 'DateTime'>
    


  /**
   * Reference to a field of type 'Float'
   */
  export type FloatFieldRefInput<$PrismaModel> = FieldRefInputType<$PrismaModel, 'Float'>
    


  /**
   * Reference to a field of type 'GuildRole'
   */
  export type EnumGuildRoleFieldRefInput<$PrismaModel> = FieldRefInputType<$PrismaModel, 'GuildRole'>
    


  /**
   * Reference to a field of type 'ItemType'
   */
  export type EnumItemTypeFieldRefInput<$PrismaModel> = FieldRefInputType<$PrismaModel, 'ItemType'>
    


  /**
   * Reference to a field of type 'EnchantType'
   */
  export type EnumEnchantTypeFieldRefInput<$PrismaModel> = FieldRefInputType<$PrismaModel, 'EnchantType'>
    


  /**
   * Reference to a field of type 'TrxType'
   */
  export type EnumTrxTypeFieldRefInput<$PrismaModel> = FieldRefInputType<$PrismaModel, 'TrxType'>
    


  /**
   * Reference to a field of type 'DataType'
   */
  export type EnumDataTypeFieldRefInput<$PrismaModel> = FieldRefInputType<$PrismaModel, 'DataType'>
    
  /**
   * Deep Input Types
   */


  export type UserWhereInput = {
    AND?: UserWhereInput | UserWhereInput[]
    OR?: UserWhereInput[]
    NOT?: UserWhereInput | UserWhereInput[]
    userId?: IntFilter<"User"> | number
    xuid?: StringFilter<"User"> | string
    name?: StringFilter<"User"> | string
    role?: EnumUserRoleFilter<"User"> | $Enums.UserRole
    money?: IntFilter<"User"> | number
    canTpa?: BoolFilter<"User"> | boolean
    password?: StringNullableFilter<"User"> | string | null
    createdAt?: DateTimeFilter<"User"> | Date | string
    updatedAt?: DateTimeFilter<"User"> | Date | string
    guildId?: IntNullableFilter<"User"> | number | null
    guildMember?: XOR<GuildMemberNullableRelationFilter, GuildMemberWhereInput> | null
    userTransaction?: TransactionListRelationFilter
    targetTransaction?: TransactionListRelationFilter
    waypoint?: WayPointListRelationFilter
  }

  export type UserOrderByWithRelationInput = {
    userId?: SortOrder
    xuid?: SortOrder
    name?: SortOrder
    role?: SortOrder
    money?: SortOrder
    canTpa?: SortOrder
    password?: SortOrderInput | SortOrder
    createdAt?: SortOrder
    updatedAt?: SortOrder
    guildId?: SortOrderInput | SortOrder
    guildMember?: GuildMemberOrderByWithRelationInput
    userTransaction?: TransactionOrderByRelationAggregateInput
    targetTransaction?: TransactionOrderByRelationAggregateInput
    waypoint?: WayPointOrderByRelationAggregateInput
  }

  export type UserWhereUniqueInput = Prisma.AtLeast<{
    userId?: number
    xuid?: string
    AND?: UserWhereInput | UserWhereInput[]
    OR?: UserWhereInput[]
    NOT?: UserWhereInput | UserWhereInput[]
    name?: StringFilter<"User"> | string
    role?: EnumUserRoleFilter<"User"> | $Enums.UserRole
    money?: IntFilter<"User"> | number
    canTpa?: BoolFilter<"User"> | boolean
    password?: StringNullableFilter<"User"> | string | null
    createdAt?: DateTimeFilter<"User"> | Date | string
    updatedAt?: DateTimeFilter<"User"> | Date | string
    guildId?: IntNullableFilter<"User"> | number | null
    guildMember?: XOR<GuildMemberNullableRelationFilter, GuildMemberWhereInput> | null
    userTransaction?: TransactionListRelationFilter
    targetTransaction?: TransactionListRelationFilter
    waypoint?: WayPointListRelationFilter
  }, "userId" | "xuid">

  export type UserOrderByWithAggregationInput = {
    userId?: SortOrder
    xuid?: SortOrder
    name?: SortOrder
    role?: SortOrder
    money?: SortOrder
    canTpa?: SortOrder
    password?: SortOrderInput | SortOrder
    createdAt?: SortOrder
    updatedAt?: SortOrder
    guildId?: SortOrderInput | SortOrder
    _count?: UserCountOrderByAggregateInput
    _avg?: UserAvgOrderByAggregateInput
    _max?: UserMaxOrderByAggregateInput
    _min?: UserMinOrderByAggregateInput
    _sum?: UserSumOrderByAggregateInput
  }

  export type UserScalarWhereWithAggregatesInput = {
    AND?: UserScalarWhereWithAggregatesInput | UserScalarWhereWithAggregatesInput[]
    OR?: UserScalarWhereWithAggregatesInput[]
    NOT?: UserScalarWhereWithAggregatesInput | UserScalarWhereWithAggregatesInput[]
    userId?: IntWithAggregatesFilter<"User"> | number
    xuid?: StringWithAggregatesFilter<"User"> | string
    name?: StringWithAggregatesFilter<"User"> | string
    role?: EnumUserRoleWithAggregatesFilter<"User"> | $Enums.UserRole
    money?: IntWithAggregatesFilter<"User"> | number
    canTpa?: BoolWithAggregatesFilter<"User"> | boolean
    password?: StringNullableWithAggregatesFilter<"User"> | string | null
    createdAt?: DateTimeWithAggregatesFilter<"User"> | Date | string
    updatedAt?: DateTimeWithAggregatesFilter<"User"> | Date | string
    guildId?: IntNullableWithAggregatesFilter<"User"> | number | null
  }

  export type WarpWhereInput = {
    AND?: WarpWhereInput | WarpWhereInput[]
    OR?: WarpWhereInput[]
    NOT?: WarpWhereInput | WarpWhereInput[]
    id?: IntFilter<"Warp"> | number
    name?: StringFilter<"Warp"> | string
    texture?: StringFilter<"Warp"> | string
    gamemode?: StringFilter<"Warp"> | string
    x?: FloatFilter<"Warp"> | number
    y?: FloatFilter<"Warp"> | number
    z?: FloatFilter<"Warp"> | number
    active?: BoolFilter<"Warp"> | boolean
  }

  export type WarpOrderByWithRelationInput = {
    id?: SortOrder
    name?: SortOrder
    texture?: SortOrder
    gamemode?: SortOrder
    x?: SortOrder
    y?: SortOrder
    z?: SortOrder
    active?: SortOrder
  }

  export type WarpWhereUniqueInput = Prisma.AtLeast<{
    id?: number
    AND?: WarpWhereInput | WarpWhereInput[]
    OR?: WarpWhereInput[]
    NOT?: WarpWhereInput | WarpWhereInput[]
    name?: StringFilter<"Warp"> | string
    texture?: StringFilter<"Warp"> | string
    gamemode?: StringFilter<"Warp"> | string
    x?: FloatFilter<"Warp"> | number
    y?: FloatFilter<"Warp"> | number
    z?: FloatFilter<"Warp"> | number
    active?: BoolFilter<"Warp"> | boolean
  }, "id">

  export type WarpOrderByWithAggregationInput = {
    id?: SortOrder
    name?: SortOrder
    texture?: SortOrder
    gamemode?: SortOrder
    x?: SortOrder
    y?: SortOrder
    z?: SortOrder
    active?: SortOrder
    _count?: WarpCountOrderByAggregateInput
    _avg?: WarpAvgOrderByAggregateInput
    _max?: WarpMaxOrderByAggregateInput
    _min?: WarpMinOrderByAggregateInput
    _sum?: WarpSumOrderByAggregateInput
  }

  export type WarpScalarWhereWithAggregatesInput = {
    AND?: WarpScalarWhereWithAggregatesInput | WarpScalarWhereWithAggregatesInput[]
    OR?: WarpScalarWhereWithAggregatesInput[]
    NOT?: WarpScalarWhereWithAggregatesInput | WarpScalarWhereWithAggregatesInput[]
    id?: IntWithAggregatesFilter<"Warp"> | number
    name?: StringWithAggregatesFilter<"Warp"> | string
    texture?: StringWithAggregatesFilter<"Warp"> | string
    gamemode?: StringWithAggregatesFilter<"Warp"> | string
    x?: FloatWithAggregatesFilter<"Warp"> | number
    y?: FloatWithAggregatesFilter<"Warp"> | number
    z?: FloatWithAggregatesFilter<"Warp"> | number
    active?: BoolWithAggregatesFilter<"Warp"> | boolean
  }

  export type GuildWhereInput = {
    AND?: GuildWhereInput | GuildWhereInput[]
    OR?: GuildWhereInput[]
    NOT?: GuildWhereInput | GuildWhereInput[]
    guildId?: IntFilter<"Guild"> | number
    name?: StringFilter<"Guild"> | string
    description?: StringNullableFilter<"Guild"> | string | null
    ownerId?: StringFilter<"Guild"> | string
    maxMembers?: IntFilter<"Guild"> | number
    isPublic?: BoolFilter<"Guild"> | boolean
    createdAt?: DateTimeFilter<"Guild"> | Date | string
    updatedAt?: DateTimeFilter<"Guild"> | Date | string
    GuildMember?: GuildMemberListRelationFilter
  }

  export type GuildOrderByWithRelationInput = {
    guildId?: SortOrder
    name?: SortOrder
    description?: SortOrderInput | SortOrder
    ownerId?: SortOrder
    maxMembers?: SortOrder
    isPublic?: SortOrder
    createdAt?: SortOrder
    updatedAt?: SortOrder
    GuildMember?: GuildMemberOrderByRelationAggregateInput
  }

  export type GuildWhereUniqueInput = Prisma.AtLeast<{
    guildId?: number
    ownerId?: string
    AND?: GuildWhereInput | GuildWhereInput[]
    OR?: GuildWhereInput[]
    NOT?: GuildWhereInput | GuildWhereInput[]
    name?: StringFilter<"Guild"> | string
    description?: StringNullableFilter<"Guild"> | string | null
    maxMembers?: IntFilter<"Guild"> | number
    isPublic?: BoolFilter<"Guild"> | boolean
    createdAt?: DateTimeFilter<"Guild"> | Date | string
    updatedAt?: DateTimeFilter<"Guild"> | Date | string
    GuildMember?: GuildMemberListRelationFilter
  }, "guildId" | "ownerId">

  export type GuildOrderByWithAggregationInput = {
    guildId?: SortOrder
    name?: SortOrder
    description?: SortOrderInput | SortOrder
    ownerId?: SortOrder
    maxMembers?: SortOrder
    isPublic?: SortOrder
    createdAt?: SortOrder
    updatedAt?: SortOrder
    _count?: GuildCountOrderByAggregateInput
    _avg?: GuildAvgOrderByAggregateInput
    _max?: GuildMaxOrderByAggregateInput
    _min?: GuildMinOrderByAggregateInput
    _sum?: GuildSumOrderByAggregateInput
  }

  export type GuildScalarWhereWithAggregatesInput = {
    AND?: GuildScalarWhereWithAggregatesInput | GuildScalarWhereWithAggregatesInput[]
    OR?: GuildScalarWhereWithAggregatesInput[]
    NOT?: GuildScalarWhereWithAggregatesInput | GuildScalarWhereWithAggregatesInput[]
    guildId?: IntWithAggregatesFilter<"Guild"> | number
    name?: StringWithAggregatesFilter<"Guild"> | string
    description?: StringNullableWithAggregatesFilter<"Guild"> | string | null
    ownerId?: StringWithAggregatesFilter<"Guild"> | string
    maxMembers?: IntWithAggregatesFilter<"Guild"> | number
    isPublic?: BoolWithAggregatesFilter<"Guild"> | boolean
    createdAt?: DateTimeWithAggregatesFilter<"Guild"> | Date | string
    updatedAt?: DateTimeWithAggregatesFilter<"Guild"> | Date | string
  }

  export type GuildMemberWhereInput = {
    AND?: GuildMemberWhereInput | GuildMemberWhereInput[]
    OR?: GuildMemberWhereInput[]
    NOT?: GuildMemberWhereInput | GuildMemberWhereInput[]
    id?: IntFilter<"GuildMember"> | number
    guildId?: IntFilter<"GuildMember"> | number
    memberId?: StringFilter<"GuildMember"> | string
    memberRole?: EnumGuildRoleFilter<"GuildMember"> | $Enums.GuildRole
    guild?: XOR<GuildRelationFilter, GuildWhereInput>
    member?: XOR<UserRelationFilter, UserWhereInput>
  }

  export type GuildMemberOrderByWithRelationInput = {
    id?: SortOrder
    guildId?: SortOrder
    memberId?: SortOrder
    memberRole?: SortOrder
    guild?: GuildOrderByWithRelationInput
    member?: UserOrderByWithRelationInput
  }

  export type GuildMemberWhereUniqueInput = Prisma.AtLeast<{
    id?: number
    memberId?: string
    AND?: GuildMemberWhereInput | GuildMemberWhereInput[]
    OR?: GuildMemberWhereInput[]
    NOT?: GuildMemberWhereInput | GuildMemberWhereInput[]
    guildId?: IntFilter<"GuildMember"> | number
    memberRole?: EnumGuildRoleFilter<"GuildMember"> | $Enums.GuildRole
    guild?: XOR<GuildRelationFilter, GuildWhereInput>
    member?: XOR<UserRelationFilter, UserWhereInput>
  }, "id" | "memberId">

  export type GuildMemberOrderByWithAggregationInput = {
    id?: SortOrder
    guildId?: SortOrder
    memberId?: SortOrder
    memberRole?: SortOrder
    _count?: GuildMemberCountOrderByAggregateInput
    _avg?: GuildMemberAvgOrderByAggregateInput
    _max?: GuildMemberMaxOrderByAggregateInput
    _min?: GuildMemberMinOrderByAggregateInput
    _sum?: GuildMemberSumOrderByAggregateInput
  }

  export type GuildMemberScalarWhereWithAggregatesInput = {
    AND?: GuildMemberScalarWhereWithAggregatesInput | GuildMemberScalarWhereWithAggregatesInput[]
    OR?: GuildMemberScalarWhereWithAggregatesInput[]
    NOT?: GuildMemberScalarWhereWithAggregatesInput | GuildMemberScalarWhereWithAggregatesInput[]
    id?: IntWithAggregatesFilter<"GuildMember"> | number
    guildId?: IntWithAggregatesFilter<"GuildMember"> | number
    memberId?: StringWithAggregatesFilter<"GuildMember"> | string
    memberRole?: EnumGuildRoleWithAggregatesFilter<"GuildMember"> | $Enums.GuildRole
  }

  export type ShopCategoryWhereInput = {
    AND?: ShopCategoryWhereInput | ShopCategoryWhereInput[]
    OR?: ShopCategoryWhereInput[]
    NOT?: ShopCategoryWhereInput | ShopCategoryWhereInput[]
    categoryID?: IntFilter<"ShopCategory"> | number
    no?: IntFilter<"ShopCategory"> | number
    name?: StringFilter<"ShopCategory"> | string
    texture?: StringFilter<"ShopCategory"> | string
    type?: EnumItemTypeFilter<"ShopCategory"> | $Enums.ItemType
    active?: BoolFilter<"ShopCategory"> | boolean
    ShopItem?: ShopItemListRelationFilter
  }

  export type ShopCategoryOrderByWithRelationInput = {
    categoryID?: SortOrder
    no?: SortOrder
    name?: SortOrder
    texture?: SortOrder
    type?: SortOrder
    active?: SortOrder
    ShopItem?: ShopItemOrderByRelationAggregateInput
  }

  export type ShopCategoryWhereUniqueInput = Prisma.AtLeast<{
    categoryID?: number
    AND?: ShopCategoryWhereInput | ShopCategoryWhereInput[]
    OR?: ShopCategoryWhereInput[]
    NOT?: ShopCategoryWhereInput | ShopCategoryWhereInput[]
    no?: IntFilter<"ShopCategory"> | number
    name?: StringFilter<"ShopCategory"> | string
    texture?: StringFilter<"ShopCategory"> | string
    type?: EnumItemTypeFilter<"ShopCategory"> | $Enums.ItemType
    active?: BoolFilter<"ShopCategory"> | boolean
    ShopItem?: ShopItemListRelationFilter
  }, "categoryID">

  export type ShopCategoryOrderByWithAggregationInput = {
    categoryID?: SortOrder
    no?: SortOrder
    name?: SortOrder
    texture?: SortOrder
    type?: SortOrder
    active?: SortOrder
    _count?: ShopCategoryCountOrderByAggregateInput
    _avg?: ShopCategoryAvgOrderByAggregateInput
    _max?: ShopCategoryMaxOrderByAggregateInput
    _min?: ShopCategoryMinOrderByAggregateInput
    _sum?: ShopCategorySumOrderByAggregateInput
  }

  export type ShopCategoryScalarWhereWithAggregatesInput = {
    AND?: ShopCategoryScalarWhereWithAggregatesInput | ShopCategoryScalarWhereWithAggregatesInput[]
    OR?: ShopCategoryScalarWhereWithAggregatesInput[]
    NOT?: ShopCategoryScalarWhereWithAggregatesInput | ShopCategoryScalarWhereWithAggregatesInput[]
    categoryID?: IntWithAggregatesFilter<"ShopCategory"> | number
    no?: IntWithAggregatesFilter<"ShopCategory"> | number
    name?: StringWithAggregatesFilter<"ShopCategory"> | string
    texture?: StringWithAggregatesFilter<"ShopCategory"> | string
    type?: EnumItemTypeWithAggregatesFilter<"ShopCategory"> | $Enums.ItemType
    active?: BoolWithAggregatesFilter<"ShopCategory"> | boolean
  }

  export type ShopItemWhereInput = {
    AND?: ShopItemWhereInput | ShopItemWhereInput[]
    OR?: ShopItemWhereInput[]
    NOT?: ShopItemWhereInput | ShopItemWhereInput[]
    itemId?: IntFilter<"ShopItem"> | number
    categoryId?: IntFilter<"ShopItem"> | number
    texture?: StringFilter<"ShopItem"> | string
    name?: StringFilter<"ShopItem"> | string
    cost?: IntFilter<"ShopItem"> | number
    sell?: IntNullableFilter<"ShopItem"> | number | null
    data?: IntFilter<"ShopItem"> | number
    item?: StringFilter<"ShopItem"> | string
    maxLevel?: IntNullableFilter<"ShopItem"> | number | null
    enchant?: StringNullableFilter<"ShopItem"> | string | null
    enchantType?: EnumEnchantTypeNullableFilter<"ShopItem"> | $Enums.EnchantType | null
    available?: BoolFilter<"ShopItem"> | boolean
    createdAt?: DateTimeFilter<"ShopItem"> | Date | string
    updatedAt?: DateTimeFilter<"ShopItem"> | Date | string
    category?: XOR<ShopCategoryRelationFilter, ShopCategoryWhereInput>
    TransactionDetail?: TransactionDetailListRelationFilter
  }

  export type ShopItemOrderByWithRelationInput = {
    itemId?: SortOrder
    categoryId?: SortOrder
    texture?: SortOrder
    name?: SortOrder
    cost?: SortOrder
    sell?: SortOrderInput | SortOrder
    data?: SortOrder
    item?: SortOrder
    maxLevel?: SortOrderInput | SortOrder
    enchant?: SortOrderInput | SortOrder
    enchantType?: SortOrderInput | SortOrder
    available?: SortOrder
    createdAt?: SortOrder
    updatedAt?: SortOrder
    category?: ShopCategoryOrderByWithRelationInput
    TransactionDetail?: TransactionDetailOrderByRelationAggregateInput
  }

  export type ShopItemWhereUniqueInput = Prisma.AtLeast<{
    itemId?: number
    AND?: ShopItemWhereInput | ShopItemWhereInput[]
    OR?: ShopItemWhereInput[]
    NOT?: ShopItemWhereInput | ShopItemWhereInput[]
    categoryId?: IntFilter<"ShopItem"> | number
    texture?: StringFilter<"ShopItem"> | string
    name?: StringFilter<"ShopItem"> | string
    cost?: IntFilter<"ShopItem"> | number
    sell?: IntNullableFilter<"ShopItem"> | number | null
    data?: IntFilter<"ShopItem"> | number
    item?: StringFilter<"ShopItem"> | string
    maxLevel?: IntNullableFilter<"ShopItem"> | number | null
    enchant?: StringNullableFilter<"ShopItem"> | string | null
    enchantType?: EnumEnchantTypeNullableFilter<"ShopItem"> | $Enums.EnchantType | null
    available?: BoolFilter<"ShopItem"> | boolean
    createdAt?: DateTimeFilter<"ShopItem"> | Date | string
    updatedAt?: DateTimeFilter<"ShopItem"> | Date | string
    category?: XOR<ShopCategoryRelationFilter, ShopCategoryWhereInput>
    TransactionDetail?: TransactionDetailListRelationFilter
  }, "itemId">

  export type ShopItemOrderByWithAggregationInput = {
    itemId?: SortOrder
    categoryId?: SortOrder
    texture?: SortOrder
    name?: SortOrder
    cost?: SortOrder
    sell?: SortOrderInput | SortOrder
    data?: SortOrder
    item?: SortOrder
    maxLevel?: SortOrderInput | SortOrder
    enchant?: SortOrderInput | SortOrder
    enchantType?: SortOrderInput | SortOrder
    available?: SortOrder
    createdAt?: SortOrder
    updatedAt?: SortOrder
    _count?: ShopItemCountOrderByAggregateInput
    _avg?: ShopItemAvgOrderByAggregateInput
    _max?: ShopItemMaxOrderByAggregateInput
    _min?: ShopItemMinOrderByAggregateInput
    _sum?: ShopItemSumOrderByAggregateInput
  }

  export type ShopItemScalarWhereWithAggregatesInput = {
    AND?: ShopItemScalarWhereWithAggregatesInput | ShopItemScalarWhereWithAggregatesInput[]
    OR?: ShopItemScalarWhereWithAggregatesInput[]
    NOT?: ShopItemScalarWhereWithAggregatesInput | ShopItemScalarWhereWithAggregatesInput[]
    itemId?: IntWithAggregatesFilter<"ShopItem"> | number
    categoryId?: IntWithAggregatesFilter<"ShopItem"> | number
    texture?: StringWithAggregatesFilter<"ShopItem"> | string
    name?: StringWithAggregatesFilter<"ShopItem"> | string
    cost?: IntWithAggregatesFilter<"ShopItem"> | number
    sell?: IntNullableWithAggregatesFilter<"ShopItem"> | number | null
    data?: IntWithAggregatesFilter<"ShopItem"> | number
    item?: StringWithAggregatesFilter<"ShopItem"> | string
    maxLevel?: IntNullableWithAggregatesFilter<"ShopItem"> | number | null
    enchant?: StringNullableWithAggregatesFilter<"ShopItem"> | string | null
    enchantType?: EnumEnchantTypeNullableWithAggregatesFilter<"ShopItem"> | $Enums.EnchantType | null
    available?: BoolWithAggregatesFilter<"ShopItem"> | boolean
    createdAt?: DateTimeWithAggregatesFilter<"ShopItem"> | Date | string
    updatedAt?: DateTimeWithAggregatesFilter<"ShopItem"> | Date | string
  }

  export type TransactionWhereInput = {
    AND?: TransactionWhereInput | TransactionWhereInput[]
    OR?: TransactionWhereInput[]
    NOT?: TransactionWhereInput | TransactionWhereInput[]
    transactionId?: IntFilter<"Transaction"> | number
    userId?: StringFilter<"Transaction"> | string
    targetUserId?: StringNullableFilter<"Transaction"> | string | null
    createdAt?: DateTimeFilter<"Transaction"> | Date | string
    trxType?: EnumTrxTypeFilter<"Transaction"> | $Enums.TrxType
    user?: XOR<UserNullableRelationFilter, UserWhereInput> | null
    targetUser?: XOR<UserNullableRelationFilter, UserWhereInput> | null
    TransactionDetail?: XOR<TransactionDetailNullableRelationFilter, TransactionDetailWhereInput> | null
  }

  export type TransactionOrderByWithRelationInput = {
    transactionId?: SortOrder
    userId?: SortOrder
    targetUserId?: SortOrderInput | SortOrder
    createdAt?: SortOrder
    trxType?: SortOrder
    user?: UserOrderByWithRelationInput
    targetUser?: UserOrderByWithRelationInput
    TransactionDetail?: TransactionDetailOrderByWithRelationInput
  }

  export type TransactionWhereUniqueInput = Prisma.AtLeast<{
    transactionId?: number
    AND?: TransactionWhereInput | TransactionWhereInput[]
    OR?: TransactionWhereInput[]
    NOT?: TransactionWhereInput | TransactionWhereInput[]
    userId?: StringFilter<"Transaction"> | string
    targetUserId?: StringNullableFilter<"Transaction"> | string | null
    createdAt?: DateTimeFilter<"Transaction"> | Date | string
    trxType?: EnumTrxTypeFilter<"Transaction"> | $Enums.TrxType
    user?: XOR<UserNullableRelationFilter, UserWhereInput> | null
    targetUser?: XOR<UserNullableRelationFilter, UserWhereInput> | null
    TransactionDetail?: XOR<TransactionDetailNullableRelationFilter, TransactionDetailWhereInput> | null
  }, "transactionId">

  export type TransactionOrderByWithAggregationInput = {
    transactionId?: SortOrder
    userId?: SortOrder
    targetUserId?: SortOrderInput | SortOrder
    createdAt?: SortOrder
    trxType?: SortOrder
    _count?: TransactionCountOrderByAggregateInput
    _avg?: TransactionAvgOrderByAggregateInput
    _max?: TransactionMaxOrderByAggregateInput
    _min?: TransactionMinOrderByAggregateInput
    _sum?: TransactionSumOrderByAggregateInput
  }

  export type TransactionScalarWhereWithAggregatesInput = {
    AND?: TransactionScalarWhereWithAggregatesInput | TransactionScalarWhereWithAggregatesInput[]
    OR?: TransactionScalarWhereWithAggregatesInput[]
    NOT?: TransactionScalarWhereWithAggregatesInput | TransactionScalarWhereWithAggregatesInput[]
    transactionId?: IntWithAggregatesFilter<"Transaction"> | number
    userId?: StringWithAggregatesFilter<"Transaction"> | string
    targetUserId?: StringNullableWithAggregatesFilter<"Transaction"> | string | null
    createdAt?: DateTimeWithAggregatesFilter<"Transaction"> | Date | string
    trxType?: EnumTrxTypeWithAggregatesFilter<"Transaction"> | $Enums.TrxType
  }

  export type TransactionDetailWhereInput = {
    AND?: TransactionDetailWhereInput | TransactionDetailWhereInput[]
    OR?: TransactionDetailWhereInput[]
    NOT?: TransactionDetailWhereInput | TransactionDetailWhereInput[]
    id?: IntFilter<"TransactionDetail"> | number
    transactionId?: IntFilter<"TransactionDetail"> | number
    itemId?: IntNullableFilter<"TransactionDetail"> | number | null
    qty?: IntFilter<"TransactionDetail"> | number
    totalPrice?: IntFilter<"TransactionDetail"> | number
    shopItem?: XOR<ShopItemNullableRelationFilter, ShopItemWhereInput> | null
    transaction?: XOR<TransactionRelationFilter, TransactionWhereInput>
  }

  export type TransactionDetailOrderByWithRelationInput = {
    id?: SortOrder
    transactionId?: SortOrder
    itemId?: SortOrderInput | SortOrder
    qty?: SortOrder
    totalPrice?: SortOrder
    shopItem?: ShopItemOrderByWithRelationInput
    transaction?: TransactionOrderByWithRelationInput
  }

  export type TransactionDetailWhereUniqueInput = Prisma.AtLeast<{
    id?: number
    transactionId?: number
    AND?: TransactionDetailWhereInput | TransactionDetailWhereInput[]
    OR?: TransactionDetailWhereInput[]
    NOT?: TransactionDetailWhereInput | TransactionDetailWhereInput[]
    itemId?: IntNullableFilter<"TransactionDetail"> | number | null
    qty?: IntFilter<"TransactionDetail"> | number
    totalPrice?: IntFilter<"TransactionDetail"> | number
    shopItem?: XOR<ShopItemNullableRelationFilter, ShopItemWhereInput> | null
    transaction?: XOR<TransactionRelationFilter, TransactionWhereInput>
  }, "id" | "transactionId">

  export type TransactionDetailOrderByWithAggregationInput = {
    id?: SortOrder
    transactionId?: SortOrder
    itemId?: SortOrderInput | SortOrder
    qty?: SortOrder
    totalPrice?: SortOrder
    _count?: TransactionDetailCountOrderByAggregateInput
    _avg?: TransactionDetailAvgOrderByAggregateInput
    _max?: TransactionDetailMaxOrderByAggregateInput
    _min?: TransactionDetailMinOrderByAggregateInput
    _sum?: TransactionDetailSumOrderByAggregateInput
  }

  export type TransactionDetailScalarWhereWithAggregatesInput = {
    AND?: TransactionDetailScalarWhereWithAggregatesInput | TransactionDetailScalarWhereWithAggregatesInput[]
    OR?: TransactionDetailScalarWhereWithAggregatesInput[]
    NOT?: TransactionDetailScalarWhereWithAggregatesInput | TransactionDetailScalarWhereWithAggregatesInput[]
    id?: IntWithAggregatesFilter<"TransactionDetail"> | number
    transactionId?: IntWithAggregatesFilter<"TransactionDetail"> | number
    itemId?: IntNullableWithAggregatesFilter<"TransactionDetail"> | number | null
    qty?: IntWithAggregatesFilter<"TransactionDetail"> | number
    totalPrice?: IntWithAggregatesFilter<"TransactionDetail"> | number
  }

  export type TpaRequestWhereInput = {
    AND?: TpaRequestWhereInput | TpaRequestWhereInput[]
    OR?: TpaRequestWhereInput[]
    NOT?: TpaRequestWhereInput | TpaRequestWhereInput[]
    id?: IntFilter<"TpaRequest"> | number
    fromName?: StringFilter<"TpaRequest"> | string
    targetName?: StringFilter<"TpaRequest"> | string
    createdAt?: DateTimeFilter<"TpaRequest"> | Date | string
  }

  export type TpaRequestOrderByWithRelationInput = {
    id?: SortOrder
    fromName?: SortOrder
    targetName?: SortOrder
    createdAt?: SortOrder
  }

  export type TpaRequestWhereUniqueInput = Prisma.AtLeast<{
    id?: number
    AND?: TpaRequestWhereInput | TpaRequestWhereInput[]
    OR?: TpaRequestWhereInput[]
    NOT?: TpaRequestWhereInput | TpaRequestWhereInput[]
    fromName?: StringFilter<"TpaRequest"> | string
    targetName?: StringFilter<"TpaRequest"> | string
    createdAt?: DateTimeFilter<"TpaRequest"> | Date | string
  }, "id">

  export type TpaRequestOrderByWithAggregationInput = {
    id?: SortOrder
    fromName?: SortOrder
    targetName?: SortOrder
    createdAt?: SortOrder
    _count?: TpaRequestCountOrderByAggregateInput
    _avg?: TpaRequestAvgOrderByAggregateInput
    _max?: TpaRequestMaxOrderByAggregateInput
    _min?: TpaRequestMinOrderByAggregateInput
    _sum?: TpaRequestSumOrderByAggregateInput
  }

  export type TpaRequestScalarWhereWithAggregatesInput = {
    AND?: TpaRequestScalarWhereWithAggregatesInput | TpaRequestScalarWhereWithAggregatesInput[]
    OR?: TpaRequestScalarWhereWithAggregatesInput[]
    NOT?: TpaRequestScalarWhereWithAggregatesInput | TpaRequestScalarWhereWithAggregatesInput[]
    id?: IntWithAggregatesFilter<"TpaRequest"> | number
    fromName?: StringWithAggregatesFilter<"TpaRequest"> | string
    targetName?: StringWithAggregatesFilter<"TpaRequest"> | string
    createdAt?: DateTimeWithAggregatesFilter<"TpaRequest"> | Date | string
  }

  export type WayPointWhereInput = {
    AND?: WayPointWhereInput | WayPointWhereInput[]
    OR?: WayPointWhereInput[]
    NOT?: WayPointWhereInput | WayPointWhereInput[]
    id?: IntFilter<"WayPoint"> | number
    ownerId?: StringFilter<"WayPoint"> | string
    name?: StringFilter<"WayPoint"> | string
    x?: FloatFilter<"WayPoint"> | number
    y?: FloatFilter<"WayPoint"> | number
    z?: FloatFilter<"WayPoint"> | number
    dimension?: StringFilter<"WayPoint"> | string
    isPublic?: BoolFilter<"WayPoint"> | boolean
    User?: XOR<UserNullableRelationFilter, UserWhereInput> | null
  }

  export type WayPointOrderByWithRelationInput = {
    id?: SortOrder
    ownerId?: SortOrder
    name?: SortOrder
    x?: SortOrder
    y?: SortOrder
    z?: SortOrder
    dimension?: SortOrder
    isPublic?: SortOrder
    User?: UserOrderByWithRelationInput
  }

  export type WayPointWhereUniqueInput = Prisma.AtLeast<{
    id?: number
    AND?: WayPointWhereInput | WayPointWhereInput[]
    OR?: WayPointWhereInput[]
    NOT?: WayPointWhereInput | WayPointWhereInput[]
    ownerId?: StringFilter<"WayPoint"> | string
    name?: StringFilter<"WayPoint"> | string
    x?: FloatFilter<"WayPoint"> | number
    y?: FloatFilter<"WayPoint"> | number
    z?: FloatFilter<"WayPoint"> | number
    dimension?: StringFilter<"WayPoint"> | string
    isPublic?: BoolFilter<"WayPoint"> | boolean
    User?: XOR<UserNullableRelationFilter, UserWhereInput> | null
  }, "id">

  export type WayPointOrderByWithAggregationInput = {
    id?: SortOrder
    ownerId?: SortOrder
    name?: SortOrder
    x?: SortOrder
    y?: SortOrder
    z?: SortOrder
    dimension?: SortOrder
    isPublic?: SortOrder
    _count?: WayPointCountOrderByAggregateInput
    _avg?: WayPointAvgOrderByAggregateInput
    _max?: WayPointMaxOrderByAggregateInput
    _min?: WayPointMinOrderByAggregateInput
    _sum?: WayPointSumOrderByAggregateInput
  }

  export type WayPointScalarWhereWithAggregatesInput = {
    AND?: WayPointScalarWhereWithAggregatesInput | WayPointScalarWhereWithAggregatesInput[]
    OR?: WayPointScalarWhereWithAggregatesInput[]
    NOT?: WayPointScalarWhereWithAggregatesInput | WayPointScalarWhereWithAggregatesInput[]
    id?: IntWithAggregatesFilter<"WayPoint"> | number
    ownerId?: StringWithAggregatesFilter<"WayPoint"> | string
    name?: StringWithAggregatesFilter<"WayPoint"> | string
    x?: FloatWithAggregatesFilter<"WayPoint"> | number
    y?: FloatWithAggregatesFilter<"WayPoint"> | number
    z?: FloatWithAggregatesFilter<"WayPoint"> | number
    dimension?: StringWithAggregatesFilter<"WayPoint"> | string
    isPublic?: BoolWithAggregatesFilter<"WayPoint"> | boolean
  }

  export type SettingsWhereInput = {
    AND?: SettingsWhereInput | SettingsWhereInput[]
    OR?: SettingsWhereInput[]
    NOT?: SettingsWhereInput | SettingsWhereInput[]
    id?: IntFilter<"Settings"> | number
    name?: StringFilter<"Settings"> | string
    value?: StringNullableFilter<"Settings"> | string | null
    type?: EnumDataTypeFilter<"Settings"> | $Enums.DataType
    createdAt?: DateTimeFilter<"Settings"> | Date | string
    updatedAt?: DateTimeFilter<"Settings"> | Date | string
  }

  export type SettingsOrderByWithRelationInput = {
    id?: SortOrder
    name?: SortOrder
    value?: SortOrderInput | SortOrder
    type?: SortOrder
    createdAt?: SortOrder
    updatedAt?: SortOrder
  }

  export type SettingsWhereUniqueInput = Prisma.AtLeast<{
    id?: number
    AND?: SettingsWhereInput | SettingsWhereInput[]
    OR?: SettingsWhereInput[]
    NOT?: SettingsWhereInput | SettingsWhereInput[]
    name?: StringFilter<"Settings"> | string
    value?: StringNullableFilter<"Settings"> | string | null
    type?: EnumDataTypeFilter<"Settings"> | $Enums.DataType
    createdAt?: DateTimeFilter<"Settings"> | Date | string
    updatedAt?: DateTimeFilter<"Settings"> | Date | string
  }, "id">

  export type SettingsOrderByWithAggregationInput = {
    id?: SortOrder
    name?: SortOrder
    value?: SortOrderInput | SortOrder
    type?: SortOrder
    createdAt?: SortOrder
    updatedAt?: SortOrder
    _count?: SettingsCountOrderByAggregateInput
    _avg?: SettingsAvgOrderByAggregateInput
    _max?: SettingsMaxOrderByAggregateInput
    _min?: SettingsMinOrderByAggregateInput
    _sum?: SettingsSumOrderByAggregateInput
  }

  export type SettingsScalarWhereWithAggregatesInput = {
    AND?: SettingsScalarWhereWithAggregatesInput | SettingsScalarWhereWithAggregatesInput[]
    OR?: SettingsScalarWhereWithAggregatesInput[]
    NOT?: SettingsScalarWhereWithAggregatesInput | SettingsScalarWhereWithAggregatesInput[]
    id?: IntWithAggregatesFilter<"Settings"> | number
    name?: StringWithAggregatesFilter<"Settings"> | string
    value?: StringNullableWithAggregatesFilter<"Settings"> | string | null
    type?: EnumDataTypeWithAggregatesFilter<"Settings"> | $Enums.DataType
    createdAt?: DateTimeWithAggregatesFilter<"Settings"> | Date | string
    updatedAt?: DateTimeWithAggregatesFilter<"Settings"> | Date | string
  }

  export type UserCreateInput = {
    xuid: string
    name: string
    role?: $Enums.UserRole
    money?: number
    canTpa?: boolean
    password?: string | null
    createdAt?: Date | string
    updatedAt?: Date | string
    guildId?: number | null
    guildMember?: GuildMemberCreateNestedOneWithoutMemberInput
    userTransaction?: TransactionCreateNestedManyWithoutUserInput
    targetTransaction?: TransactionCreateNestedManyWithoutTargetUserInput
    waypoint?: WayPointCreateNestedManyWithoutUserInput
  }

  export type UserUncheckedCreateInput = {
    userId?: number
    xuid: string
    name: string
    role?: $Enums.UserRole
    money?: number
    canTpa?: boolean
    password?: string | null
    createdAt?: Date | string
    updatedAt?: Date | string
    guildId?: number | null
    guildMember?: GuildMemberUncheckedCreateNestedOneWithoutMemberInput
    userTransaction?: TransactionUncheckedCreateNestedManyWithoutUserInput
    targetTransaction?: TransactionUncheckedCreateNestedManyWithoutTargetUserInput
    waypoint?: WayPointUncheckedCreateNestedManyWithoutUserInput
  }

  export type UserUpdateInput = {
    xuid?: StringFieldUpdateOperationsInput | string
    name?: StringFieldUpdateOperationsInput | string
    role?: EnumUserRoleFieldUpdateOperationsInput | $Enums.UserRole
    money?: IntFieldUpdateOperationsInput | number
    canTpa?: BoolFieldUpdateOperationsInput | boolean
    password?: NullableStringFieldUpdateOperationsInput | string | null
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    updatedAt?: DateTimeFieldUpdateOperationsInput | Date | string
    guildId?: NullableIntFieldUpdateOperationsInput | number | null
    guildMember?: GuildMemberUpdateOneWithoutMemberNestedInput
    userTransaction?: TransactionUpdateManyWithoutUserNestedInput
    targetTransaction?: TransactionUpdateManyWithoutTargetUserNestedInput
    waypoint?: WayPointUpdateManyWithoutUserNestedInput
  }

  export type UserUncheckedUpdateInput = {
    userId?: IntFieldUpdateOperationsInput | number
    xuid?: StringFieldUpdateOperationsInput | string
    name?: StringFieldUpdateOperationsInput | string
    role?: EnumUserRoleFieldUpdateOperationsInput | $Enums.UserRole
    money?: IntFieldUpdateOperationsInput | number
    canTpa?: BoolFieldUpdateOperationsInput | boolean
    password?: NullableStringFieldUpdateOperationsInput | string | null
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    updatedAt?: DateTimeFieldUpdateOperationsInput | Date | string
    guildId?: NullableIntFieldUpdateOperationsInput | number | null
    guildMember?: GuildMemberUncheckedUpdateOneWithoutMemberNestedInput
    userTransaction?: TransactionUncheckedUpdateManyWithoutUserNestedInput
    targetTransaction?: TransactionUncheckedUpdateManyWithoutTargetUserNestedInput
    waypoint?: WayPointUncheckedUpdateManyWithoutUserNestedInput
  }

  export type UserCreateManyInput = {
    userId?: number
    xuid: string
    name: string
    role?: $Enums.UserRole
    money?: number
    canTpa?: boolean
    password?: string | null
    createdAt?: Date | string
    updatedAt?: Date | string
    guildId?: number | null
  }

  export type UserUpdateManyMutationInput = {
    xuid?: StringFieldUpdateOperationsInput | string
    name?: StringFieldUpdateOperationsInput | string
    role?: EnumUserRoleFieldUpdateOperationsInput | $Enums.UserRole
    money?: IntFieldUpdateOperationsInput | number
    canTpa?: BoolFieldUpdateOperationsInput | boolean
    password?: NullableStringFieldUpdateOperationsInput | string | null
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    updatedAt?: DateTimeFieldUpdateOperationsInput | Date | string
    guildId?: NullableIntFieldUpdateOperationsInput | number | null
  }

  export type UserUncheckedUpdateManyInput = {
    userId?: IntFieldUpdateOperationsInput | number
    xuid?: StringFieldUpdateOperationsInput | string
    name?: StringFieldUpdateOperationsInput | string
    role?: EnumUserRoleFieldUpdateOperationsInput | $Enums.UserRole
    money?: IntFieldUpdateOperationsInput | number
    canTpa?: BoolFieldUpdateOperationsInput | boolean
    password?: NullableStringFieldUpdateOperationsInput | string | null
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    updatedAt?: DateTimeFieldUpdateOperationsInput | Date | string
    guildId?: NullableIntFieldUpdateOperationsInput | number | null
  }

  export type WarpCreateInput = {
    name: string
    texture: string
    gamemode: string
    x: number
    y: number
    z: number
    active: boolean
  }

  export type WarpUncheckedCreateInput = {
    id?: number
    name: string
    texture: string
    gamemode: string
    x: number
    y: number
    z: number
    active: boolean
  }

  export type WarpUpdateInput = {
    name?: StringFieldUpdateOperationsInput | string
    texture?: StringFieldUpdateOperationsInput | string
    gamemode?: StringFieldUpdateOperationsInput | string
    x?: FloatFieldUpdateOperationsInput | number
    y?: FloatFieldUpdateOperationsInput | number
    z?: FloatFieldUpdateOperationsInput | number
    active?: BoolFieldUpdateOperationsInput | boolean
  }

  export type WarpUncheckedUpdateInput = {
    id?: IntFieldUpdateOperationsInput | number
    name?: StringFieldUpdateOperationsInput | string
    texture?: StringFieldUpdateOperationsInput | string
    gamemode?: StringFieldUpdateOperationsInput | string
    x?: FloatFieldUpdateOperationsInput | number
    y?: FloatFieldUpdateOperationsInput | number
    z?: FloatFieldUpdateOperationsInput | number
    active?: BoolFieldUpdateOperationsInput | boolean
  }

  export type WarpCreateManyInput = {
    id?: number
    name: string
    texture: string
    gamemode: string
    x: number
    y: number
    z: number
    active: boolean
  }

  export type WarpUpdateManyMutationInput = {
    name?: StringFieldUpdateOperationsInput | string
    texture?: StringFieldUpdateOperationsInput | string
    gamemode?: StringFieldUpdateOperationsInput | string
    x?: FloatFieldUpdateOperationsInput | number
    y?: FloatFieldUpdateOperationsInput | number
    z?: FloatFieldUpdateOperationsInput | number
    active?: BoolFieldUpdateOperationsInput | boolean
  }

  export type WarpUncheckedUpdateManyInput = {
    id?: IntFieldUpdateOperationsInput | number
    name?: StringFieldUpdateOperationsInput | string
    texture?: StringFieldUpdateOperationsInput | string
    gamemode?: StringFieldUpdateOperationsInput | string
    x?: FloatFieldUpdateOperationsInput | number
    y?: FloatFieldUpdateOperationsInput | number
    z?: FloatFieldUpdateOperationsInput | number
    active?: BoolFieldUpdateOperationsInput | boolean
  }

  export type GuildCreateInput = {
    name: string
    description?: string | null
    ownerId: string
    maxMembers?: number
    isPublic?: boolean
    createdAt?: Date | string
    updatedAt?: Date | string
    GuildMember?: GuildMemberCreateNestedManyWithoutGuildInput
  }

  export type GuildUncheckedCreateInput = {
    guildId?: number
    name: string
    description?: string | null
    ownerId: string
    maxMembers?: number
    isPublic?: boolean
    createdAt?: Date | string
    updatedAt?: Date | string
    GuildMember?: GuildMemberUncheckedCreateNestedManyWithoutGuildInput
  }

  export type GuildUpdateInput = {
    name?: StringFieldUpdateOperationsInput | string
    description?: NullableStringFieldUpdateOperationsInput | string | null
    ownerId?: StringFieldUpdateOperationsInput | string
    maxMembers?: IntFieldUpdateOperationsInput | number
    isPublic?: BoolFieldUpdateOperationsInput | boolean
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    updatedAt?: DateTimeFieldUpdateOperationsInput | Date | string
    GuildMember?: GuildMemberUpdateManyWithoutGuildNestedInput
  }

  export type GuildUncheckedUpdateInput = {
    guildId?: IntFieldUpdateOperationsInput | number
    name?: StringFieldUpdateOperationsInput | string
    description?: NullableStringFieldUpdateOperationsInput | string | null
    ownerId?: StringFieldUpdateOperationsInput | string
    maxMembers?: IntFieldUpdateOperationsInput | number
    isPublic?: BoolFieldUpdateOperationsInput | boolean
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    updatedAt?: DateTimeFieldUpdateOperationsInput | Date | string
    GuildMember?: GuildMemberUncheckedUpdateManyWithoutGuildNestedInput
  }

  export type GuildCreateManyInput = {
    guildId?: number
    name: string
    description?: string | null
    ownerId: string
    maxMembers?: number
    isPublic?: boolean
    createdAt?: Date | string
    updatedAt?: Date | string
  }

  export type GuildUpdateManyMutationInput = {
    name?: StringFieldUpdateOperationsInput | string
    description?: NullableStringFieldUpdateOperationsInput | string | null
    ownerId?: StringFieldUpdateOperationsInput | string
    maxMembers?: IntFieldUpdateOperationsInput | number
    isPublic?: BoolFieldUpdateOperationsInput | boolean
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    updatedAt?: DateTimeFieldUpdateOperationsInput | Date | string
  }

  export type GuildUncheckedUpdateManyInput = {
    guildId?: IntFieldUpdateOperationsInput | number
    name?: StringFieldUpdateOperationsInput | string
    description?: NullableStringFieldUpdateOperationsInput | string | null
    ownerId?: StringFieldUpdateOperationsInput | string
    maxMembers?: IntFieldUpdateOperationsInput | number
    isPublic?: BoolFieldUpdateOperationsInput | boolean
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    updatedAt?: DateTimeFieldUpdateOperationsInput | Date | string
  }

  export type GuildMemberCreateInput = {
    memberRole?: $Enums.GuildRole
    guild: GuildCreateNestedOneWithoutGuildMemberInput
    member: UserCreateNestedOneWithoutGuildMemberInput
  }

  export type GuildMemberUncheckedCreateInput = {
    id?: number
    guildId: number
    memberId: string
    memberRole?: $Enums.GuildRole
  }

  export type GuildMemberUpdateInput = {
    memberRole?: EnumGuildRoleFieldUpdateOperationsInput | $Enums.GuildRole
    guild?: GuildUpdateOneRequiredWithoutGuildMemberNestedInput
    member?: UserUpdateOneRequiredWithoutGuildMemberNestedInput
  }

  export type GuildMemberUncheckedUpdateInput = {
    id?: IntFieldUpdateOperationsInput | number
    guildId?: IntFieldUpdateOperationsInput | number
    memberId?: StringFieldUpdateOperationsInput | string
    memberRole?: EnumGuildRoleFieldUpdateOperationsInput | $Enums.GuildRole
  }

  export type GuildMemberCreateManyInput = {
    id?: number
    guildId: number
    memberId: string
    memberRole?: $Enums.GuildRole
  }

  export type GuildMemberUpdateManyMutationInput = {
    memberRole?: EnumGuildRoleFieldUpdateOperationsInput | $Enums.GuildRole
  }

  export type GuildMemberUncheckedUpdateManyInput = {
    id?: IntFieldUpdateOperationsInput | number
    guildId?: IntFieldUpdateOperationsInput | number
    memberId?: StringFieldUpdateOperationsInput | string
    memberRole?: EnumGuildRoleFieldUpdateOperationsInput | $Enums.GuildRole
  }

  export type ShopCategoryCreateInput = {
    no: number
    name: string
    texture: string
    type?: $Enums.ItemType
    active?: boolean
    ShopItem?: ShopItemCreateNestedManyWithoutCategoryInput
  }

  export type ShopCategoryUncheckedCreateInput = {
    categoryID?: number
    no: number
    name: string
    texture: string
    type?: $Enums.ItemType
    active?: boolean
    ShopItem?: ShopItemUncheckedCreateNestedManyWithoutCategoryInput
  }

  export type ShopCategoryUpdateInput = {
    no?: IntFieldUpdateOperationsInput | number
    name?: StringFieldUpdateOperationsInput | string
    texture?: StringFieldUpdateOperationsInput | string
    type?: EnumItemTypeFieldUpdateOperationsInput | $Enums.ItemType
    active?: BoolFieldUpdateOperationsInput | boolean
    ShopItem?: ShopItemUpdateManyWithoutCategoryNestedInput
  }

  export type ShopCategoryUncheckedUpdateInput = {
    categoryID?: IntFieldUpdateOperationsInput | number
    no?: IntFieldUpdateOperationsInput | number
    name?: StringFieldUpdateOperationsInput | string
    texture?: StringFieldUpdateOperationsInput | string
    type?: EnumItemTypeFieldUpdateOperationsInput | $Enums.ItemType
    active?: BoolFieldUpdateOperationsInput | boolean
    ShopItem?: ShopItemUncheckedUpdateManyWithoutCategoryNestedInput
  }

  export type ShopCategoryCreateManyInput = {
    categoryID?: number
    no: number
    name: string
    texture: string
    type?: $Enums.ItemType
    active?: boolean
  }

  export type ShopCategoryUpdateManyMutationInput = {
    no?: IntFieldUpdateOperationsInput | number
    name?: StringFieldUpdateOperationsInput | string
    texture?: StringFieldUpdateOperationsInput | string
    type?: EnumItemTypeFieldUpdateOperationsInput | $Enums.ItemType
    active?: BoolFieldUpdateOperationsInput | boolean
  }

  export type ShopCategoryUncheckedUpdateManyInput = {
    categoryID?: IntFieldUpdateOperationsInput | number
    no?: IntFieldUpdateOperationsInput | number
    name?: StringFieldUpdateOperationsInput | string
    texture?: StringFieldUpdateOperationsInput | string
    type?: EnumItemTypeFieldUpdateOperationsInput | $Enums.ItemType
    active?: BoolFieldUpdateOperationsInput | boolean
  }

  export type ShopItemCreateInput = {
    texture: string
    name: string
    cost: number
    sell?: number | null
    data?: number
    item: string
    maxLevel?: number | null
    enchant?: string | null
    enchantType?: $Enums.EnchantType | null
    available?: boolean
    createdAt?: Date | string
    updatedAt?: Date | string
    category: ShopCategoryCreateNestedOneWithoutShopItemInput
    TransactionDetail?: TransactionDetailCreateNestedManyWithoutShopItemInput
  }

  export type ShopItemUncheckedCreateInput = {
    itemId?: number
    categoryId: number
    texture: string
    name: string
    cost: number
    sell?: number | null
    data?: number
    item: string
    maxLevel?: number | null
    enchant?: string | null
    enchantType?: $Enums.EnchantType | null
    available?: boolean
    createdAt?: Date | string
    updatedAt?: Date | string
    TransactionDetail?: TransactionDetailUncheckedCreateNestedManyWithoutShopItemInput
  }

  export type ShopItemUpdateInput = {
    texture?: StringFieldUpdateOperationsInput | string
    name?: StringFieldUpdateOperationsInput | string
    cost?: IntFieldUpdateOperationsInput | number
    sell?: NullableIntFieldUpdateOperationsInput | number | null
    data?: IntFieldUpdateOperationsInput | number
    item?: StringFieldUpdateOperationsInput | string
    maxLevel?: NullableIntFieldUpdateOperationsInput | number | null
    enchant?: NullableStringFieldUpdateOperationsInput | string | null
    enchantType?: NullableEnumEnchantTypeFieldUpdateOperationsInput | $Enums.EnchantType | null
    available?: BoolFieldUpdateOperationsInput | boolean
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    updatedAt?: DateTimeFieldUpdateOperationsInput | Date | string
    category?: ShopCategoryUpdateOneRequiredWithoutShopItemNestedInput
    TransactionDetail?: TransactionDetailUpdateManyWithoutShopItemNestedInput
  }

  export type ShopItemUncheckedUpdateInput = {
    itemId?: IntFieldUpdateOperationsInput | number
    categoryId?: IntFieldUpdateOperationsInput | number
    texture?: StringFieldUpdateOperationsInput | string
    name?: StringFieldUpdateOperationsInput | string
    cost?: IntFieldUpdateOperationsInput | number
    sell?: NullableIntFieldUpdateOperationsInput | number | null
    data?: IntFieldUpdateOperationsInput | number
    item?: StringFieldUpdateOperationsInput | string
    maxLevel?: NullableIntFieldUpdateOperationsInput | number | null
    enchant?: NullableStringFieldUpdateOperationsInput | string | null
    enchantType?: NullableEnumEnchantTypeFieldUpdateOperationsInput | $Enums.EnchantType | null
    available?: BoolFieldUpdateOperationsInput | boolean
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    updatedAt?: DateTimeFieldUpdateOperationsInput | Date | string
    TransactionDetail?: TransactionDetailUncheckedUpdateManyWithoutShopItemNestedInput
  }

  export type ShopItemCreateManyInput = {
    itemId?: number
    categoryId: number
    texture: string
    name: string
    cost: number
    sell?: number | null
    data?: number
    item: string
    maxLevel?: number | null
    enchant?: string | null
    enchantType?: $Enums.EnchantType | null
    available?: boolean
    createdAt?: Date | string
    updatedAt?: Date | string
  }

  export type ShopItemUpdateManyMutationInput = {
    texture?: StringFieldUpdateOperationsInput | string
    name?: StringFieldUpdateOperationsInput | string
    cost?: IntFieldUpdateOperationsInput | number
    sell?: NullableIntFieldUpdateOperationsInput | number | null
    data?: IntFieldUpdateOperationsInput | number
    item?: StringFieldUpdateOperationsInput | string
    maxLevel?: NullableIntFieldUpdateOperationsInput | number | null
    enchant?: NullableStringFieldUpdateOperationsInput | string | null
    enchantType?: NullableEnumEnchantTypeFieldUpdateOperationsInput | $Enums.EnchantType | null
    available?: BoolFieldUpdateOperationsInput | boolean
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    updatedAt?: DateTimeFieldUpdateOperationsInput | Date | string
  }

  export type ShopItemUncheckedUpdateManyInput = {
    itemId?: IntFieldUpdateOperationsInput | number
    categoryId?: IntFieldUpdateOperationsInput | number
    texture?: StringFieldUpdateOperationsInput | string
    name?: StringFieldUpdateOperationsInput | string
    cost?: IntFieldUpdateOperationsInput | number
    sell?: NullableIntFieldUpdateOperationsInput | number | null
    data?: IntFieldUpdateOperationsInput | number
    item?: StringFieldUpdateOperationsInput | string
    maxLevel?: NullableIntFieldUpdateOperationsInput | number | null
    enchant?: NullableStringFieldUpdateOperationsInput | string | null
    enchantType?: NullableEnumEnchantTypeFieldUpdateOperationsInput | $Enums.EnchantType | null
    available?: BoolFieldUpdateOperationsInput | boolean
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    updatedAt?: DateTimeFieldUpdateOperationsInput | Date | string
  }

  export type TransactionCreateInput = {
    createdAt?: Date | string
    trxType?: $Enums.TrxType
    user?: UserCreateNestedOneWithoutUserTransactionInput
    targetUser?: UserCreateNestedOneWithoutTargetTransactionInput
    TransactionDetail?: TransactionDetailCreateNestedOneWithoutTransactionInput
  }

  export type TransactionUncheckedCreateInput = {
    transactionId?: number
    userId: string
    targetUserId?: string | null
    createdAt?: Date | string
    trxType?: $Enums.TrxType
    TransactionDetail?: TransactionDetailUncheckedCreateNestedOneWithoutTransactionInput
  }

  export type TransactionUpdateInput = {
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    trxType?: EnumTrxTypeFieldUpdateOperationsInput | $Enums.TrxType
    user?: UserUpdateOneWithoutUserTransactionNestedInput
    targetUser?: UserUpdateOneWithoutTargetTransactionNestedInput
    TransactionDetail?: TransactionDetailUpdateOneWithoutTransactionNestedInput
  }

  export type TransactionUncheckedUpdateInput = {
    transactionId?: IntFieldUpdateOperationsInput | number
    userId?: StringFieldUpdateOperationsInput | string
    targetUserId?: NullableStringFieldUpdateOperationsInput | string | null
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    trxType?: EnumTrxTypeFieldUpdateOperationsInput | $Enums.TrxType
    TransactionDetail?: TransactionDetailUncheckedUpdateOneWithoutTransactionNestedInput
  }

  export type TransactionCreateManyInput = {
    transactionId?: number
    userId: string
    targetUserId?: string | null
    createdAt?: Date | string
    trxType?: $Enums.TrxType
  }

  export type TransactionUpdateManyMutationInput = {
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    trxType?: EnumTrxTypeFieldUpdateOperationsInput | $Enums.TrxType
  }

  export type TransactionUncheckedUpdateManyInput = {
    transactionId?: IntFieldUpdateOperationsInput | number
    userId?: StringFieldUpdateOperationsInput | string
    targetUserId?: NullableStringFieldUpdateOperationsInput | string | null
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    trxType?: EnumTrxTypeFieldUpdateOperationsInput | $Enums.TrxType
  }

  export type TransactionDetailCreateInput = {
    qty: number
    totalPrice: number
    shopItem?: ShopItemCreateNestedOneWithoutTransactionDetailInput
    transaction: TransactionCreateNestedOneWithoutTransactionDetailInput
  }

  export type TransactionDetailUncheckedCreateInput = {
    id?: number
    transactionId: number
    itemId?: number | null
    qty: number
    totalPrice: number
  }

  export type TransactionDetailUpdateInput = {
    qty?: IntFieldUpdateOperationsInput | number
    totalPrice?: IntFieldUpdateOperationsInput | number
    shopItem?: ShopItemUpdateOneWithoutTransactionDetailNestedInput
    transaction?: TransactionUpdateOneRequiredWithoutTransactionDetailNestedInput
  }

  export type TransactionDetailUncheckedUpdateInput = {
    id?: IntFieldUpdateOperationsInput | number
    transactionId?: IntFieldUpdateOperationsInput | number
    itemId?: NullableIntFieldUpdateOperationsInput | number | null
    qty?: IntFieldUpdateOperationsInput | number
    totalPrice?: IntFieldUpdateOperationsInput | number
  }

  export type TransactionDetailCreateManyInput = {
    id?: number
    transactionId: number
    itemId?: number | null
    qty: number
    totalPrice: number
  }

  export type TransactionDetailUpdateManyMutationInput = {
    qty?: IntFieldUpdateOperationsInput | number
    totalPrice?: IntFieldUpdateOperationsInput | number
  }

  export type TransactionDetailUncheckedUpdateManyInput = {
    id?: IntFieldUpdateOperationsInput | number
    transactionId?: IntFieldUpdateOperationsInput | number
    itemId?: NullableIntFieldUpdateOperationsInput | number | null
    qty?: IntFieldUpdateOperationsInput | number
    totalPrice?: IntFieldUpdateOperationsInput | number
  }

  export type TpaRequestCreateInput = {
    fromName: string
    targetName: string
    createdAt?: Date | string
  }

  export type TpaRequestUncheckedCreateInput = {
    id?: number
    fromName: string
    targetName: string
    createdAt?: Date | string
  }

  export type TpaRequestUpdateInput = {
    fromName?: StringFieldUpdateOperationsInput | string
    targetName?: StringFieldUpdateOperationsInput | string
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
  }

  export type TpaRequestUncheckedUpdateInput = {
    id?: IntFieldUpdateOperationsInput | number
    fromName?: StringFieldUpdateOperationsInput | string
    targetName?: StringFieldUpdateOperationsInput | string
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
  }

  export type TpaRequestCreateManyInput = {
    id?: number
    fromName: string
    targetName: string
    createdAt?: Date | string
  }

  export type TpaRequestUpdateManyMutationInput = {
    fromName?: StringFieldUpdateOperationsInput | string
    targetName?: StringFieldUpdateOperationsInput | string
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
  }

  export type TpaRequestUncheckedUpdateManyInput = {
    id?: IntFieldUpdateOperationsInput | number
    fromName?: StringFieldUpdateOperationsInput | string
    targetName?: StringFieldUpdateOperationsInput | string
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
  }

  export type WayPointCreateInput = {
    name: string
    x: number
    y: number
    z: number
    dimension: string
    isPublic?: boolean
    User?: UserCreateNestedOneWithoutWaypointInput
  }

  export type WayPointUncheckedCreateInput = {
    id?: number
    ownerId: string
    name: string
    x: number
    y: number
    z: number
    dimension: string
    isPublic?: boolean
  }

  export type WayPointUpdateInput = {
    name?: StringFieldUpdateOperationsInput | string
    x?: FloatFieldUpdateOperationsInput | number
    y?: FloatFieldUpdateOperationsInput | number
    z?: FloatFieldUpdateOperationsInput | number
    dimension?: StringFieldUpdateOperationsInput | string
    isPublic?: BoolFieldUpdateOperationsInput | boolean
    User?: UserUpdateOneWithoutWaypointNestedInput
  }

  export type WayPointUncheckedUpdateInput = {
    id?: IntFieldUpdateOperationsInput | number
    ownerId?: StringFieldUpdateOperationsInput | string
    name?: StringFieldUpdateOperationsInput | string
    x?: FloatFieldUpdateOperationsInput | number
    y?: FloatFieldUpdateOperationsInput | number
    z?: FloatFieldUpdateOperationsInput | number
    dimension?: StringFieldUpdateOperationsInput | string
    isPublic?: BoolFieldUpdateOperationsInput | boolean
  }

  export type WayPointCreateManyInput = {
    id?: number
    ownerId: string
    name: string
    x: number
    y: number
    z: number
    dimension: string
    isPublic?: boolean
  }

  export type WayPointUpdateManyMutationInput = {
    name?: StringFieldUpdateOperationsInput | string
    x?: FloatFieldUpdateOperationsInput | number
    y?: FloatFieldUpdateOperationsInput | number
    z?: FloatFieldUpdateOperationsInput | number
    dimension?: StringFieldUpdateOperationsInput | string
    isPublic?: BoolFieldUpdateOperationsInput | boolean
  }

  export type WayPointUncheckedUpdateManyInput = {
    id?: IntFieldUpdateOperationsInput | number
    ownerId?: StringFieldUpdateOperationsInput | string
    name?: StringFieldUpdateOperationsInput | string
    x?: FloatFieldUpdateOperationsInput | number
    y?: FloatFieldUpdateOperationsInput | number
    z?: FloatFieldUpdateOperationsInput | number
    dimension?: StringFieldUpdateOperationsInput | string
    isPublic?: BoolFieldUpdateOperationsInput | boolean
  }

  export type SettingsCreateInput = {
    name: string
    value?: string | null
    type?: $Enums.DataType
    createdAt?: Date | string
    updatedAt?: Date | string
  }

  export type SettingsUncheckedCreateInput = {
    id?: number
    name: string
    value?: string | null
    type?: $Enums.DataType
    createdAt?: Date | string
    updatedAt?: Date | string
  }

  export type SettingsUpdateInput = {
    name?: StringFieldUpdateOperationsInput | string
    value?: NullableStringFieldUpdateOperationsInput | string | null
    type?: EnumDataTypeFieldUpdateOperationsInput | $Enums.DataType
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    updatedAt?: DateTimeFieldUpdateOperationsInput | Date | string
  }

  export type SettingsUncheckedUpdateInput = {
    id?: IntFieldUpdateOperationsInput | number
    name?: StringFieldUpdateOperationsInput | string
    value?: NullableStringFieldUpdateOperationsInput | string | null
    type?: EnumDataTypeFieldUpdateOperationsInput | $Enums.DataType
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    updatedAt?: DateTimeFieldUpdateOperationsInput | Date | string
  }

  export type SettingsCreateManyInput = {
    id?: number
    name: string
    value?: string | null
    type?: $Enums.DataType
    createdAt?: Date | string
    updatedAt?: Date | string
  }

  export type SettingsUpdateManyMutationInput = {
    name?: StringFieldUpdateOperationsInput | string
    value?: NullableStringFieldUpdateOperationsInput | string | null
    type?: EnumDataTypeFieldUpdateOperationsInput | $Enums.DataType
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    updatedAt?: DateTimeFieldUpdateOperationsInput | Date | string
  }

  export type SettingsUncheckedUpdateManyInput = {
    id?: IntFieldUpdateOperationsInput | number
    name?: StringFieldUpdateOperationsInput | string
    value?: NullableStringFieldUpdateOperationsInput | string | null
    type?: EnumDataTypeFieldUpdateOperationsInput | $Enums.DataType
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    updatedAt?: DateTimeFieldUpdateOperationsInput | Date | string
  }

  export type IntFilter<$PrismaModel = never> = {
    equals?: number | IntFieldRefInput<$PrismaModel>
    in?: number[]
    notIn?: number[]
    lt?: number | IntFieldRefInput<$PrismaModel>
    lte?: number | IntFieldRefInput<$PrismaModel>
    gt?: number | IntFieldRefInput<$PrismaModel>
    gte?: number | IntFieldRefInput<$PrismaModel>
    not?: NestedIntFilter<$PrismaModel> | number
  }

  export type StringFilter<$PrismaModel = never> = {
    equals?: string | StringFieldRefInput<$PrismaModel>
    in?: string[]
    notIn?: string[]
    lt?: string | StringFieldRefInput<$PrismaModel>
    lte?: string | StringFieldRefInput<$PrismaModel>
    gt?: string | StringFieldRefInput<$PrismaModel>
    gte?: string | StringFieldRefInput<$PrismaModel>
    contains?: string | StringFieldRefInput<$PrismaModel>
    startsWith?: string | StringFieldRefInput<$PrismaModel>
    endsWith?: string | StringFieldRefInput<$PrismaModel>
    not?: NestedStringFilter<$PrismaModel> | string
  }

  export type EnumUserRoleFilter<$PrismaModel = never> = {
    equals?: $Enums.UserRole | EnumUserRoleFieldRefInput<$PrismaModel>
    in?: $Enums.UserRole[]
    notIn?: $Enums.UserRole[]
    not?: NestedEnumUserRoleFilter<$PrismaModel> | $Enums.UserRole
  }

  export type BoolFilter<$PrismaModel = never> = {
    equals?: boolean | BooleanFieldRefInput<$PrismaModel>
    not?: NestedBoolFilter<$PrismaModel> | boolean
  }

  export type StringNullableFilter<$PrismaModel = never> = {
    equals?: string | StringFieldRefInput<$PrismaModel> | null
    in?: string[] | null
    notIn?: string[] | null
    lt?: string | StringFieldRefInput<$PrismaModel>
    lte?: string | StringFieldRefInput<$PrismaModel>
    gt?: string | StringFieldRefInput<$PrismaModel>
    gte?: string | StringFieldRefInput<$PrismaModel>
    contains?: string | StringFieldRefInput<$PrismaModel>
    startsWith?: string | StringFieldRefInput<$PrismaModel>
    endsWith?: string | StringFieldRefInput<$PrismaModel>
    not?: NestedStringNullableFilter<$PrismaModel> | string | null
  }

  export type DateTimeFilter<$PrismaModel = never> = {
    equals?: Date | string | DateTimeFieldRefInput<$PrismaModel>
    in?: Date[] | string[]
    notIn?: Date[] | string[]
    lt?: Date | string | DateTimeFieldRefInput<$PrismaModel>
    lte?: Date | string | DateTimeFieldRefInput<$PrismaModel>
    gt?: Date | string | DateTimeFieldRefInput<$PrismaModel>
    gte?: Date | string | DateTimeFieldRefInput<$PrismaModel>
    not?: NestedDateTimeFilter<$PrismaModel> | Date | string
  }

  export type IntNullableFilter<$PrismaModel = never> = {
    equals?: number | IntFieldRefInput<$PrismaModel> | null
    in?: number[] | null
    notIn?: number[] | null
    lt?: number | IntFieldRefInput<$PrismaModel>
    lte?: number | IntFieldRefInput<$PrismaModel>
    gt?: number | IntFieldRefInput<$PrismaModel>
    gte?: number | IntFieldRefInput<$PrismaModel>
    not?: NestedIntNullableFilter<$PrismaModel> | number | null
  }

  export type GuildMemberNullableRelationFilter = {
    is?: GuildMemberWhereInput | null
    isNot?: GuildMemberWhereInput | null
  }

  export type TransactionListRelationFilter = {
    every?: TransactionWhereInput
    some?: TransactionWhereInput
    none?: TransactionWhereInput
  }

  export type WayPointListRelationFilter = {
    every?: WayPointWhereInput
    some?: WayPointWhereInput
    none?: WayPointWhereInput
  }

  export type SortOrderInput = {
    sort: SortOrder
    nulls?: NullsOrder
  }

  export type TransactionOrderByRelationAggregateInput = {
    _count?: SortOrder
  }

  export type WayPointOrderByRelationAggregateInput = {
    _count?: SortOrder
  }

  export type UserCountOrderByAggregateInput = {
    userId?: SortOrder
    xuid?: SortOrder
    name?: SortOrder
    role?: SortOrder
    money?: SortOrder
    canTpa?: SortOrder
    password?: SortOrder
    createdAt?: SortOrder
    updatedAt?: SortOrder
    guildId?: SortOrder
  }

  export type UserAvgOrderByAggregateInput = {
    userId?: SortOrder
    money?: SortOrder
    guildId?: SortOrder
  }

  export type UserMaxOrderByAggregateInput = {
    userId?: SortOrder
    xuid?: SortOrder
    name?: SortOrder
    role?: SortOrder
    money?: SortOrder
    canTpa?: SortOrder
    password?: SortOrder
    createdAt?: SortOrder
    updatedAt?: SortOrder
    guildId?: SortOrder
  }

  export type UserMinOrderByAggregateInput = {
    userId?: SortOrder
    xuid?: SortOrder
    name?: SortOrder
    role?: SortOrder
    money?: SortOrder
    canTpa?: SortOrder
    password?: SortOrder
    createdAt?: SortOrder
    updatedAt?: SortOrder
    guildId?: SortOrder
  }

  export type UserSumOrderByAggregateInput = {
    userId?: SortOrder
    money?: SortOrder
    guildId?: SortOrder
  }

  export type IntWithAggregatesFilter<$PrismaModel = never> = {
    equals?: number | IntFieldRefInput<$PrismaModel>
    in?: number[]
    notIn?: number[]
    lt?: number | IntFieldRefInput<$PrismaModel>
    lte?: number | IntFieldRefInput<$PrismaModel>
    gt?: number | IntFieldRefInput<$PrismaModel>
    gte?: number | IntFieldRefInput<$PrismaModel>
    not?: NestedIntWithAggregatesFilter<$PrismaModel> | number
    _count?: NestedIntFilter<$PrismaModel>
    _avg?: NestedFloatFilter<$PrismaModel>
    _sum?: NestedIntFilter<$PrismaModel>
    _min?: NestedIntFilter<$PrismaModel>
    _max?: NestedIntFilter<$PrismaModel>
  }

  export type StringWithAggregatesFilter<$PrismaModel = never> = {
    equals?: string | StringFieldRefInput<$PrismaModel>
    in?: string[]
    notIn?: string[]
    lt?: string | StringFieldRefInput<$PrismaModel>
    lte?: string | StringFieldRefInput<$PrismaModel>
    gt?: string | StringFieldRefInput<$PrismaModel>
    gte?: string | StringFieldRefInput<$PrismaModel>
    contains?: string | StringFieldRefInput<$PrismaModel>
    startsWith?: string | StringFieldRefInput<$PrismaModel>
    endsWith?: string | StringFieldRefInput<$PrismaModel>
    not?: NestedStringWithAggregatesFilter<$PrismaModel> | string
    _count?: NestedIntFilter<$PrismaModel>
    _min?: NestedStringFilter<$PrismaModel>
    _max?: NestedStringFilter<$PrismaModel>
  }

  export type EnumUserRoleWithAggregatesFilter<$PrismaModel = never> = {
    equals?: $Enums.UserRole | EnumUserRoleFieldRefInput<$PrismaModel>
    in?: $Enums.UserRole[]
    notIn?: $Enums.UserRole[]
    not?: NestedEnumUserRoleWithAggregatesFilter<$PrismaModel> | $Enums.UserRole
    _count?: NestedIntFilter<$PrismaModel>
    _min?: NestedEnumUserRoleFilter<$PrismaModel>
    _max?: NestedEnumUserRoleFilter<$PrismaModel>
  }

  export type BoolWithAggregatesFilter<$PrismaModel = never> = {
    equals?: boolean | BooleanFieldRefInput<$PrismaModel>
    not?: NestedBoolWithAggregatesFilter<$PrismaModel> | boolean
    _count?: NestedIntFilter<$PrismaModel>
    _min?: NestedBoolFilter<$PrismaModel>
    _max?: NestedBoolFilter<$PrismaModel>
  }

  export type StringNullableWithAggregatesFilter<$PrismaModel = never> = {
    equals?: string | StringFieldRefInput<$PrismaModel> | null
    in?: string[] | null
    notIn?: string[] | null
    lt?: string | StringFieldRefInput<$PrismaModel>
    lte?: string | StringFieldRefInput<$PrismaModel>
    gt?: string | StringFieldRefInput<$PrismaModel>
    gte?: string | StringFieldRefInput<$PrismaModel>
    contains?: string | StringFieldRefInput<$PrismaModel>
    startsWith?: string | StringFieldRefInput<$PrismaModel>
    endsWith?: string | StringFieldRefInput<$PrismaModel>
    not?: NestedStringNullableWithAggregatesFilter<$PrismaModel> | string | null
    _count?: NestedIntNullableFilter<$PrismaModel>
    _min?: NestedStringNullableFilter<$PrismaModel>
    _max?: NestedStringNullableFilter<$PrismaModel>
  }

  export type DateTimeWithAggregatesFilter<$PrismaModel = never> = {
    equals?: Date | string | DateTimeFieldRefInput<$PrismaModel>
    in?: Date[] | string[]
    notIn?: Date[] | string[]
    lt?: Date | string | DateTimeFieldRefInput<$PrismaModel>
    lte?: Date | string | DateTimeFieldRefInput<$PrismaModel>
    gt?: Date | string | DateTimeFieldRefInput<$PrismaModel>
    gte?: Date | string | DateTimeFieldRefInput<$PrismaModel>
    not?: NestedDateTimeWithAggregatesFilter<$PrismaModel> | Date | string
    _count?: NestedIntFilter<$PrismaModel>
    _min?: NestedDateTimeFilter<$PrismaModel>
    _max?: NestedDateTimeFilter<$PrismaModel>
  }

  export type IntNullableWithAggregatesFilter<$PrismaModel = never> = {
    equals?: number | IntFieldRefInput<$PrismaModel> | null
    in?: number[] | null
    notIn?: number[] | null
    lt?: number | IntFieldRefInput<$PrismaModel>
    lte?: number | IntFieldRefInput<$PrismaModel>
    gt?: number | IntFieldRefInput<$PrismaModel>
    gte?: number | IntFieldRefInput<$PrismaModel>
    not?: NestedIntNullableWithAggregatesFilter<$PrismaModel> | number | null
    _count?: NestedIntNullableFilter<$PrismaModel>
    _avg?: NestedFloatNullableFilter<$PrismaModel>
    _sum?: NestedIntNullableFilter<$PrismaModel>
    _min?: NestedIntNullableFilter<$PrismaModel>
    _max?: NestedIntNullableFilter<$PrismaModel>
  }

  export type FloatFilter<$PrismaModel = never> = {
    equals?: number | FloatFieldRefInput<$PrismaModel>
    in?: number[]
    notIn?: number[]
    lt?: number | FloatFieldRefInput<$PrismaModel>
    lte?: number | FloatFieldRefInput<$PrismaModel>
    gt?: number | FloatFieldRefInput<$PrismaModel>
    gte?: number | FloatFieldRefInput<$PrismaModel>
    not?: NestedFloatFilter<$PrismaModel> | number
  }

  export type WarpCountOrderByAggregateInput = {
    id?: SortOrder
    name?: SortOrder
    texture?: SortOrder
    gamemode?: SortOrder
    x?: SortOrder
    y?: SortOrder
    z?: SortOrder
    active?: SortOrder
  }

  export type WarpAvgOrderByAggregateInput = {
    id?: SortOrder
    x?: SortOrder
    y?: SortOrder
    z?: SortOrder
  }

  export type WarpMaxOrderByAggregateInput = {
    id?: SortOrder
    name?: SortOrder
    texture?: SortOrder
    gamemode?: SortOrder
    x?: SortOrder
    y?: SortOrder
    z?: SortOrder
    active?: SortOrder
  }

  export type WarpMinOrderByAggregateInput = {
    id?: SortOrder
    name?: SortOrder
    texture?: SortOrder
    gamemode?: SortOrder
    x?: SortOrder
    y?: SortOrder
    z?: SortOrder
    active?: SortOrder
  }

  export type WarpSumOrderByAggregateInput = {
    id?: SortOrder
    x?: SortOrder
    y?: SortOrder
    z?: SortOrder
  }

  export type FloatWithAggregatesFilter<$PrismaModel = never> = {
    equals?: number | FloatFieldRefInput<$PrismaModel>
    in?: number[]
    notIn?: number[]
    lt?: number | FloatFieldRefInput<$PrismaModel>
    lte?: number | FloatFieldRefInput<$PrismaModel>
    gt?: number | FloatFieldRefInput<$PrismaModel>
    gte?: number | FloatFieldRefInput<$PrismaModel>
    not?: NestedFloatWithAggregatesFilter<$PrismaModel> | number
    _count?: NestedIntFilter<$PrismaModel>
    _avg?: NestedFloatFilter<$PrismaModel>
    _sum?: NestedFloatFilter<$PrismaModel>
    _min?: NestedFloatFilter<$PrismaModel>
    _max?: NestedFloatFilter<$PrismaModel>
  }

  export type GuildMemberListRelationFilter = {
    every?: GuildMemberWhereInput
    some?: GuildMemberWhereInput
    none?: GuildMemberWhereInput
  }

  export type GuildMemberOrderByRelationAggregateInput = {
    _count?: SortOrder
  }

  export type GuildCountOrderByAggregateInput = {
    guildId?: SortOrder
    name?: SortOrder
    description?: SortOrder
    ownerId?: SortOrder
    maxMembers?: SortOrder
    isPublic?: SortOrder
    createdAt?: SortOrder
    updatedAt?: SortOrder
  }

  export type GuildAvgOrderByAggregateInput = {
    guildId?: SortOrder
    maxMembers?: SortOrder
  }

  export type GuildMaxOrderByAggregateInput = {
    guildId?: SortOrder
    name?: SortOrder
    description?: SortOrder
    ownerId?: SortOrder
    maxMembers?: SortOrder
    isPublic?: SortOrder
    createdAt?: SortOrder
    updatedAt?: SortOrder
  }

  export type GuildMinOrderByAggregateInput = {
    guildId?: SortOrder
    name?: SortOrder
    description?: SortOrder
    ownerId?: SortOrder
    maxMembers?: SortOrder
    isPublic?: SortOrder
    createdAt?: SortOrder
    updatedAt?: SortOrder
  }

  export type GuildSumOrderByAggregateInput = {
    guildId?: SortOrder
    maxMembers?: SortOrder
  }

  export type EnumGuildRoleFilter<$PrismaModel = never> = {
    equals?: $Enums.GuildRole | EnumGuildRoleFieldRefInput<$PrismaModel>
    in?: $Enums.GuildRole[]
    notIn?: $Enums.GuildRole[]
    not?: NestedEnumGuildRoleFilter<$PrismaModel> | $Enums.GuildRole
  }

  export type GuildRelationFilter = {
    is?: GuildWhereInput
    isNot?: GuildWhereInput
  }

  export type UserRelationFilter = {
    is?: UserWhereInput
    isNot?: UserWhereInput
  }

  export type GuildMemberCountOrderByAggregateInput = {
    id?: SortOrder
    guildId?: SortOrder
    memberId?: SortOrder
    memberRole?: SortOrder
  }

  export type GuildMemberAvgOrderByAggregateInput = {
    id?: SortOrder
    guildId?: SortOrder
  }

  export type GuildMemberMaxOrderByAggregateInput = {
    id?: SortOrder
    guildId?: SortOrder
    memberId?: SortOrder
    memberRole?: SortOrder
  }

  export type GuildMemberMinOrderByAggregateInput = {
    id?: SortOrder
    guildId?: SortOrder
    memberId?: SortOrder
    memberRole?: SortOrder
  }

  export type GuildMemberSumOrderByAggregateInput = {
    id?: SortOrder
    guildId?: SortOrder
  }

  export type EnumGuildRoleWithAggregatesFilter<$PrismaModel = never> = {
    equals?: $Enums.GuildRole | EnumGuildRoleFieldRefInput<$PrismaModel>
    in?: $Enums.GuildRole[]
    notIn?: $Enums.GuildRole[]
    not?: NestedEnumGuildRoleWithAggregatesFilter<$PrismaModel> | $Enums.GuildRole
    _count?: NestedIntFilter<$PrismaModel>
    _min?: NestedEnumGuildRoleFilter<$PrismaModel>
    _max?: NestedEnumGuildRoleFilter<$PrismaModel>
  }

  export type EnumItemTypeFilter<$PrismaModel = never> = {
    equals?: $Enums.ItemType | EnumItemTypeFieldRefInput<$PrismaModel>
    in?: $Enums.ItemType[]
    notIn?: $Enums.ItemType[]
    not?: NestedEnumItemTypeFilter<$PrismaModel> | $Enums.ItemType
  }

  export type ShopItemListRelationFilter = {
    every?: ShopItemWhereInput
    some?: ShopItemWhereInput
    none?: ShopItemWhereInput
  }

  export type ShopItemOrderByRelationAggregateInput = {
    _count?: SortOrder
  }

  export type ShopCategoryCountOrderByAggregateInput = {
    categoryID?: SortOrder
    no?: SortOrder
    name?: SortOrder
    texture?: SortOrder
    type?: SortOrder
    active?: SortOrder
  }

  export type ShopCategoryAvgOrderByAggregateInput = {
    categoryID?: SortOrder
    no?: SortOrder
  }

  export type ShopCategoryMaxOrderByAggregateInput = {
    categoryID?: SortOrder
    no?: SortOrder
    name?: SortOrder
    texture?: SortOrder
    type?: SortOrder
    active?: SortOrder
  }

  export type ShopCategoryMinOrderByAggregateInput = {
    categoryID?: SortOrder
    no?: SortOrder
    name?: SortOrder
    texture?: SortOrder
    type?: SortOrder
    active?: SortOrder
  }

  export type ShopCategorySumOrderByAggregateInput = {
    categoryID?: SortOrder
    no?: SortOrder
  }

  export type EnumItemTypeWithAggregatesFilter<$PrismaModel = never> = {
    equals?: $Enums.ItemType | EnumItemTypeFieldRefInput<$PrismaModel>
    in?: $Enums.ItemType[]
    notIn?: $Enums.ItemType[]
    not?: NestedEnumItemTypeWithAggregatesFilter<$PrismaModel> | $Enums.ItemType
    _count?: NestedIntFilter<$PrismaModel>
    _min?: NestedEnumItemTypeFilter<$PrismaModel>
    _max?: NestedEnumItemTypeFilter<$PrismaModel>
  }

  export type EnumEnchantTypeNullableFilter<$PrismaModel = never> = {
    equals?: $Enums.EnchantType | EnumEnchantTypeFieldRefInput<$PrismaModel> | null
    in?: $Enums.EnchantType[] | null
    notIn?: $Enums.EnchantType[] | null
    not?: NestedEnumEnchantTypeNullableFilter<$PrismaModel> | $Enums.EnchantType | null
  }

  export type ShopCategoryRelationFilter = {
    is?: ShopCategoryWhereInput
    isNot?: ShopCategoryWhereInput
  }

  export type TransactionDetailListRelationFilter = {
    every?: TransactionDetailWhereInput
    some?: TransactionDetailWhereInput
    none?: TransactionDetailWhereInput
  }

  export type TransactionDetailOrderByRelationAggregateInput = {
    _count?: SortOrder
  }

  export type ShopItemCountOrderByAggregateInput = {
    itemId?: SortOrder
    categoryId?: SortOrder
    texture?: SortOrder
    name?: SortOrder
    cost?: SortOrder
    sell?: SortOrder
    data?: SortOrder
    item?: SortOrder
    maxLevel?: SortOrder
    enchant?: SortOrder
    enchantType?: SortOrder
    available?: SortOrder
    createdAt?: SortOrder
    updatedAt?: SortOrder
  }

  export type ShopItemAvgOrderByAggregateInput = {
    itemId?: SortOrder
    categoryId?: SortOrder
    cost?: SortOrder
    sell?: SortOrder
    data?: SortOrder
    maxLevel?: SortOrder
  }

  export type ShopItemMaxOrderByAggregateInput = {
    itemId?: SortOrder
    categoryId?: SortOrder
    texture?: SortOrder
    name?: SortOrder
    cost?: SortOrder
    sell?: SortOrder
    data?: SortOrder
    item?: SortOrder
    maxLevel?: SortOrder
    enchant?: SortOrder
    enchantType?: SortOrder
    available?: SortOrder
    createdAt?: SortOrder
    updatedAt?: SortOrder
  }

  export type ShopItemMinOrderByAggregateInput = {
    itemId?: SortOrder
    categoryId?: SortOrder
    texture?: SortOrder
    name?: SortOrder
    cost?: SortOrder
    sell?: SortOrder
    data?: SortOrder
    item?: SortOrder
    maxLevel?: SortOrder
    enchant?: SortOrder
    enchantType?: SortOrder
    available?: SortOrder
    createdAt?: SortOrder
    updatedAt?: SortOrder
  }

  export type ShopItemSumOrderByAggregateInput = {
    itemId?: SortOrder
    categoryId?: SortOrder
    cost?: SortOrder
    sell?: SortOrder
    data?: SortOrder
    maxLevel?: SortOrder
  }

  export type EnumEnchantTypeNullableWithAggregatesFilter<$PrismaModel = never> = {
    equals?: $Enums.EnchantType | EnumEnchantTypeFieldRefInput<$PrismaModel> | null
    in?: $Enums.EnchantType[] | null
    notIn?: $Enums.EnchantType[] | null
    not?: NestedEnumEnchantTypeNullableWithAggregatesFilter<$PrismaModel> | $Enums.EnchantType | null
    _count?: NestedIntNullableFilter<$PrismaModel>
    _min?: NestedEnumEnchantTypeNullableFilter<$PrismaModel>
    _max?: NestedEnumEnchantTypeNullableFilter<$PrismaModel>
  }

  export type EnumTrxTypeFilter<$PrismaModel = never> = {
    equals?: $Enums.TrxType | EnumTrxTypeFieldRefInput<$PrismaModel>
    in?: $Enums.TrxType[]
    notIn?: $Enums.TrxType[]
    not?: NestedEnumTrxTypeFilter<$PrismaModel> | $Enums.TrxType
  }

  export type UserNullableRelationFilter = {
    is?: UserWhereInput | null
    isNot?: UserWhereInput | null
  }

  export type TransactionDetailNullableRelationFilter = {
    is?: TransactionDetailWhereInput | null
    isNot?: TransactionDetailWhereInput | null
  }

  export type TransactionCountOrderByAggregateInput = {
    transactionId?: SortOrder
    userId?: SortOrder
    targetUserId?: SortOrder
    createdAt?: SortOrder
    trxType?: SortOrder
  }

  export type TransactionAvgOrderByAggregateInput = {
    transactionId?: SortOrder
  }

  export type TransactionMaxOrderByAggregateInput = {
    transactionId?: SortOrder
    userId?: SortOrder
    targetUserId?: SortOrder
    createdAt?: SortOrder
    trxType?: SortOrder
  }

  export type TransactionMinOrderByAggregateInput = {
    transactionId?: SortOrder
    userId?: SortOrder
    targetUserId?: SortOrder
    createdAt?: SortOrder
    trxType?: SortOrder
  }

  export type TransactionSumOrderByAggregateInput = {
    transactionId?: SortOrder
  }

  export type EnumTrxTypeWithAggregatesFilter<$PrismaModel = never> = {
    equals?: $Enums.TrxType | EnumTrxTypeFieldRefInput<$PrismaModel>
    in?: $Enums.TrxType[]
    notIn?: $Enums.TrxType[]
    not?: NestedEnumTrxTypeWithAggregatesFilter<$PrismaModel> | $Enums.TrxType
    _count?: NestedIntFilter<$PrismaModel>
    _min?: NestedEnumTrxTypeFilter<$PrismaModel>
    _max?: NestedEnumTrxTypeFilter<$PrismaModel>
  }

  export type ShopItemNullableRelationFilter = {
    is?: ShopItemWhereInput | null
    isNot?: ShopItemWhereInput | null
  }

  export type TransactionRelationFilter = {
    is?: TransactionWhereInput
    isNot?: TransactionWhereInput
  }

  export type TransactionDetailCountOrderByAggregateInput = {
    id?: SortOrder
    transactionId?: SortOrder
    itemId?: SortOrder
    qty?: SortOrder
    totalPrice?: SortOrder
  }

  export type TransactionDetailAvgOrderByAggregateInput = {
    id?: SortOrder
    transactionId?: SortOrder
    itemId?: SortOrder
    qty?: SortOrder
    totalPrice?: SortOrder
  }

  export type TransactionDetailMaxOrderByAggregateInput = {
    id?: SortOrder
    transactionId?: SortOrder
    itemId?: SortOrder
    qty?: SortOrder
    totalPrice?: SortOrder
  }

  export type TransactionDetailMinOrderByAggregateInput = {
    id?: SortOrder
    transactionId?: SortOrder
    itemId?: SortOrder
    qty?: SortOrder
    totalPrice?: SortOrder
  }

  export type TransactionDetailSumOrderByAggregateInput = {
    id?: SortOrder
    transactionId?: SortOrder
    itemId?: SortOrder
    qty?: SortOrder
    totalPrice?: SortOrder
  }

  export type TpaRequestCountOrderByAggregateInput = {
    id?: SortOrder
    fromName?: SortOrder
    targetName?: SortOrder
    createdAt?: SortOrder
  }

  export type TpaRequestAvgOrderByAggregateInput = {
    id?: SortOrder
  }

  export type TpaRequestMaxOrderByAggregateInput = {
    id?: SortOrder
    fromName?: SortOrder
    targetName?: SortOrder
    createdAt?: SortOrder
  }

  export type TpaRequestMinOrderByAggregateInput = {
    id?: SortOrder
    fromName?: SortOrder
    targetName?: SortOrder
    createdAt?: SortOrder
  }

  export type TpaRequestSumOrderByAggregateInput = {
    id?: SortOrder
  }

  export type WayPointCountOrderByAggregateInput = {
    id?: SortOrder
    ownerId?: SortOrder
    name?: SortOrder
    x?: SortOrder
    y?: SortOrder
    z?: SortOrder
    dimension?: SortOrder
    isPublic?: SortOrder
  }

  export type WayPointAvgOrderByAggregateInput = {
    id?: SortOrder
    x?: SortOrder
    y?: SortOrder
    z?: SortOrder
  }

  export type WayPointMaxOrderByAggregateInput = {
    id?: SortOrder
    ownerId?: SortOrder
    name?: SortOrder
    x?: SortOrder
    y?: SortOrder
    z?: SortOrder
    dimension?: SortOrder
    isPublic?: SortOrder
  }

  export type WayPointMinOrderByAggregateInput = {
    id?: SortOrder
    ownerId?: SortOrder
    name?: SortOrder
    x?: SortOrder
    y?: SortOrder
    z?: SortOrder
    dimension?: SortOrder
    isPublic?: SortOrder
  }

  export type WayPointSumOrderByAggregateInput = {
    id?: SortOrder
    x?: SortOrder
    y?: SortOrder
    z?: SortOrder
  }

  export type EnumDataTypeFilter<$PrismaModel = never> = {
    equals?: $Enums.DataType | EnumDataTypeFieldRefInput<$PrismaModel>
    in?: $Enums.DataType[]
    notIn?: $Enums.DataType[]
    not?: NestedEnumDataTypeFilter<$PrismaModel> | $Enums.DataType
  }

  export type SettingsCountOrderByAggregateInput = {
    id?: SortOrder
    name?: SortOrder
    value?: SortOrder
    type?: SortOrder
    createdAt?: SortOrder
    updatedAt?: SortOrder
  }

  export type SettingsAvgOrderByAggregateInput = {
    id?: SortOrder
  }

  export type SettingsMaxOrderByAggregateInput = {
    id?: SortOrder
    name?: SortOrder
    value?: SortOrder
    type?: SortOrder
    createdAt?: SortOrder
    updatedAt?: SortOrder
  }

  export type SettingsMinOrderByAggregateInput = {
    id?: SortOrder
    name?: SortOrder
    value?: SortOrder
    type?: SortOrder
    createdAt?: SortOrder
    updatedAt?: SortOrder
  }

  export type SettingsSumOrderByAggregateInput = {
    id?: SortOrder
  }

  export type EnumDataTypeWithAggregatesFilter<$PrismaModel = never> = {
    equals?: $Enums.DataType | EnumDataTypeFieldRefInput<$PrismaModel>
    in?: $Enums.DataType[]
    notIn?: $Enums.DataType[]
    not?: NestedEnumDataTypeWithAggregatesFilter<$PrismaModel> | $Enums.DataType
    _count?: NestedIntFilter<$PrismaModel>
    _min?: NestedEnumDataTypeFilter<$PrismaModel>
    _max?: NestedEnumDataTypeFilter<$PrismaModel>
  }

  export type GuildMemberCreateNestedOneWithoutMemberInput = {
    create?: XOR<GuildMemberCreateWithoutMemberInput, GuildMemberUncheckedCreateWithoutMemberInput>
    connectOrCreate?: GuildMemberCreateOrConnectWithoutMemberInput
    connect?: GuildMemberWhereUniqueInput
  }

  export type TransactionCreateNestedManyWithoutUserInput = {
    create?: XOR<TransactionCreateWithoutUserInput, TransactionUncheckedCreateWithoutUserInput> | TransactionCreateWithoutUserInput[] | TransactionUncheckedCreateWithoutUserInput[]
    connectOrCreate?: TransactionCreateOrConnectWithoutUserInput | TransactionCreateOrConnectWithoutUserInput[]
    createMany?: TransactionCreateManyUserInputEnvelope
    connect?: TransactionWhereUniqueInput | TransactionWhereUniqueInput[]
  }

  export type TransactionCreateNestedManyWithoutTargetUserInput = {
    create?: XOR<TransactionCreateWithoutTargetUserInput, TransactionUncheckedCreateWithoutTargetUserInput> | TransactionCreateWithoutTargetUserInput[] | TransactionUncheckedCreateWithoutTargetUserInput[]
    connectOrCreate?: TransactionCreateOrConnectWithoutTargetUserInput | TransactionCreateOrConnectWithoutTargetUserInput[]
    createMany?: TransactionCreateManyTargetUserInputEnvelope
    connect?: TransactionWhereUniqueInput | TransactionWhereUniqueInput[]
  }

  export type WayPointCreateNestedManyWithoutUserInput = {
    create?: XOR<WayPointCreateWithoutUserInput, WayPointUncheckedCreateWithoutUserInput> | WayPointCreateWithoutUserInput[] | WayPointUncheckedCreateWithoutUserInput[]
    connectOrCreate?: WayPointCreateOrConnectWithoutUserInput | WayPointCreateOrConnectWithoutUserInput[]
    createMany?: WayPointCreateManyUserInputEnvelope
    connect?: WayPointWhereUniqueInput | WayPointWhereUniqueInput[]
  }

  export type GuildMemberUncheckedCreateNestedOneWithoutMemberInput = {
    create?: XOR<GuildMemberCreateWithoutMemberInput, GuildMemberUncheckedCreateWithoutMemberInput>
    connectOrCreate?: GuildMemberCreateOrConnectWithoutMemberInput
    connect?: GuildMemberWhereUniqueInput
  }

  export type TransactionUncheckedCreateNestedManyWithoutUserInput = {
    create?: XOR<TransactionCreateWithoutUserInput, TransactionUncheckedCreateWithoutUserInput> | TransactionCreateWithoutUserInput[] | TransactionUncheckedCreateWithoutUserInput[]
    connectOrCreate?: TransactionCreateOrConnectWithoutUserInput | TransactionCreateOrConnectWithoutUserInput[]
    createMany?: TransactionCreateManyUserInputEnvelope
    connect?: TransactionWhereUniqueInput | TransactionWhereUniqueInput[]
  }

  export type TransactionUncheckedCreateNestedManyWithoutTargetUserInput = {
    create?: XOR<TransactionCreateWithoutTargetUserInput, TransactionUncheckedCreateWithoutTargetUserInput> | TransactionCreateWithoutTargetUserInput[] | TransactionUncheckedCreateWithoutTargetUserInput[]
    connectOrCreate?: TransactionCreateOrConnectWithoutTargetUserInput | TransactionCreateOrConnectWithoutTargetUserInput[]
    createMany?: TransactionCreateManyTargetUserInputEnvelope
    connect?: TransactionWhereUniqueInput | TransactionWhereUniqueInput[]
  }

  export type WayPointUncheckedCreateNestedManyWithoutUserInput = {
    create?: XOR<WayPointCreateWithoutUserInput, WayPointUncheckedCreateWithoutUserInput> | WayPointCreateWithoutUserInput[] | WayPointUncheckedCreateWithoutUserInput[]
    connectOrCreate?: WayPointCreateOrConnectWithoutUserInput | WayPointCreateOrConnectWithoutUserInput[]
    createMany?: WayPointCreateManyUserInputEnvelope
    connect?: WayPointWhereUniqueInput | WayPointWhereUniqueInput[]
  }

  export type StringFieldUpdateOperationsInput = {
    set?: string
  }

  export type EnumUserRoleFieldUpdateOperationsInput = {
    set?: $Enums.UserRole
  }

  export type IntFieldUpdateOperationsInput = {
    set?: number
    increment?: number
    decrement?: number
    multiply?: number
    divide?: number
  }

  export type BoolFieldUpdateOperationsInput = {
    set?: boolean
  }

  export type NullableStringFieldUpdateOperationsInput = {
    set?: string | null
  }

  export type DateTimeFieldUpdateOperationsInput = {
    set?: Date | string
  }

  export type NullableIntFieldUpdateOperationsInput = {
    set?: number | null
    increment?: number
    decrement?: number
    multiply?: number
    divide?: number
  }

  export type GuildMemberUpdateOneWithoutMemberNestedInput = {
    create?: XOR<GuildMemberCreateWithoutMemberInput, GuildMemberUncheckedCreateWithoutMemberInput>
    connectOrCreate?: GuildMemberCreateOrConnectWithoutMemberInput
    upsert?: GuildMemberUpsertWithoutMemberInput
    disconnect?: GuildMemberWhereInput | boolean
    delete?: GuildMemberWhereInput | boolean
    connect?: GuildMemberWhereUniqueInput
    update?: XOR<XOR<GuildMemberUpdateToOneWithWhereWithoutMemberInput, GuildMemberUpdateWithoutMemberInput>, GuildMemberUncheckedUpdateWithoutMemberInput>
  }

  export type TransactionUpdateManyWithoutUserNestedInput = {
    create?: XOR<TransactionCreateWithoutUserInput, TransactionUncheckedCreateWithoutUserInput> | TransactionCreateWithoutUserInput[] | TransactionUncheckedCreateWithoutUserInput[]
    connectOrCreate?: TransactionCreateOrConnectWithoutUserInput | TransactionCreateOrConnectWithoutUserInput[]
    upsert?: TransactionUpsertWithWhereUniqueWithoutUserInput | TransactionUpsertWithWhereUniqueWithoutUserInput[]
    createMany?: TransactionCreateManyUserInputEnvelope
    set?: TransactionWhereUniqueInput | TransactionWhereUniqueInput[]
    disconnect?: TransactionWhereUniqueInput | TransactionWhereUniqueInput[]
    delete?: TransactionWhereUniqueInput | TransactionWhereUniqueInput[]
    connect?: TransactionWhereUniqueInput | TransactionWhereUniqueInput[]
    update?: TransactionUpdateWithWhereUniqueWithoutUserInput | TransactionUpdateWithWhereUniqueWithoutUserInput[]
    updateMany?: TransactionUpdateManyWithWhereWithoutUserInput | TransactionUpdateManyWithWhereWithoutUserInput[]
    deleteMany?: TransactionScalarWhereInput | TransactionScalarWhereInput[]
  }

  export type TransactionUpdateManyWithoutTargetUserNestedInput = {
    create?: XOR<TransactionCreateWithoutTargetUserInput, TransactionUncheckedCreateWithoutTargetUserInput> | TransactionCreateWithoutTargetUserInput[] | TransactionUncheckedCreateWithoutTargetUserInput[]
    connectOrCreate?: TransactionCreateOrConnectWithoutTargetUserInput | TransactionCreateOrConnectWithoutTargetUserInput[]
    upsert?: TransactionUpsertWithWhereUniqueWithoutTargetUserInput | TransactionUpsertWithWhereUniqueWithoutTargetUserInput[]
    createMany?: TransactionCreateManyTargetUserInputEnvelope
    set?: TransactionWhereUniqueInput | TransactionWhereUniqueInput[]
    disconnect?: TransactionWhereUniqueInput | TransactionWhereUniqueInput[]
    delete?: TransactionWhereUniqueInput | TransactionWhereUniqueInput[]
    connect?: TransactionWhereUniqueInput | TransactionWhereUniqueInput[]
    update?: TransactionUpdateWithWhereUniqueWithoutTargetUserInput | TransactionUpdateWithWhereUniqueWithoutTargetUserInput[]
    updateMany?: TransactionUpdateManyWithWhereWithoutTargetUserInput | TransactionUpdateManyWithWhereWithoutTargetUserInput[]
    deleteMany?: TransactionScalarWhereInput | TransactionScalarWhereInput[]
  }

  export type WayPointUpdateManyWithoutUserNestedInput = {
    create?: XOR<WayPointCreateWithoutUserInput, WayPointUncheckedCreateWithoutUserInput> | WayPointCreateWithoutUserInput[] | WayPointUncheckedCreateWithoutUserInput[]
    connectOrCreate?: WayPointCreateOrConnectWithoutUserInput | WayPointCreateOrConnectWithoutUserInput[]
    upsert?: WayPointUpsertWithWhereUniqueWithoutUserInput | WayPointUpsertWithWhereUniqueWithoutUserInput[]
    createMany?: WayPointCreateManyUserInputEnvelope
    set?: WayPointWhereUniqueInput | WayPointWhereUniqueInput[]
    disconnect?: WayPointWhereUniqueInput | WayPointWhereUniqueInput[]
    delete?: WayPointWhereUniqueInput | WayPointWhereUniqueInput[]
    connect?: WayPointWhereUniqueInput | WayPointWhereUniqueInput[]
    update?: WayPointUpdateWithWhereUniqueWithoutUserInput | WayPointUpdateWithWhereUniqueWithoutUserInput[]
    updateMany?: WayPointUpdateManyWithWhereWithoutUserInput | WayPointUpdateManyWithWhereWithoutUserInput[]
    deleteMany?: WayPointScalarWhereInput | WayPointScalarWhereInput[]
  }

  export type GuildMemberUncheckedUpdateOneWithoutMemberNestedInput = {
    create?: XOR<GuildMemberCreateWithoutMemberInput, GuildMemberUncheckedCreateWithoutMemberInput>
    connectOrCreate?: GuildMemberCreateOrConnectWithoutMemberInput
    upsert?: GuildMemberUpsertWithoutMemberInput
    disconnect?: GuildMemberWhereInput | boolean
    delete?: GuildMemberWhereInput | boolean
    connect?: GuildMemberWhereUniqueInput
    update?: XOR<XOR<GuildMemberUpdateToOneWithWhereWithoutMemberInput, GuildMemberUpdateWithoutMemberInput>, GuildMemberUncheckedUpdateWithoutMemberInput>
  }

  export type TransactionUncheckedUpdateManyWithoutUserNestedInput = {
    create?: XOR<TransactionCreateWithoutUserInput, TransactionUncheckedCreateWithoutUserInput> | TransactionCreateWithoutUserInput[] | TransactionUncheckedCreateWithoutUserInput[]
    connectOrCreate?: TransactionCreateOrConnectWithoutUserInput | TransactionCreateOrConnectWithoutUserInput[]
    upsert?: TransactionUpsertWithWhereUniqueWithoutUserInput | TransactionUpsertWithWhereUniqueWithoutUserInput[]
    createMany?: TransactionCreateManyUserInputEnvelope
    set?: TransactionWhereUniqueInput | TransactionWhereUniqueInput[]
    disconnect?: TransactionWhereUniqueInput | TransactionWhereUniqueInput[]
    delete?: TransactionWhereUniqueInput | TransactionWhereUniqueInput[]
    connect?: TransactionWhereUniqueInput | TransactionWhereUniqueInput[]
    update?: TransactionUpdateWithWhereUniqueWithoutUserInput | TransactionUpdateWithWhereUniqueWithoutUserInput[]
    updateMany?: TransactionUpdateManyWithWhereWithoutUserInput | TransactionUpdateManyWithWhereWithoutUserInput[]
    deleteMany?: TransactionScalarWhereInput | TransactionScalarWhereInput[]
  }

  export type TransactionUncheckedUpdateManyWithoutTargetUserNestedInput = {
    create?: XOR<TransactionCreateWithoutTargetUserInput, TransactionUncheckedCreateWithoutTargetUserInput> | TransactionCreateWithoutTargetUserInput[] | TransactionUncheckedCreateWithoutTargetUserInput[]
    connectOrCreate?: TransactionCreateOrConnectWithoutTargetUserInput | TransactionCreateOrConnectWithoutTargetUserInput[]
    upsert?: TransactionUpsertWithWhereUniqueWithoutTargetUserInput | TransactionUpsertWithWhereUniqueWithoutTargetUserInput[]
    createMany?: TransactionCreateManyTargetUserInputEnvelope
    set?: TransactionWhereUniqueInput | TransactionWhereUniqueInput[]
    disconnect?: TransactionWhereUniqueInput | TransactionWhereUniqueInput[]
    delete?: TransactionWhereUniqueInput | TransactionWhereUniqueInput[]
    connect?: TransactionWhereUniqueInput | TransactionWhereUniqueInput[]
    update?: TransactionUpdateWithWhereUniqueWithoutTargetUserInput | TransactionUpdateWithWhereUniqueWithoutTargetUserInput[]
    updateMany?: TransactionUpdateManyWithWhereWithoutTargetUserInput | TransactionUpdateManyWithWhereWithoutTargetUserInput[]
    deleteMany?: TransactionScalarWhereInput | TransactionScalarWhereInput[]
  }

  export type WayPointUncheckedUpdateManyWithoutUserNestedInput = {
    create?: XOR<WayPointCreateWithoutUserInput, WayPointUncheckedCreateWithoutUserInput> | WayPointCreateWithoutUserInput[] | WayPointUncheckedCreateWithoutUserInput[]
    connectOrCreate?: WayPointCreateOrConnectWithoutUserInput | WayPointCreateOrConnectWithoutUserInput[]
    upsert?: WayPointUpsertWithWhereUniqueWithoutUserInput | WayPointUpsertWithWhereUniqueWithoutUserInput[]
    createMany?: WayPointCreateManyUserInputEnvelope
    set?: WayPointWhereUniqueInput | WayPointWhereUniqueInput[]
    disconnect?: WayPointWhereUniqueInput | WayPointWhereUniqueInput[]
    delete?: WayPointWhereUniqueInput | WayPointWhereUniqueInput[]
    connect?: WayPointWhereUniqueInput | WayPointWhereUniqueInput[]
    update?: WayPointUpdateWithWhereUniqueWithoutUserInput | WayPointUpdateWithWhereUniqueWithoutUserInput[]
    updateMany?: WayPointUpdateManyWithWhereWithoutUserInput | WayPointUpdateManyWithWhereWithoutUserInput[]
    deleteMany?: WayPointScalarWhereInput | WayPointScalarWhereInput[]
  }

  export type FloatFieldUpdateOperationsInput = {
    set?: number
    increment?: number
    decrement?: number
    multiply?: number
    divide?: number
  }

  export type GuildMemberCreateNestedManyWithoutGuildInput = {
    create?: XOR<GuildMemberCreateWithoutGuildInput, GuildMemberUncheckedCreateWithoutGuildInput> | GuildMemberCreateWithoutGuildInput[] | GuildMemberUncheckedCreateWithoutGuildInput[]
    connectOrCreate?: GuildMemberCreateOrConnectWithoutGuildInput | GuildMemberCreateOrConnectWithoutGuildInput[]
    createMany?: GuildMemberCreateManyGuildInputEnvelope
    connect?: GuildMemberWhereUniqueInput | GuildMemberWhereUniqueInput[]
  }

  export type GuildMemberUncheckedCreateNestedManyWithoutGuildInput = {
    create?: XOR<GuildMemberCreateWithoutGuildInput, GuildMemberUncheckedCreateWithoutGuildInput> | GuildMemberCreateWithoutGuildInput[] | GuildMemberUncheckedCreateWithoutGuildInput[]
    connectOrCreate?: GuildMemberCreateOrConnectWithoutGuildInput | GuildMemberCreateOrConnectWithoutGuildInput[]
    createMany?: GuildMemberCreateManyGuildInputEnvelope
    connect?: GuildMemberWhereUniqueInput | GuildMemberWhereUniqueInput[]
  }

  export type GuildMemberUpdateManyWithoutGuildNestedInput = {
    create?: XOR<GuildMemberCreateWithoutGuildInput, GuildMemberUncheckedCreateWithoutGuildInput> | GuildMemberCreateWithoutGuildInput[] | GuildMemberUncheckedCreateWithoutGuildInput[]
    connectOrCreate?: GuildMemberCreateOrConnectWithoutGuildInput | GuildMemberCreateOrConnectWithoutGuildInput[]
    upsert?: GuildMemberUpsertWithWhereUniqueWithoutGuildInput | GuildMemberUpsertWithWhereUniqueWithoutGuildInput[]
    createMany?: GuildMemberCreateManyGuildInputEnvelope
    set?: GuildMemberWhereUniqueInput | GuildMemberWhereUniqueInput[]
    disconnect?: GuildMemberWhereUniqueInput | GuildMemberWhereUniqueInput[]
    delete?: GuildMemberWhereUniqueInput | GuildMemberWhereUniqueInput[]
    connect?: GuildMemberWhereUniqueInput | GuildMemberWhereUniqueInput[]
    update?: GuildMemberUpdateWithWhereUniqueWithoutGuildInput | GuildMemberUpdateWithWhereUniqueWithoutGuildInput[]
    updateMany?: GuildMemberUpdateManyWithWhereWithoutGuildInput | GuildMemberUpdateManyWithWhereWithoutGuildInput[]
    deleteMany?: GuildMemberScalarWhereInput | GuildMemberScalarWhereInput[]
  }

  export type GuildMemberUncheckedUpdateManyWithoutGuildNestedInput = {
    create?: XOR<GuildMemberCreateWithoutGuildInput, GuildMemberUncheckedCreateWithoutGuildInput> | GuildMemberCreateWithoutGuildInput[] | GuildMemberUncheckedCreateWithoutGuildInput[]
    connectOrCreate?: GuildMemberCreateOrConnectWithoutGuildInput | GuildMemberCreateOrConnectWithoutGuildInput[]
    upsert?: GuildMemberUpsertWithWhereUniqueWithoutGuildInput | GuildMemberUpsertWithWhereUniqueWithoutGuildInput[]
    createMany?: GuildMemberCreateManyGuildInputEnvelope
    set?: GuildMemberWhereUniqueInput | GuildMemberWhereUniqueInput[]
    disconnect?: GuildMemberWhereUniqueInput | GuildMemberWhereUniqueInput[]
    delete?: GuildMemberWhereUniqueInput | GuildMemberWhereUniqueInput[]
    connect?: GuildMemberWhereUniqueInput | GuildMemberWhereUniqueInput[]
    update?: GuildMemberUpdateWithWhereUniqueWithoutGuildInput | GuildMemberUpdateWithWhereUniqueWithoutGuildInput[]
    updateMany?: GuildMemberUpdateManyWithWhereWithoutGuildInput | GuildMemberUpdateManyWithWhereWithoutGuildInput[]
    deleteMany?: GuildMemberScalarWhereInput | GuildMemberScalarWhereInput[]
  }

  export type GuildCreateNestedOneWithoutGuildMemberInput = {
    create?: XOR<GuildCreateWithoutGuildMemberInput, GuildUncheckedCreateWithoutGuildMemberInput>
    connectOrCreate?: GuildCreateOrConnectWithoutGuildMemberInput
    connect?: GuildWhereUniqueInput
  }

  export type UserCreateNestedOneWithoutGuildMemberInput = {
    create?: XOR<UserCreateWithoutGuildMemberInput, UserUncheckedCreateWithoutGuildMemberInput>
    connectOrCreate?: UserCreateOrConnectWithoutGuildMemberInput
    connect?: UserWhereUniqueInput
  }

  export type EnumGuildRoleFieldUpdateOperationsInput = {
    set?: $Enums.GuildRole
  }

  export type GuildUpdateOneRequiredWithoutGuildMemberNestedInput = {
    create?: XOR<GuildCreateWithoutGuildMemberInput, GuildUncheckedCreateWithoutGuildMemberInput>
    connectOrCreate?: GuildCreateOrConnectWithoutGuildMemberInput
    upsert?: GuildUpsertWithoutGuildMemberInput
    connect?: GuildWhereUniqueInput
    update?: XOR<XOR<GuildUpdateToOneWithWhereWithoutGuildMemberInput, GuildUpdateWithoutGuildMemberInput>, GuildUncheckedUpdateWithoutGuildMemberInput>
  }

  export type UserUpdateOneRequiredWithoutGuildMemberNestedInput = {
    create?: XOR<UserCreateWithoutGuildMemberInput, UserUncheckedCreateWithoutGuildMemberInput>
    connectOrCreate?: UserCreateOrConnectWithoutGuildMemberInput
    upsert?: UserUpsertWithoutGuildMemberInput
    connect?: UserWhereUniqueInput
    update?: XOR<XOR<UserUpdateToOneWithWhereWithoutGuildMemberInput, UserUpdateWithoutGuildMemberInput>, UserUncheckedUpdateWithoutGuildMemberInput>
  }

  export type ShopItemCreateNestedManyWithoutCategoryInput = {
    create?: XOR<ShopItemCreateWithoutCategoryInput, ShopItemUncheckedCreateWithoutCategoryInput> | ShopItemCreateWithoutCategoryInput[] | ShopItemUncheckedCreateWithoutCategoryInput[]
    connectOrCreate?: ShopItemCreateOrConnectWithoutCategoryInput | ShopItemCreateOrConnectWithoutCategoryInput[]
    createMany?: ShopItemCreateManyCategoryInputEnvelope
    connect?: ShopItemWhereUniqueInput | ShopItemWhereUniqueInput[]
  }

  export type ShopItemUncheckedCreateNestedManyWithoutCategoryInput = {
    create?: XOR<ShopItemCreateWithoutCategoryInput, ShopItemUncheckedCreateWithoutCategoryInput> | ShopItemCreateWithoutCategoryInput[] | ShopItemUncheckedCreateWithoutCategoryInput[]
    connectOrCreate?: ShopItemCreateOrConnectWithoutCategoryInput | ShopItemCreateOrConnectWithoutCategoryInput[]
    createMany?: ShopItemCreateManyCategoryInputEnvelope
    connect?: ShopItemWhereUniqueInput | ShopItemWhereUniqueInput[]
  }

  export type EnumItemTypeFieldUpdateOperationsInput = {
    set?: $Enums.ItemType
  }

  export type ShopItemUpdateManyWithoutCategoryNestedInput = {
    create?: XOR<ShopItemCreateWithoutCategoryInput, ShopItemUncheckedCreateWithoutCategoryInput> | ShopItemCreateWithoutCategoryInput[] | ShopItemUncheckedCreateWithoutCategoryInput[]
    connectOrCreate?: ShopItemCreateOrConnectWithoutCategoryInput | ShopItemCreateOrConnectWithoutCategoryInput[]
    upsert?: ShopItemUpsertWithWhereUniqueWithoutCategoryInput | ShopItemUpsertWithWhereUniqueWithoutCategoryInput[]
    createMany?: ShopItemCreateManyCategoryInputEnvelope
    set?: ShopItemWhereUniqueInput | ShopItemWhereUniqueInput[]
    disconnect?: ShopItemWhereUniqueInput | ShopItemWhereUniqueInput[]
    delete?: ShopItemWhereUniqueInput | ShopItemWhereUniqueInput[]
    connect?: ShopItemWhereUniqueInput | ShopItemWhereUniqueInput[]
    update?: ShopItemUpdateWithWhereUniqueWithoutCategoryInput | ShopItemUpdateWithWhereUniqueWithoutCategoryInput[]
    updateMany?: ShopItemUpdateManyWithWhereWithoutCategoryInput | ShopItemUpdateManyWithWhereWithoutCategoryInput[]
    deleteMany?: ShopItemScalarWhereInput | ShopItemScalarWhereInput[]
  }

  export type ShopItemUncheckedUpdateManyWithoutCategoryNestedInput = {
    create?: XOR<ShopItemCreateWithoutCategoryInput, ShopItemUncheckedCreateWithoutCategoryInput> | ShopItemCreateWithoutCategoryInput[] | ShopItemUncheckedCreateWithoutCategoryInput[]
    connectOrCreate?: ShopItemCreateOrConnectWithoutCategoryInput | ShopItemCreateOrConnectWithoutCategoryInput[]
    upsert?: ShopItemUpsertWithWhereUniqueWithoutCategoryInput | ShopItemUpsertWithWhereUniqueWithoutCategoryInput[]
    createMany?: ShopItemCreateManyCategoryInputEnvelope
    set?: ShopItemWhereUniqueInput | ShopItemWhereUniqueInput[]
    disconnect?: ShopItemWhereUniqueInput | ShopItemWhereUniqueInput[]
    delete?: ShopItemWhereUniqueInput | ShopItemWhereUniqueInput[]
    connect?: ShopItemWhereUniqueInput | ShopItemWhereUniqueInput[]
    update?: ShopItemUpdateWithWhereUniqueWithoutCategoryInput | ShopItemUpdateWithWhereUniqueWithoutCategoryInput[]
    updateMany?: ShopItemUpdateManyWithWhereWithoutCategoryInput | ShopItemUpdateManyWithWhereWithoutCategoryInput[]
    deleteMany?: ShopItemScalarWhereInput | ShopItemScalarWhereInput[]
  }

  export type ShopCategoryCreateNestedOneWithoutShopItemInput = {
    create?: XOR<ShopCategoryCreateWithoutShopItemInput, ShopCategoryUncheckedCreateWithoutShopItemInput>
    connectOrCreate?: ShopCategoryCreateOrConnectWithoutShopItemInput
    connect?: ShopCategoryWhereUniqueInput
  }

  export type TransactionDetailCreateNestedManyWithoutShopItemInput = {
    create?: XOR<TransactionDetailCreateWithoutShopItemInput, TransactionDetailUncheckedCreateWithoutShopItemInput> | TransactionDetailCreateWithoutShopItemInput[] | TransactionDetailUncheckedCreateWithoutShopItemInput[]
    connectOrCreate?: TransactionDetailCreateOrConnectWithoutShopItemInput | TransactionDetailCreateOrConnectWithoutShopItemInput[]
    createMany?: TransactionDetailCreateManyShopItemInputEnvelope
    connect?: TransactionDetailWhereUniqueInput | TransactionDetailWhereUniqueInput[]
  }

  export type TransactionDetailUncheckedCreateNestedManyWithoutShopItemInput = {
    create?: XOR<TransactionDetailCreateWithoutShopItemInput, TransactionDetailUncheckedCreateWithoutShopItemInput> | TransactionDetailCreateWithoutShopItemInput[] | TransactionDetailUncheckedCreateWithoutShopItemInput[]
    connectOrCreate?: TransactionDetailCreateOrConnectWithoutShopItemInput | TransactionDetailCreateOrConnectWithoutShopItemInput[]
    createMany?: TransactionDetailCreateManyShopItemInputEnvelope
    connect?: TransactionDetailWhereUniqueInput | TransactionDetailWhereUniqueInput[]
  }

  export type NullableEnumEnchantTypeFieldUpdateOperationsInput = {
    set?: $Enums.EnchantType | null
  }

  export type ShopCategoryUpdateOneRequiredWithoutShopItemNestedInput = {
    create?: XOR<ShopCategoryCreateWithoutShopItemInput, ShopCategoryUncheckedCreateWithoutShopItemInput>
    connectOrCreate?: ShopCategoryCreateOrConnectWithoutShopItemInput
    upsert?: ShopCategoryUpsertWithoutShopItemInput
    connect?: ShopCategoryWhereUniqueInput
    update?: XOR<XOR<ShopCategoryUpdateToOneWithWhereWithoutShopItemInput, ShopCategoryUpdateWithoutShopItemInput>, ShopCategoryUncheckedUpdateWithoutShopItemInput>
  }

  export type TransactionDetailUpdateManyWithoutShopItemNestedInput = {
    create?: XOR<TransactionDetailCreateWithoutShopItemInput, TransactionDetailUncheckedCreateWithoutShopItemInput> | TransactionDetailCreateWithoutShopItemInput[] | TransactionDetailUncheckedCreateWithoutShopItemInput[]
    connectOrCreate?: TransactionDetailCreateOrConnectWithoutShopItemInput | TransactionDetailCreateOrConnectWithoutShopItemInput[]
    upsert?: TransactionDetailUpsertWithWhereUniqueWithoutShopItemInput | TransactionDetailUpsertWithWhereUniqueWithoutShopItemInput[]
    createMany?: TransactionDetailCreateManyShopItemInputEnvelope
    set?: TransactionDetailWhereUniqueInput | TransactionDetailWhereUniqueInput[]
    disconnect?: TransactionDetailWhereUniqueInput | TransactionDetailWhereUniqueInput[]
    delete?: TransactionDetailWhereUniqueInput | TransactionDetailWhereUniqueInput[]
    connect?: TransactionDetailWhereUniqueInput | TransactionDetailWhereUniqueInput[]
    update?: TransactionDetailUpdateWithWhereUniqueWithoutShopItemInput | TransactionDetailUpdateWithWhereUniqueWithoutShopItemInput[]
    updateMany?: TransactionDetailUpdateManyWithWhereWithoutShopItemInput | TransactionDetailUpdateManyWithWhereWithoutShopItemInput[]
    deleteMany?: TransactionDetailScalarWhereInput | TransactionDetailScalarWhereInput[]
  }

  export type TransactionDetailUncheckedUpdateManyWithoutShopItemNestedInput = {
    create?: XOR<TransactionDetailCreateWithoutShopItemInput, TransactionDetailUncheckedCreateWithoutShopItemInput> | TransactionDetailCreateWithoutShopItemInput[] | TransactionDetailUncheckedCreateWithoutShopItemInput[]
    connectOrCreate?: TransactionDetailCreateOrConnectWithoutShopItemInput | TransactionDetailCreateOrConnectWithoutShopItemInput[]
    upsert?: TransactionDetailUpsertWithWhereUniqueWithoutShopItemInput | TransactionDetailUpsertWithWhereUniqueWithoutShopItemInput[]
    createMany?: TransactionDetailCreateManyShopItemInputEnvelope
    set?: TransactionDetailWhereUniqueInput | TransactionDetailWhereUniqueInput[]
    disconnect?: TransactionDetailWhereUniqueInput | TransactionDetailWhereUniqueInput[]
    delete?: TransactionDetailWhereUniqueInput | TransactionDetailWhereUniqueInput[]
    connect?: TransactionDetailWhereUniqueInput | TransactionDetailWhereUniqueInput[]
    update?: TransactionDetailUpdateWithWhereUniqueWithoutShopItemInput | TransactionDetailUpdateWithWhereUniqueWithoutShopItemInput[]
    updateMany?: TransactionDetailUpdateManyWithWhereWithoutShopItemInput | TransactionDetailUpdateManyWithWhereWithoutShopItemInput[]
    deleteMany?: TransactionDetailScalarWhereInput | TransactionDetailScalarWhereInput[]
  }

  export type UserCreateNestedOneWithoutUserTransactionInput = {
    create?: XOR<UserCreateWithoutUserTransactionInput, UserUncheckedCreateWithoutUserTransactionInput>
    connectOrCreate?: UserCreateOrConnectWithoutUserTransactionInput
    connect?: UserWhereUniqueInput
  }

  export type UserCreateNestedOneWithoutTargetTransactionInput = {
    create?: XOR<UserCreateWithoutTargetTransactionInput, UserUncheckedCreateWithoutTargetTransactionInput>
    connectOrCreate?: UserCreateOrConnectWithoutTargetTransactionInput
    connect?: UserWhereUniqueInput
  }

  export type TransactionDetailCreateNestedOneWithoutTransactionInput = {
    create?: XOR<TransactionDetailCreateWithoutTransactionInput, TransactionDetailUncheckedCreateWithoutTransactionInput>
    connectOrCreate?: TransactionDetailCreateOrConnectWithoutTransactionInput
    connect?: TransactionDetailWhereUniqueInput
  }

  export type TransactionDetailUncheckedCreateNestedOneWithoutTransactionInput = {
    create?: XOR<TransactionDetailCreateWithoutTransactionInput, TransactionDetailUncheckedCreateWithoutTransactionInput>
    connectOrCreate?: TransactionDetailCreateOrConnectWithoutTransactionInput
    connect?: TransactionDetailWhereUniqueInput
  }

  export type EnumTrxTypeFieldUpdateOperationsInput = {
    set?: $Enums.TrxType
  }

  export type UserUpdateOneWithoutUserTransactionNestedInput = {
    create?: XOR<UserCreateWithoutUserTransactionInput, UserUncheckedCreateWithoutUserTransactionInput>
    connectOrCreate?: UserCreateOrConnectWithoutUserTransactionInput
    upsert?: UserUpsertWithoutUserTransactionInput
    disconnect?: UserWhereInput | boolean
    delete?: UserWhereInput | boolean
    connect?: UserWhereUniqueInput
    update?: XOR<XOR<UserUpdateToOneWithWhereWithoutUserTransactionInput, UserUpdateWithoutUserTransactionInput>, UserUncheckedUpdateWithoutUserTransactionInput>
  }

  export type UserUpdateOneWithoutTargetTransactionNestedInput = {
    create?: XOR<UserCreateWithoutTargetTransactionInput, UserUncheckedCreateWithoutTargetTransactionInput>
    connectOrCreate?: UserCreateOrConnectWithoutTargetTransactionInput
    upsert?: UserUpsertWithoutTargetTransactionInput
    disconnect?: UserWhereInput | boolean
    delete?: UserWhereInput | boolean
    connect?: UserWhereUniqueInput
    update?: XOR<XOR<UserUpdateToOneWithWhereWithoutTargetTransactionInput, UserUpdateWithoutTargetTransactionInput>, UserUncheckedUpdateWithoutTargetTransactionInput>
  }

  export type TransactionDetailUpdateOneWithoutTransactionNestedInput = {
    create?: XOR<TransactionDetailCreateWithoutTransactionInput, TransactionDetailUncheckedCreateWithoutTransactionInput>
    connectOrCreate?: TransactionDetailCreateOrConnectWithoutTransactionInput
    upsert?: TransactionDetailUpsertWithoutTransactionInput
    disconnect?: TransactionDetailWhereInput | boolean
    delete?: TransactionDetailWhereInput | boolean
    connect?: TransactionDetailWhereUniqueInput
    update?: XOR<XOR<TransactionDetailUpdateToOneWithWhereWithoutTransactionInput, TransactionDetailUpdateWithoutTransactionInput>, TransactionDetailUncheckedUpdateWithoutTransactionInput>
  }

  export type TransactionDetailUncheckedUpdateOneWithoutTransactionNestedInput = {
    create?: XOR<TransactionDetailCreateWithoutTransactionInput, TransactionDetailUncheckedCreateWithoutTransactionInput>
    connectOrCreate?: TransactionDetailCreateOrConnectWithoutTransactionInput
    upsert?: TransactionDetailUpsertWithoutTransactionInput
    disconnect?: TransactionDetailWhereInput | boolean
    delete?: TransactionDetailWhereInput | boolean
    connect?: TransactionDetailWhereUniqueInput
    update?: XOR<XOR<TransactionDetailUpdateToOneWithWhereWithoutTransactionInput, TransactionDetailUpdateWithoutTransactionInput>, TransactionDetailUncheckedUpdateWithoutTransactionInput>
  }

  export type ShopItemCreateNestedOneWithoutTransactionDetailInput = {
    create?: XOR<ShopItemCreateWithoutTransactionDetailInput, ShopItemUncheckedCreateWithoutTransactionDetailInput>
    connectOrCreate?: ShopItemCreateOrConnectWithoutTransactionDetailInput
    connect?: ShopItemWhereUniqueInput
  }

  export type TransactionCreateNestedOneWithoutTransactionDetailInput = {
    create?: XOR<TransactionCreateWithoutTransactionDetailInput, TransactionUncheckedCreateWithoutTransactionDetailInput>
    connectOrCreate?: TransactionCreateOrConnectWithoutTransactionDetailInput
    connect?: TransactionWhereUniqueInput
  }

  export type ShopItemUpdateOneWithoutTransactionDetailNestedInput = {
    create?: XOR<ShopItemCreateWithoutTransactionDetailInput, ShopItemUncheckedCreateWithoutTransactionDetailInput>
    connectOrCreate?: ShopItemCreateOrConnectWithoutTransactionDetailInput
    upsert?: ShopItemUpsertWithoutTransactionDetailInput
    disconnect?: ShopItemWhereInput | boolean
    delete?: ShopItemWhereInput | boolean
    connect?: ShopItemWhereUniqueInput
    update?: XOR<XOR<ShopItemUpdateToOneWithWhereWithoutTransactionDetailInput, ShopItemUpdateWithoutTransactionDetailInput>, ShopItemUncheckedUpdateWithoutTransactionDetailInput>
  }

  export type TransactionUpdateOneRequiredWithoutTransactionDetailNestedInput = {
    create?: XOR<TransactionCreateWithoutTransactionDetailInput, TransactionUncheckedCreateWithoutTransactionDetailInput>
    connectOrCreate?: TransactionCreateOrConnectWithoutTransactionDetailInput
    upsert?: TransactionUpsertWithoutTransactionDetailInput
    connect?: TransactionWhereUniqueInput
    update?: XOR<XOR<TransactionUpdateToOneWithWhereWithoutTransactionDetailInput, TransactionUpdateWithoutTransactionDetailInput>, TransactionUncheckedUpdateWithoutTransactionDetailInput>
  }

  export type UserCreateNestedOneWithoutWaypointInput = {
    create?: XOR<UserCreateWithoutWaypointInput, UserUncheckedCreateWithoutWaypointInput>
    connectOrCreate?: UserCreateOrConnectWithoutWaypointInput
    connect?: UserWhereUniqueInput
  }

  export type UserUpdateOneWithoutWaypointNestedInput = {
    create?: XOR<UserCreateWithoutWaypointInput, UserUncheckedCreateWithoutWaypointInput>
    connectOrCreate?: UserCreateOrConnectWithoutWaypointInput
    upsert?: UserUpsertWithoutWaypointInput
    disconnect?: UserWhereInput | boolean
    delete?: UserWhereInput | boolean
    connect?: UserWhereUniqueInput
    update?: XOR<XOR<UserUpdateToOneWithWhereWithoutWaypointInput, UserUpdateWithoutWaypointInput>, UserUncheckedUpdateWithoutWaypointInput>
  }

  export type EnumDataTypeFieldUpdateOperationsInput = {
    set?: $Enums.DataType
  }

  export type NestedIntFilter<$PrismaModel = never> = {
    equals?: number | IntFieldRefInput<$PrismaModel>
    in?: number[]
    notIn?: number[]
    lt?: number | IntFieldRefInput<$PrismaModel>
    lte?: number | IntFieldRefInput<$PrismaModel>
    gt?: number | IntFieldRefInput<$PrismaModel>
    gte?: number | IntFieldRefInput<$PrismaModel>
    not?: NestedIntFilter<$PrismaModel> | number
  }

  export type NestedStringFilter<$PrismaModel = never> = {
    equals?: string | StringFieldRefInput<$PrismaModel>
    in?: string[]
    notIn?: string[]
    lt?: string | StringFieldRefInput<$PrismaModel>
    lte?: string | StringFieldRefInput<$PrismaModel>
    gt?: string | StringFieldRefInput<$PrismaModel>
    gte?: string | StringFieldRefInput<$PrismaModel>
    contains?: string | StringFieldRefInput<$PrismaModel>
    startsWith?: string | StringFieldRefInput<$PrismaModel>
    endsWith?: string | StringFieldRefInput<$PrismaModel>
    not?: NestedStringFilter<$PrismaModel> | string
  }

  export type NestedEnumUserRoleFilter<$PrismaModel = never> = {
    equals?: $Enums.UserRole | EnumUserRoleFieldRefInput<$PrismaModel>
    in?: $Enums.UserRole[]
    notIn?: $Enums.UserRole[]
    not?: NestedEnumUserRoleFilter<$PrismaModel> | $Enums.UserRole
  }

  export type NestedBoolFilter<$PrismaModel = never> = {
    equals?: boolean | BooleanFieldRefInput<$PrismaModel>
    not?: NestedBoolFilter<$PrismaModel> | boolean
  }

  export type NestedStringNullableFilter<$PrismaModel = never> = {
    equals?: string | StringFieldRefInput<$PrismaModel> | null
    in?: string[] | null
    notIn?: string[] | null
    lt?: string | StringFieldRefInput<$PrismaModel>
    lte?: string | StringFieldRefInput<$PrismaModel>
    gt?: string | StringFieldRefInput<$PrismaModel>
    gte?: string | StringFieldRefInput<$PrismaModel>
    contains?: string | StringFieldRefInput<$PrismaModel>
    startsWith?: string | StringFieldRefInput<$PrismaModel>
    endsWith?: string | StringFieldRefInput<$PrismaModel>
    not?: NestedStringNullableFilter<$PrismaModel> | string | null
  }

  export type NestedDateTimeFilter<$PrismaModel = never> = {
    equals?: Date | string | DateTimeFieldRefInput<$PrismaModel>
    in?: Date[] | string[]
    notIn?: Date[] | string[]
    lt?: Date | string | DateTimeFieldRefInput<$PrismaModel>
    lte?: Date | string | DateTimeFieldRefInput<$PrismaModel>
    gt?: Date | string | DateTimeFieldRefInput<$PrismaModel>
    gte?: Date | string | DateTimeFieldRefInput<$PrismaModel>
    not?: NestedDateTimeFilter<$PrismaModel> | Date | string
  }

  export type NestedIntNullableFilter<$PrismaModel = never> = {
    equals?: number | IntFieldRefInput<$PrismaModel> | null
    in?: number[] | null
    notIn?: number[] | null
    lt?: number | IntFieldRefInput<$PrismaModel>
    lte?: number | IntFieldRefInput<$PrismaModel>
    gt?: number | IntFieldRefInput<$PrismaModel>
    gte?: number | IntFieldRefInput<$PrismaModel>
    not?: NestedIntNullableFilter<$PrismaModel> | number | null
  }

  export type NestedIntWithAggregatesFilter<$PrismaModel = never> = {
    equals?: number | IntFieldRefInput<$PrismaModel>
    in?: number[]
    notIn?: number[]
    lt?: number | IntFieldRefInput<$PrismaModel>
    lte?: number | IntFieldRefInput<$PrismaModel>
    gt?: number | IntFieldRefInput<$PrismaModel>
    gte?: number | IntFieldRefInput<$PrismaModel>
    not?: NestedIntWithAggregatesFilter<$PrismaModel> | number
    _count?: NestedIntFilter<$PrismaModel>
    _avg?: NestedFloatFilter<$PrismaModel>
    _sum?: NestedIntFilter<$PrismaModel>
    _min?: NestedIntFilter<$PrismaModel>
    _max?: NestedIntFilter<$PrismaModel>
  }

  export type NestedFloatFilter<$PrismaModel = never> = {
    equals?: number | FloatFieldRefInput<$PrismaModel>
    in?: number[]
    notIn?: number[]
    lt?: number | FloatFieldRefInput<$PrismaModel>
    lte?: number | FloatFieldRefInput<$PrismaModel>
    gt?: number | FloatFieldRefInput<$PrismaModel>
    gte?: number | FloatFieldRefInput<$PrismaModel>
    not?: NestedFloatFilter<$PrismaModel> | number
  }

  export type NestedStringWithAggregatesFilter<$PrismaModel = never> = {
    equals?: string | StringFieldRefInput<$PrismaModel>
    in?: string[]
    notIn?: string[]
    lt?: string | StringFieldRefInput<$PrismaModel>
    lte?: string | StringFieldRefInput<$PrismaModel>
    gt?: string | StringFieldRefInput<$PrismaModel>
    gte?: string | StringFieldRefInput<$PrismaModel>
    contains?: string | StringFieldRefInput<$PrismaModel>
    startsWith?: string | StringFieldRefInput<$PrismaModel>
    endsWith?: string | StringFieldRefInput<$PrismaModel>
    not?: NestedStringWithAggregatesFilter<$PrismaModel> | string
    _count?: NestedIntFilter<$PrismaModel>
    _min?: NestedStringFilter<$PrismaModel>
    _max?: NestedStringFilter<$PrismaModel>
  }

  export type NestedEnumUserRoleWithAggregatesFilter<$PrismaModel = never> = {
    equals?: $Enums.UserRole | EnumUserRoleFieldRefInput<$PrismaModel>
    in?: $Enums.UserRole[]
    notIn?: $Enums.UserRole[]
    not?: NestedEnumUserRoleWithAggregatesFilter<$PrismaModel> | $Enums.UserRole
    _count?: NestedIntFilter<$PrismaModel>
    _min?: NestedEnumUserRoleFilter<$PrismaModel>
    _max?: NestedEnumUserRoleFilter<$PrismaModel>
  }

  export type NestedBoolWithAggregatesFilter<$PrismaModel = never> = {
    equals?: boolean | BooleanFieldRefInput<$PrismaModel>
    not?: NestedBoolWithAggregatesFilter<$PrismaModel> | boolean
    _count?: NestedIntFilter<$PrismaModel>
    _min?: NestedBoolFilter<$PrismaModel>
    _max?: NestedBoolFilter<$PrismaModel>
  }

  export type NestedStringNullableWithAggregatesFilter<$PrismaModel = never> = {
    equals?: string | StringFieldRefInput<$PrismaModel> | null
    in?: string[] | null
    notIn?: string[] | null
    lt?: string | StringFieldRefInput<$PrismaModel>
    lte?: string | StringFieldRefInput<$PrismaModel>
    gt?: string | StringFieldRefInput<$PrismaModel>
    gte?: string | StringFieldRefInput<$PrismaModel>
    contains?: string | StringFieldRefInput<$PrismaModel>
    startsWith?: string | StringFieldRefInput<$PrismaModel>
    endsWith?: string | StringFieldRefInput<$PrismaModel>
    not?: NestedStringNullableWithAggregatesFilter<$PrismaModel> | string | null
    _count?: NestedIntNullableFilter<$PrismaModel>
    _min?: NestedStringNullableFilter<$PrismaModel>
    _max?: NestedStringNullableFilter<$PrismaModel>
  }

  export type NestedDateTimeWithAggregatesFilter<$PrismaModel = never> = {
    equals?: Date | string | DateTimeFieldRefInput<$PrismaModel>
    in?: Date[] | string[]
    notIn?: Date[] | string[]
    lt?: Date | string | DateTimeFieldRefInput<$PrismaModel>
    lte?: Date | string | DateTimeFieldRefInput<$PrismaModel>
    gt?: Date | string | DateTimeFieldRefInput<$PrismaModel>
    gte?: Date | string | DateTimeFieldRefInput<$PrismaModel>
    not?: NestedDateTimeWithAggregatesFilter<$PrismaModel> | Date | string
    _count?: NestedIntFilter<$PrismaModel>
    _min?: NestedDateTimeFilter<$PrismaModel>
    _max?: NestedDateTimeFilter<$PrismaModel>
  }

  export type NestedIntNullableWithAggregatesFilter<$PrismaModel = never> = {
    equals?: number | IntFieldRefInput<$PrismaModel> | null
    in?: number[] | null
    notIn?: number[] | null
    lt?: number | IntFieldRefInput<$PrismaModel>
    lte?: number | IntFieldRefInput<$PrismaModel>
    gt?: number | IntFieldRefInput<$PrismaModel>
    gte?: number | IntFieldRefInput<$PrismaModel>
    not?: NestedIntNullableWithAggregatesFilter<$PrismaModel> | number | null
    _count?: NestedIntNullableFilter<$PrismaModel>
    _avg?: NestedFloatNullableFilter<$PrismaModel>
    _sum?: NestedIntNullableFilter<$PrismaModel>
    _min?: NestedIntNullableFilter<$PrismaModel>
    _max?: NestedIntNullableFilter<$PrismaModel>
  }

  export type NestedFloatNullableFilter<$PrismaModel = never> = {
    equals?: number | FloatFieldRefInput<$PrismaModel> | null
    in?: number[] | null
    notIn?: number[] | null
    lt?: number | FloatFieldRefInput<$PrismaModel>
    lte?: number | FloatFieldRefInput<$PrismaModel>
    gt?: number | FloatFieldRefInput<$PrismaModel>
    gte?: number | FloatFieldRefInput<$PrismaModel>
    not?: NestedFloatNullableFilter<$PrismaModel> | number | null
  }

  export type NestedFloatWithAggregatesFilter<$PrismaModel = never> = {
    equals?: number | FloatFieldRefInput<$PrismaModel>
    in?: number[]
    notIn?: number[]
    lt?: number | FloatFieldRefInput<$PrismaModel>
    lte?: number | FloatFieldRefInput<$PrismaModel>
    gt?: number | FloatFieldRefInput<$PrismaModel>
    gte?: number | FloatFieldRefInput<$PrismaModel>
    not?: NestedFloatWithAggregatesFilter<$PrismaModel> | number
    _count?: NestedIntFilter<$PrismaModel>
    _avg?: NestedFloatFilter<$PrismaModel>
    _sum?: NestedFloatFilter<$PrismaModel>
    _min?: NestedFloatFilter<$PrismaModel>
    _max?: NestedFloatFilter<$PrismaModel>
  }

  export type NestedEnumGuildRoleFilter<$PrismaModel = never> = {
    equals?: $Enums.GuildRole | EnumGuildRoleFieldRefInput<$PrismaModel>
    in?: $Enums.GuildRole[]
    notIn?: $Enums.GuildRole[]
    not?: NestedEnumGuildRoleFilter<$PrismaModel> | $Enums.GuildRole
  }

  export type NestedEnumGuildRoleWithAggregatesFilter<$PrismaModel = never> = {
    equals?: $Enums.GuildRole | EnumGuildRoleFieldRefInput<$PrismaModel>
    in?: $Enums.GuildRole[]
    notIn?: $Enums.GuildRole[]
    not?: NestedEnumGuildRoleWithAggregatesFilter<$PrismaModel> | $Enums.GuildRole
    _count?: NestedIntFilter<$PrismaModel>
    _min?: NestedEnumGuildRoleFilter<$PrismaModel>
    _max?: NestedEnumGuildRoleFilter<$PrismaModel>
  }

  export type NestedEnumItemTypeFilter<$PrismaModel = never> = {
    equals?: $Enums.ItemType | EnumItemTypeFieldRefInput<$PrismaModel>
    in?: $Enums.ItemType[]
    notIn?: $Enums.ItemType[]
    not?: NestedEnumItemTypeFilter<$PrismaModel> | $Enums.ItemType
  }

  export type NestedEnumItemTypeWithAggregatesFilter<$PrismaModel = never> = {
    equals?: $Enums.ItemType | EnumItemTypeFieldRefInput<$PrismaModel>
    in?: $Enums.ItemType[]
    notIn?: $Enums.ItemType[]
    not?: NestedEnumItemTypeWithAggregatesFilter<$PrismaModel> | $Enums.ItemType
    _count?: NestedIntFilter<$PrismaModel>
    _min?: NestedEnumItemTypeFilter<$PrismaModel>
    _max?: NestedEnumItemTypeFilter<$PrismaModel>
  }

  export type NestedEnumEnchantTypeNullableFilter<$PrismaModel = never> = {
    equals?: $Enums.EnchantType | EnumEnchantTypeFieldRefInput<$PrismaModel> | null
    in?: $Enums.EnchantType[] | null
    notIn?: $Enums.EnchantType[] | null
    not?: NestedEnumEnchantTypeNullableFilter<$PrismaModel> | $Enums.EnchantType | null
  }

  export type NestedEnumEnchantTypeNullableWithAggregatesFilter<$PrismaModel = never> = {
    equals?: $Enums.EnchantType | EnumEnchantTypeFieldRefInput<$PrismaModel> | null
    in?: $Enums.EnchantType[] | null
    notIn?: $Enums.EnchantType[] | null
    not?: NestedEnumEnchantTypeNullableWithAggregatesFilter<$PrismaModel> | $Enums.EnchantType | null
    _count?: NestedIntNullableFilter<$PrismaModel>
    _min?: NestedEnumEnchantTypeNullableFilter<$PrismaModel>
    _max?: NestedEnumEnchantTypeNullableFilter<$PrismaModel>
  }

  export type NestedEnumTrxTypeFilter<$PrismaModel = never> = {
    equals?: $Enums.TrxType | EnumTrxTypeFieldRefInput<$PrismaModel>
    in?: $Enums.TrxType[]
    notIn?: $Enums.TrxType[]
    not?: NestedEnumTrxTypeFilter<$PrismaModel> | $Enums.TrxType
  }

  export type NestedEnumTrxTypeWithAggregatesFilter<$PrismaModel = never> = {
    equals?: $Enums.TrxType | EnumTrxTypeFieldRefInput<$PrismaModel>
    in?: $Enums.TrxType[]
    notIn?: $Enums.TrxType[]
    not?: NestedEnumTrxTypeWithAggregatesFilter<$PrismaModel> | $Enums.TrxType
    _count?: NestedIntFilter<$PrismaModel>
    _min?: NestedEnumTrxTypeFilter<$PrismaModel>
    _max?: NestedEnumTrxTypeFilter<$PrismaModel>
  }

  export type NestedEnumDataTypeFilter<$PrismaModel = never> = {
    equals?: $Enums.DataType | EnumDataTypeFieldRefInput<$PrismaModel>
    in?: $Enums.DataType[]
    notIn?: $Enums.DataType[]
    not?: NestedEnumDataTypeFilter<$PrismaModel> | $Enums.DataType
  }

  export type NestedEnumDataTypeWithAggregatesFilter<$PrismaModel = never> = {
    equals?: $Enums.DataType | EnumDataTypeFieldRefInput<$PrismaModel>
    in?: $Enums.DataType[]
    notIn?: $Enums.DataType[]
    not?: NestedEnumDataTypeWithAggregatesFilter<$PrismaModel> | $Enums.DataType
    _count?: NestedIntFilter<$PrismaModel>
    _min?: NestedEnumDataTypeFilter<$PrismaModel>
    _max?: NestedEnumDataTypeFilter<$PrismaModel>
  }

  export type GuildMemberCreateWithoutMemberInput = {
    memberRole?: $Enums.GuildRole
    guild: GuildCreateNestedOneWithoutGuildMemberInput
  }

  export type GuildMemberUncheckedCreateWithoutMemberInput = {
    id?: number
    guildId: number
    memberRole?: $Enums.GuildRole
  }

  export type GuildMemberCreateOrConnectWithoutMemberInput = {
    where: GuildMemberWhereUniqueInput
    create: XOR<GuildMemberCreateWithoutMemberInput, GuildMemberUncheckedCreateWithoutMemberInput>
  }

  export type TransactionCreateWithoutUserInput = {
    createdAt?: Date | string
    trxType?: $Enums.TrxType
    targetUser?: UserCreateNestedOneWithoutTargetTransactionInput
    TransactionDetail?: TransactionDetailCreateNestedOneWithoutTransactionInput
  }

  export type TransactionUncheckedCreateWithoutUserInput = {
    transactionId?: number
    targetUserId?: string | null
    createdAt?: Date | string
    trxType?: $Enums.TrxType
    TransactionDetail?: TransactionDetailUncheckedCreateNestedOneWithoutTransactionInput
  }

  export type TransactionCreateOrConnectWithoutUserInput = {
    where: TransactionWhereUniqueInput
    create: XOR<TransactionCreateWithoutUserInput, TransactionUncheckedCreateWithoutUserInput>
  }

  export type TransactionCreateManyUserInputEnvelope = {
    data: TransactionCreateManyUserInput | TransactionCreateManyUserInput[]
    skipDuplicates?: boolean
  }

  export type TransactionCreateWithoutTargetUserInput = {
    createdAt?: Date | string
    trxType?: $Enums.TrxType
    user?: UserCreateNestedOneWithoutUserTransactionInput
    TransactionDetail?: TransactionDetailCreateNestedOneWithoutTransactionInput
  }

  export type TransactionUncheckedCreateWithoutTargetUserInput = {
    transactionId?: number
    userId: string
    createdAt?: Date | string
    trxType?: $Enums.TrxType
    TransactionDetail?: TransactionDetailUncheckedCreateNestedOneWithoutTransactionInput
  }

  export type TransactionCreateOrConnectWithoutTargetUserInput = {
    where: TransactionWhereUniqueInput
    create: XOR<TransactionCreateWithoutTargetUserInput, TransactionUncheckedCreateWithoutTargetUserInput>
  }

  export type TransactionCreateManyTargetUserInputEnvelope = {
    data: TransactionCreateManyTargetUserInput | TransactionCreateManyTargetUserInput[]
    skipDuplicates?: boolean
  }

  export type WayPointCreateWithoutUserInput = {
    name: string
    x: number
    y: number
    z: number
    dimension: string
    isPublic?: boolean
  }

  export type WayPointUncheckedCreateWithoutUserInput = {
    id?: number
    name: string
    x: number
    y: number
    z: number
    dimension: string
    isPublic?: boolean
  }

  export type WayPointCreateOrConnectWithoutUserInput = {
    where: WayPointWhereUniqueInput
    create: XOR<WayPointCreateWithoutUserInput, WayPointUncheckedCreateWithoutUserInput>
  }

  export type WayPointCreateManyUserInputEnvelope = {
    data: WayPointCreateManyUserInput | WayPointCreateManyUserInput[]
    skipDuplicates?: boolean
  }

  export type GuildMemberUpsertWithoutMemberInput = {
    update: XOR<GuildMemberUpdateWithoutMemberInput, GuildMemberUncheckedUpdateWithoutMemberInput>
    create: XOR<GuildMemberCreateWithoutMemberInput, GuildMemberUncheckedCreateWithoutMemberInput>
    where?: GuildMemberWhereInput
  }

  export type GuildMemberUpdateToOneWithWhereWithoutMemberInput = {
    where?: GuildMemberWhereInput
    data: XOR<GuildMemberUpdateWithoutMemberInput, GuildMemberUncheckedUpdateWithoutMemberInput>
  }

  export type GuildMemberUpdateWithoutMemberInput = {
    memberRole?: EnumGuildRoleFieldUpdateOperationsInput | $Enums.GuildRole
    guild?: GuildUpdateOneRequiredWithoutGuildMemberNestedInput
  }

  export type GuildMemberUncheckedUpdateWithoutMemberInput = {
    id?: IntFieldUpdateOperationsInput | number
    guildId?: IntFieldUpdateOperationsInput | number
    memberRole?: EnumGuildRoleFieldUpdateOperationsInput | $Enums.GuildRole
  }

  export type TransactionUpsertWithWhereUniqueWithoutUserInput = {
    where: TransactionWhereUniqueInput
    update: XOR<TransactionUpdateWithoutUserInput, TransactionUncheckedUpdateWithoutUserInput>
    create: XOR<TransactionCreateWithoutUserInput, TransactionUncheckedCreateWithoutUserInput>
  }

  export type TransactionUpdateWithWhereUniqueWithoutUserInput = {
    where: TransactionWhereUniqueInput
    data: XOR<TransactionUpdateWithoutUserInput, TransactionUncheckedUpdateWithoutUserInput>
  }

  export type TransactionUpdateManyWithWhereWithoutUserInput = {
    where: TransactionScalarWhereInput
    data: XOR<TransactionUpdateManyMutationInput, TransactionUncheckedUpdateManyWithoutUserInput>
  }

  export type TransactionScalarWhereInput = {
    AND?: TransactionScalarWhereInput | TransactionScalarWhereInput[]
    OR?: TransactionScalarWhereInput[]
    NOT?: TransactionScalarWhereInput | TransactionScalarWhereInput[]
    transactionId?: IntFilter<"Transaction"> | number
    userId?: StringFilter<"Transaction"> | string
    targetUserId?: StringNullableFilter<"Transaction"> | string | null
    createdAt?: DateTimeFilter<"Transaction"> | Date | string
    trxType?: EnumTrxTypeFilter<"Transaction"> | $Enums.TrxType
  }

  export type TransactionUpsertWithWhereUniqueWithoutTargetUserInput = {
    where: TransactionWhereUniqueInput
    update: XOR<TransactionUpdateWithoutTargetUserInput, TransactionUncheckedUpdateWithoutTargetUserInput>
    create: XOR<TransactionCreateWithoutTargetUserInput, TransactionUncheckedCreateWithoutTargetUserInput>
  }

  export type TransactionUpdateWithWhereUniqueWithoutTargetUserInput = {
    where: TransactionWhereUniqueInput
    data: XOR<TransactionUpdateWithoutTargetUserInput, TransactionUncheckedUpdateWithoutTargetUserInput>
  }

  export type TransactionUpdateManyWithWhereWithoutTargetUserInput = {
    where: TransactionScalarWhereInput
    data: XOR<TransactionUpdateManyMutationInput, TransactionUncheckedUpdateManyWithoutTargetUserInput>
  }

  export type WayPointUpsertWithWhereUniqueWithoutUserInput = {
    where: WayPointWhereUniqueInput
    update: XOR<WayPointUpdateWithoutUserInput, WayPointUncheckedUpdateWithoutUserInput>
    create: XOR<WayPointCreateWithoutUserInput, WayPointUncheckedCreateWithoutUserInput>
  }

  export type WayPointUpdateWithWhereUniqueWithoutUserInput = {
    where: WayPointWhereUniqueInput
    data: XOR<WayPointUpdateWithoutUserInput, WayPointUncheckedUpdateWithoutUserInput>
  }

  export type WayPointUpdateManyWithWhereWithoutUserInput = {
    where: WayPointScalarWhereInput
    data: XOR<WayPointUpdateManyMutationInput, WayPointUncheckedUpdateManyWithoutUserInput>
  }

  export type WayPointScalarWhereInput = {
    AND?: WayPointScalarWhereInput | WayPointScalarWhereInput[]
    OR?: WayPointScalarWhereInput[]
    NOT?: WayPointScalarWhereInput | WayPointScalarWhereInput[]
    id?: IntFilter<"WayPoint"> | number
    ownerId?: StringFilter<"WayPoint"> | string
    name?: StringFilter<"WayPoint"> | string
    x?: FloatFilter<"WayPoint"> | number
    y?: FloatFilter<"WayPoint"> | number
    z?: FloatFilter<"WayPoint"> | number
    dimension?: StringFilter<"WayPoint"> | string
    isPublic?: BoolFilter<"WayPoint"> | boolean
  }

  export type GuildMemberCreateWithoutGuildInput = {
    memberRole?: $Enums.GuildRole
    member: UserCreateNestedOneWithoutGuildMemberInput
  }

  export type GuildMemberUncheckedCreateWithoutGuildInput = {
    id?: number
    memberId: string
    memberRole?: $Enums.GuildRole
  }

  export type GuildMemberCreateOrConnectWithoutGuildInput = {
    where: GuildMemberWhereUniqueInput
    create: XOR<GuildMemberCreateWithoutGuildInput, GuildMemberUncheckedCreateWithoutGuildInput>
  }

  export type GuildMemberCreateManyGuildInputEnvelope = {
    data: GuildMemberCreateManyGuildInput | GuildMemberCreateManyGuildInput[]
    skipDuplicates?: boolean
  }

  export type GuildMemberUpsertWithWhereUniqueWithoutGuildInput = {
    where: GuildMemberWhereUniqueInput
    update: XOR<GuildMemberUpdateWithoutGuildInput, GuildMemberUncheckedUpdateWithoutGuildInput>
    create: XOR<GuildMemberCreateWithoutGuildInput, GuildMemberUncheckedCreateWithoutGuildInput>
  }

  export type GuildMemberUpdateWithWhereUniqueWithoutGuildInput = {
    where: GuildMemberWhereUniqueInput
    data: XOR<GuildMemberUpdateWithoutGuildInput, GuildMemberUncheckedUpdateWithoutGuildInput>
  }

  export type GuildMemberUpdateManyWithWhereWithoutGuildInput = {
    where: GuildMemberScalarWhereInput
    data: XOR<GuildMemberUpdateManyMutationInput, GuildMemberUncheckedUpdateManyWithoutGuildInput>
  }

  export type GuildMemberScalarWhereInput = {
    AND?: GuildMemberScalarWhereInput | GuildMemberScalarWhereInput[]
    OR?: GuildMemberScalarWhereInput[]
    NOT?: GuildMemberScalarWhereInput | GuildMemberScalarWhereInput[]
    id?: IntFilter<"GuildMember"> | number
    guildId?: IntFilter<"GuildMember"> | number
    memberId?: StringFilter<"GuildMember"> | string
    memberRole?: EnumGuildRoleFilter<"GuildMember"> | $Enums.GuildRole
  }

  export type GuildCreateWithoutGuildMemberInput = {
    name: string
    description?: string | null
    ownerId: string
    maxMembers?: number
    isPublic?: boolean
    createdAt?: Date | string
    updatedAt?: Date | string
  }

  export type GuildUncheckedCreateWithoutGuildMemberInput = {
    guildId?: number
    name: string
    description?: string | null
    ownerId: string
    maxMembers?: number
    isPublic?: boolean
    createdAt?: Date | string
    updatedAt?: Date | string
  }

  export type GuildCreateOrConnectWithoutGuildMemberInput = {
    where: GuildWhereUniqueInput
    create: XOR<GuildCreateWithoutGuildMemberInput, GuildUncheckedCreateWithoutGuildMemberInput>
  }

  export type UserCreateWithoutGuildMemberInput = {
    xuid: string
    name: string
    role?: $Enums.UserRole
    money?: number
    canTpa?: boolean
    password?: string | null
    createdAt?: Date | string
    updatedAt?: Date | string
    guildId?: number | null
    userTransaction?: TransactionCreateNestedManyWithoutUserInput
    targetTransaction?: TransactionCreateNestedManyWithoutTargetUserInput
    waypoint?: WayPointCreateNestedManyWithoutUserInput
  }

  export type UserUncheckedCreateWithoutGuildMemberInput = {
    userId?: number
    xuid: string
    name: string
    role?: $Enums.UserRole
    money?: number
    canTpa?: boolean
    password?: string | null
    createdAt?: Date | string
    updatedAt?: Date | string
    guildId?: number | null
    userTransaction?: TransactionUncheckedCreateNestedManyWithoutUserInput
    targetTransaction?: TransactionUncheckedCreateNestedManyWithoutTargetUserInput
    waypoint?: WayPointUncheckedCreateNestedManyWithoutUserInput
  }

  export type UserCreateOrConnectWithoutGuildMemberInput = {
    where: UserWhereUniqueInput
    create: XOR<UserCreateWithoutGuildMemberInput, UserUncheckedCreateWithoutGuildMemberInput>
  }

  export type GuildUpsertWithoutGuildMemberInput = {
    update: XOR<GuildUpdateWithoutGuildMemberInput, GuildUncheckedUpdateWithoutGuildMemberInput>
    create: XOR<GuildCreateWithoutGuildMemberInput, GuildUncheckedCreateWithoutGuildMemberInput>
    where?: GuildWhereInput
  }

  export type GuildUpdateToOneWithWhereWithoutGuildMemberInput = {
    where?: GuildWhereInput
    data: XOR<GuildUpdateWithoutGuildMemberInput, GuildUncheckedUpdateWithoutGuildMemberInput>
  }

  export type GuildUpdateWithoutGuildMemberInput = {
    name?: StringFieldUpdateOperationsInput | string
    description?: NullableStringFieldUpdateOperationsInput | string | null
    ownerId?: StringFieldUpdateOperationsInput | string
    maxMembers?: IntFieldUpdateOperationsInput | number
    isPublic?: BoolFieldUpdateOperationsInput | boolean
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    updatedAt?: DateTimeFieldUpdateOperationsInput | Date | string
  }

  export type GuildUncheckedUpdateWithoutGuildMemberInput = {
    guildId?: IntFieldUpdateOperationsInput | number
    name?: StringFieldUpdateOperationsInput | string
    description?: NullableStringFieldUpdateOperationsInput | string | null
    ownerId?: StringFieldUpdateOperationsInput | string
    maxMembers?: IntFieldUpdateOperationsInput | number
    isPublic?: BoolFieldUpdateOperationsInput | boolean
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    updatedAt?: DateTimeFieldUpdateOperationsInput | Date | string
  }

  export type UserUpsertWithoutGuildMemberInput = {
    update: XOR<UserUpdateWithoutGuildMemberInput, UserUncheckedUpdateWithoutGuildMemberInput>
    create: XOR<UserCreateWithoutGuildMemberInput, UserUncheckedCreateWithoutGuildMemberInput>
    where?: UserWhereInput
  }

  export type UserUpdateToOneWithWhereWithoutGuildMemberInput = {
    where?: UserWhereInput
    data: XOR<UserUpdateWithoutGuildMemberInput, UserUncheckedUpdateWithoutGuildMemberInput>
  }

  export type UserUpdateWithoutGuildMemberInput = {
    xuid?: StringFieldUpdateOperationsInput | string
    name?: StringFieldUpdateOperationsInput | string
    role?: EnumUserRoleFieldUpdateOperationsInput | $Enums.UserRole
    money?: IntFieldUpdateOperationsInput | number
    canTpa?: BoolFieldUpdateOperationsInput | boolean
    password?: NullableStringFieldUpdateOperationsInput | string | null
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    updatedAt?: DateTimeFieldUpdateOperationsInput | Date | string
    guildId?: NullableIntFieldUpdateOperationsInput | number | null
    userTransaction?: TransactionUpdateManyWithoutUserNestedInput
    targetTransaction?: TransactionUpdateManyWithoutTargetUserNestedInput
    waypoint?: WayPointUpdateManyWithoutUserNestedInput
  }

  export type UserUncheckedUpdateWithoutGuildMemberInput = {
    userId?: IntFieldUpdateOperationsInput | number
    xuid?: StringFieldUpdateOperationsInput | string
    name?: StringFieldUpdateOperationsInput | string
    role?: EnumUserRoleFieldUpdateOperationsInput | $Enums.UserRole
    money?: IntFieldUpdateOperationsInput | number
    canTpa?: BoolFieldUpdateOperationsInput | boolean
    password?: NullableStringFieldUpdateOperationsInput | string | null
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    updatedAt?: DateTimeFieldUpdateOperationsInput | Date | string
    guildId?: NullableIntFieldUpdateOperationsInput | number | null
    userTransaction?: TransactionUncheckedUpdateManyWithoutUserNestedInput
    targetTransaction?: TransactionUncheckedUpdateManyWithoutTargetUserNestedInput
    waypoint?: WayPointUncheckedUpdateManyWithoutUserNestedInput
  }

  export type ShopItemCreateWithoutCategoryInput = {
    texture: string
    name: string
    cost: number
    sell?: number | null
    data?: number
    item: string
    maxLevel?: number | null
    enchant?: string | null
    enchantType?: $Enums.EnchantType | null
    available?: boolean
    createdAt?: Date | string
    updatedAt?: Date | string
    TransactionDetail?: TransactionDetailCreateNestedManyWithoutShopItemInput
  }

  export type ShopItemUncheckedCreateWithoutCategoryInput = {
    itemId?: number
    texture: string
    name: string
    cost: number
    sell?: number | null
    data?: number
    item: string
    maxLevel?: number | null
    enchant?: string | null
    enchantType?: $Enums.EnchantType | null
    available?: boolean
    createdAt?: Date | string
    updatedAt?: Date | string
    TransactionDetail?: TransactionDetailUncheckedCreateNestedManyWithoutShopItemInput
  }

  export type ShopItemCreateOrConnectWithoutCategoryInput = {
    where: ShopItemWhereUniqueInput
    create: XOR<ShopItemCreateWithoutCategoryInput, ShopItemUncheckedCreateWithoutCategoryInput>
  }

  export type ShopItemCreateManyCategoryInputEnvelope = {
    data: ShopItemCreateManyCategoryInput | ShopItemCreateManyCategoryInput[]
    skipDuplicates?: boolean
  }

  export type ShopItemUpsertWithWhereUniqueWithoutCategoryInput = {
    where: ShopItemWhereUniqueInput
    update: XOR<ShopItemUpdateWithoutCategoryInput, ShopItemUncheckedUpdateWithoutCategoryInput>
    create: XOR<ShopItemCreateWithoutCategoryInput, ShopItemUncheckedCreateWithoutCategoryInput>
  }

  export type ShopItemUpdateWithWhereUniqueWithoutCategoryInput = {
    where: ShopItemWhereUniqueInput
    data: XOR<ShopItemUpdateWithoutCategoryInput, ShopItemUncheckedUpdateWithoutCategoryInput>
  }

  export type ShopItemUpdateManyWithWhereWithoutCategoryInput = {
    where: ShopItemScalarWhereInput
    data: XOR<ShopItemUpdateManyMutationInput, ShopItemUncheckedUpdateManyWithoutCategoryInput>
  }

  export type ShopItemScalarWhereInput = {
    AND?: ShopItemScalarWhereInput | ShopItemScalarWhereInput[]
    OR?: ShopItemScalarWhereInput[]
    NOT?: ShopItemScalarWhereInput | ShopItemScalarWhereInput[]
    itemId?: IntFilter<"ShopItem"> | number
    categoryId?: IntFilter<"ShopItem"> | number
    texture?: StringFilter<"ShopItem"> | string
    name?: StringFilter<"ShopItem"> | string
    cost?: IntFilter<"ShopItem"> | number
    sell?: IntNullableFilter<"ShopItem"> | number | null
    data?: IntFilter<"ShopItem"> | number
    item?: StringFilter<"ShopItem"> | string
    maxLevel?: IntNullableFilter<"ShopItem"> | number | null
    enchant?: StringNullableFilter<"ShopItem"> | string | null
    enchantType?: EnumEnchantTypeNullableFilter<"ShopItem"> | $Enums.EnchantType | null
    available?: BoolFilter<"ShopItem"> | boolean
    createdAt?: DateTimeFilter<"ShopItem"> | Date | string
    updatedAt?: DateTimeFilter<"ShopItem"> | Date | string
  }

  export type ShopCategoryCreateWithoutShopItemInput = {
    no: number
    name: string
    texture: string
    type?: $Enums.ItemType
    active?: boolean
  }

  export type ShopCategoryUncheckedCreateWithoutShopItemInput = {
    categoryID?: number
    no: number
    name: string
    texture: string
    type?: $Enums.ItemType
    active?: boolean
  }

  export type ShopCategoryCreateOrConnectWithoutShopItemInput = {
    where: ShopCategoryWhereUniqueInput
    create: XOR<ShopCategoryCreateWithoutShopItemInput, ShopCategoryUncheckedCreateWithoutShopItemInput>
  }

  export type TransactionDetailCreateWithoutShopItemInput = {
    qty: number
    totalPrice: number
    transaction: TransactionCreateNestedOneWithoutTransactionDetailInput
  }

  export type TransactionDetailUncheckedCreateWithoutShopItemInput = {
    id?: number
    transactionId: number
    qty: number
    totalPrice: number
  }

  export type TransactionDetailCreateOrConnectWithoutShopItemInput = {
    where: TransactionDetailWhereUniqueInput
    create: XOR<TransactionDetailCreateWithoutShopItemInput, TransactionDetailUncheckedCreateWithoutShopItemInput>
  }

  export type TransactionDetailCreateManyShopItemInputEnvelope = {
    data: TransactionDetailCreateManyShopItemInput | TransactionDetailCreateManyShopItemInput[]
    skipDuplicates?: boolean
  }

  export type ShopCategoryUpsertWithoutShopItemInput = {
    update: XOR<ShopCategoryUpdateWithoutShopItemInput, ShopCategoryUncheckedUpdateWithoutShopItemInput>
    create: XOR<ShopCategoryCreateWithoutShopItemInput, ShopCategoryUncheckedCreateWithoutShopItemInput>
    where?: ShopCategoryWhereInput
  }

  export type ShopCategoryUpdateToOneWithWhereWithoutShopItemInput = {
    where?: ShopCategoryWhereInput
    data: XOR<ShopCategoryUpdateWithoutShopItemInput, ShopCategoryUncheckedUpdateWithoutShopItemInput>
  }

  export type ShopCategoryUpdateWithoutShopItemInput = {
    no?: IntFieldUpdateOperationsInput | number
    name?: StringFieldUpdateOperationsInput | string
    texture?: StringFieldUpdateOperationsInput | string
    type?: EnumItemTypeFieldUpdateOperationsInput | $Enums.ItemType
    active?: BoolFieldUpdateOperationsInput | boolean
  }

  export type ShopCategoryUncheckedUpdateWithoutShopItemInput = {
    categoryID?: IntFieldUpdateOperationsInput | number
    no?: IntFieldUpdateOperationsInput | number
    name?: StringFieldUpdateOperationsInput | string
    texture?: StringFieldUpdateOperationsInput | string
    type?: EnumItemTypeFieldUpdateOperationsInput | $Enums.ItemType
    active?: BoolFieldUpdateOperationsInput | boolean
  }

  export type TransactionDetailUpsertWithWhereUniqueWithoutShopItemInput = {
    where: TransactionDetailWhereUniqueInput
    update: XOR<TransactionDetailUpdateWithoutShopItemInput, TransactionDetailUncheckedUpdateWithoutShopItemInput>
    create: XOR<TransactionDetailCreateWithoutShopItemInput, TransactionDetailUncheckedCreateWithoutShopItemInput>
  }

  export type TransactionDetailUpdateWithWhereUniqueWithoutShopItemInput = {
    where: TransactionDetailWhereUniqueInput
    data: XOR<TransactionDetailUpdateWithoutShopItemInput, TransactionDetailUncheckedUpdateWithoutShopItemInput>
  }

  export type TransactionDetailUpdateManyWithWhereWithoutShopItemInput = {
    where: TransactionDetailScalarWhereInput
    data: XOR<TransactionDetailUpdateManyMutationInput, TransactionDetailUncheckedUpdateManyWithoutShopItemInput>
  }

  export type TransactionDetailScalarWhereInput = {
    AND?: TransactionDetailScalarWhereInput | TransactionDetailScalarWhereInput[]
    OR?: TransactionDetailScalarWhereInput[]
    NOT?: TransactionDetailScalarWhereInput | TransactionDetailScalarWhereInput[]
    id?: IntFilter<"TransactionDetail"> | number
    transactionId?: IntFilter<"TransactionDetail"> | number
    itemId?: IntNullableFilter<"TransactionDetail"> | number | null
    qty?: IntFilter<"TransactionDetail"> | number
    totalPrice?: IntFilter<"TransactionDetail"> | number
  }

  export type UserCreateWithoutUserTransactionInput = {
    xuid: string
    name: string
    role?: $Enums.UserRole
    money?: number
    canTpa?: boolean
    password?: string | null
    createdAt?: Date | string
    updatedAt?: Date | string
    guildId?: number | null
    guildMember?: GuildMemberCreateNestedOneWithoutMemberInput
    targetTransaction?: TransactionCreateNestedManyWithoutTargetUserInput
    waypoint?: WayPointCreateNestedManyWithoutUserInput
  }

  export type UserUncheckedCreateWithoutUserTransactionInput = {
    userId?: number
    xuid: string
    name: string
    role?: $Enums.UserRole
    money?: number
    canTpa?: boolean
    password?: string | null
    createdAt?: Date | string
    updatedAt?: Date | string
    guildId?: number | null
    guildMember?: GuildMemberUncheckedCreateNestedOneWithoutMemberInput
    targetTransaction?: TransactionUncheckedCreateNestedManyWithoutTargetUserInput
    waypoint?: WayPointUncheckedCreateNestedManyWithoutUserInput
  }

  export type UserCreateOrConnectWithoutUserTransactionInput = {
    where: UserWhereUniqueInput
    create: XOR<UserCreateWithoutUserTransactionInput, UserUncheckedCreateWithoutUserTransactionInput>
  }

  export type UserCreateWithoutTargetTransactionInput = {
    xuid: string
    name: string
    role?: $Enums.UserRole
    money?: number
    canTpa?: boolean
    password?: string | null
    createdAt?: Date | string
    updatedAt?: Date | string
    guildId?: number | null
    guildMember?: GuildMemberCreateNestedOneWithoutMemberInput
    userTransaction?: TransactionCreateNestedManyWithoutUserInput
    waypoint?: WayPointCreateNestedManyWithoutUserInput
  }

  export type UserUncheckedCreateWithoutTargetTransactionInput = {
    userId?: number
    xuid: string
    name: string
    role?: $Enums.UserRole
    money?: number
    canTpa?: boolean
    password?: string | null
    createdAt?: Date | string
    updatedAt?: Date | string
    guildId?: number | null
    guildMember?: GuildMemberUncheckedCreateNestedOneWithoutMemberInput
    userTransaction?: TransactionUncheckedCreateNestedManyWithoutUserInput
    waypoint?: WayPointUncheckedCreateNestedManyWithoutUserInput
  }

  export type UserCreateOrConnectWithoutTargetTransactionInput = {
    where: UserWhereUniqueInput
    create: XOR<UserCreateWithoutTargetTransactionInput, UserUncheckedCreateWithoutTargetTransactionInput>
  }

  export type TransactionDetailCreateWithoutTransactionInput = {
    qty: number
    totalPrice: number
    shopItem?: ShopItemCreateNestedOneWithoutTransactionDetailInput
  }

  export type TransactionDetailUncheckedCreateWithoutTransactionInput = {
    id?: number
    itemId?: number | null
    qty: number
    totalPrice: number
  }

  export type TransactionDetailCreateOrConnectWithoutTransactionInput = {
    where: TransactionDetailWhereUniqueInput
    create: XOR<TransactionDetailCreateWithoutTransactionInput, TransactionDetailUncheckedCreateWithoutTransactionInput>
  }

  export type UserUpsertWithoutUserTransactionInput = {
    update: XOR<UserUpdateWithoutUserTransactionInput, UserUncheckedUpdateWithoutUserTransactionInput>
    create: XOR<UserCreateWithoutUserTransactionInput, UserUncheckedCreateWithoutUserTransactionInput>
    where?: UserWhereInput
  }

  export type UserUpdateToOneWithWhereWithoutUserTransactionInput = {
    where?: UserWhereInput
    data: XOR<UserUpdateWithoutUserTransactionInput, UserUncheckedUpdateWithoutUserTransactionInput>
  }

  export type UserUpdateWithoutUserTransactionInput = {
    xuid?: StringFieldUpdateOperationsInput | string
    name?: StringFieldUpdateOperationsInput | string
    role?: EnumUserRoleFieldUpdateOperationsInput | $Enums.UserRole
    money?: IntFieldUpdateOperationsInput | number
    canTpa?: BoolFieldUpdateOperationsInput | boolean
    password?: NullableStringFieldUpdateOperationsInput | string | null
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    updatedAt?: DateTimeFieldUpdateOperationsInput | Date | string
    guildId?: NullableIntFieldUpdateOperationsInput | number | null
    guildMember?: GuildMemberUpdateOneWithoutMemberNestedInput
    targetTransaction?: TransactionUpdateManyWithoutTargetUserNestedInput
    waypoint?: WayPointUpdateManyWithoutUserNestedInput
  }

  export type UserUncheckedUpdateWithoutUserTransactionInput = {
    userId?: IntFieldUpdateOperationsInput | number
    xuid?: StringFieldUpdateOperationsInput | string
    name?: StringFieldUpdateOperationsInput | string
    role?: EnumUserRoleFieldUpdateOperationsInput | $Enums.UserRole
    money?: IntFieldUpdateOperationsInput | number
    canTpa?: BoolFieldUpdateOperationsInput | boolean
    password?: NullableStringFieldUpdateOperationsInput | string | null
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    updatedAt?: DateTimeFieldUpdateOperationsInput | Date | string
    guildId?: NullableIntFieldUpdateOperationsInput | number | null
    guildMember?: GuildMemberUncheckedUpdateOneWithoutMemberNestedInput
    targetTransaction?: TransactionUncheckedUpdateManyWithoutTargetUserNestedInput
    waypoint?: WayPointUncheckedUpdateManyWithoutUserNestedInput
  }

  export type UserUpsertWithoutTargetTransactionInput = {
    update: XOR<UserUpdateWithoutTargetTransactionInput, UserUncheckedUpdateWithoutTargetTransactionInput>
    create: XOR<UserCreateWithoutTargetTransactionInput, UserUncheckedCreateWithoutTargetTransactionInput>
    where?: UserWhereInput
  }

  export type UserUpdateToOneWithWhereWithoutTargetTransactionInput = {
    where?: UserWhereInput
    data: XOR<UserUpdateWithoutTargetTransactionInput, UserUncheckedUpdateWithoutTargetTransactionInput>
  }

  export type UserUpdateWithoutTargetTransactionInput = {
    xuid?: StringFieldUpdateOperationsInput | string
    name?: StringFieldUpdateOperationsInput | string
    role?: EnumUserRoleFieldUpdateOperationsInput | $Enums.UserRole
    money?: IntFieldUpdateOperationsInput | number
    canTpa?: BoolFieldUpdateOperationsInput | boolean
    password?: NullableStringFieldUpdateOperationsInput | string | null
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    updatedAt?: DateTimeFieldUpdateOperationsInput | Date | string
    guildId?: NullableIntFieldUpdateOperationsInput | number | null
    guildMember?: GuildMemberUpdateOneWithoutMemberNestedInput
    userTransaction?: TransactionUpdateManyWithoutUserNestedInput
    waypoint?: WayPointUpdateManyWithoutUserNestedInput
  }

  export type UserUncheckedUpdateWithoutTargetTransactionInput = {
    userId?: IntFieldUpdateOperationsInput | number
    xuid?: StringFieldUpdateOperationsInput | string
    name?: StringFieldUpdateOperationsInput | string
    role?: EnumUserRoleFieldUpdateOperationsInput | $Enums.UserRole
    money?: IntFieldUpdateOperationsInput | number
    canTpa?: BoolFieldUpdateOperationsInput | boolean
    password?: NullableStringFieldUpdateOperationsInput | string | null
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    updatedAt?: DateTimeFieldUpdateOperationsInput | Date | string
    guildId?: NullableIntFieldUpdateOperationsInput | number | null
    guildMember?: GuildMemberUncheckedUpdateOneWithoutMemberNestedInput
    userTransaction?: TransactionUncheckedUpdateManyWithoutUserNestedInput
    waypoint?: WayPointUncheckedUpdateManyWithoutUserNestedInput
  }

  export type TransactionDetailUpsertWithoutTransactionInput = {
    update: XOR<TransactionDetailUpdateWithoutTransactionInput, TransactionDetailUncheckedUpdateWithoutTransactionInput>
    create: XOR<TransactionDetailCreateWithoutTransactionInput, TransactionDetailUncheckedCreateWithoutTransactionInput>
    where?: TransactionDetailWhereInput
  }

  export type TransactionDetailUpdateToOneWithWhereWithoutTransactionInput = {
    where?: TransactionDetailWhereInput
    data: XOR<TransactionDetailUpdateWithoutTransactionInput, TransactionDetailUncheckedUpdateWithoutTransactionInput>
  }

  export type TransactionDetailUpdateWithoutTransactionInput = {
    qty?: IntFieldUpdateOperationsInput | number
    totalPrice?: IntFieldUpdateOperationsInput | number
    shopItem?: ShopItemUpdateOneWithoutTransactionDetailNestedInput
  }

  export type TransactionDetailUncheckedUpdateWithoutTransactionInput = {
    id?: IntFieldUpdateOperationsInput | number
    itemId?: NullableIntFieldUpdateOperationsInput | number | null
    qty?: IntFieldUpdateOperationsInput | number
    totalPrice?: IntFieldUpdateOperationsInput | number
  }

  export type ShopItemCreateWithoutTransactionDetailInput = {
    texture: string
    name: string
    cost: number
    sell?: number | null
    data?: number
    item: string
    maxLevel?: number | null
    enchant?: string | null
    enchantType?: $Enums.EnchantType | null
    available?: boolean
    createdAt?: Date | string
    updatedAt?: Date | string
    category: ShopCategoryCreateNestedOneWithoutShopItemInput
  }

  export type ShopItemUncheckedCreateWithoutTransactionDetailInput = {
    itemId?: number
    categoryId: number
    texture: string
    name: string
    cost: number
    sell?: number | null
    data?: number
    item: string
    maxLevel?: number | null
    enchant?: string | null
    enchantType?: $Enums.EnchantType | null
    available?: boolean
    createdAt?: Date | string
    updatedAt?: Date | string
  }

  export type ShopItemCreateOrConnectWithoutTransactionDetailInput = {
    where: ShopItemWhereUniqueInput
    create: XOR<ShopItemCreateWithoutTransactionDetailInput, ShopItemUncheckedCreateWithoutTransactionDetailInput>
  }

  export type TransactionCreateWithoutTransactionDetailInput = {
    createdAt?: Date | string
    trxType?: $Enums.TrxType
    user?: UserCreateNestedOneWithoutUserTransactionInput
    targetUser?: UserCreateNestedOneWithoutTargetTransactionInput
  }

  export type TransactionUncheckedCreateWithoutTransactionDetailInput = {
    transactionId?: number
    userId: string
    targetUserId?: string | null
    createdAt?: Date | string
    trxType?: $Enums.TrxType
  }

  export type TransactionCreateOrConnectWithoutTransactionDetailInput = {
    where: TransactionWhereUniqueInput
    create: XOR<TransactionCreateWithoutTransactionDetailInput, TransactionUncheckedCreateWithoutTransactionDetailInput>
  }

  export type ShopItemUpsertWithoutTransactionDetailInput = {
    update: XOR<ShopItemUpdateWithoutTransactionDetailInput, ShopItemUncheckedUpdateWithoutTransactionDetailInput>
    create: XOR<ShopItemCreateWithoutTransactionDetailInput, ShopItemUncheckedCreateWithoutTransactionDetailInput>
    where?: ShopItemWhereInput
  }

  export type ShopItemUpdateToOneWithWhereWithoutTransactionDetailInput = {
    where?: ShopItemWhereInput
    data: XOR<ShopItemUpdateWithoutTransactionDetailInput, ShopItemUncheckedUpdateWithoutTransactionDetailInput>
  }

  export type ShopItemUpdateWithoutTransactionDetailInput = {
    texture?: StringFieldUpdateOperationsInput | string
    name?: StringFieldUpdateOperationsInput | string
    cost?: IntFieldUpdateOperationsInput | number
    sell?: NullableIntFieldUpdateOperationsInput | number | null
    data?: IntFieldUpdateOperationsInput | number
    item?: StringFieldUpdateOperationsInput | string
    maxLevel?: NullableIntFieldUpdateOperationsInput | number | null
    enchant?: NullableStringFieldUpdateOperationsInput | string | null
    enchantType?: NullableEnumEnchantTypeFieldUpdateOperationsInput | $Enums.EnchantType | null
    available?: BoolFieldUpdateOperationsInput | boolean
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    updatedAt?: DateTimeFieldUpdateOperationsInput | Date | string
    category?: ShopCategoryUpdateOneRequiredWithoutShopItemNestedInput
  }

  export type ShopItemUncheckedUpdateWithoutTransactionDetailInput = {
    itemId?: IntFieldUpdateOperationsInput | number
    categoryId?: IntFieldUpdateOperationsInput | number
    texture?: StringFieldUpdateOperationsInput | string
    name?: StringFieldUpdateOperationsInput | string
    cost?: IntFieldUpdateOperationsInput | number
    sell?: NullableIntFieldUpdateOperationsInput | number | null
    data?: IntFieldUpdateOperationsInput | number
    item?: StringFieldUpdateOperationsInput | string
    maxLevel?: NullableIntFieldUpdateOperationsInput | number | null
    enchant?: NullableStringFieldUpdateOperationsInput | string | null
    enchantType?: NullableEnumEnchantTypeFieldUpdateOperationsInput | $Enums.EnchantType | null
    available?: BoolFieldUpdateOperationsInput | boolean
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    updatedAt?: DateTimeFieldUpdateOperationsInput | Date | string
  }

  export type TransactionUpsertWithoutTransactionDetailInput = {
    update: XOR<TransactionUpdateWithoutTransactionDetailInput, TransactionUncheckedUpdateWithoutTransactionDetailInput>
    create: XOR<TransactionCreateWithoutTransactionDetailInput, TransactionUncheckedCreateWithoutTransactionDetailInput>
    where?: TransactionWhereInput
  }

  export type TransactionUpdateToOneWithWhereWithoutTransactionDetailInput = {
    where?: TransactionWhereInput
    data: XOR<TransactionUpdateWithoutTransactionDetailInput, TransactionUncheckedUpdateWithoutTransactionDetailInput>
  }

  export type TransactionUpdateWithoutTransactionDetailInput = {
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    trxType?: EnumTrxTypeFieldUpdateOperationsInput | $Enums.TrxType
    user?: UserUpdateOneWithoutUserTransactionNestedInput
    targetUser?: UserUpdateOneWithoutTargetTransactionNestedInput
  }

  export type TransactionUncheckedUpdateWithoutTransactionDetailInput = {
    transactionId?: IntFieldUpdateOperationsInput | number
    userId?: StringFieldUpdateOperationsInput | string
    targetUserId?: NullableStringFieldUpdateOperationsInput | string | null
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    trxType?: EnumTrxTypeFieldUpdateOperationsInput | $Enums.TrxType
  }

  export type UserCreateWithoutWaypointInput = {
    xuid: string
    name: string
    role?: $Enums.UserRole
    money?: number
    canTpa?: boolean
    password?: string | null
    createdAt?: Date | string
    updatedAt?: Date | string
    guildId?: number | null
    guildMember?: GuildMemberCreateNestedOneWithoutMemberInput
    userTransaction?: TransactionCreateNestedManyWithoutUserInput
    targetTransaction?: TransactionCreateNestedManyWithoutTargetUserInput
  }

  export type UserUncheckedCreateWithoutWaypointInput = {
    userId?: number
    xuid: string
    name: string
    role?: $Enums.UserRole
    money?: number
    canTpa?: boolean
    password?: string | null
    createdAt?: Date | string
    updatedAt?: Date | string
    guildId?: number | null
    guildMember?: GuildMemberUncheckedCreateNestedOneWithoutMemberInput
    userTransaction?: TransactionUncheckedCreateNestedManyWithoutUserInput
    targetTransaction?: TransactionUncheckedCreateNestedManyWithoutTargetUserInput
  }

  export type UserCreateOrConnectWithoutWaypointInput = {
    where: UserWhereUniqueInput
    create: XOR<UserCreateWithoutWaypointInput, UserUncheckedCreateWithoutWaypointInput>
  }

  export type UserUpsertWithoutWaypointInput = {
    update: XOR<UserUpdateWithoutWaypointInput, UserUncheckedUpdateWithoutWaypointInput>
    create: XOR<UserCreateWithoutWaypointInput, UserUncheckedCreateWithoutWaypointInput>
    where?: UserWhereInput
  }

  export type UserUpdateToOneWithWhereWithoutWaypointInput = {
    where?: UserWhereInput
    data: XOR<UserUpdateWithoutWaypointInput, UserUncheckedUpdateWithoutWaypointInput>
  }

  export type UserUpdateWithoutWaypointInput = {
    xuid?: StringFieldUpdateOperationsInput | string
    name?: StringFieldUpdateOperationsInput | string
    role?: EnumUserRoleFieldUpdateOperationsInput | $Enums.UserRole
    money?: IntFieldUpdateOperationsInput | number
    canTpa?: BoolFieldUpdateOperationsInput | boolean
    password?: NullableStringFieldUpdateOperationsInput | string | null
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    updatedAt?: DateTimeFieldUpdateOperationsInput | Date | string
    guildId?: NullableIntFieldUpdateOperationsInput | number | null
    guildMember?: GuildMemberUpdateOneWithoutMemberNestedInput
    userTransaction?: TransactionUpdateManyWithoutUserNestedInput
    targetTransaction?: TransactionUpdateManyWithoutTargetUserNestedInput
  }

  export type UserUncheckedUpdateWithoutWaypointInput = {
    userId?: IntFieldUpdateOperationsInput | number
    xuid?: StringFieldUpdateOperationsInput | string
    name?: StringFieldUpdateOperationsInput | string
    role?: EnumUserRoleFieldUpdateOperationsInput | $Enums.UserRole
    money?: IntFieldUpdateOperationsInput | number
    canTpa?: BoolFieldUpdateOperationsInput | boolean
    password?: NullableStringFieldUpdateOperationsInput | string | null
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    updatedAt?: DateTimeFieldUpdateOperationsInput | Date | string
    guildId?: NullableIntFieldUpdateOperationsInput | number | null
    guildMember?: GuildMemberUncheckedUpdateOneWithoutMemberNestedInput
    userTransaction?: TransactionUncheckedUpdateManyWithoutUserNestedInput
    targetTransaction?: TransactionUncheckedUpdateManyWithoutTargetUserNestedInput
  }

  export type TransactionCreateManyUserInput = {
    transactionId?: number
    targetUserId?: string | null
    createdAt?: Date | string
    trxType?: $Enums.TrxType
  }

  export type TransactionCreateManyTargetUserInput = {
    transactionId?: number
    userId: string
    createdAt?: Date | string
    trxType?: $Enums.TrxType
  }

  export type WayPointCreateManyUserInput = {
    id?: number
    name: string
    x: number
    y: number
    z: number
    dimension: string
    isPublic?: boolean
  }

  export type TransactionUpdateWithoutUserInput = {
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    trxType?: EnumTrxTypeFieldUpdateOperationsInput | $Enums.TrxType
    targetUser?: UserUpdateOneWithoutTargetTransactionNestedInput
    TransactionDetail?: TransactionDetailUpdateOneWithoutTransactionNestedInput
  }

  export type TransactionUncheckedUpdateWithoutUserInput = {
    transactionId?: IntFieldUpdateOperationsInput | number
    targetUserId?: NullableStringFieldUpdateOperationsInput | string | null
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    trxType?: EnumTrxTypeFieldUpdateOperationsInput | $Enums.TrxType
    TransactionDetail?: TransactionDetailUncheckedUpdateOneWithoutTransactionNestedInput
  }

  export type TransactionUncheckedUpdateManyWithoutUserInput = {
    transactionId?: IntFieldUpdateOperationsInput | number
    targetUserId?: NullableStringFieldUpdateOperationsInput | string | null
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    trxType?: EnumTrxTypeFieldUpdateOperationsInput | $Enums.TrxType
  }

  export type TransactionUpdateWithoutTargetUserInput = {
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    trxType?: EnumTrxTypeFieldUpdateOperationsInput | $Enums.TrxType
    user?: UserUpdateOneWithoutUserTransactionNestedInput
    TransactionDetail?: TransactionDetailUpdateOneWithoutTransactionNestedInput
  }

  export type TransactionUncheckedUpdateWithoutTargetUserInput = {
    transactionId?: IntFieldUpdateOperationsInput | number
    userId?: StringFieldUpdateOperationsInput | string
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    trxType?: EnumTrxTypeFieldUpdateOperationsInput | $Enums.TrxType
    TransactionDetail?: TransactionDetailUncheckedUpdateOneWithoutTransactionNestedInput
  }

  export type TransactionUncheckedUpdateManyWithoutTargetUserInput = {
    transactionId?: IntFieldUpdateOperationsInput | number
    userId?: StringFieldUpdateOperationsInput | string
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    trxType?: EnumTrxTypeFieldUpdateOperationsInput | $Enums.TrxType
  }

  export type WayPointUpdateWithoutUserInput = {
    name?: StringFieldUpdateOperationsInput | string
    x?: FloatFieldUpdateOperationsInput | number
    y?: FloatFieldUpdateOperationsInput | number
    z?: FloatFieldUpdateOperationsInput | number
    dimension?: StringFieldUpdateOperationsInput | string
    isPublic?: BoolFieldUpdateOperationsInput | boolean
  }

  export type WayPointUncheckedUpdateWithoutUserInput = {
    id?: IntFieldUpdateOperationsInput | number
    name?: StringFieldUpdateOperationsInput | string
    x?: FloatFieldUpdateOperationsInput | number
    y?: FloatFieldUpdateOperationsInput | number
    z?: FloatFieldUpdateOperationsInput | number
    dimension?: StringFieldUpdateOperationsInput | string
    isPublic?: BoolFieldUpdateOperationsInput | boolean
  }

  export type WayPointUncheckedUpdateManyWithoutUserInput = {
    id?: IntFieldUpdateOperationsInput | number
    name?: StringFieldUpdateOperationsInput | string
    x?: FloatFieldUpdateOperationsInput | number
    y?: FloatFieldUpdateOperationsInput | number
    z?: FloatFieldUpdateOperationsInput | number
    dimension?: StringFieldUpdateOperationsInput | string
    isPublic?: BoolFieldUpdateOperationsInput | boolean
  }

  export type GuildMemberCreateManyGuildInput = {
    id?: number
    memberId: string
    memberRole?: $Enums.GuildRole
  }

  export type GuildMemberUpdateWithoutGuildInput = {
    memberRole?: EnumGuildRoleFieldUpdateOperationsInput | $Enums.GuildRole
    member?: UserUpdateOneRequiredWithoutGuildMemberNestedInput
  }

  export type GuildMemberUncheckedUpdateWithoutGuildInput = {
    id?: IntFieldUpdateOperationsInput | number
    memberId?: StringFieldUpdateOperationsInput | string
    memberRole?: EnumGuildRoleFieldUpdateOperationsInput | $Enums.GuildRole
  }

  export type GuildMemberUncheckedUpdateManyWithoutGuildInput = {
    id?: IntFieldUpdateOperationsInput | number
    memberId?: StringFieldUpdateOperationsInput | string
    memberRole?: EnumGuildRoleFieldUpdateOperationsInput | $Enums.GuildRole
  }

  export type ShopItemCreateManyCategoryInput = {
    itemId?: number
    texture: string
    name: string
    cost: number
    sell?: number | null
    data?: number
    item: string
    maxLevel?: number | null
    enchant?: string | null
    enchantType?: $Enums.EnchantType | null
    available?: boolean
    createdAt?: Date | string
    updatedAt?: Date | string
  }

  export type ShopItemUpdateWithoutCategoryInput = {
    texture?: StringFieldUpdateOperationsInput | string
    name?: StringFieldUpdateOperationsInput | string
    cost?: IntFieldUpdateOperationsInput | number
    sell?: NullableIntFieldUpdateOperationsInput | number | null
    data?: IntFieldUpdateOperationsInput | number
    item?: StringFieldUpdateOperationsInput | string
    maxLevel?: NullableIntFieldUpdateOperationsInput | number | null
    enchant?: NullableStringFieldUpdateOperationsInput | string | null
    enchantType?: NullableEnumEnchantTypeFieldUpdateOperationsInput | $Enums.EnchantType | null
    available?: BoolFieldUpdateOperationsInput | boolean
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    updatedAt?: DateTimeFieldUpdateOperationsInput | Date | string
    TransactionDetail?: TransactionDetailUpdateManyWithoutShopItemNestedInput
  }

  export type ShopItemUncheckedUpdateWithoutCategoryInput = {
    itemId?: IntFieldUpdateOperationsInput | number
    texture?: StringFieldUpdateOperationsInput | string
    name?: StringFieldUpdateOperationsInput | string
    cost?: IntFieldUpdateOperationsInput | number
    sell?: NullableIntFieldUpdateOperationsInput | number | null
    data?: IntFieldUpdateOperationsInput | number
    item?: StringFieldUpdateOperationsInput | string
    maxLevel?: NullableIntFieldUpdateOperationsInput | number | null
    enchant?: NullableStringFieldUpdateOperationsInput | string | null
    enchantType?: NullableEnumEnchantTypeFieldUpdateOperationsInput | $Enums.EnchantType | null
    available?: BoolFieldUpdateOperationsInput | boolean
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    updatedAt?: DateTimeFieldUpdateOperationsInput | Date | string
    TransactionDetail?: TransactionDetailUncheckedUpdateManyWithoutShopItemNestedInput
  }

  export type ShopItemUncheckedUpdateManyWithoutCategoryInput = {
    itemId?: IntFieldUpdateOperationsInput | number
    texture?: StringFieldUpdateOperationsInput | string
    name?: StringFieldUpdateOperationsInput | string
    cost?: IntFieldUpdateOperationsInput | number
    sell?: NullableIntFieldUpdateOperationsInput | number | null
    data?: IntFieldUpdateOperationsInput | number
    item?: StringFieldUpdateOperationsInput | string
    maxLevel?: NullableIntFieldUpdateOperationsInput | number | null
    enchant?: NullableStringFieldUpdateOperationsInput | string | null
    enchantType?: NullableEnumEnchantTypeFieldUpdateOperationsInput | $Enums.EnchantType | null
    available?: BoolFieldUpdateOperationsInput | boolean
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    updatedAt?: DateTimeFieldUpdateOperationsInput | Date | string
  }

  export type TransactionDetailCreateManyShopItemInput = {
    id?: number
    transactionId: number
    qty: number
    totalPrice: number
  }

  export type TransactionDetailUpdateWithoutShopItemInput = {
    qty?: IntFieldUpdateOperationsInput | number
    totalPrice?: IntFieldUpdateOperationsInput | number
    transaction?: TransactionUpdateOneRequiredWithoutTransactionDetailNestedInput
  }

  export type TransactionDetailUncheckedUpdateWithoutShopItemInput = {
    id?: IntFieldUpdateOperationsInput | number
    transactionId?: IntFieldUpdateOperationsInput | number
    qty?: IntFieldUpdateOperationsInput | number
    totalPrice?: IntFieldUpdateOperationsInput | number
  }

  export type TransactionDetailUncheckedUpdateManyWithoutShopItemInput = {
    id?: IntFieldUpdateOperationsInput | number
    transactionId?: IntFieldUpdateOperationsInput | number
    qty?: IntFieldUpdateOperationsInput | number
    totalPrice?: IntFieldUpdateOperationsInput | number
  }



  /**
   * Aliases for legacy arg types
   */
    /**
     * @deprecated Use UserCountOutputTypeDefaultArgs instead
     */
    export type UserCountOutputTypeArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = UserCountOutputTypeDefaultArgs<ExtArgs>
    /**
     * @deprecated Use GuildCountOutputTypeDefaultArgs instead
     */
    export type GuildCountOutputTypeArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = GuildCountOutputTypeDefaultArgs<ExtArgs>
    /**
     * @deprecated Use ShopCategoryCountOutputTypeDefaultArgs instead
     */
    export type ShopCategoryCountOutputTypeArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = ShopCategoryCountOutputTypeDefaultArgs<ExtArgs>
    /**
     * @deprecated Use ShopItemCountOutputTypeDefaultArgs instead
     */
    export type ShopItemCountOutputTypeArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = ShopItemCountOutputTypeDefaultArgs<ExtArgs>
    /**
     * @deprecated Use UserDefaultArgs instead
     */
    export type UserArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = UserDefaultArgs<ExtArgs>
    /**
     * @deprecated Use WarpDefaultArgs instead
     */
    export type WarpArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = WarpDefaultArgs<ExtArgs>
    /**
     * @deprecated Use GuildDefaultArgs instead
     */
    export type GuildArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = GuildDefaultArgs<ExtArgs>
    /**
     * @deprecated Use GuildMemberDefaultArgs instead
     */
    export type GuildMemberArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = GuildMemberDefaultArgs<ExtArgs>
    /**
     * @deprecated Use ShopCategoryDefaultArgs instead
     */
    export type ShopCategoryArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = ShopCategoryDefaultArgs<ExtArgs>
    /**
     * @deprecated Use ShopItemDefaultArgs instead
     */
    export type ShopItemArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = ShopItemDefaultArgs<ExtArgs>
    /**
     * @deprecated Use TransactionDefaultArgs instead
     */
    export type TransactionArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = TransactionDefaultArgs<ExtArgs>
    /**
     * @deprecated Use TransactionDetailDefaultArgs instead
     */
    export type TransactionDetailArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = TransactionDetailDefaultArgs<ExtArgs>
    /**
     * @deprecated Use TpaRequestDefaultArgs instead
     */
    export type TpaRequestArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = TpaRequestDefaultArgs<ExtArgs>
    /**
     * @deprecated Use WayPointDefaultArgs instead
     */
    export type WayPointArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = WayPointDefaultArgs<ExtArgs>
    /**
     * @deprecated Use SettingsDefaultArgs instead
     */
    export type SettingsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = SettingsDefaultArgs<ExtArgs>

  /**
   * Batch Payload for updateMany & deleteMany & createMany
   */

  export type BatchPayload = {
    count: number
  }

  /**
   * DMMF
   */
  export const dmmf: runtime.BaseDMMF
}