
Object.defineProperty(exports, "__esModule", { value: true });

const {
  Decimal,
  objectEnumValues,
  makeStrictEnum,
  Public,
  detectRuntime,
} = require('@prisma/client/runtime/index-browser')


const Prisma = {}

exports.Prisma = Prisma
exports.$Enums = {}

/**
 * Prisma Client JS version: 5.7.0
 * Query Engine version: 79fb5193cf0a8fdbef536e4b4a159cad677ab1b9
 */
Prisma.prismaVersion = {
  client: "5.7.0",
  engine: "79fb5193cf0a8fdbef536e4b4a159cad677ab1b9"
}

Prisma.PrismaClientKnownRequestError = () => {
  throw new Error(`PrismaClientKnownRequestError is unable to be run ${runtimeDescription}.
In case this error is unexpected for you, please report it in https://github.com/prisma/prisma/issues`,
)};
Prisma.PrismaClientUnknownRequestError = () => {
  throw new Error(`PrismaClientUnknownRequestError is unable to be run ${runtimeDescription}.
In case this error is unexpected for you, please report it in https://github.com/prisma/prisma/issues`,
)}
Prisma.PrismaClientRustPanicError = () => {
  throw new Error(`PrismaClientRustPanicError is unable to be run ${runtimeDescription}.
In case this error is unexpected for you, please report it in https://github.com/prisma/prisma/issues`,
)}
Prisma.PrismaClientInitializationError = () => {
  throw new Error(`PrismaClientInitializationError is unable to be run ${runtimeDescription}.
In case this error is unexpected for you, please report it in https://github.com/prisma/prisma/issues`,
)}
Prisma.PrismaClientValidationError = () => {
  throw new Error(`PrismaClientValidationError is unable to be run ${runtimeDescription}.
In case this error is unexpected for you, please report it in https://github.com/prisma/prisma/issues`,
)}
Prisma.NotFoundError = () => {
  throw new Error(`NotFoundError is unable to be run ${runtimeDescription}.
In case this error is unexpected for you, please report it in https://github.com/prisma/prisma/issues`,
)}
Prisma.Decimal = Decimal

/**
 * Re-export of sql-template-tag
 */
Prisma.sql = () => {
  throw new Error(`sqltag is unable to be run ${runtimeDescription}.
In case this error is unexpected for you, please report it in https://github.com/prisma/prisma/issues`,
)}
Prisma.empty = () => {
  throw new Error(`empty is unable to be run ${runtimeDescription}.
In case this error is unexpected for you, please report it in https://github.com/prisma/prisma/issues`,
)}
Prisma.join = () => {
  throw new Error(`join is unable to be run ${runtimeDescription}.
In case this error is unexpected for you, please report it in https://github.com/prisma/prisma/issues`,
)}
Prisma.raw = () => {
  throw new Error(`raw is unable to be run ${runtimeDescription}.
In case this error is unexpected for you, please report it in https://github.com/prisma/prisma/issues`,
)}
Prisma.validator = Public.validator

/**
* Extensions
*/
Prisma.getExtensionContext = () => {
  throw new Error(`Extensions.getExtensionContext is unable to be run ${runtimeDescription}.
In case this error is unexpected for you, please report it in https://github.com/prisma/prisma/issues`,
)}
Prisma.defineExtension = () => {
  throw new Error(`Extensions.defineExtension is unable to be run ${runtimeDescription}.
In case this error is unexpected for you, please report it in https://github.com/prisma/prisma/issues`,
)}

/**
 * Shorthand utilities for JSON filtering
 */
Prisma.DbNull = objectEnumValues.instances.DbNull
Prisma.JsonNull = objectEnumValues.instances.JsonNull
Prisma.AnyNull = objectEnumValues.instances.AnyNull

Prisma.NullTypes = {
  DbNull: objectEnumValues.classes.DbNull,
  JsonNull: objectEnumValues.classes.JsonNull,
  AnyNull: objectEnumValues.classes.AnyNull
}

/**
 * Enums
 */

exports.Prisma.TransactionIsolationLevel = makeStrictEnum({
  ReadUncommitted: 'ReadUncommitted',
  ReadCommitted: 'ReadCommitted',
  RepeatableRead: 'RepeatableRead',
  Serializable: 'Serializable'
});

exports.Prisma.UserScalarFieldEnum = {
  userId: 'userId',
  xuid: 'xuid',
  name: 'name',
  role: 'role',
  money: 'money',
  canTpa: 'canTpa',
  password: 'password',
  createdAt: 'createdAt',
  updatedAt: 'updatedAt',
  guildId: 'guildId'
};

exports.Prisma.WarpScalarFieldEnum = {
  id: 'id',
  name: 'name',
  texture: 'texture',
  gamemode: 'gamemode',
  x: 'x',
  y: 'y',
  z: 'z',
  active: 'active'
};

exports.Prisma.GuildScalarFieldEnum = {
  guildId: 'guildId',
  name: 'name',
  description: 'description',
  ownerId: 'ownerId',
  maxMembers: 'maxMembers',
  isPublic: 'isPublic',
  createdAt: 'createdAt',
  updatedAt: 'updatedAt'
};

exports.Prisma.GuildMemberScalarFieldEnum = {
  id: 'id',
  guildId: 'guildId',
  memberId: 'memberId',
  memberRole: 'memberRole'
};

exports.Prisma.ShopCategoryScalarFieldEnum = {
  categoryID: 'categoryID',
  no: 'no',
  name: 'name',
  texture: 'texture',
  type: 'type',
  active: 'active'
};

exports.Prisma.ShopItemScalarFieldEnum = {
  itemId: 'itemId',
  categoryId: 'categoryId',
  texture: 'texture',
  name: 'name',
  cost: 'cost',
  sell: 'sell',
  data: 'data',
  item: 'item',
  maxLevel: 'maxLevel',
  enchant: 'enchant',
  enchantType: 'enchantType',
  available: 'available',
  createdAt: 'createdAt',
  updatedAt: 'updatedAt'
};

exports.Prisma.TransactionScalarFieldEnum = {
  transactionId: 'transactionId',
  userId: 'userId',
  targetUserId: 'targetUserId',
  createdAt: 'createdAt',
  trxType: 'trxType'
};

exports.Prisma.TransactionDetailScalarFieldEnum = {
  id: 'id',
  transactionId: 'transactionId',
  itemId: 'itemId',
  qty: 'qty',
  totalPrice: 'totalPrice'
};

exports.Prisma.TpaRequestScalarFieldEnum = {
  id: 'id',
  fromName: 'fromName',
  targetName: 'targetName',
  createdAt: 'createdAt'
};

exports.Prisma.WayPointScalarFieldEnum = {
  id: 'id',
  ownerId: 'ownerId',
  name: 'name',
  x: 'x',
  y: 'y',
  z: 'z',
  dimension: 'dimension',
  isPublic: 'isPublic'
};

exports.Prisma.SettingsScalarFieldEnum = {
  id: 'id',
  name: 'name',
  value: 'value',
  type: 'type',
  createdAt: 'createdAt',
  updatedAt: 'updatedAt'
};

exports.Prisma.SortOrder = {
  asc: 'asc',
  desc: 'desc'
};

exports.Prisma.NullsOrder = {
  first: 'first',
  last: 'last'
};
exports.UserRole = exports.$Enums.UserRole = {
  OPERATOR: 'OPERATOR',
  ADMIN: 'ADMIN',
  MODERATOR: 'MODERATOR',
  BUILDER: 'BUILDER',
  STAFF: 'STAFF',
  VIP: 'VIP',
  USER: 'USER'
};

exports.GuildRole = exports.$Enums.GuildRole = {
  LEADER: 'LEADER',
  OFFICER: 'OFFICER',
  MEMBER: 'MEMBER'
};

exports.ItemType = exports.$Enums.ItemType = {
  ITEM: 'ITEM',
  ENCHANT: 'ENCHANT',
  TRANSFER: 'TRANSFER',
  EXP: 'EXP'
};

exports.EnchantType = exports.$Enums.EnchantType = {
  ALL: 'ALL',
  ARMOR: 'ARMOR',
  MELEE_WEAPON: 'MELEE_WEAPON',
  RANGED_WEAPON: 'RANGED_WEAPON',
  TOOL: 'TOOL'
};

exports.TrxType = exports.$Enums.TrxType = {
  DEBIT: 'DEBIT',
  CREDIT: 'CREDIT'
};

exports.DataType = exports.$Enums.DataType = {
  STRING: 'STRING',
  INTEGER: 'INTEGER',
  FLOAT: 'FLOAT',
  DOUBLE: 'DOUBLE',
  BOOLEAN: 'BOOLEAN'
};

exports.Prisma.ModelName = {
  User: 'User',
  Warp: 'Warp',
  Guild: 'Guild',
  GuildMember: 'GuildMember',
  ShopCategory: 'ShopCategory',
  ShopItem: 'ShopItem',
  Transaction: 'Transaction',
  TransactionDetail: 'TransactionDetail',
  TpaRequest: 'TpaRequest',
  WayPoint: 'WayPoint',
  Settings: 'Settings'
};

/**
 * This is a stub Prisma Client that will error at runtime if called.
 */
class PrismaClient {
  constructor() {
    return new Proxy(this, {
      get(target, prop) {
        const runtime = detectRuntime()
        const edgeRuntimeName = {
          'workerd': 'Cloudflare Workers',
          'deno': 'Deno and Deno Deploy',
          'netlify': 'Netlify Edge Functions',
          'edge-light': 'Vercel Edge Functions',
        }[runtime]

        let message = 'PrismaClient is unable to run in '
        if (edgeRuntimeName !== undefined) {
          message += edgeRuntimeName + '. As an alternative, try Accelerate: https://pris.ly/d/accelerate.'
        } else {
          message += 'this browser environment, or has been bundled for the browser (running in `' + runtime + '`).'
        }
        
        message += `
If this is unexpected, please open an issue: https://github.com/prisma/prisma/issues`

        throw new Error(message)
      }
    })
  }
}

exports.PrismaClient = PrismaClient

Object.assign(exports, Prisma)
