"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.genInternalErrorResponse = exports.genErrorResponse = exports.defaultResponseApi = exports.generateUUID = exports.prisma = void 0;
const client_1 = require("@prisma/client");
const uuid_1 = require("uuid");
exports.prisma = new client_1.PrismaClient({
    log: ['error']
});
const generateUUID = () => {
    return (0, uuid_1.v4)();
};
exports.generateUUID = generateUUID;
const defaultResponseApi = () => {
    return {
        code: 200,
        status: 'success'
    };
};
exports.defaultResponseApi = defaultResponseApi;
const genErrorResponse = (message, code = 400) => {
    return {
        code,
        status: 'failed',
        message,
    };
};
exports.genErrorResponse = genErrorResponse;
const genInternalErrorResponse = (response, error) => {
    response.code = 500;
    response.status = 'error';
    response.message = "Internal Server Error";
    if (error instanceof Error) {
        response.message = error.message;
    }
    if (error instanceof client_1.Prisma.PrismaClientKnownRequestError) {
        response.message = error.message;
    }
    return response;
};
exports.genInternalErrorResponse = genInternalErrorResponse;
