"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const utils_1 = require("../utils/utils");
const WaypointRoute = (server, options) => __awaiter(void 0, void 0, void 0, function* () {
    server.get('/waypoints', {}, (request, reply) => __awaiter(void 0, void 0, void 0, function* () {
        var response = (0, utils_1.defaultResponseApi)();
        try {
            const waypoint = yield utils_1.prisma.wayPoint.findMany({
                include: {
                    User: true,
                },
                where: {
                    isPublic: true
                }
            });
            if (!waypoint) {
                response = (0, utils_1.genErrorResponse)("Waypoint Empty");
            }
            response.result = waypoint;
            return response;
        }
        catch (error) {
            return reply.send((0, utils_1.genInternalErrorResponse)(response, error));
        }
    }));
    server.get('/waypoint/:ownerId', {}, (request, reply) => __awaiter(void 0, void 0, void 0, function* () {
        var response = (0, utils_1.defaultResponseApi)();
        try {
            const waypoint = yield utils_1.prisma.wayPoint.findMany({
                include: {
                    User: true,
                },
                where: { ownerId: request.params.ownerId }
            });
            if (!waypoint) {
                response = (0, utils_1.genErrorResponse)("Waypoint not found", 1001);
            }
            response.result = waypoint;
            return response;
        }
        catch (error) {
            return reply.send((0, utils_1.genInternalErrorResponse)(response, error));
        }
    }));
    server.post('/waypoint', {}, (request, reply) => __awaiter(void 0, void 0, void 0, function* () {
        var response = (0, utils_1.defaultResponseApi)();
        try {
            const existwaypoint = yield utils_1.prisma.wayPoint.findMany({
                where: {
                    name: request.body.name
                }
            });
            if (existwaypoint.length == 0) {
                const waypointCreate = request.body;
                const waypoint = yield utils_1.prisma.wayPoint.create({
                    data: waypointCreate
                });
                response.result = waypoint;
            }
            else {
                response = (0, utils_1.genErrorResponse)("Waypoint Name: " + request.body.name + " Already Exist", 1001);
            }
            return response;
        }
        catch (error) {
            return reply.send((0, utils_1.genInternalErrorResponse)(response, error));
        }
    }));
    server.put('/waypoint', {}, (request, reply) => __awaiter(void 0, void 0, void 0, function* () {
        var _a, _b, _c, _d, _e, _f;
        var response = (0, utils_1.defaultResponseApi)();
        try {
            const waypoint = yield utils_1.prisma.wayPoint.findFirst({
                where: {
                    id: request.body.id
                }
            });
            if (!waypoint) {
                return (0, utils_1.genErrorResponse)("Waypoint ID: " + request.body.id + " Not Found", 1009);
            }
            const existName = yield utils_1.prisma.wayPoint.findFirst({
                where: {
                    name: request.body.name
                }
            });
            const waypointName = request.body.name;
            if (existName && waypointName && (waypointName != waypoint.name)) {
                return (0, utils_1.genErrorResponse)("Waypoint name: " + existName.name + " is exist");
            }
            const waypointUpdate = {
                name: (_a = request.body.name) !== null && _a !== void 0 ? _a : waypoint.name,
                x: (_b = request.body.x) !== null && _b !== void 0 ? _b : waypoint.x,
                y: (_c = request.body.y) !== null && _c !== void 0 ? _c : waypoint.y,
                z: (_d = request.body.z) !== null && _d !== void 0 ? _d : waypoint.z,
                dimension: (_e = request.body.dimension) !== null && _e !== void 0 ? _e : waypoint.dimension,
                isPublic: (_f = request.body.isPublic) !== null && _f !== void 0 ? _f : waypoint.isPublic,
            };
            const update = yield utils_1.prisma.wayPoint.update({
                data: waypointUpdate,
                where: {
                    id: request.body.id
                }
            });
            response.result = update;
            return response;
        }
        catch (error) {
            return reply.send((0, utils_1.genInternalErrorResponse)(response, error));
        }
    }));
    server.delete('/waypoint/:id', {}, (request, reply) => __awaiter(void 0, void 0, void 0, function* () {
        var response = (0, utils_1.defaultResponseApi)();
        try {
            const waypoint = yield utils_1.prisma.wayPoint.findFirst({
                where: {
                    id: Number(request.params.id)
                }
            });
            if (waypoint) {
                const deletewaypoint = yield utils_1.prisma.wayPoint.delete({
                    where: {
                        id: Number(request.params.id)
                    }
                });
                response.result = deletewaypoint;
            }
            else {
                response = (0, utils_1.genErrorResponse)("Waypoint ID: " + request.params.id + " Not Found");
            }
            return response;
        }
        catch (error) {
            return reply.send((0, utils_1.genInternalErrorResponse)(response, error));
        }
    }));
});
exports.default = WaypointRoute;
