"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const utils_1 = require("../utils/utils");
const WarpRoute = (server, options) => __awaiter(void 0, void 0, void 0, function* () {
    server.get('/warps', {}, (request, reply) => __awaiter(void 0, void 0, void 0, function* () {
        var response = (0, utils_1.defaultResponseApi)();
        try {
            const warp = yield utils_1.prisma.warp.findMany();
            if (!warp) {
                response = (0, utils_1.genErrorResponse)("Warp Empty");
            }
            response.result = warp;
            return response;
        }
        catch (error) {
            return reply.send((0, utils_1.genInternalErrorResponse)(response, error));
        }
    }));
    server.get('/warp/:id', {}, (request, reply) => __awaiter(void 0, void 0, void 0, function* () {
        var response = (0, utils_1.defaultResponseApi)();
        try {
            const warp = yield utils_1.prisma.warp.findFirst({
                where: { id: Number(request.params.id) }
            });
            if (!warp) {
                response = (0, utils_1.genErrorResponse)("Warp not found");
            }
            response.result = warp;
            return response;
        }
        catch (error) {
            return reply.send((0, utils_1.genInternalErrorResponse)(response, error));
        }
    }));
    server.post('/warp', {}, (request, reply) => __awaiter(void 0, void 0, void 0, function* () {
        var response = (0, utils_1.defaultResponseApi)();
        try {
            const existwarp = yield utils_1.prisma.warp.findMany({
                where: {
                    name: request.body.name
                }
            });
            if (existwarp.length == 0) {
                const warpCreate = request.body;
                const warp = yield utils_1.prisma.warp.create({
                    data: warpCreate
                });
                response.result = warp;
            }
            else {
                response = (0, utils_1.genErrorResponse)("Warp Name: " + request.body.name + " Already Exist");
            }
            return response;
        }
        catch (error) {
            return reply.send((0, utils_1.genInternalErrorResponse)(response, error));
        }
    }));
    server.put('/warp', {}, (request, reply) => __awaiter(void 0, void 0, void 0, function* () {
        var _a, _b, _c, _d, _e, _f;
        var response = (0, utils_1.defaultResponseApi)();
        try {
            const existName = yield utils_1.prisma.warp.findFirst({
                where: {
                    name: request.body.name
                }
            });
            if (existName && (request.body.name != existName.name)) {
                return (0, utils_1.genErrorResponse)("Warp name: " + existName.name + " is exist");
            }
            const warp = yield utils_1.prisma.warp.findFirst({
                where: {
                    id: request.body.id
                }
            });
            if (warp) {
                const warpUpdate = {
                    name: (_a = request.body.name) !== null && _a !== void 0 ? _a : warp.name,
                    texture: (_b = request.body.texture) !== null && _b !== void 0 ? _b : warp.texture,
                    x: (_c = request.body.x) !== null && _c !== void 0 ? _c : warp.x,
                    y: (_d = request.body.y) !== null && _d !== void 0 ? _d : warp.y,
                    z: (_e = request.body.z) !== null && _e !== void 0 ? _e : warp.z,
                    active: (_f = request.body.active) !== null && _f !== void 0 ? _f : warp.active,
                };
                const update = yield utils_1.prisma.warp.update({
                    data: warpUpdate,
                    where: {
                        id: request.body.id
                    }
                });
                response.result = update;
            }
            else {
                response = (0, utils_1.genErrorResponse)("Warp ID: " + request.body.id + " Not Found");
            }
            return response;
        }
        catch (error) {
            return reply.send((0, utils_1.genInternalErrorResponse)(response, error));
        }
    }));
    server.delete('/warp/:id', {}, (request, reply) => __awaiter(void 0, void 0, void 0, function* () {
        var response = (0, utils_1.defaultResponseApi)();
        try {
            const warp = yield utils_1.prisma.warp.findFirst({
                where: {
                    id: Number(request.params.id)
                }
            });
            if (warp) {
                const deletewarp = yield utils_1.prisma.warp.delete({
                    where: {
                        id: Number(request.params.id)
                    }
                });
                response.result = deletewarp;
            }
            else {
                response = (0, utils_1.genErrorResponse)("Warp ID: " + request.params.id + " Not Found");
            }
            return response;
        }
        catch (error) {
            return reply.send((0, utils_1.genInternalErrorResponse)(response, error));
        }
    }));
});
exports.default = WarpRoute;
