"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const client_1 = __importDefault(require("@prisma/client"));
const utils_1 = require("../utils/utils");
const UserRoute = (server, options) => __awaiter(void 0, void 0, void 0, function* () {
    server.get('/users', {}, (request, reply) => __awaiter(void 0, void 0, void 0, function* () {
        var response = (0, utils_1.defaultResponseApi)();
        try {
            const user = yield utils_1.prisma.user.findMany();
            if (!user) {
                response = (0, utils_1.genErrorResponse)("User Empty");
            }
            response.result = user;
            return response;
        }
        catch (error) {
            return reply.send((0, utils_1.genInternalErrorResponse)(response, error));
        }
    }));
    server.get('/user/:id', {}, (request, reply) => __awaiter(void 0, void 0, void 0, function* () {
        var response = (0, utils_1.defaultResponseApi)();
        try {
            const user = yield utils_1.prisma.user.findFirst({
                include: {
                    guildMember: true,
                },
                where: { xuid: request.params.id }
            });
            if (!user) {
                response = (0, utils_1.genErrorResponse)("User not found");
            }
            response.result = user;
            if (user === null || user === void 0 ? void 0 : user.guildMember) {
                const guild = yield utils_1.prisma.guild.findFirst({ where: { guildId: user.guildId } });
                response.result.guild = guild;
            }
            return response;
        }
        catch (error) {
            return reply.send((0, utils_1.genInternalErrorResponse)(response, error));
        }
    }));
    server.post('/user', {}, (request, reply) => __awaiter(void 0, void 0, void 0, function* () {
        var response = (0, utils_1.defaultResponseApi)();
        try {
            const existUser = yield utils_1.prisma.user.findMany({
                where: {
                    OR: [
                        { xuid: request.body.xuid },
                    ]
                }
            });
            if (existUser.length == 0) {
                const user = yield utils_1.prisma.user.create({
                    data: {
                        xuid: request.body.xuid,
                        name: request.body.name,
                        role: client_1.default.UserRole.USER
                    }
                });
                response.result = user;
            }
            else {
                const user = yield utils_1.prisma.user.update({
                    data: {
                        name: request.body.name,
                    },
                    where: {
                        xuid: request.body.xuid,
                    }
                });
                response.result = user;
            }
            return response;
        }
        catch (error) {
            return reply.send((0, utils_1.genInternalErrorResponse)(response, error));
        }
    }));
    server.put('/user', {}, (request, reply) => __awaiter(void 0, void 0, void 0, function* () {
        var _a, _b, _c;
        var response = (0, utils_1.defaultResponseApi)();
        try {
            const user = yield utils_1.prisma.user.findFirst({
                where: {
                    xuid: request.body.xuid
                }
            });
            if (user) {
                const update = yield utils_1.prisma.user.update({
                    data: {
                        name: (_a = request.body.name) !== null && _a !== void 0 ? _a : user.name,
                        role: (_b = request.body.role) !== null && _b !== void 0 ? _b : user.role,
                        canTpa: (_c = request.body.canTpa) !== null && _c !== void 0 ? _c : user.canTpa
                    },
                    where: {
                        xuid: request.body.xuid
                    }
                });
                response.result = update;
            }
            else {
                response = (0, utils_1.genErrorResponse)("User XUID: " + request.body.xuid + " Not Found");
            }
            return response;
        }
        catch (error) {
            return reply.send((0, utils_1.genInternalErrorResponse)(response, error));
        }
    }));
    server.delete('/user/:xuid', {}, (request, reply) => __awaiter(void 0, void 0, void 0, function* () {
        var response = (0, utils_1.defaultResponseApi)();
        try {
            const user = yield utils_1.prisma.user.findFirst({
                where: {
                    xuid: request.params.xuid
                }
            });
            if (user) {
                const deleteUser = yield utils_1.prisma.user.delete({
                    where: {
                        xuid: request.params.xuid
                    }
                });
                response.result = deleteUser;
            }
            else {
                response = (0, utils_1.genErrorResponse)("User XUID: " + request.params.xuid + " Not Found");
            }
            return response;
        }
        catch (error) {
            return reply.send((0, utils_1.genInternalErrorResponse)(response, error));
        }
    }));
});
exports.default = UserRoute;
