"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const client_1 = __importDefault(require("@prisma/client"));
const utils_1 = require("../utils/utils");
const TransactionRoute = (server, options) => __awaiter(void 0, void 0, void 0, function* () {
    server.get('/transaction/:xuid', {}, (request, reply) => __awaiter(void 0, void 0, void 0, function* () {
        var response = (0, utils_1.defaultResponseApi)();
        try {
            const xuid = request.params.xuid;
            const user = yield utils_1.prisma.user.findFirst({ where: { xuid } });
            if (!user) {
                return (0, utils_1.genErrorResponse)("User XUID: " + xuid + " not found", 1001);
            }
            const transaction = yield utils_1.prisma.transaction.findMany({
                include: {
                    TransactionDetail: true
                },
                where: {
                    userId: xuid
                }
            });
            response.result = transaction;
            return response;
        }
        catch (error) {
            return reply.send((0, utils_1.genInternalErrorResponse)(response, error));
        }
    }));
    server.post('/transaction/transfer', {}, (request, reply) => __awaiter(void 0, void 0, void 0, function* () {
        var response = (0, utils_1.defaultResponseApi)();
        try {
            const xuid = request.body.xuid;
            const targetXuid = request.body.targetXuid;
            const amount = request.body.amount;
            const transaction = yield utils_1.prisma.$transaction((tx) => __awaiter(void 0, void 0, void 0, function* () {
                const userFrom = yield tx.user.findFirst({ where: { xuid } });
                if (!userFrom) {
                    return (0, utils_1.genErrorResponse)("User Source ID: " + xuid + " not found", 1001);
                }
                const userTarget = yield tx.user.findFirst({ where: { xuid: targetXuid } });
                if (!userTarget) {
                    return (0, utils_1.genErrorResponse)("User Target ID: " + targetXuid + " not found", 1002);
                }
                if (userFrom.money < amount) {
                    return (0, utils_1.genErrorResponse)("Money user: " + userFrom.money + " not enough, need " + amount, 1003);
                }
                const transaction1 = yield tx.transaction.create({
                    data: {
                        userId: xuid,
                        trxType: client_1.default.TrxType.DEBIT,
                    }
                });
                const transaction2 = yield tx.transaction.create({
                    data: {
                        userId: targetXuid,
                        trxType: client_1.default.TrxType.CREDIT,
                    }
                });
                yield tx.transactionDetail.create({
                    data: {
                        transactionId: transaction1.transactionId,
                        itemId: 0,
                        qty: amount,
                        totalPrice: amount
                    }
                });
                yield tx.transactionDetail.create({
                    data: {
                        transactionId: transaction2.transactionId,
                        itemId: 0,
                        qty: amount,
                        totalPrice: amount
                    }
                });
                yield tx.user.update({
                    data: {
                        money: userFrom.money - amount
                    },
                    where: {
                        xuid
                    }
                });
                yield tx.user.update({
                    data: {
                        money: userTarget.money + amount
                    },
                    where: {
                        xuid: targetXuid
                    }
                });
                return transaction1;
            }));
            response.result = transaction;
            return response;
        }
        catch (error) {
            return reply.send((0, utils_1.genInternalErrorResponse)(response, error));
        }
    }));
});
exports.default = TransactionRoute;
