"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const utils_1 = require("../utils/utils");
const TpaRoute = (server, options) => __awaiter(void 0, void 0, void 0, function* () {
    server.get('/tpas', {}, (request, reply) => __awaiter(void 0, void 0, void 0, function* () {
        var response = (0, utils_1.defaultResponseApi)();
        try {
            const tpa = yield utils_1.prisma.tpaRequest.findMany();
            if (!tpa) {
                response = (0, utils_1.genErrorResponse)("Tpa Empty");
            }
            response.result = tpa;
            return response;
        }
        catch (error) {
            return reply.send((0, utils_1.genInternalErrorResponse)(response, error));
        }
    }));
    server.get('/tpa/request', {}, (request, reply) => __awaiter(void 0, void 0, void 0, function* () {
        var response = (0, utils_1.defaultResponseApi)();
        try {
            const tpa = yield utils_1.prisma.tpaRequest.findFirst({
                where: {
                    AND: [
                        { fromName: request.query.fromName },
                        { targetName: request.query.targetName },
                    ]
                }
            });
            if (!tpa) {
                response = (0, utils_1.genErrorResponse)("Tpa not found", 1001);
            }
            response.result = tpa;
            return response;
        }
        catch (error) {
            return reply.send((0, utils_1.genInternalErrorResponse)(response, error));
        }
    }));
    server.get('/tpa/list', {}, (request, reply) => __awaiter(void 0, void 0, void 0, function* () {
        var response = (0, utils_1.defaultResponseApi)();
        try {
            const tpa = yield utils_1.prisma.tpaRequest.findMany({
                where: {
                    OR: [
                        { fromName: request.query.name },
                        { targetName: request.query.name },
                    ]
                }
            });
            if (!tpa) {
                response = (0, utils_1.genErrorResponse)("Tpa not found");
            }
            response.result = tpa;
            return response;
        }
        catch (error) {
            return reply.send((0, utils_1.genInternalErrorResponse)(response, error));
        }
    }));
    server.post('/tpa', {}, (request, reply) => __awaiter(void 0, void 0, void 0, function* () {
        var response = (0, utils_1.defaultResponseApi)();
        try {
            const existtpa = yield utils_1.prisma.tpaRequest.findMany({
                where: {
                    AND: [
                        {
                            fromName: request.body.fromName
                        },
                        {
                            targetName: request.body.targetName
                        }
                    ]
                }
            });
            if (existtpa.length == 0) {
                const tpaCreate = request.body;
                const tpa = yield utils_1.prisma.tpaRequest.create({
                    data: tpaCreate
                });
                response.result = tpa;
            }
            else {
                response = (0, utils_1.genErrorResponse)("Tpa Request from " + request.body.fromName + " to " + request.body.targetName + " already exist", 401);
            }
            return response;
        }
        catch (error) {
            return reply.send((0, utils_1.genInternalErrorResponse)(response, error));
        }
    }));
    server.put('/tpa', {}, (request, reply) => __awaiter(void 0, void 0, void 0, function* () {
        var _a, _b;
        var response = (0, utils_1.defaultResponseApi)();
        try {
            const existName = yield utils_1.prisma.tpaRequest.findFirst({
                where: {
                    AND: [
                        {
                            fromName: request.body.fromName
                        },
                        {
                            targetName: request.body.targetName
                        }
                    ]
                }
            });
            if (existName && (request.body.fromName != existName.fromName) && (request.body.targetName != existName.targetName)) {
                return (0, utils_1.genErrorResponse)("Tpa Request from " + request.body.fromName + " to " + request.body.targetName + " already exist", 401);
            }
            const tpa = yield utils_1.prisma.tpaRequest.findFirst({
                where: {
                    id: request.body.id
                }
            });
            if (tpa) {
                const tpaUpdate = {
                    fromName: (_a = request.body.fromName) !== null && _a !== void 0 ? _a : tpa.fromName,
                    targetName: (_b = request.body.targetName) !== null && _b !== void 0 ? _b : tpa.targetName,
                };
                const update = yield utils_1.prisma.tpaRequest.update({
                    data: tpaUpdate,
                    where: {
                        id: request.body.id
                    }
                });
                response.result = update;
            }
            else {
                response = (0, utils_1.genErrorResponse)("Tpa ID: " + request.body.id + " Not Found");
            }
            return response;
        }
        catch (error) {
            return reply.send((0, utils_1.genInternalErrorResponse)(response, error));
        }
    }));
    server.delete('/tpa', {}, (request, reply) => __awaiter(void 0, void 0, void 0, function* () {
        var response = (0, utils_1.defaultResponseApi)();
        try {
            const tpa = yield utils_1.prisma.tpaRequest.findFirst({
                where: {
                    AND: [
                        { fromName: request.body.fromName },
                        { targetName: request.body.targetName },
                    ]
                }
            });
            if (tpa) {
                const deletetpa = yield utils_1.prisma.tpaRequest.deleteMany({
                    where: {
                        AND: [
                            { fromName: request.body.fromName },
                            { targetName: request.body.targetName },
                        ]
                    }
                });
                response.result = deletetpa;
            }
            else {
                response = (0, utils_1.genErrorResponse)("Tpa Request Not Found", 1001);
            }
            return response;
        }
        catch (error) {
            return reply.send((0, utils_1.genInternalErrorResponse)(response, error));
        }
    }));
});
exports.default = TpaRoute;
