"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const client_1 = __importDefault(require("@prisma/client"));
const utils_1 = require("../utils/utils");
const ShopRoute = (server, options) => __awaiter(void 0, void 0, void 0, function* () {
    // [ CATEGORY ]
    server.get('/shop/category', {}, (request, reply) => __awaiter(void 0, void 0, void 0, function* () {
        var response = (0, utils_1.defaultResponseApi)();
        try {
            const category = yield utils_1.prisma.shopCategory.findMany({
                select: {
                    categoryID: true, no: true, name: true, texture: true, type: true
                },
                orderBy: {
                    no: 'asc'
                },
                where: {
                    active: true
                }
            });
            if (!category) {
                response = (0, utils_1.genErrorResponse)("Category not found");
            }
            response.result = category;
            return response;
        }
        catch (error) {
            return reply.send((0, utils_1.genInternalErrorResponse)(response, error));
        }
    }));
    server.post('/shop/category', {}, (request, reply) => __awaiter(void 0, void 0, void 0, function* () {
        var response = (0, utils_1.defaultResponseApi)();
        try {
            const category = yield utils_1.prisma.shopCategory.create({
                data: request.body
            });
            response.result = category;
            return response;
        }
        catch (error) {
            return reply.send((0, utils_1.genInternalErrorResponse)(response, error));
        }
    }));
    server.put('/shop/category', {}, (request, reply) => __awaiter(void 0, void 0, void 0, function* () {
        var _a, _b, _c, _d;
        var response = (0, utils_1.defaultResponseApi)();
        try {
            const category = yield utils_1.prisma.shopCategory.findFirst({
                where: {
                    categoryID: request.body.id
                }
            });
            if (category) {
                const categoryUpdate = {
                    no: (_a = request.body.no) !== null && _a !== void 0 ? _a : category.no,
                    name: (_b = request.body.name) !== null && _b !== void 0 ? _b : category.name,
                    texture: (_c = request.body.texture) !== null && _c !== void 0 ? _c : category.texture,
                    type: (_d = request.body.type) !== null && _d !== void 0 ? _d : category.type
                };
                const update = yield utils_1.prisma.shopCategory.update({
                    data: categoryUpdate,
                    where: {
                        categoryID: request.body.id
                    }
                });
                response.result = update;
            }
            else {
                response = (0, utils_1.genErrorResponse)("Category Not Found");
            }
            return response;
        }
        catch (error) {
            return reply.send((0, utils_1.genInternalErrorResponse)(response, error));
        }
    }));
    server.delete('/shop/category/:id', {}, (request, reply) => __awaiter(void 0, void 0, void 0, function* () {
        var response = (0, utils_1.defaultResponseApi)();
        try {
            const category = yield utils_1.prisma.shopCategory.findFirst({
                where: {
                    categoryID: Number(request.params.id)
                }
            });
            if (category) {
                const deleteCategory = yield utils_1.prisma.shopCategory.delete({
                    where: {
                        categoryID: Number(request.params.id)
                    }
                });
                response.result = deleteCategory;
            }
            else {
                response = (0, utils_1.genErrorResponse)("Category Not Found");
            }
            return response;
        }
        catch (error) {
            return reply.send((0, utils_1.genInternalErrorResponse)(response, error));
        }
    }));
    // [ ITEMS ]
    server.get('/shop/items', {}, (request, reply) => __awaiter(void 0, void 0, void 0, function* () {
        var _e;
        var response = (0, utils_1.defaultResponseApi)();
        try {
            var item = {};
            if (request.query.page) {
                const limit = (_e = request.query.limit) !== null && _e !== void 0 ? _e : 15;
                const page = request.query.page;
                item = yield utils_1.prisma.shopItem.findMany({
                    skip: limit * (page - 1),
                    take: limit
                });
            }
            else if (request.query.category) {
                item = yield utils_1.prisma.shopItem.findMany({
                    where: { categoryId: Number(request.query.category) }
                });
            }
            else {
                item = yield utils_1.prisma.shopItem.findMany();
            }
            if (!item) {
                response = (0, utils_1.genErrorResponse)("Item not found");
            }
            response.result = item;
            return response;
        }
        catch (error) {
            return reply.send((0, utils_1.genInternalErrorResponse)(response, error));
        }
    }));
    server.get('/shop/item/:id', {}, (request, reply) => __awaiter(void 0, void 0, void 0, function* () {
        var response = (0, utils_1.defaultResponseApi)();
        try {
            var item = yield utils_1.prisma.shopItem.findFirst({ where: { itemId: Number(request.params.id) } });
            if (!item) {
                response = (0, utils_1.genErrorResponse)("Item not found", 1001);
            }
            response.result = item;
            return response;
        }
        catch (error) {
            return reply.send((0, utils_1.genInternalErrorResponse)(response, error));
        }
    }));
    server.get('/shop/item/exp', {}, (request, reply) => __awaiter(void 0, void 0, void 0, function* () {
        var response = (0, utils_1.defaultResponseApi)();
        try {
            var item = yield utils_1.prisma.shopItem.findFirst({ where: { name: 'EXP' } });
            if (!item) {
                response = (0, utils_1.genErrorResponse)("Item not found", 1001);
            }
            response.result = item;
            return response;
        }
        catch (error) {
            return reply.send((0, utils_1.genInternalErrorResponse)(response, error));
        }
    }));
    server.post('/shop/item', {}, (request, reply) => __awaiter(void 0, void 0, void 0, function* () {
        var response = (0, utils_1.defaultResponseApi)();
        try {
            const item = yield utils_1.prisma.shopItem.create({
                data: request.body
            });
            response.result = item;
            return response;
        }
        catch (error) {
            return reply.send((0, utils_1.genInternalErrorResponse)(response, error));
        }
    }));
    server.put('/shop/item', {}, (request, reply) => __awaiter(void 0, void 0, void 0, function* () {
        var _f, _g, _h, _j, _k, _l, _m, _o, _p, _q;
        var response = (0, utils_1.defaultResponseApi)();
        try {
            const item = yield utils_1.prisma.shopItem.findFirst({
                where: {
                    itemId: request.body.id
                }
            });
            if (item) {
                if (request.body.categoryId) {
                    const itemCategory = yield utils_1.prisma.shopCategory.findFirst({
                        where: {
                            categoryID: request.body.categoryId
                        }
                    });
                    if (!itemCategory) {
                        return (0, utils_1.genErrorResponse)("Category with ID: " + request.body.categoryId + " not found");
                    }
                }
                const categoryUpdate = {
                    categoryId: (_f = request.body.categoryId) !== null && _f !== void 0 ? _f : item.categoryId,
                    texture: (_g = request.body.texture) !== null && _g !== void 0 ? _g : item.texture,
                    name: (_h = request.body.name) !== null && _h !== void 0 ? _h : item.name,
                    cost: (_j = request.body.cost) !== null && _j !== void 0 ? _j : item.cost,
                    sell: (_k = request.body.sell) !== null && _k !== void 0 ? _k : item.sell,
                    data: (_l = request.body.data) !== null && _l !== void 0 ? _l : item.data,
                    item: (_m = request.body.item) !== null && _m !== void 0 ? _m : item.item,
                    maxLevel: (_o = request.body.maxLevel) !== null && _o !== void 0 ? _o : item.maxLevel,
                    enchant: (_p = request.body.enchant) !== null && _p !== void 0 ? _p : item.enchant,
                    enchantType: (_q = request.body.enchantType) !== null && _q !== void 0 ? _q : item.enchantType,
                };
                const update = yield utils_1.prisma.shopItem.update({
                    data: categoryUpdate,
                    where: {
                        itemId: request.body.id
                    }
                });
                response.result = update;
            }
            else {
                response = (0, utils_1.genErrorResponse)("Item Not Found");
            }
            return response;
        }
        catch (error) {
            return reply.send((0, utils_1.genInternalErrorResponse)(response, error));
        }
    }));
    server.delete('/shop/item/:id', {}, (request, reply) => __awaiter(void 0, void 0, void 0, function* () {
        var response = (0, utils_1.defaultResponseApi)();
        try {
            const item = yield utils_1.prisma.shopItem.findFirst({
                where: {
                    itemId: Number(request.params.id)
                }
            });
            if (item) {
                const deleteItem = yield utils_1.prisma.shopItem.delete({
                    where: {
                        itemId: Number(request.params.id)
                    }
                });
                response.result = deleteItem;
            }
            else {
                response = (0, utils_1.genErrorResponse)("Item Not Found");
            }
            return response;
        }
        catch (error) {
            return reply.send((0, utils_1.genInternalErrorResponse)(response, error));
        }
    }));
    // [ TRX FLOW ]
    server.post('/shop/buy', {}, (request, reply) => __awaiter(void 0, void 0, void 0, function* () {
        var response = (0, utils_1.defaultResponseApi)();
        try {
            const xuid = request.body.xuid;
            const itemId = request.body.itemId;
            const qty = request.body.qty;
            const result = yield utils_1.prisma.$transaction((tx) => __awaiter(void 0, void 0, void 0, function* () {
                const user = yield tx.user.findFirst({ where: { xuid } });
                if (!user) {
                    return (0, utils_1.genErrorResponse)("User ID: " + xuid + " not found", 1001);
                }
                const shopItem = yield tx.shopItem.findFirst({ where: { itemId } });
                if (!shopItem) {
                    return (0, utils_1.genErrorResponse)("Item ID: " + itemId + " not found", 1002);
                }
                const totalPrice = shopItem.cost * qty;
                if (user.money < totalPrice) {
                    return (0, utils_1.genErrorResponse)("Money user: " + user.money + " not enough, need " + totalPrice, 1003);
                }
                const transaction = yield tx.transaction.create({
                    data: {
                        userId: xuid,
                        trxType: client_1.default.TrxType.DEBIT,
                    }
                });
                yield tx.transactionDetail.create({
                    data: {
                        transactionId: transaction.transactionId,
                        itemId: shopItem.itemId,
                        qty,
                        totalPrice
                    }
                });
                yield tx.user.update({
                    data: {
                        money: user.money - totalPrice
                    },
                    where: {
                        xuid
                    }
                });
                var resp = (0, utils_1.defaultResponseApi)();
                resp.result = transaction;
                return resp;
            }));
            response = result;
            return response;
        }
        catch (error) {
            return reply.send((0, utils_1.genInternalErrorResponse)(response, error));
        }
    }));
    server.post('/shop/sell', {}, (request, reply) => __awaiter(void 0, void 0, void 0, function* () {
        var response = (0, utils_1.defaultResponseApi)();
        try {
            const xuid = request.body.xuid;
            const itemId = request.body.itemId;
            const qty = request.body.qty;
            const result = yield utils_1.prisma.$transaction((tx) => __awaiter(void 0, void 0, void 0, function* () {
                const user = yield tx.user.findFirst({ where: { xuid } });
                if (!user) {
                    return (0, utils_1.genErrorResponse)("User ID: " + xuid + " not found", 1001);
                }
                const shopItem = yield tx.shopItem.findFirst({ where: { itemId } });
                if (!shopItem) {
                    return (0, utils_1.genErrorResponse)("Item ID: " + itemId + " not found", 1002);
                }
                if (!shopItem.sell) {
                    return (0, utils_1.genErrorResponse)("Item ID: " + itemId + " is not sell", 1003);
                }
                const totalPrice = shopItem.sell * qty;
                const transaction = yield tx.transaction.create({
                    data: {
                        userId: xuid,
                        trxType: client_1.default.TrxType.CREDIT,
                    }
                });
                yield tx.transactionDetail.create({
                    data: {
                        transactionId: transaction.transactionId,
                        itemId: shopItem.itemId,
                        qty,
                        totalPrice
                    }
                });
                yield tx.user.update({
                    data: {
                        money: user.money + totalPrice
                    },
                    where: {
                        xuid
                    }
                });
                var resp = (0, utils_1.defaultResponseApi)();
                resp.result = transaction;
                return resp;
            }));
            response = result;
            return response;
        }
        catch (error) {
            return reply.send((0, utils_1.genInternalErrorResponse)(response, error));
        }
    }));
});
exports.default = ShopRoute;
