"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const utils_1 = require("../utils/utils");
const SettingRoute = (server, options) => __awaiter(void 0, void 0, void 0, function* () {
    server.get('/settings', {}, (request, reply) => __awaiter(void 0, void 0, void 0, function* () {
        var response = (0, utils_1.defaultResponseApi)();
        try {
            const setting = yield utils_1.prisma.settings.findMany();
            if (!setting) {
                response = (0, utils_1.genErrorResponse)("Setting Empty");
            }
            response.result = setting;
            return response;
        }
        catch (error) {
            return reply.send((0, utils_1.genInternalErrorResponse)(response, error));
        }
    }));
    server.get('/setting/:id', {}, (request, reply) => __awaiter(void 0, void 0, void 0, function* () {
        var response = (0, utils_1.defaultResponseApi)();
        try {
            const setting = yield utils_1.prisma.settings.findFirst({
                where: { id: Number(request.params.id) }
            });
            if (!setting) {
                response = (0, utils_1.genErrorResponse)("Setting not found");
            }
            response.result = setting;
            return response;
        }
        catch (error) {
            return reply.send((0, utils_1.genInternalErrorResponse)(response, error));
        }
    }));
    server.post('/setting', {}, (request, reply) => __awaiter(void 0, void 0, void 0, function* () {
        var response = (0, utils_1.defaultResponseApi)();
        try {
            const existsetting = yield utils_1.prisma.settings.findMany({
                where: {
                    name: request.body.name
                }
            });
            if (existsetting.length == 0) {
                const settingCreate = request.body;
                const setting = yield utils_1.prisma.settings.create({
                    data: settingCreate
                });
                response.result = setting;
            }
            else {
                response = (0, utils_1.genErrorResponse)("Setting Name: " + request.body.name + " Already Exist");
            }
            return response;
        }
        catch (error) {
            return reply.send((0, utils_1.genInternalErrorResponse)(response, error));
        }
    }));
    server.put('/setting', {}, (request, reply) => __awaiter(void 0, void 0, void 0, function* () {
        var _a, _b, _c;
        var response = (0, utils_1.defaultResponseApi)();
        try {
            const existID = yield utils_1.prisma.settings.findFirst({
                where: {
                    id: request.body.id
                }
            });
            const existName = yield utils_1.prisma.settings.findFirst({
                where: {
                    name: request.body.name
                }
            });
            if (existName && (existName.name != (existID === null || existID === void 0 ? void 0 : existID.name))) {
                return (0, utils_1.genErrorResponse)("Setting name: " + existName.name + " is exist");
            }
            const setting = yield utils_1.prisma.settings.findFirst({
                where: {
                    id: request.body.id
                }
            });
            if (setting) {
                const settingUpdate = {
                    name: (_a = request.body.name) !== null && _a !== void 0 ? _a : setting.name,
                    value: (_b = request.body.value) !== null && _b !== void 0 ? _b : setting.value,
                    type: (_c = request.body.type) !== null && _c !== void 0 ? _c : setting.type,
                };
                const update = yield utils_1.prisma.settings.update({
                    data: settingUpdate,
                    where: {
                        id: request.body.id
                    }
                });
                response.result = update;
            }
            else {
                response = (0, utils_1.genErrorResponse)("Setting ID: " + request.body.id + " Not Found");
            }
            return response;
        }
        catch (error) {
            return reply.send((0, utils_1.genInternalErrorResponse)(response, error));
        }
    }));
    server.delete('/setting/:id', {}, (request, reply) => __awaiter(void 0, void 0, void 0, function* () {
        var response = (0, utils_1.defaultResponseApi)();
        try {
            const setting = yield utils_1.prisma.settings.findFirst({
                where: {
                    id: Number(request.params.id)
                }
            });
            if (setting) {
                const deletesetting = yield utils_1.prisma.settings.delete({
                    where: {
                        id: Number(request.params.id)
                    }
                });
                response.result = deletesetting;
            }
            else {
                response = (0, utils_1.genErrorResponse)("Setting ID: " + request.params.id + " Not Found");
            }
            return response;
        }
        catch (error) {
            return reply.send((0, utils_1.genInternalErrorResponse)(response, error));
        }
    }));
});
exports.default = SettingRoute;
