"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GAME_EVENTS = exports.MINECRAFT_VERSION = exports.NAME = exports.MAX_COMMAND_PROCESSING = void 0;
exports.MAX_COMMAND_PROCESSING = 100;
/*The amount of commands the client can process at a time without responding.

This is already handleded internally so there is usually no need to use
this. You can think of the client managing a FIFO queue of command requests
with a capacity of 100. The client pops out the first entered command request
and sends a command response bback to the server. When the server tries to
send a command request while the queue is already full, then the command will
never be executed and an error will be sent by the client.

.. mermaid::
    :caption: An example of an interaction between the server and a client.
    
    %%{init: {'theme': 'dark'}}%%
    sequenceDiagram
        Server-)Client: Command Request
        Server-)Client: Command Request
        Server-)Client: Command Request
        Client-)Server: Command Response
        loop 98 times
            Server-)Client: Command Request
        end
        Server-xClient: Command Request
        loop 98 times
            Client-)Server: Command Response
        end
*/
exports.NAME = "External";
/*The name of the server displayed in the game.

This name is displayed left to the message when the ``say`` command is used. Therefore
it is usually preferred to use ``tellraw`` instead.
*/
exports.MINECRAFT_VERSION = "1.20.50";
// The Minecraft version to use for the command syntax. This usually has no big impact.
exports.GAME_EVENTS = {
    ADDITIONAL_CONTENT_LOADED: "additional_content_loaded",
    AGENT_COMMAND: "agent_command",
    AGENT_CREATED: "agent_created",
    API_INIT: "api_init",
    APP_PAUSED: "app_paused",
    APP_RESUMED: "app_resumed",
    APP_SUSPENDED: "app_suspended",
    AWARD_ACHIEVEMENT: "award_achievement",
    BLOCK_BROKEN: "block_broken",
    BLOCK_PLACED: "block_placed",
    BOARD_TEXT_UPDATED: "board_text_updated",
    BOSS_KILLED: "boss_killed",
    CAMERA_USED: "camera_used",
    CAULDRON_USED: "cauldron_used",
    CONFIGURATION_CHANGED: "configuration_changed",
    CONNECTION_FAILED: "connection_failed",
    CRAFTING_SESSION_COMPLETED: "crafting_session_completed",
    END_OF_DAY: "end_of_day",
    ENTITY_SPAWNED: "entity_spawned",
    FILE_TRANSMISSION_CANCELLED: "file_transmission_cancelled",
    FILE_TRANSMISSION_COMPLETED: "file_transmission_completed",
    FILE_TRANSMISSION_STARTED: "file_transmission_started",
    FIRST_TIME_CLIENT_OPEN: "first_time_client_open",
    FOCUS_GAINED: "focus_gained",
    FOCUS_LOST: "focus_lost",
    GAME_SESSION_COMPLETE: "game_session_complete",
    GAME_SESSION_START: "game_session_start",
    HARDWARE_INFO: "hardware_info",
    HAS_NEW_CONTENT: "has_new_content",
    ITEM_ACQUIRED: "item_acquired",
    ITEM_CRAFTED: "item_crafted",
    ITEM_DESTROYED: "item_destroyed",
    ITEM_DROPPED: "item_dropped",
    ITEM_ENCHANTED: "item_enchanted",
    ITEM_SMELTED: "item_smelted",
    ITEM_USED: "item_used",
    JOIN_CANCELED: "join_canceled",
    JUKEBOX_USED: "jukebox_used",
    LICENSE_CENSUS: "license_census",
    MASCOT_CREATED: "mascot_created",
    MENU_SHOWN: "menu_shown",
    MOB_INTERACTED: "mob_interacted",
    MOB_KILLED: "mob_killed",
    MULTIPLAYER_CONNECTION_STATE_CHANGED: "multiplayer_connection_state_changed",
    MULTIPLAYER_ROUND_END: "multiplayer_round_end",
    MULTIPLAYER_ROUND_START: "multiplayer_round_start",
    NPC_PROPERTIES_UPDATED: "npc_properties_updated",
    OPTIONS_UPDATED: "options_updated",
    PERFORMANCE_METRICS: "performance_metrics",
    PLAYER_BOUNCED: "player_bounced",
    PLAYER_DIED: "player_died",
    PLAYER_JOIN: "player_join",
    PLAYER_LEAVE: "player_leave",
    PLAYER_MESSAGE: "player_message",
    PLAYER_TELEPORTED: "player_teleported",
    PLAYER_TRANSFORM: "player_transform",
    PLAYER_TRAVELLED: "player_travelled",
    PORTAL_BUILT: "portal_built",
    PORTAL_USED: "portal_used",
    PORTFOLIO_EXPORTED: "portfolio_exported",
    POTION_BREWED: "potion_brewed",
    PURCHASE_ATTEMPT: "purchase_attempt",
    PURCHASE_RESOLVED: "purchase_resolved",
    REGIONAL_POPUP: "regional_popup",
    RESPONDED_TO_ACCEPT_CONTENT: "responded_to_accept_content",
    SCREEN_CHANGED: "screen_changed",
    SCREEN_HEARTBEAT: "screen_heartbeat",
    SIGN_IN_TO_EDU: "sign_in_to_edu",
    SIGN_IN_TO_XBOX_LIVE: "sign_in_to_xbox_live",
    SIGN_OUT_OF_XBOX_LIVE: "sign_out_of_xbox_live",
    SPECIAL_MOB_BUILT: "special_mob_built",
    START_CLIENT: "start_client",
    START_WORLD: "start_world",
    TEXT_TO_SPEECH_TOGGLED: "text_to_speech_toggled",
    UGC_DOWNLOAD_COMPLETED: "ugc_download_completed",
    UGC_DOWNLOAD_STARTED: "ugc_download_started",
    UPLOAD_SKIN: "upload_skin",
    VEHICLE_EXITED: "vehicle_exited",
    WORLD_EXPORTED: "world_exported",
    WORLD_FILES_LISTED: "world_files_listed",
    WORLD_GENERATED: "world_generated",
    WORLD_LOADED: "world_loaded",
    WORLD_UNLOADED: "world_unloaded",
};
/*A list of game events the server can subcribe to.

.. note:: Some of these events may not work or are useless in a way.
*/ 
