"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
require("dotenv").config();
const autoload_1 = __importDefault(require("@fastify/autoload"));
const cors_1 = __importDefault(require("@fastify/cors"));
const fastify_1 = __importDefault(require("fastify"));
const path_1 = __importDefault(require("path"));
const build = (opts = {}) => {
    const fastify = (0, fastify_1.default)(opts);
    fastify.addHook('preHandler', (req, reply, done) => {
        reply.header("Content-Type", "application/json");
        done();
    });
    fastify.register(cors_1.default);
    fastify.register(autoload_1.default, {
        dir: path_1.default.join(__dirname, 'routes'),
        options: {
            prefix: '/api/v1'
        }
    });
    fastify.get('/', () => {
        return {
            code: 200,
            status: true,
            message: "MechaCraft API Server v1.0",
            date: new Date()
        };
    });
    return fastify;
};
exports.default = build;
